/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fp.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.util.EqualsUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fm.common.FMLoginModel;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.fp.FPFormFactory;
import com.kingdee.eas.fm.fp.FPFormStateEnum;
import com.kingdee.eas.fm.fp.IFPForm;
import com.kingdee.eas.fm.fp.client.AbstractFPFormListUI;
import com.kingdee.eas.fm.fp.client.FPFormAddNewCondParam;
import com.kingdee.eas.fm.fp.client.FPFormAddNewCondUI;
import com.kingdee.eas.fm.fp.client.FPFormAdjustUI;
import com.kingdee.eas.fm.fp.client.FPFormClientHelper;
import com.kingdee.eas.fm.fp.client.FPFormEditUI;
import com.kingdee.eas.fm.fp.client.FPFormFilterUI;
import com.kingdee.eas.fm.fp.client.FPFormVersionUI;
import com.kingdee.eas.fm.fp.client.FPTraceUI;
import com.kingdee.eas.fm.fp.client.FPVersionDiffUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.enums.IntEnum;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class FPFormListUI
extends AbstractFPFormListUI {
    public static String resourcePath = "com.kingdee.eas.fm.fp.FPFormResource";
    private FPFormFilterUI filterUI;
    private String editUIName = FPFormEditUI.class.getName();
    FillListener fillListener = new FillListener();

    protected void initListener() {
        super.initListener();
        this.tblMain.getDataRequestManager().addDataFillListener((KDTDataFillListener)this.fillListener);
    }

    protected String getEditUIName() {
        String id = this.getSelectedKeyValue();
        if (id == null) {
            return this.editUIName;
        }
        FPFormStateEnum stateEnum = FPFormStateEnum.BEFOREAPPROVAL;
        try {
            IFPForm form = FPFormFactory.getRemoteInstance();
            stateEnum = FPFormClientHelper.getFormState(id);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        if (stateEnum.equals((Object)FPFormStateEnum.ADJUSTING)) {
            return FPFormAdjustUI.class.getName();
        }
        return this.editUIName;
    }

    protected void setEditUIName(String name) {
        this.editUIName = name;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return FPFormFactory.getRemoteInstance();
    }

    public static void main(String[] args) {
        FMLoginModel login = FMLoginModel.newInstance();
        login.login("zgh1", "", "eas", "TM006");
        String uiname = FPFormListUI.class.getName();
        System.out.println(uiname);
        login.loginMain(uiname);
    }

    public void actionAdjust_actionPerformed(ActionEvent e) throws Exception {
        super.actionAdjust_actionPerformed(e);
        this.checkSelected();
        FPFormStateEnum stateEnum = FPFormClientHelper.getFormState(this.getSelectedKeyValue());
        if (stateEnum.equals((Object)FPFormStateEnum.BEFOREAPPROVAL)) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"UNAuditFormCanNotAdjust"));
            SysUtil.abort();
        } else if (stateEnum.equals((Object)FPFormStateEnum.OUTDATED)) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"OverdueForm"));
            SysUtil.abort();
        }
        this.checkOutDate();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)this.getSelectedKeyValue());
        this.prepareUIContext(uiContext, e);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(FPFormAdjustUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
        this.refresh(e);
    }

    private void checkOutDate() throws BOSException, SQLException {
        int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        IRow row = this.tblMain.getRow(rowIndex);
        Date beginDate = (Date)row.getCell("beginDate").getValue();
        Date endDate = (Date)row.getCell("endDate").getValue();
        String sql = "select getdate() nowDate";
        ISQLExecutor iExecutor = SQLExecutorFactory.getRemoteInstance((String)sql);
        IRowSet irs = iExecutor.executeSQL();
        Date nowDate = null;
        if (irs.next()) {
            nowDate = irs.getDate(1);
        }
        if (nowDate.after(endDate)) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"OverdueForm"));
            SysUtil.abort();
        }
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new FPFormFilterUI();
        }
        return this.filterUI;
    }

    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        FPFormClientHelper.auditForm((Component)((Object)this), this.getSelectedKeyValue());
        this.refresh(e);
    }

    public void actionMntVersion_actionPerformed(ActionEvent e) throws Exception {
        super.actionMntVersion_actionPerformed(e);
        this.checkSelected();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)this.getSelectedKeyValue());
        this.prepareUIContext(uiContext, e);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(FPVersionDiffUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
    }

    protected String getEditUIModal() {
        return FMClientHelper.getEditUIMode((CoreUIObject)this);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        FPFormAddNewCondParam param = FPFormAddNewCondUI.showDialogWindow((Component)((Object)this));
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"param", (Object)param);
        this.prepareUIContext(uiContext, e);
        if (param.isState() != 1) {
            return;
        }
        IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(FPFormEditUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
        this.refresh(e);
    }

    public void actionSeachVersion_actionPerformed(ActionEvent e) throws Exception {
        super.actionSeachVersion_actionPerformed(e);
        this.checkSelected();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)this.getSelectedKeyValue());
        this.prepareUIContext(uiContext, e);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(FPFormVersionUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        super.actionSubmit_actionPerformed(e);
        String id = this.getSelectedKeyValue();
        IFPForm iFPForm = FPFormFactory.getRemoteInstance();
        iFPForm.submitWF(BOSUuid.read((String)id));
        this.showMessage(EASResource.getString((String)resourcePath, (String)"SubmitWFSucceed"));
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnSubmit.setIcon(EASResource.getIcon((String)"imgTbtn_submit"));
        this.btnAudit.setIcon(EASResource.getIcon((String)"imgTbtn_audit"));
        this.btnAdjust.setIcon(EASResource.getIcon((String)"imgTbtn_budgetadjust"));
        this.btnMntVersion.setIcon(EASResource.getIcon((String)"imgTbtn_editiondifference"));
        this.btnSeachVersion.setIcon(EASResource.getIcon((String)"imgTbtn_historyedition"));
        this.btnTrack.setIcon(EASResource.getIcon((String)"imgTbtn_follow"));
        this.btnAntiAudit.setIcon(EASResource.getIcon((String)"imgTbtn_unaudit"));
        this.btnAuditResult.setIcon(EASResource.getIcon((String)"imgTbtn_multapproveresult"));
        this.btnViewDoProcess.setIcon(EASResource.getIcon((String)"imgTbtn_descryrefer"));
    }

    public void actionViewDoProcess_actionPerformed(ActionEvent e) throws Exception {
        super.actionViewDoProcess_actionPerformed(e);
        this.checkSelected();
        FMClientHelper.viewDoProccess((CoreUIObject)this, (String)this.getSelectedKeyValue());
    }

    public void actionTrack_actionPerformed(ActionEvent e) throws Exception {
        super.actionTrack_actionPerformed(e);
        this.checkSelected();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)this.getSelectedKeyValue());
        this.prepareUIContext(uiContext, e);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(FPTraceUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
    }

    private void changeButtonStatus() {
        List rows = FMClientHelper.getAllSelectedRow((KDTable)this.tblMain);
        for (int i = 0; i < rows.size(); ++i) {
            IRow row = (IRow)rows.get(i);
            BizEnumValueInfo state = (BizEnumValueInfo)row.getCell("state").getValue();
            if (state == null) continue;
            if (EqualsUtil.equals((IntEnum)FPFormStateEnum.BEFOREAPPROVAL, (BizEnumValueInfo)state)) {
                this.actionAudit.setEnabled(true);
                this.btnAdjust.setEnabled(false);
                this.btnMntVersion.setEnabled(false);
                this.btnSeachVersion.setEnabled(false);
                this.btnAntiAudit.setEnabled(false);
                this.actionSubmit.setEnabled(true);
                this.viewverion.setEnabled(false);
                this.menuItemVerion.setEnabled(false);
                continue;
            }
            if (EqualsUtil.equals((IntEnum)FPFormStateEnum.APPROVED, (BizEnumValueInfo)state)) {
                this.actionAudit.setEnabled(false);
                this.btnAdjust.setEnabled(true);
                this.btnMntVersion.setEnabled(true);
                this.btnSeachVersion.setEnabled(true);
                this.btnAntiAudit.setEnabled(true);
                this.actionSubmit.setEnabled(false);
                this.viewverion.setEnabled(true);
                this.menuItemVerion.setEnabled(true);
                continue;
            }
            if (EqualsUtil.equals((IntEnum)FPFormStateEnum.ADJUSTING, (BizEnumValueInfo)state)) {
                this.actionAudit.setEnabled(true);
                this.btnAdjust.setEnabled(true);
                this.btnMntVersion.setEnabled(true);
                this.btnSeachVersion.setEnabled(true);
                this.btnAntiAudit.setEnabled(false);
                this.actionSubmit.setEnabled(true);
                this.viewverion.setEnabled(true);
                this.menuItemVerion.setEnabled(true);
                continue;
            }
            this.viewverion.setEnabled(true);
            this.menuItemVerion.setEnabled(true);
        }
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        super.tblMain_tableSelectChanged(e);
        this.changeButtonStatus();
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        IFPForm form = FPFormFactory.getRemoteInstance();
        FPFormStateEnum stateEnum = FPFormClientHelper.getFormState(id);
        if (stateEnum.equals((Object)FPFormStateEnum.APPROVED) || stateEnum.equals((Object)FPFormStateEnum.ADJUSTING)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"AlreadyAuditCanNotEdit"));
            SysUtil.abort();
        }
        super.actionEdit_actionPerformed(e);
    }

    public void actionAntiAudit_actionPerformed(ActionEvent e) throws Exception {
        super.actionAntiAudit_actionPerformed(e);
        this.checkSelected();
        FPFormStateEnum stateEnum = this.getSelectedStateEnum();
        FPFormClientHelper.antiAuditForm((Component)((Object)this), this.getSelectedKeyValue(), stateEnum);
        this.refresh(e);
    }

    private FPFormStateEnum getSelectedStateEnum() {
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        if (selectBlock != null) {
            int rowIndex = selectBlock.getTop();
            IRow row = this.tblMain.getRow(rowIndex);
            if (row == null) {
                return null;
            }
            ICell cell = row.getCell("state");
            if (cell == null) {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_KeyField_Fail"));
                SysUtil.abort();
            }
            Object keyValue = cell.getValue();
            return FPFormStateEnum.getEnum(((BizEnumValueInfo)keyValue).getInt());
        }
        return null;
    }

    private final class FillListener
    implements KDTDataFillListener {
        private FillListener() {
        }

        public void afterDataFill(KDTDataRequestEvent e) {
            for (int i = 0; i < FPFormListUI.this.tblMain.getRowCount(); ++i) {
                IRow row = FPFormListUI.this.tblMain.getRow(i);
                ICell cell = row.getCell("state");
                BizEnumValueInfo state = (BizEnumValueInfo)cell.getValue();
                FPFormStateEnum enumState = FPFormStateEnum.getEnum(state.getInt());
                if (EqualsUtil.equals((IntEnum)FPFormStateEnum.ADJUSTING, (IntEnum)enumState)) {
                    row.getStyleAttributes().setBackground(FMClientHelper.KDTABLE_SUBTOTAL_BG_COLOR);
                    continue;
                }
                if (!EqualsUtil.equals((IntEnum)FPFormStateEnum.APPROVED, (IntEnum)enumState)) continue;
                row.getStyleAttributes().setBackground(FMClientHelper.KDTABLE_TOTAL_BG_COLOR);
            }
            FPFormListUI.this.tblMain.repaint();
        }
    }
}

