/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fp.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.fp.AdjustFormCollection;
import com.kingdee.eas.fm.fp.AdjustFormFactory;
import com.kingdee.eas.fm.fp.FPFormFactory;
import com.kingdee.eas.fm.fp.FPFormInfo;
import com.kingdee.eas.fm.fp.IAdjustForm;
import com.kingdee.eas.fm.fp.client.AbstractFPFormVersionUI;
import com.kingdee.eas.fm.fp.client.FPFormClientHelper;
import com.kingdee.eas.fm.fp.client.FPFormVersionCondParam;
import com.kingdee.eas.fm.fp.client.FPVersionUI;
import com.kingdee.eas.framework.ICoreBase;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;

public class FPFormVersionUI
extends AbstractFPFormVersionUI {
    public static String FLAG = "VERSION_INFO";

    public void loadFields() {
        super.loadFields();
    }

    protected IObjectValue createNewData() {
        return null;
    }

    public boolean checkBeforeWindowClosing() {
        return true;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        String formId = (String)this.getUIContext().get("ID");
        Component owerUI = (Component)this.getUIContext().get("Owner");
        FPFormVersionCondParam param = FPVersionUI.showDialogWindow(owerUI, formId, FLAG);
        if (param.isState() != 1) {
            this.abort();
        }
        FMClientHelper.clearSeparatorOnToolBar((KDToolBar)this.toolBar);
        this.initVersionInfo(param);
        this.btnViewOverdue.setVisible(false);
        this.enableExportExcel(this.tblMain);
        this.kDSeparator7.setVisible(false);
        this.kDSeparator6.setVisible(false);
        this.kDSeparator8.setVisible(false);
    }

    private void initVersionInfo(FPFormVersionCondParam param) throws EASBizException, BOSException {
        AdjustFormCollection adjustFormColl = param.getAdjustFormColl();
        if (adjustFormColl != null && adjustFormColl.size() > 0) {
            FPFormInfo fpFormInfo = adjustFormColl.get(0).getFpForm();
            this.txtNumber.setText(fpFormInfo.getNumber());
            this.txtName.setText(fpFormInfo.getName());
            this.txtCompany.setText(fpFormInfo.getCompany().getName());
            this.txtCurrency.setText(fpFormInfo.getCurrency().getName());
            this.txtTemplate.setText(fpFormInfo.getTemplate().getName());
            int beginYear = fpFormInfo.getBeginYear();
            int beginMonth = fpFormInfo.getBeginMonth();
            int endYear = fpFormInfo.getEndYear();
            int endMonth = fpFormInfo.getEndMonth();
            this.txtPeriod.setText(FPFormClientHelper.getPeriodStr(beginYear, beginMonth + 1, endYear, endMonth + 1));
            this.bizPromptCreator.setValue((Object)fpFormInfo.getCreator().getName());
            this.bizPromptAuditor.setValue((Object)fpFormInfo.getAuditor().getName());
            this.dtpCreateTime.setValue((Object)fpFormInfo.getCreateTime());
            this.dtpAuditedTime.setValue((Object)fpFormInfo.getAuditedTime());
            IAdjustForm iAdjustForm = AdjustFormFactory.getRemoteInstance();
            BigDecimal verNo = null;
            verNo = param.isCurrVersion() ? Constants.CURR_VERSION : adjustFormColl.get(0).getVersionNo();
            FPFormInfo info = iAdjustForm.getFPFormByVersion(fpFormInfo.getId().toString(), verNo);
            FPFormClientHelper.sortFormEntries(info);
            FPFormClientHelper.setData(this.tblMain, info, true, false);
        }
    }

    protected ICoreBase getBizInterface() throws Exception {
        return FPFormFactory.getRemoteInstance();
    }

    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        FMClientHelper.exportExcel((Component)((Object)this), (KDTable)this.tblMain);
    }
}

