/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fp.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.fp.FPItemCollection;
import com.kingdee.eas.fm.fp.FPItemInfo;
import com.kingdee.eas.fm.fp.FPItemTypeEnum;
import com.kingdee.eas.fm.fp.FPMonitorFactory;
import com.kingdee.eas.fm.fp.IFPMonitor;
import com.kingdee.eas.fm.fp.client.AbstractFPItemPromptBoxUI;
import java.awt.event.ActionEvent;
import java.util.Date;

public class FPItemPromptBoxUI
extends AbstractFPItemPromptBoxUI {
    public static String CTX_COMPANYID = "COMPANYID";
    public static String CTX_CURRENCYID = "CURRENCYID";
    public static String CTX_DATE = "DATE";
    public static String CTX_ITEM_TYPE = "ITEM_TYPE";
    public static final String COL_SELECTED = "selected";
    private static String COL_LINE_NO = "lineNo";
    private static String COL_NUMBER = "number";
    private static String COL_NAME = "name";
    private static String COL_TYPE = "type";
    private static String COL_COMMENT = "comment";
    private boolean canceled = true;
    private boolean isSingle = false;
    Object result;

    public boolean isSingle() {
        return this.isSingle;
    }

    public void setSingle(boolean isSingle) {
        this.isSingle = isSingle;
    }

    public void loadFields() {
        super.loadFields();
    }

    public void storeFields() {
        super.storeFields();
    }

    protected IObjectValue createNewData() {
        return null;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initFPFormItemTable();
    }

    private void initFPFormItemTable() throws EASBizException, BOSException {
        IFPMonitor iFPMonitor = FPMonitorFactory.getRemoteInstance();
        String companyId = (String)this.getUIContext().get(CTX_COMPANYID);
        String currencyId = (String)this.getUIContext().get(CTX_CURRENCYID);
        Date bizDate = (Date)this.getUIContext().get(CTX_DATE);
        FPItemTypeEnum[] itemTypes = (FPItemTypeEnum[])this.getUIContext().get(CTX_ITEM_TYPE);
        FPItemCollection itemColl = iFPMonitor.getFPItemCollection(companyId, currencyId, bizDate, itemTypes);
        this.tblFPItems.checkParsed();
        for (int i = 0; i < itemColl.size(); ++i) {
            IRow row = this.tblFPItems.addRow();
            row.getCell(COL_SELECTED).setValue((Object)Boolean.FALSE);
            row.getCell(COL_LINE_NO).setValue((Object)new Integer(itemColl.get(i).getLineNo()));
            row.getCell(COL_NUMBER).setValue((Object)itemColl.get(i).getNumber());
            row.getCell(COL_NAME).setValue((Object)itemColl.get(i).getName());
            row.getCell(COL_TYPE).setValue((Object)itemColl.get(i).getType());
            row.getCell(COL_COMMENT).setValue((Object)itemColl.get(i).getComment());
            row.setUserObject((Object)itemColl.get(i));
        }
    }

    public Object getData() {
        if (this.isCanceled()) {
            return null;
        }
        return this.result;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        this.canceled = true;
        this.getUIWindow().close();
    }

    protected void btnOK_actionPerformed(ActionEvent e) throws Exception {
        super.btnOK_actionPerformed(e);
        this.canceled = false;
        this.result = this.isSingle ? this.buildSingleResult() : this.buildResult();
        if (this.result == null) {
            return;
        }
        this.getUIWindow().close();
    }

    private Object[] buildResult() {
        FPItemCollection collection = new FPItemCollection();
        int size = this.tblFPItems.getRowCount();
        for (int i = 0; i < size; ++i) {
            IRow row = this.tblFPItems.getRow(i);
            if (!((Boolean)row.getCell(COL_SELECTED).getValue()).booleanValue()) continue;
            FPItemInfo info = (FPItemInfo)row.getUserObject();
            collection.add(info);
        }
        return collection.toArray();
    }

    private Object buildSingleResult() {
        int rowIndex = this.tblFPItems.getSelectManager().getActiveRowIndex();
        FPItemInfo info = null;
        if (rowIndex != -1) {
            IRow row = this.tblFPItems.getRow(rowIndex);
            info = (FPItemInfo)row.getUserObject();
        }
        return info;
    }

    protected void cbxSelectAll_actionPerformed(ActionEvent e) throws Exception {
        super.cbxSelectAll_actionPerformed(e);
        Boolean theBoolean = this.cbxSelectAll.isSelected();
        int size = this.tblFPItems.getRowCount();
        for (int i = 0; i < size; ++i) {
            IRow row = this.tblFPItems.getRow(i);
            row.getCell(COL_SELECTED).setValue((Object)theBoolean);
        }
    }
}

