/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fp.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitCommon;
import com.kingdee.eas.basedata.org.OrgUnitCommonFactory;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.CompanyF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.FMCommonFacadeFactory;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.IFMCommonFacade;
import com.kingdee.eas.fm.common.client.F7SelectorFactory;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.fp.CycleTypeEnum;
import com.kingdee.eas.fm.fp.FPItemCollection;
import com.kingdee.eas.fm.fp.FPItemFactory;
import com.kingdee.eas.fm.fp.FPScheduleCondParam;
import com.kingdee.eas.fm.fp.FPTemplateFactory;
import com.kingdee.eas.fm.fp.FPTemplateInfo;
import com.kingdee.eas.fm.fp.IFPItem;
import com.kingdee.eas.fm.fp.IFPTemplate;
import com.kingdee.eas.fm.fp.client.AbstractFPScheduleCondUI;
import com.kingdee.eas.fm.fp.client.FPClientHelper;
import com.kingdee.eas.framework.CheckedStatusEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.UuidException;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Set;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;

public class FPScheduleCondUI
extends AbstractFPScheduleCondUI {
    public static String resourcePath = "com.kingdee.eas.fm.fp.client.FPScheduleResource";

    public void onLoad() throws Exception {
        super.onLoad();
        this.btnCompanySelect.setVisible(false);
        this.btnCompanySelect.setEnabled(false);
    }

    public CompanyF7 getCompanySelector() {
        return F7SelectorFactory.getSelectCompany((IUIObject)this, (IUIObject)this.getListUI(), (ItemAction)this.getActionListOnLoad(), (boolean)false);
    }

    public Object getParam() {
        FPScheduleCondParam para = new FPScheduleCondParam();
        String companyId = AccessHelper.getF7Id((KDBizPromptBox)this.prmtCompany);
        para.setCompanyId(companyId);
        String name = null;
        try {
            name = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)companyId))).getName();
        }
        catch (EASBizException e) {
            e.printStackTrace();
            SysUtil.abort();
        }
        catch (BOSException e) {
            e.printStackTrace();
            SysUtil.abort();
        }
        catch (UuidException e) {
            e.printStackTrace();
            SysUtil.abort();
        }
        para.setCompanyName(name);
        para.setTemplateId(AccessHelper.getF7Id((KDBizPromptBox)this.f7Template));
        para.setTemplateName((String)AccessHelper.getF7Attribute((KDBizPromptBox)this.f7Template, (String)"name"));
        para.setCurrencyId(AccessHelper.getCboId((KDComboBox)this.cboCurrency));
        para.setCurrencyName((String)AccessHelper.getCboAttribute((KDComboBox)this.cboCurrency, (String)"name"));
        para.setCycleType(AccessHelper.getCboInt((KDComboBox)this.cboCycleType));
        para.setFpItemIdAry(AccessHelper.getF7Ids((KDBizPromptBox)this.f7FPItem));
        para.setBeginMonth(AccessHelper.getSpiValue((KDSpinner)this.spiBeginMonth));
        para.setBeginYear(AccessHelper.getSpiValue((KDSpinner)this.spiBeginYear));
        para.setEndMonth(AccessHelper.getSpiValue((KDSpinner)this.spiEndMonth));
        para.setEndYear(AccessHelper.getSpiValue((KDSpinner)this.spiEndYear));
        return para;
    }

    public void setParam(Object param) {
        if (param == null) {
            return;
        }
        if (!(param instanceof FPScheduleCondParam)) {
            return;
        }
        FPScheduleCondParam filterParam = (FPScheduleCondParam)param;
        String[] companyIds = new String[]{filterParam.getCompanyId()};
        this.setCompanyIds(companyIds);
        String currencyId = filterParam.getCurrencyId();
        CurrencyInfo currencyInfo = null;
        try {
            CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)filterParam.getCompanyId())));
            this.prmtCompany.setData((Object)company);
            ICurrency iCurrency = CurrencyFactory.getRemoteInstance();
            currencyInfo = iCurrency.getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyId));
            this.cboCurrency.setSelectedItem((Object)currencyInfo);
            String templateId = filterParam.getTemplateId();
            FPTemplateInfo templateInfo = null;
            IFPTemplate iTemplate = FPTemplateFactory.getRemoteInstance();
            templateInfo = iTemplate.getFPTemplateInfo((IObjectPK)new ObjectUuidPK(templateId));
            this.f7Template.setData((Object)templateInfo);
            Object[] fpItemIdAry = filterParam.getFpItemIdAry();
            if (!FMHelper.isEmpty((Object[])fpItemIdAry)) {
                IFPItem itemCtrl = FPItemFactory.getRemoteInstance();
                EntityViewInfo ev = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                HashSet<Object> set = new HashSet<Object>(fpItemIdAry.length);
                for (int i = 0; i < fpItemIdAry.length; ++i) {
                    set.add(fpItemIdAry[i]);
                }
                ev.setFilter(filter);
                FPItemCollection itemColl = itemCtrl.getFPItemCollection(ev);
                this.f7FPItem.setData((Object)itemColl.toArray());
            }
        }
        catch (Exception e2) {
            SysUtil.abort();
        }
        this.cboCycleType.setSelectedItem((Object)CycleTypeEnum.getEnum(filterParam.getCycleType()));
        this.spiBeginYear.setValue((Object)new Integer(filterParam.getBeginYear()));
        this.spiBeginMonth.setValue((Object)new Integer(filterParam.getBeginMonth()));
        this.spiEndYear.setValue((Object)new Integer(filterParam.getEndYear()));
        this.spiEndMonth.setValue((Object)new Integer(filterParam.getEndMonth()));
    }

    protected void init() throws Exception {
        super.init();
        this.initCompanyIds();
        FMClientHelper.initSpinFromTO((KDSpinner)this.spiBeginYear, (KDSpinner)this.spiBeginMonth, (KDSpinner)this.spiEndYear, (KDSpinner)this.spiEndMonth);
        FMClientHelper.initCurrency((KDComboBox)this.cboCurrency);
        CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        this.f7Template.setHasCUDefaultFilter(false);
        if (company != null) {
            EntityViewInfo ev = FPClientHelper.getTemplateFilterInfo(company.getId().toString());
            this.f7Template.setEntityViewInfo(ev);
        }
        FMClientHelper.setSelectObject((KDComboBox)this.cboCurrency, (Object)ContextHelperFactory.getRemoteInstance().getCompanyBaseCurrency(company));
        if (!company.isIsOnlyUnion()) {
            this.prmtCompany.setData((Object)company);
            this.prmtCompany.setEnabled(false);
        }
    }

    protected void prmtCompany_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtCompany_dataChanged(e);
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)this.prmtCompany.getData();
        this.f7Template.setData(null);
        if (company != null) {
            EntityViewInfo ev = FPClientHelper.getTemplateFilterInfo(company.getId().toString());
            this.f7Template.setEntityViewInfo(ev);
        }
    }

    protected void initCompanyIds() throws BOSException {
        String[] companyIds = new String[]{this.currentCompany.getId().toString()};
        this.setCompanyIds(companyIds);
    }

    protected void f7Template_dataChanged(DataChangeEvent e) throws Exception {
        super.f7Template_dataChanged(e);
        FPTemplateInfo info = (FPTemplateInfo)this.f7Template.getData();
        if (info == null) {
            return;
        }
        if (!info.containsKey("cycleType")) {
            IFPTemplate template = FPTemplateFactory.getRemoteInstance();
            info = template.getFPTemplateInfo("select *  where id='" + info.getId() + "'");
        }
        CycleTypeEnum ct = info.getCycleType();
        this.cboCycleType.removeAllItems();
        if (ct.equals((Object)CycleTypeEnum.DAY) || ct.equals((Object)CycleTypeEnum.WEEK) || ct.equals((Object)CycleTypeEnum.MONTH)) {
            this.cboCycleType.addItem((Object)CycleTypeEnum.MONTH);
            this.cboCycleType.addItem((Object)CycleTypeEnum.QUARTER);
            this.cboCycleType.addItem((Object)CycleTypeEnum.YEAR);
        } else if (ct.equals((Object)CycleTypeEnum.QUARTER)) {
            this.cboCycleType.addItem((Object)CycleTypeEnum.QUARTER);
            this.cboCycleType.addItem((Object)CycleTypeEnum.YEAR);
        } else if (ct.equals((Object)CycleTypeEnum.YEAR)) {
            this.cboCycleType.addItem((Object)CycleTypeEnum.YEAR);
        }
        FMClientHelper.initSpinFromTO((KDSpinner)this.spiBeginYear, (KDSpinner)this.spiBeginMonth, (KDSpinner)this.spiEndYear, (KDSpinner)this.spiEndMonth);
        if (ct.equals((Object)CycleTypeEnum.QUARTER)) {
            Calendar instance = Calendar.getInstance();
            int thisMonth = instance.get(2);
            int quarter = DateUtil.getSeason((int)thisMonth);
            SpinnerNumberModel mBeginModel = new SpinnerNumberModel(3 * quarter - 2, 1, 10, 3);
            this.spiBeginMonth.setModel((SpinnerModel)mBeginModel);
            SpinnerNumberModel mEndModel = new SpinnerNumberModel(3 * quarter, 3, 12, 3);
            this.spiEndMonth.setModel((SpinnerModel)mEndModel);
        }
        if (ct.equals((Object)CycleTypeEnum.YEAR)) {
            SpinnerNumberModel mBeginModel = new SpinnerNumberModel(1, 1, 1, 1);
            this.spiBeginMonth.setModel((SpinnerModel)mBeginModel);
            SpinnerNumberModel mEndModel = new SpinnerNumberModel(12, 12, 12, 1);
            this.spiEndMonth.setModel((SpinnerModel)mEndModel);
        }
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("fpTemplateId", (Object)info.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("type", (Object)new Integer(2001), CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("type", (Object)new Integer(4000), CompareType.NOTEQUALS));
        ev.getSorter().add(new SorterItemInfo("lineNo"));
        ev.setFilter(filter);
        this.f7FPItem.setEntityViewInfo(ev);
        this.f7FPItem.setData(null);
    }

    public boolean verify() {
        int endMonth;
        int endYear;
        int beginMonth;
        int beginYear;
        Integer value;
        super.verify();
        if (this.getCompanyIds() == null || this.getCompanyIds().length == 0 || this.prmtCompany.getData() == null) {
            this.btnCompanySelect.requestFocus(true);
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"CompanyNotEmpty"));
            SysUtil.abort();
        }
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (String)resourcePath, (KDBizPromptBox)this.f7Template, (String)"templateCannotEmpty");
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (String)resourcePath, (KDComboBox)this.cboCurrency, (String)"CurrencyNotEmpty");
        CycleTypeEnum ctype = (CycleTypeEnum)((Object)this.cboCycleType.getSelectedItem());
        if (ctype.equals((Object)CycleTypeEnum.QUARTER) && (value = (Integer)this.spiBeginMonth.getValue()) % 3 != 1) {
            this.spiBeginMonth.requestFocus(true);
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fp.client.FPSumAnalysisResource", (String)"MustFirstMonth"));
            SysUtil.abort();
        }
        if ((beginYear = ((Integer)this.spiBeginYear.getValue()).intValue()) * 100 + (beginMonth = ((Integer)this.spiBeginMonth.getValue()).intValue()) > (endYear = ((Integer)this.spiEndYear.getValue()).intValue()) * 100 + (endMonth = ((Integer)this.spiEndMonth.getValue()).intValue())) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"BeginThanEnd"));
            SysUtil.abort();
        }
        return true;
    }

    protected void f7FPItem_willShow(SelectorEvent e) throws Exception {
        super.f7FPItem_willShow(e);
        Object data = this.f7Template.getData();
        if (data == null) {
            this.f7Template.requestFocus(true);
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"templateCannotEmpty"));
            e.setCanceled(true);
            return;
        }
    }

    protected void companyValueChange(PropertyChangeEvent e) throws Exception {
        Object[] company = this.getCompanyIds();
        if (FMHelper.isEmpty((Object[])company)) {
            return;
        }
        Set<String> set = new HashSet<String>();
        if (company.length > 1) {
            IOrgUnitCommon com = OrgUnitCommonFactory.getRemoteInstance();
            CompanyOrgUnitInfo c = com.getRootCompany();
            set.add(c.getId().toString());
        } else {
            OrgUnitInfo info = (OrgUnitInfo)company[0];
            IFMCommonFacade fm = FMCommonFacadeFactory.getRemoteInstance();
            String treeId = "00000000-0000-0000-0000-0000000000024F2827FD";
            set = fm.getAllParentOrgIds(treeId, info.getId().toString());
        }
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", set, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("checkedStatus", (Object)new Integer(CheckedStatusEnum.AUDITED.getValue())));
        if (company.length == 1) {
            FilterInfo self = new FilterInfo();
            OrgUnitInfo info = (OrgUnitInfo)company[0];
            self.getFilterItems().add(new FilterItemInfo("company.id", (Object)info.getId()));
            filter.mergeFilter(self, "or");
        }
        ev.setFilter(filter);
        this.f7Template.setEntityViewInfo(ev);
        this.f7Template.setData(null);
        this.f7FPItem.setData(null);
        super.companyValueChange((Object)e);
    }
}

