/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fp.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.fp.CycleRangeCollection;
import com.kingdee.eas.fm.fp.CycleRangeInfo;
import com.kingdee.eas.fm.fp.CycleTypeEnum;
import com.kingdee.eas.fm.fp.FPCycleIntervalEnum;
import com.kingdee.eas.fm.fp.FPHelper;
import com.kingdee.eas.fm.fp.FPSumAnalysisCondParam;
import com.kingdee.eas.fm.fp.FPSumAnalysisOrderEnum;
import com.kingdee.eas.fm.fp.client.AbstractFPSumAnalysisHandler;
import com.kingdee.eas.fm.fp.client.FPFormClientHelper;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import javax.swing.tree.MutableTreeNode;

public class FPSumAnalysisCompanyHandler
extends AbstractFPSumAnalysisHandler {
    public void initTreeList(FPSumAnalysisCondParam param, DefaultKingdeeTreeNode root) {
        String[] companyId = param.getCompanyIdAry();
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < companyId.length; ++i) {
            set.add(companyId[i]);
        }
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        ev.getSelector().add("name");
        filter.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
        ev.setFilter(filter);
        CompanyOrgUnitCollection coll = null;
        try {
            ICompanyOrgUnit company = CompanyOrgUnitFactory.getRemoteInstance();
            coll = company.getCompanyOrgUnitCollection(ev);
        }
        catch (BOSException e) {
            SysUtil.abort();
        }
        for (int i = 0; i < coll.size(); ++i) {
            DefaultKingdeeTreeNode newChild = new DefaultKingdeeTreeNode((Object)coll.get(i));
            root.add((MutableTreeNode)newChild);
        }
    }

    public void initTableHeader(KDTable tblMain, FPSumAnalysisCondParam param) throws Exception {
        CycleTypeEnum cycleType = CycleTypeEnum.getEnum(param.getCycleType());
        int amountNumber = 1;
        if (param.getIsDispActual()) {
            amountNumber = 2;
        }
        CycleRangeCollection coll = FPHelper.genCycleRanges(cycleType, FPCycleIntervalEnum.ONE, param.getBeginYear(), param.getBeginMonth() - 1, param.getEndYear(), param.getEndMonth() - 1);
        this.insertHeader(tblMain, param, amountNumber, (IObjectCollection)coll);
        tblMain.getColumn(0).setWidth(300);
        this.initCycleHeader(tblMain, cycleType, amountNumber, coll);
    }

    public IRowSet getRowset(IMetaDataPK mainQueryPK, EntityViewInfo mainQuery, FPSumAnalysisCondParam param, CoreBaseInfo info) throws BOSException {
        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)mainQueryPK);
        EntityViewInfo ev = (EntityViewInfo)mainQuery.clone();
        ev.getFilter().getFilterItems().add(new FilterItemInfo("companyId", (Object)info.getId()));
        exec.setObjectView(ev);
        String sql = exec.getSQL();
        StringBuffer sb = new StringBuffer(128);
        sb.append("SELECT ");
        sb.append(" ENTRIESNAME,FPITEMEXPRESSION, SUM(ENTRIESPLANAMOUNT) AS PLANAMOUNT, SUM(ENTRIESACTUALAMOUNT) AS ACTUALAMOUNT");
        CycleTypeEnum cycleType = CycleTypeEnum.getEnum(param.getCycleType());
        this.appendCycleType(sb, cycleType);
        sb.append(" from (");
        sb.append(sql);
        sb.append(") a");
        sb.append(" GROUP BY");
        sb.append(" ENTRIESNAME,FPITEMLINENO,FPITEMEXPRESSION");
        this.appendCycleType(sb, cycleType);
        sb.append(" ORDER BY FPITEMLINENO");
        ISQLExecutor sqlExe = SQLExecutorFactory.getRemoteInstance((String)sb.toString());
        IRowSet rs = sqlExe.executeSQL();
        return rs;
    }

    public Map getRowsetMap(IRowSet rs, CycleTypeEnum cycleType) throws SQLException {
        String[] keys = null;
        keys = cycleType.equals((Object)CycleTypeEnum.YEAR) ? new String[]{"ENTRIESNAME", "CYCLERANGEYEAR"} : (cycleType.equals((Object)CycleTypeEnum.QUARTER) ? new String[]{"ENTRIESNAME", "CYCLERANGEYEAR", "CYCLERANGEQUARTER"} : new String[]{"ENTRIESNAME", "CYCLERANGEYEAR", "CYCLERANGEMONTH"});
        String[] valueskey = new String[]{"PLANAMOUNT", "ACTUALAMOUNT"};
        Map cache = FMHelper.populateMap((ResultSet)rs, (String[])valueskey, (String[])keys);
        return cache;
    }

    public String getFirstColKey() {
        return "ENTRIESNAME";
    }

    public FPSumAnalysisOrderEnum getFirstColType() {
        return FPSumAnalysisOrderEnum.ITEM;
    }

    public void fillData(KDTable tblMain, Map cache, boolean isDispActual) {
        super.fillData(tblMain, cache, isDispActual);
    }

    public BigDecimal getActualBegining(KDTable tblMain, FPSumAnalysisCondParam param, CoreBaseInfo treeNodeInfo, int i) {
        CycleTypeEnum cycleType = CycleTypeEnum.getEnum(param.getCycleType());
        String val = (String)tblMain.getHeadRow(0).getCell(i).getUserObject();
        Date bizDate = CycleRangeInfo.dateKeyToDate(cycleType, val);
        BigDecimal actual = FPFormClientHelper.getActualBegining((IObjectPK)new ObjectUuidPK(treeNodeInfo.getId()), (IObjectPK)new ObjectUuidPK(param.getCurrencyId()), bizDate);
        return actual;
    }

    public boolean isStatusItems() {
        return true;
    }

    private void appendCycleType(StringBuffer str, CycleTypeEnum typeEnum) {
    }
}

