/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fp.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.fp.CycleRangeCollection;
import com.kingdee.eas.fm.fp.CycleRangeInfo;
import com.kingdee.eas.fm.fp.CycleTypeEnum;
import com.kingdee.eas.fm.fp.FPCycleIntervalEnum;
import com.kingdee.eas.fm.fp.FPHelper;
import com.kingdee.eas.fm.fp.FPSumAnalysisCondParam;
import com.kingdee.eas.fm.fp.FPSumAnalysisOrderEnum;
import com.kingdee.eas.fm.fp.client.AbstractFPSumAnalysisHandler;
import com.kingdee.eas.fm.fp.client.FPFormClientHelper;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.Map;
import javax.swing.tree.MutableTreeNode;

public class FPSumAnalysisCycleHandler
extends AbstractFPSumAnalysisHandler {
    public void initTreeList(FPSumAnalysisCondParam p, DefaultKingdeeTreeNode root) {
        CycleTypeEnum ctype = CycleTypeEnum.getEnum(p.getCycleType());
        int beginMonth = p.getBeginMonth() - 1;
        if (ctype.equals((Object)CycleTypeEnum.QUARTER)) {
            beginMonth = beginMonth / 3 * 3;
        }
        CycleRangeCollection coll = FPHelper.genCycleRanges(ctype, FPCycleIntervalEnum.ONE, p.getBeginYear(), beginMonth, p.getEndYear(), p.getEndMonth() - 1);
        for (int i = 0; i < coll.size(); ++i) {
            CycleRangeInfo cycleRangeInfo = coll.get(i);
            DefaultKingdeeTreeNode newChild = new DefaultKingdeeTreeNode((Object)cycleRangeInfo);
            newChild.setText(cycleRangeInfo.toString());
            root.add((MutableTreeNode)newChild);
        }
    }

    public void initTableHeader(KDTable tblMain, FPSumAnalysisCondParam param) throws Exception {
        int amountNumber = 1;
        if (param.getIsDispActual()) {
            amountNumber = 2;
        }
        CompanyOrgUnitCollection coll = this.getCompanyColl(param);
        this.insertHeader(tblMain, param, amountNumber, (IObjectCollection)coll);
        tblMain.getColumn(0).setWidth(300);
        this.initCompanyHeader(tblMain, amountNumber, coll);
    }

    public IRowSet getRowset(IMetaDataPK mainQueryPK, EntityViewInfo mainQuery, FPSumAnalysisCondParam param, CoreBaseInfo info) throws BOSException {
        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)mainQueryPK);
        EntityViewInfo ev = (EntityViewInfo)mainQuery.clone();
        ev.getFilter().getFilterItems().add(new FilterItemInfo("cycleRangeBeginDate", (Object)info.getDate("BeginDate"), CompareType.GREATER_EQUALS));
        ev.getFilter().getFilterItems().add(new FilterItemInfo("cycleRangeEndDate", (Object)info.getDate("EndDate"), CompareType.LESS_EQUALS));
        exec.setObjectView(ev);
        String sql = exec.getSQL();
        StringBuffer sb = new StringBuffer(128);
        sb.append("SELECT ");
        sb.append(" ENTRIESNAME,FPITEMEXPRESSION, SUM(ENTRIESPLANAMOUNT) AS PLANAMOUNT, SUM(ENTRIESACTUALAMOUNT) AS ACTUALAMOUNT , COMPANYID");
        CycleTypeEnum cycleType = CycleTypeEnum.getEnum(param.getCycleType());
        this.appendCycleType(sb, cycleType);
        sb.append(" from (");
        sb.append(sql);
        sb.append(") a");
        sb.append(" GROUP BY");
        sb.append(" ENTRIESNAME,FPITEMLINENO,COMPANYID,FPITEMEXPRESSION ");
        this.appendCycleType(sb, cycleType);
        sb.append(" ORDER BY FPITEMLINENO,COMPANYID");
        ISQLExecutor sqlExe = SQLExecutorFactory.getRemoteInstance((String)sb.toString());
        IRowSet rs = sqlExe.executeSQL();
        return rs;
    }

    public Map getRowsetMap(IRowSet rs, CycleTypeEnum cycleType) throws SQLException {
        String[] keys = new String[]{"ENTRIESNAME", "COMPANYID"};
        String[] valueskey = new String[]{"PLANAMOUNT", "ACTUALAMOUNT"};
        Map cache = FMHelper.populateMap((ResultSet)rs, (String[])valueskey, (String[])keys);
        return cache;
    }

    public String getFirstColKey() {
        return "ENTRIESNAME";
    }

    public FPSumAnalysisOrderEnum getFirstColType() {
        return FPSumAnalysisOrderEnum.ITEM;
    }

    public BigDecimal getActualBegining(KDTable tblMain, FPSumAnalysisCondParam param, CoreBaseInfo treeNodeInfo, int i) {
        CycleRangeInfo info = (CycleRangeInfo)treeNodeInfo;
        Date bizDate = info.getBeginDate();
        CycleTypeEnum cycleType = CycleTypeEnum.getEnum(param.getCycleType());
        BOSUuid val = (BOSUuid)tblMain.getHeadRow(0).getCell(i).getUserObject();
        BigDecimal actual = FPFormClientHelper.getActualBegining((IObjectPK)new ObjectUuidPK(val), (IObjectPK)new ObjectUuidPK(param.getCurrencyId()), bizDate);
        return actual;
    }

    public boolean isStatusItems() {
        return true;
    }

    private void appendCycleType(StringBuffer str, CycleTypeEnum typeEnum) {
    }
}

