/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fp.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.fp.CycleRangeCollection;
import com.kingdee.eas.fm.fp.CycleTypeEnum;
import com.kingdee.eas.fm.fp.FPCycleIntervalEnum;
import com.kingdee.eas.fm.fp.FPHelper;
import com.kingdee.eas.fm.fp.FPSumAnalysisCondParam;
import com.kingdee.eas.fm.fp.FPSumAnalysisOrderEnum;
import com.kingdee.eas.fm.fp.client.AbstractFPSumAnalysisFPItemHandler;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

public class FPSumAnalysisFPItemCycleHandler
extends AbstractFPSumAnalysisFPItemHandler {
    public Map getRowsetMap(IRowSet rs, CycleTypeEnum cycleType) throws SQLException {
        String[] keys = null;
        keys = cycleType.equals((Object)CycleTypeEnum.YEAR) ? new String[]{"COMPANYNAME", "CYCLERANGEYEAR"} : (cycleType.equals((Object)CycleTypeEnum.QUARTER) ? new String[]{"COMPANYNAME", "CYCLERANGEYEAR", "CYCLERANGEQUARTER"} : new String[]{"COMPANYNAME", "CYCLERANGEYEAR", "CYCLERANGEMONTH"});
        String[] valueskey = new String[]{"PLANAMOUNT", "ACTUALAMOUNT"};
        Map cache = FMHelper.populateMap((ResultSet)rs, (String[])valueskey, (String[])keys);
        return cache;
    }

    public void initTableHeader(KDTable tblMain, FPSumAnalysisCondParam param) throws Exception {
        CycleTypeEnum cycleType = CycleTypeEnum.getEnum(param.getCycleType());
        int amountNumber = 1;
        if (param.getIsDispActual()) {
            amountNumber = 2;
        }
        CycleRangeCollection coll = FPHelper.genCycleRanges(cycleType, FPCycleIntervalEnum.ONE, param.getBeginYear(), param.getBeginMonth() - 1, param.getEndYear(), param.getEndMonth() - 1);
        this.insertHeader(tblMain, param, amountNumber, (IObjectCollection)coll);
        this.initCycleHeader(tblMain, cycleType, amountNumber, coll);
    }

    public IRowSet getRowset(IMetaDataPK mainQueryPK, EntityViewInfo mainQuery, FPSumAnalysisCondParam param, CoreBaseInfo info) throws BOSException {
        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)mainQueryPK);
        EntityViewInfo ev = (EntityViewInfo)mainQuery.clone();
        ev.getFilter().getFilterItems().add(new FilterItemInfo("fpItemId", (Object)info.getId()));
        exec.setObjectView(ev);
        String sql = exec.getSQL();
        StringBuffer sb = new StringBuffer(128);
        sb.append("SELECT ");
        sb.append(" COMPANYNAME, SUM(ENTRIESPLANAMOUNT) AS PLANAMOUNT, SUM(ENTRIESACTUALAMOUNT) AS ACTUALAMOUNT");
        CycleTypeEnum cycleType = CycleTypeEnum.getEnum(param.getCycleType());
        this.appendCycleType(sb, cycleType);
        this.appendCycleDisp(sb, cycleType);
        sb.append(" from (");
        sb.append(sql);
        sb.append(") a");
        sb.append(" GROUP BY");
        this.appendCycleType0(sb, cycleType);
        sb.append(", COMPANYNAME");
        ISQLExecutor sqlExe = SQLExecutorFactory.getRemoteInstance((String)sb.toString());
        IRowSet rs = sqlExe.executeSQL();
        return rs;
    }

    public String getFirstColKey() {
        return "COMPANYNAME";
    }

    public FPSumAnalysisOrderEnum getFirstColType() {
        return FPSumAnalysisOrderEnum.COMPANY;
    }

    private void appendCycleType(StringBuffer str, CycleTypeEnum typeEnum) {
    }

    private void appendCycleDisp(StringBuffer str, CycleTypeEnum typeEnum) {
    }

    private void appendCycleType0(StringBuffer str, CycleTypeEnum typeEnum) {
    }
}

