/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fp.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.HashSearchEngine;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.fp.CycleRangeCollection;
import com.kingdee.eas.fm.fp.CycleRangeInfo;
import com.kingdee.eas.fm.fp.FPFormEntryCollection;
import com.kingdee.eas.fm.fp.FPFormEntryInfo;
import com.kingdee.eas.fm.fp.FPFormFactory;
import com.kingdee.eas.fm.fp.FPFormInfo;
import com.kingdee.eas.fm.fp.FPFormulaCollection;
import com.kingdee.eas.fm.fp.FPFormulaContext;
import com.kingdee.eas.fm.fp.FPFormulaFactory;
import com.kingdee.eas.fm.fp.FPFormulaInfo;
import com.kingdee.eas.fm.fp.FPFormulaTypeEnum;
import com.kingdee.eas.fm.fp.FPItemTypeEnum;
import com.kingdee.eas.fm.fp.IFPForm;
import com.kingdee.eas.fm.fp.IFPFormula;
import com.kingdee.eas.fm.fp.client.AbstractFPTraceUI;
import com.kingdee.eas.fm.fp.client.FPFormClientHelper;
import com.kingdee.eas.fm.fp.client.FPFormListUI;
import com.kingdee.eas.fm.fp.client.FPTraceDetailUI;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.math.BigDecimal;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class FPTraceUI
extends AbstractFPTraceUI {
    private static final String COL_ACTUALAMOUNT = "actualAmount";
    private final String resourcePath = "com.kingdee.eas.fm.fp.client.FPTraceResource";
    private boolean isAudit;
    IRow currentRow;
    private FPFormEntryInfo so = null;

    public void loadFields() {
        super.loadFields();
    }

    public boolean checkBeforeWindowClosing() {
        return true;
    }

    public void storeFields() {
        super.storeFields();
    }

    protected IObjectValue createNewData() {
        return null;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnViewDetail.setIcon(EASResource.getIcon((String)"imgTbtn_check"));
        this.btnViewDetail.setEnabled(true);
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.kDSplitPane1.setDividerLocation(270);
        FMClientHelper.clearSeparatorOnToolBar((KDToolBar)this.toolBar);
    }

    protected ICoreBase getBizInterface() throws Exception {
        return FPFormFactory.getRemoteInstance();
    }

    public void onLoad() throws Exception {
        this.tblMain.checkParsed();
        super.onLoad();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("entries.*"));
        selector.add(new SelectorItemInfo("entries.fpItem.id"));
        selector.add(new SelectorItemInfo("entries.fpItem.lineNo"));
        selector.add(new SelectorItemInfo("entries.fpItem.expression"));
        selector.add(new SelectorItemInfo("entries.fpItem.actualFormula"));
        selector.add(new SelectorItemInfo("entries.cycleRange.*"));
        selector.add(new SelectorItemInfo("auditor.name"));
        selector.add(new SelectorItemInfo("template.name"));
        selector.add(new SelectorItemInfo("creator.name"));
        selector.add(new SelectorItemInfo("template.name"));
        selector.add(new SelectorItemInfo("company.name"));
        selector.add(new SelectorItemInfo("currency.name"));
        selector.add(new SelectorItemInfo("company.number"));
        selector.add(new SelectorItemInfo("currency.number"));
        selector.add(new SelectorItemInfo("cycleRanges.*"));
        String id = (String)this.getUIContext().get("ID");
        IFPForm iFPForm = FPFormFactory.getRemoteInstance();
        FPFormInfo formInfo = iFPForm.getFPFormInfo((IObjectPK)new ObjectUuidPK(id), selector);
        FPFormClientHelper.sortFormEntries(formInfo);
        this.setDataObject((IObjectValue)formInfo);
        this.isAudit = formInfo.getAuditor() != null;
        this.setUIStatus();
        this.txtCompany.setText(formInfo.getCompany().getName());
        this.txtCurrency.setText(formInfo.getCurrency().getName());
        this.txtName.setText(formInfo.getName());
        this.txtNumber.setText(formInfo.getNumber());
        this.txtTemplate.setText(formInfo.getTemplate().getName());
        this.txtPeriod.setText(formInfo.getBeginDate() + " - " + formInfo.getEndDate());
        this.bizPromptCreator.setValue(formInfo.getCreator() == null ? null : formInfo.getCreator().getName());
        this.dtpCreateTime.setValue((Object)formInfo.getCreateTime());
        this.bizPromptAuditor.setValue(formInfo.getAuditor() == null ? null : formInfo.getAuditor().getName());
        this.dtpAuditedTime.setValue((Object)formInfo.getAuditedTime());
        this.actionExport.setVisible(true);
        this.initTraceTable(formInfo, this.tblMain);
        KingdeeTreeModel model = this.getTreeModel(formInfo.getCycleRanges());
        this.treeMain.setModel((TreeModel)model);
        this.treeMain.setRootVisible(false);
        this.treeMain.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                if (e.getNewLeadSelectionPath() != null) {
                    TreePath path = e.getNewLeadSelectionPath();
                    DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)path.getLastPathComponent();
                    if (node.isRoot()) {
                        return;
                    }
                    FPTraceUI.this.tblMain.removeRows(true);
                    FPTraceUI.this.initTraceTable(FPTraceUI.this.editData, FPTraceUI.this.tblMain);
                }
            }
        });
        FMClientHelper.goLeaf((KDTree)this.treeMain);
        this.enableExportExcel(this.tblMain);
    }

    private void setUIStatus() {
        if (this.isAudit) {
            this.btnSubmit.setEnabled(false);
            this.btnImport.setEnabled(false);
            this.btnReset.setEnabled(false);
            this.btnResetCell.setEnabled(false);
            this.btnFormula.setEnabled(false);
            this.txtFormula.setEnabled(false);
            this.tblMain.getColumn(COL_ACTUALAMOUNT).getStyleAttributes().setLocked(true);
        } else {
            this.btnViewDetail.setEnabled(false);
        }
        if (this.isGroup() && this.editData.isIsJoint()) {
            this.actionRefresh.setEnabled(true);
        } else {
            this.actionRefresh.setEnabled(false);
        }
    }

    private void initTraceTable(FPFormInfo info, KDTable tblMain) {
        FPFormClientHelper.sortFormEntries(info);
        FPFormEntryCollection coll = info.getEntries();
        TreePath path = this.treeMain.getSelectionPath();
        if (this.treeMain.getSelectionPath() == null) {
            return;
        }
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)path.getLastPathComponent();
        coll = this.filtrateEntryColl((IObjectCollection)coll, node);
        this.bindDataToTable(tblMain, (IObjectCollection)coll);
        FPFormClientHelper.hideStatRows(tblMain);
    }

    private void bindDataToTable(KDTable tblMain, IObjectCollection coll) {
        int i;
        BOSUuid currencyId = this.editData.getCurrency().getId();
        KDTDefaultCellEditor editor = FPFormClientHelper.getCurrencyEditor(currencyId);
        String numberFmt = FMClientHelper.getNumberFtm((BOSUuid)currencyId);
        tblMain.getColumn(1).getStyleAttributes().setNumberFormat(numberFmt);
        tblMain.getColumn(1).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        tblMain.getColumn(2).getStyleAttributes().setNumberFormat(numberFmt);
        tblMain.getColumn(2).setEditor((ICellEditor)editor);
        tblMain.getColumn(2).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        FPFormEntryInfo entryInfo = null;
        for (i = 0; i < coll.size(); ++i) {
            IRow row = tblMain.addRow();
            entryInfo = (FPFormEntryInfo)coll.getObject(i);
            row.setUserObject((Object)entryInfo);
            this.loadLineFields(tblMain, row, (IObjectValue)entryInfo);
        }
        FPFormClientHelper.formatTableStyle(tblMain, true);
        for (i = 1; i < tblMain.getColumnCount(); ++i) {
            for (int j = 3; j < tblMain.getRowCount(); ++j) {
                IRow totalRow = tblMain.getRow(j);
                FPFormEntryInfo info = (FPFormEntryInfo)totalRow.getUserObject();
                String expression = info.getFpItem().getCellExp();
                if (info.getType() != FPItemTypeEnum.SYSTEMHOLD && info.getType() != FPItemTypeEnum.SUBTOTAL) continue;
                totalRow.getCell(i).setExpressions(expression);
            }
        }
    }

    private IObjectCollection filtrateEntryColl(IObjectCollection coll, DefaultKingdeeTreeNode node) {
        FPFormEntryCollection newColl = new FPFormEntryCollection();
        if (node == null) {
            return newColl;
        }
        for (int i = 0; i < coll.size(); ++i) {
            CycleRangeInfo cycleRangeInfo;
            FPFormEntryInfo entryInfo = (FPFormEntryInfo)coll.getObject(i);
            if (!(node.getUserObject() instanceof CycleRangeInfo) || !(cycleRangeInfo = (CycleRangeInfo)node.getUserObject()).getId().equals((Object)entryInfo.getCycleRange().getId())) continue;
            newColl.addObject((IObjectValue)entryInfo);
        }
        return newColl;
    }

    private KingdeeTreeModel getTreeModel(CycleRangeCollection coll) {
        String period = EASResource.getString((String)FPFormListUI.resourcePath, (String)"PERIOD");
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode((Object)period);
        KingdeeTreeModel model = new KingdeeTreeModel((TreeNode)root);
        KDTreeNode node = null;
        CycleRangeInfo cycleRange = null;
        for (int i = 0; i < coll.size(); ++i) {
            cycleRange = coll.get(i);
            node = new KDTreeNode((Object)cycleRange);
            node.setText(cycleRange.getBeginDate() + " - " + cycleRange.getEndDate());
            node.setUserObject((Object)cycleRange);
            root.add((MutableTreeNode)node);
        }
        return model;
    }

    protected void loadLineFields(KDTable table, IRow row, IObjectValue obj) {
        FPFormEntryInfo entryInfo = (FPFormEntryInfo)obj;
        row.getCell(0).setValue((Object)entryInfo.getName());
        row.getCell(1).setValue((Object)entryInfo.getPlanAmount());
        row.getCell(2).setValue((Object)entryInfo.getActualAmount());
    }

    public void setDataObject(IObjectValue dataObject) {
        super.setDataObject(dataObject);
    }

    protected void tblMain_editStopped(KDTEditEvent e) throws Exception {
        super.tblMain_editStopped(e);
        int colNum = e.getColIndex();
        int rowNum = e.getRowIndex();
        this.updateEntryInfo(colNum, rowNum);
    }

    protected void updateEntryInfo(int colNum, int rowNum) {
        IRow row = this.tblMain.getRow(rowNum);
        ICell cell = this.tblMain.getCell(rowNum, colNum);
        FPFormEntryInfo entryInfo = (FPFormEntryInfo)row.getUserObject();
        Object value = cell.getValue();
        BigDecimal newValue = null;
        newValue = value == null ? Constants.ZERO : new BigDecimal(value.toString());
        entryInfo.setActualAmount(newValue);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        IFPForm iFPForm = FPFormFactory.getRemoteInstance();
        iFPForm.save((CoreBaseInfo)this.editData);
        this.showSubmitSuccess();
    }

    public void actionImport_actionPerformed(ActionEvent e) throws Exception {
        ICell cell = null;
        IRow row = null;
        FPFormClientHelper.importExcel((Component)((Object)this), this.tblMain);
        int headRowCount = this.tblMain.getHeadRowCount();
        int maxColumn = this.tblMain.getColumnCount();
        int maxRow = this.tblMain.getRowCount();
        FPFormEntryInfo formEntryInfo = null;
        String strValue = null;
        BigDecimal theValue = null;
        for (int i = 0; i < maxRow; ++i) {
            row = this.tblMain.getRow(i);
            formEntryInfo = (FPFormEntryInfo)row.getUserObject();
            for (int j = 1; j < maxColumn; ++j) {
                cell = this.tblMain.getRow(i).getCell(j);
                if (cell.getStyleAttributes().isLocked()) continue;
                strValue = cell.getValue().toString();
                theValue = new BigDecimal(strValue);
                formEntryInfo.setActualAmount(theValue);
            }
        }
    }

    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        FMClientHelper.exportExcel((Component)((Object)this), (KDTable)this.tblMain, (boolean)true);
    }

    public void actionViewDetail_actionPerformed(ActionEvent e) throws Exception {
        super.actionViewDetail_actionPerformed(e);
        FMClientHelper.checkSelected((Component)((Object)this), (KDTable)this.tblMain);
        int rowNumber = FMClientHelper.getSelectedRow((KDTable)this.tblMain);
        IRow row = this.tblMain.getRow(rowNumber);
        FPFormEntryInfo entryInfo = (FPFormEntryInfo)row.getUserObject();
        if (entryInfo == null || entryInfo.getType() == null) {
            return;
        }
        FPItemTypeEnum type = entryInfo.getType();
        if (type.equals((Object)FPItemTypeEnum.SUBTOTAL) || type.equals((Object)FPItemTypeEnum.SYSTEMHOLD) || type.equals((Object)FPItemTypeEnum.ONLYREFERENCED)) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fm.fp.client.FPTraceResource", (String)"NotInOutItem"));
            return;
        }
        String fpEntryId = entryInfo.getId().toString();
        String cycleRangeId = entryInfo.getCycleRange().getId().toString();
        FPTraceDetailUI.showDialogWindow((IUIObject)this, fpEntryId, cycleRangeId, this.editData.getCycleRanges());
    }

    public void actionReset_actionPerformed(ActionEvent e) throws Exception {
        super.actionReset_actionPerformed(e);
        FPFormEntryCollection entries = this.editData.getEntries();
        FPFormulaCollection coll = new FPFormulaCollection();
        for (int i = 0; i < entries.size(); ++i) {
            FPFormulaInfo info = new FPFormulaInfo();
            FPFormEntryInfo entry = entries.get(i);
            String script = entry.getActualFormula();
            if (FMHelper.isEmptyScript((String)script)) {
                script = entry.getFpItem().getActualFormula();
            }
            System.out.println("script" + script);
            if (EmptyUtil.isEmpty((String)script)) continue;
            if ('=' == script.charAt(0)) {
                info.setScript(script);
            } else {
                info.setScript('=' + script);
            }
            FPFormulaContext formulaCtx = new FPFormulaContext();
            formulaCtx.setCompany(this.editData.getCompany().getNumber());
            formulaCtx.setCurrency(this.editData.getCurrency().getNumber());
            formulaCtx.setCycleType(this.editData.getCycleType());
            formulaCtx.setCycleInterval(this.editData.getCycleInterval());
            formulaCtx.setBegin(entry.getCycleRange().getBeginDate());
            formulaCtx.setEnd(entry.getCycleRange().getEndDate());
            info.setFormulaCtx(formulaCtx);
            info.setRefObjectID(entry.getId());
            coll.add(info);
        }
        IFPFormula formula = FPFormulaFactory.getRemoteInstance();
        FPFormulaCollection rst = formula.runner(coll);
        HashSearchEngine se = new HashSearchEngine((IObjectCollection)rst, new String[]{"refObjectID"});
        se.setDestKeys(new String[]{"id"});
        for (int i = 0; i < entries.size(); ++i) {
            FPFormEntryInfo entry = entries.get(i);
            if (!se.evaluate((IObjectValue)entry)) continue;
            FPFormulaInfo object = (FPFormulaInfo)se.getResult();
            entry.setActualAmount(object.getResult());
        }
        this.tblMain.removeRows(true);
        this.initTraceTable(this.editData, this.tblMain);
    }

    public void actionResetCell_actionPerformed(ActionEvent e) throws Exception {
        super.actionResetCell_actionPerformed(e);
        if (this.currentRow == null) {
            return;
        }
        Object userInfo = this.currentRow.getUserObject();
        String script = null;
        if (userInfo != null && userInfo instanceof FPFormEntryInfo) {
            this.so = (FPFormEntryInfo)userInfo;
            script = this.so.getActualFormula();
            if (FMHelper.isEmptyScript((String)script)) {
                script = this.so.getFpItem().getActualFormula();
            }
        }
        if (EmptyUtil.isEmpty(script)) {
            return;
        }
        FPFormulaInfo info = new FPFormulaInfo();
        if ('=' == script.charAt(0)) {
            info.setScript(script);
        } else {
            info.setScript('=' + script);
        }
        FPFormulaContext formulaCtx = new FPFormulaContext();
        formulaCtx.setCompany(this.editData.getCompany().getNumber());
        formulaCtx.setCurrency(this.editData.getCurrency().getNumber());
        formulaCtx.setCycleType(this.editData.getCycleType());
        formulaCtx.setCycleInterval(this.editData.getCycleInterval());
        formulaCtx.setBegin(this.so.getCycleRange().getBeginDate());
        formulaCtx.setEnd(this.so.getCycleRange().getEndDate());
        info.setFormulaCtx(formulaCtx);
        info.setRefObjectID(this.so.getId());
        IFPFormula formula = FPFormulaFactory.getRemoteInstance();
        FPFormulaInfo rst = formula.runner(info);
        this.so.setActualAmount(rst.getResult());
        this.tblMain.removeRows(true);
        this.initTraceTable(this.editData, this.tblMain);
    }

    protected void txtFormula_keyReleased(KeyEvent e) throws Exception {
        super.txtFormula_keyReleased(e);
        if (this.so != null) {
            String script = this.txtFormula.getText();
            if (FMHelper.isEmptyScript((String)script) || script.equalsIgnoreCase(this.so.getFpItem().getActualFormula())) {
                this.so.setActualFormula(null);
                return;
            }
            this.so.setActualFormula(script);
        }
    }

    protected void tblMain_activeCellChanged(KDTActiveCellEvent e) throws Exception {
        boolean locked;
        super.tblMain_activeCellChanged(e);
        int columnIndex = e.getColumnIndex();
        int rowIndex = e.getRowIndex();
        IRow row = this.tblMain.getRow(rowIndex);
        if (row == null) {
            return;
        }
        Object userInfo = row.getUserObject();
        String script = null;
        if (userInfo != null && userInfo instanceof FPFormEntryInfo) {
            this.so = (FPFormEntryInfo)userInfo;
            script = this.so.getActualFormula();
            if (FMHelper.isEmptyScript((String)script)) {
                script = this.so.getFpItem().getActualFormula();
            }
        }
        if (locked = row.getStyleAttributes().isLocked()) {
            this.so = null;
            this.txtFormula.setText(null);
            this.txtFormula.setEnabled(false);
            this.actionFormula.setEnabled(false);
            this.actionResetCell.setEnabled(false);
            this.currentRow = null;
        } else {
            this.txtFormula.setText(script);
            if (script != null && script.length() > 0) {
                this.txtFormula.setCaretPosition(script.length());
            }
            if (!this.isAudit) {
                this.txtFormula.setEnabled(true);
                this.actionFormula.setEnabled(true);
                this.actionResetCell.setEnabled(true);
                this.tblMain.getEditManager().editCellAt(rowIndex, columnIndex);
            }
            this.currentRow = row;
        }
    }

    public FPFormulaTypeEnum getRstType() {
        return FPFormulaTypeEnum.ACTUAL;
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
        this.tblMain.getPrintManager().print();
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrintPreview_actionPerformed(e);
        this.tblMain.getPrintManager().printPreview();
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
        IFPForm iFPForm = FPFormFactory.getRemoteInstance();
        FPFormInfo formInfo = this.editData;
        if (formInfo == null) {
            return;
        }
        FPFormInfo newformInfo = iFPForm.summaryFPJointForm(formInfo);
        this.setDataObject((IObjectValue)newformInfo);
        this.tblMain.removeRows(true);
        this.initTraceTable(this.editData, this.tblMain);
    }

    protected boolean isGroup() {
        FPFormInfo formInfo = (FPFormInfo)this.getDataObject();
        try {
            return ContextHelperFactory.getRemoteInstance().isOnlyUnion(formInfo.getCompany());
        }
        catch (EASBizException e) {
            return false;
        }
        catch (BOSException e) {
            return false;
        }
    }
}

