/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fp.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.fp.AdjustFormCollection;
import com.kingdee.eas.fm.fp.AdjustFormFactory;
import com.kingdee.eas.fm.fp.FPFormFactory;
import com.kingdee.eas.fm.fp.FPFormInfo;
import com.kingdee.eas.fm.fp.FPItemCollection;
import com.kingdee.eas.fm.fp.FPItemFactory;
import com.kingdee.eas.fm.fp.FPItemInfo;
import com.kingdee.eas.fm.fp.FPItemTypeEnum;
import com.kingdee.eas.fm.fp.IAdjustForm;
import com.kingdee.eas.fm.fp.IFPForm;
import com.kingdee.eas.fm.fp.IFPItem;
import com.kingdee.eas.fm.fp.client.AbstractFPVersionDiffUI;
import com.kingdee.eas.fm.fp.client.FPFormClientHelper;
import com.kingdee.eas.fm.fp.client.FPFormVersionCondParam;
import com.kingdee.eas.fm.fp.client.FPVersionUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.Hashtable;
import java.util.Set;

public class FPVersionDiffUI
extends AbstractFPVersionDiffUI {
    private static String COL_ITEM = "COL_ITEM";
    private static String COL_VER = "COL_VER";
    public static String FLAG = "VERSION_DIFF";

    public void loadFields() {
        super.loadFields();
    }

    public void storeFields() {
        super.storeFields();
    }

    protected IObjectValue createNewData() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return FPFormFactory.getRemoteInstance();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        String formId = (String)this.getUIContext().get("ID");
        Component owerUI = (Component)this.getUIContext().get("Owner");
        FPFormVersionCondParam param = FPVersionUI.showDialogWindow(owerUI, formId, FLAG);
        if (param.isState() != 1) {
            this.abort();
        }
        this.initVersionInfo(param);
        this.enableExportExcel(this.tblMain);
        FMClientHelper.clearSeparatorOnToolBar((KDToolBar)this.toolBar);
    }

    private void initVersionInfo(FPFormVersionCondParam param) throws EASBizException, BOSException {
        AdjustFormCollection adjustFormColl = param.getAdjustFormColl();
        if (adjustFormColl != null && adjustFormColl.size() > 0) {
            FPFormInfo fpFormInfo = adjustFormColl.get(0).getFpForm();
            this.txtNumber.setText(fpFormInfo.getNumber());
            this.txtName.setText(fpFormInfo.getName());
            this.txtCompany.setText(fpFormInfo.getCompany().getName());
            this.txtCurrency.setText(fpFormInfo.getCurrency().getName());
            this.txtTemplate.setText(fpFormInfo.getTemplate().getName());
            int beginYear = fpFormInfo.getBeginYear();
            int beginMonth = fpFormInfo.getBeginMonth();
            int endYear = fpFormInfo.getEndYear();
            int endMonth = fpFormInfo.getEndMonth();
            this.txtPeriod.setText(FPFormClientHelper.getPeriodStr(beginYear, beginMonth + 1, endYear, endMonth + 1));
            this.bizPromptCreator.setValue((Object)fpFormInfo.getCreator().getName());
            this.bizPromptAuditor.setValue((Object)fpFormInfo.getAuditor().getName());
            this.dtpCreateTime.setValue((Object)fpFormInfo.getCreateTime());
            this.dtpAuditedTime.setValue((Object)fpFormInfo.getAuditedTime());
            FPItemCollection itemColl = this.getItems(fpFormInfo);
            this.initVersionDiffTable(adjustFormColl, itemColl);
        }
    }

    private void initVersionDiffTable(AdjustFormCollection adjustFormColl, FPItemCollection itemColl) throws EASBizException, BOSException {
        int i;
        String fpFormId = adjustFormColl.get(0).getFpForm().getId().toString();
        BOSUuid currencyId = adjustFormColl.get(0).getFpForm().getCurrency().getId();
        String numberFmt = FMClientHelper.getNumberFtm((BOSUuid)currencyId);
        this.tblMain.checkParsed();
        this.tblMain.getSelectManager().setSelectMode(10);
        this.setHeader(adjustFormColl, numberFmt);
        Object[] versionAry = new Object[adjustFormColl.size()];
        for (int i2 = 0; i2 < adjustFormColl.size(); ++i2) {
            versionAry[i2] = this.getAdjustSummaryByVersion(fpFormId, adjustFormColl.get(i2).getVersionNo());
        }
        IRow row = null;
        for (i = 0; i < itemColl.size(); ++i) {
            row = this.tblMain.addRow();
            Integer lineNo = new Integer(itemColl.get(i).getLineNo());
            row.getCell(COL_ITEM).setValue((Object)itemColl.get(i).getName());
            for (int j = 0; j < versionAry.length; ++j) {
                Hashtable versionInfo = (Hashtable)versionAry[j];
                row.getCell(COL_VER + j).setValue(versionInfo.get(lineNo));
            }
            row.setUserObject((Object)itemColl.get(i));
        }
        FPFormClientHelper.formatTableStyle(this.tblMain, true);
        for (i = 1; i < this.tblMain.getColumnCount(); ++i) {
            for (int j = 3; j < this.tblMain.getRowCount(); ++j) {
                IRow totalRow = this.tblMain.getRow(j);
                FPItemInfo item = (FPItemInfo)totalRow.getUserObject();
                String expression = item.getCellExp();
                if (item.getType() != FPItemTypeEnum.SYSTEMHOLD && item.getType() != FPItemTypeEnum.SUBTOTAL) continue;
                totalRow.getCell(i).setExpressions(expression);
            }
        }
        FPFormClientHelper.hideStatRows(this.tblMain);
    }

    private void setHeader(AdjustFormCollection adjustFormColl, String numberFmt) {
        IColumn col = this.tblMain.addColumn();
        col.setKey(COL_ITEM);
        col.getStyleAttributes().setLocked(true);
        col.setWidth(300);
        IRow headRow = this.tblMain.addHeadRow();
        headRow.getCell(COL_ITEM).setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.fp.FPFormResource", (String)FPFormClientHelper.ITEM_NAME));
        for (int i = 0; i < adjustFormColl.size(); ++i) {
            col = this.tblMain.addColumn();
            col.getStyleAttributes().setNumberFormat(numberFmt);
            col.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            col.setKey(COL_VER + i);
            col.getStyleAttributes().setLocked(true);
            col.setWidth(100);
            BigDecimal verNo = adjustFormColl.get(i).getVersionNo();
            verNo = verNo.setScale(1);
            if (verNo.compareTo(Constants.CURR_VERSION) == 0) {
                headRow.getCell(COL_VER + i).setValue((Object)EASResource.getString((String)FPFormClientHelper.resourcePath, (String)"CurrentVersion"));
                continue;
            }
            headRow.getCell(COL_VER + i).setValue((Object)("V" + verNo));
        }
    }

    private FPItemCollection getItems(FPFormInfo fpFormInfo) throws BOSException {
        String templateId = fpFormInfo.getTemplate().getId().toString();
        IFPItem iItem = FPItemFactory.getRemoteInstance();
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("fpTemplate.id", (Object)templateId));
        ev.setFilter(fi);
        SorterItemInfo lineNoSorter = new SorterItemInfo("lineNo");
        ev.getSorter().add(lineNoSorter);
        FPItemCollection itemColl = iItem.getFPItemCollection(ev);
        return itemColl;
    }

    private Hashtable getAdjustSummaryByVersion(String fpFormId, BigDecimal versionNo) throws EASBizException, BOSException {
        Hashtable currentSum = new Hashtable();
        IAdjustForm iAdjustForm = AdjustFormFactory.getRemoteInstance();
        IFPForm iFPForm = FPFormFactory.getRemoteInstance();
        BigDecimal maxVersionNo = iAdjustForm.getMaxVersonNo(fpFormId);
        Hashtable diffSum = null;
        boolean currFlag = versionNo.equals(Constants.CURR_VERSION);
        diffSum = currFlag ? iAdjustForm.getCurrVersionSumDiff(fpFormId) : iAdjustForm.getVersionSumDiff(fpFormId, versionNo);
        Hashtable sum = iFPForm.getSummary(fpFormId);
        Set keys = sum.keySet();
        for (Object key : keys) {
            BigDecimal sumItem = (BigDecimal)sum.get(key);
            BigDecimal diffSumItem = (BigDecimal)diffSum.get(key);
            if (diffSumItem != null) {
                if (currFlag) {
                    currentSum.put(key, sumItem.add(diffSumItem));
                    continue;
                }
                currentSum.put(key, sumItem.subtract(diffSumItem));
                continue;
            }
            currentSum.put(key, sumItem);
        }
        return currentSum;
    }

    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        FMClientHelper.exportExcel((Component)((Object)this), (KDTable)this.tblMain);
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
        this.tblMain.getPrintManager().print();
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrintPreview_actionPerformed(e);
        this.tblMain.getPrintManager().printPreview();
    }
}

