/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fp.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fm.common.FMSysDefinedEnum;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.fp.CycleTypeEnum;
import com.kingdee.eas.fm.fp.FixedFPItemInfo;
import com.kingdee.eas.fm.fp.FixedItemFilterParam;
import com.kingdee.eas.fm.fp.client.AbstractFixedFPItemFilterUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.enums.IntEnum;
import java.awt.Component;
import java.awt.event.ActionEvent;

public class FixedFPItemFilterUI
extends AbstractFixedFPItemFilterUI {
    public static String resourcePath = "com.kingdee.eas.fm.fp.FPFixedItemResource";

    protected void init() throws Exception {
        super.init();
        this.initCompanyIds();
        this.bizPromptBeginNumber.setHasCUDefaultFilter(false);
        this.bizPromptEndNumber.setHasCUDefaultFilter(false);
        ICurrency iCurrency = CurrencyFactory.getRemoteInstance();
        CurrencyCollection currencyCollection = iCurrency.getCurrencyCollection(true);
        this.comboCurrency.addItems(currencyCollection.toArray());
        this.comboCurrency.addItem((Object)FMSysDefinedEnum.SELECT_ALL);
        CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        CurrencyInfo currency = ContextHelperFactory.getRemoteInstance().getCompanyBaseCurrency(company);
        FMClientHelper.setSelectObject((KDComboBox)this.comboCurrency, (Object)currency);
        this.comboCycleType.addItem((Object)FMSysDefinedEnum.SELECT_ALL);
        FMClientHelper.setSelectObject((KDComboBox)this.comboCycleType, (Object)((Object)CycleTypeEnum.MONTH));
        this.initFixedItemNumF7();
    }

    protected void initCompanyIds() throws BOSException {
        String[] companyIds = new String[]{this.currentCompany.getId().toString()};
        this.setCompanyIds(companyIds);
    }

    protected void comboCurrency_actionPerformed(ActionEvent e) throws Exception {
        super.comboCurrency_actionPerformed(e);
        this.initFixedItemNumF7();
    }

    protected void comboCycleType_actionPerformed(ActionEvent e) throws Exception {
        super.comboCycleType_actionPerformed(e);
        this.initFixedItemNumF7();
    }

    private void initFixedItemNumF7() {
        int cycleTypeValue;
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        if (this.getCompanyIds() != null) {
            fi.getFilterItems().add(this.getCompanyFilterItem());
        }
        if (this.comboCycleType.getSelectedItem() != null && (cycleTypeValue = ((IntEnum)this.comboCycleType.getSelectedItem()).getValue()) != 999) {
            fi.getFilterItems().add(new FilterItemInfo("cycleType", (Object)new Integer(cycleTypeValue)));
        }
        if (this.comboCurrency.getSelectedItem() != null && !(this.comboCurrency.getSelectedItem() instanceof FMSysDefinedEnum)) {
            String currencyId = ((CurrencyInfo)this.comboCurrency.getSelectedItem()).getId().toString();
            fi.getFilterItems().add(new FilterItemInfo("currency.id", (Object)currencyId));
        }
        ev.setFilter(fi);
        this.bizPromptBeginNumber.setEntityViewInfo(ev);
        this.bizPromptBeginNumber.setData(null);
        this.bizPromptEndNumber.setEntityViewInfo(ev);
        this.bizPromptEndNumber.setData(null);
    }

    public Object getParam() {
        int cycleTypeValue;
        FixedItemFilterParam param = new FixedItemFilterParam();
        if (this.getCompanyIds() != null) {
            String[] companyIds = this.getCompanyIds();
            param.setCompanyIdAry(companyIds);
        }
        if (this.comboCycleType.getSelectedItem() != null && (cycleTypeValue = ((IntEnum)this.comboCycleType.getSelectedItem()).getValue()) != 999) {
            param.setCycleTypeValue(new Integer(((CycleTypeEnum)((Object)this.comboCycleType.getSelectedItem())).getValue()));
        }
        if (this.comboCurrency.getSelectedItem() != null && !(this.comboCurrency.getSelectedItem() instanceof FMSysDefinedEnum)) {
            param.setCurrencyId(((CurrencyInfo)this.comboCurrency.getSelectedItem()).getId().toString());
        }
        if (this.bizPromptBeginNumber.getData() != null) {
            param.setBeginNumber(((FixedFPItemInfo)this.bizPromptBeginNumber.getData()).getNumber());
        }
        if (this.bizPromptEndNumber.getData() != null) {
            param.setEndNumber(((FixedFPItemInfo)this.bizPromptEndNumber.getData()).getNumber());
        }
        return param;
    }

    public void setParam(Object param) {
        if (param == null) {
            return;
        }
        if (!(param instanceof FixedItemFilterParam)) {
            return;
        }
        FixedItemFilterParam fixedItemParam = (FixedItemFilterParam)param;
        String[] companyIds = fixedItemParam.getCompanyIdAry();
        this.setCompanyIds(companyIds);
        String currencyId = fixedItemParam.getCurrencyId();
        CurrencyInfo currencyInfo = null;
        try {
            if (currencyId != null) {
                ICurrency iCurrency = CurrencyFactory.getRemoteInstance();
                currencyInfo = iCurrency.getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyId));
                this.comboCurrency.setSelectedItem((Object)currencyInfo);
            } else {
                this.comboCurrency.setSelectedItem((Object)FMSysDefinedEnum.SELECT_ALL);
            }
        }
        catch (Exception e) {
            SysUtil.abort((Throwable)e);
        }
        Integer cycleType = fixedItemParam.getCycleTypeValue();
        if (cycleType != null) {
            CycleTypeEnum cycleTypeEnum = CycleTypeEnum.getEnum(cycleType);
            this.comboCycleType.setSelectedItem((Object)cycleTypeEnum);
        } else {
            this.comboCycleType.setSelectedItem((Object)FMSysDefinedEnum.SELECT_ALL);
        }
        String beginNumber = fixedItemParam.getBeginNumber();
        String endNumber = fixedItemParam.getEndNumber();
        FixedFPItemInfo beginInfo = new FixedFPItemInfo();
        beginInfo.setNumber(beginNumber);
        this.bizPromptBeginNumber.setValue((Object)beginInfo);
        FixedFPItemInfo endInfo = new FixedFPItemInfo();
        endInfo.setNumber(endNumber);
        this.bizPromptEndNumber.setValue((Object)endInfo);
    }

    public boolean verify() {
        if (this.getCompanyIds() == null || this.getCompanyIds().length == 0) {
            this.btnCompanySelect.requestFocus(true);
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"NoOrgUnit"));
            SysUtil.abort();
        }
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (String)resourcePath, (KDComboBox)this.comboCurrency, (String)"NoCurrency");
        return true;
    }

    protected void companyValueChange(Object object) throws Exception {
        super.companyValueChange(object);
        if (this.getCompanyIds() != null) {
            this.initFixedItemNumF7();
        }
    }
}

