/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fp.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.IContextHelper;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.fp.AbstractFixedFPItemInfo;
import com.kingdee.eas.fm.fp.CycleTypeEnum;
import com.kingdee.eas.fm.fp.FPCycleIntervalEnum;
import com.kingdee.eas.fm.fp.FixedFPItemFactory;
import com.kingdee.eas.fm.fp.FixedFPItemInfo;
import com.kingdee.eas.fm.fp.IFixedFPItem;
import com.kingdee.eas.fm.fp.client.AbstractFixedFPItemUI;
import com.kingdee.eas.fm.fp.client.FPClientHelper;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;

public class FixedFPItemUI
extends AbstractFixedFPItemUI {
    public static final String resourcePath = "com.kingdee.eas.fm.fp.FPFixedItemResource";
    public static final String CTX_COPY_FLAG = "COPY_FLAG";
    public boolean isLoaded;

    protected IObjectValue createNewData() {
        Boolean copyFlag = (Boolean)this.getUIContext().get(CTX_COPY_FLAG);
        if (copyFlag != null && copyFlag.booleanValue()) {
            String id = (String)this.getUIContext().get("ID");
            return this.copyData(id);
        }
        FixedFPItemInfo info = new FixedFPItemInfo();
        IContextHelper contextHelper = ContextHelperFactory.getRemoteInstance();
        CompanyOrgUnitInfo currentCompany = contextHelper.getCurrentCompany();
        if (currentCompany == null) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"NoCompany"));
            SysUtil.abort();
        }
        info.setCompany(currentCompany);
        info.setCycleType(CycleTypeEnum.MONTH);
        info.setCycleInterval(FPCycleIntervalEnum.ONE);
        Calendar cal = Calendar.getInstance();
        info.setBeginDate(cal.getTime());
        try {
            info.setCurrency(ContextHelperFactory.getRemoteInstance().getCompanyBaseCurrency(info.getCompany()));
        }
        catch (Exception e) {
            this.abort(e);
        }
        return info;
    }

    private IObjectValue copyData(String id) {
        FixedFPItemInfo destInfo = new FixedFPItemInfo();
        AbstractFixedFPItemInfo srcInfo = null;
        try {
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("*"));
            selector.add(new SelectorItemInfo("currency.*"));
            selector.add(new SelectorItemInfo("company.*"));
            IFixedFPItem iFixedFPItem = FixedFPItemFactory.getRemoteInstance();
            srcInfo = iFixedFPItem.getFixedFPItemInfo((IObjectPK)new ObjectUuidPK(id), selector);
        }
        catch (Exception e) {
            MsgBox.showError((String)EASResource.getString((String)resourcePath, (String)"FIXITEMNOTEXIST"));
            SysUtil.abort((Throwable)e);
        }
        destInfo.setCycleInterval(srcInfo.getCycleInterval());
        destInfo.setCycleType(srcInfo.getCycleType());
        destInfo.setBeginDate(srcInfo.getBeginDate());
        destInfo.setEndDate(srcInfo.getEndDate());
        destInfo.setCurrency(srcInfo.getCurrency());
        destInfo.setAmount(srcInfo.getAmount());
        destInfo.setDescription(srcInfo.getDescription());
        destInfo.setCompany(srcInfo.getCompany());
        destInfo.setName(srcInfo.getName());
        return destInfo;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return FixedFPItemFactory.getRemoteInstance();
    }

    public void onLoad() throws Exception {
        if (!this.isLoaded) {
            this.init();
        }
        this.isLoaded = true;
        super.onLoad();
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
        FMClientHelper.updateUITitle((CoreUIObject)this, (String)this.resHelper.getString("this.title"));
    }

    public void init() throws Exception {
        FMClientHelper.initComboCurrency((KDComboBox)this.comboCurrency);
    }

    protected void initDataStatus() {
        super.initDataStatus();
        FixedFPItemInfo info = (FixedFPItemInfo)this.getDataObject();
        if (this.isExsitCodeRule(info)) {
            this.txtNumber.setEditable(false);
        }
        if (!this.oprtState.equals(OprtState.ADDNEW)) {
            FMClientHelper.setSelectObject((KDComboBox)this.comboCurrency, (Object)info.getCurrency());
        }
        if (this.getOprtState().equals(OprtState.VIEW)) {
            this.actionAddNew.setEnabled(false);
        }
    }

    public boolean isExsitCodeRule(FixedFPItemInfo info) {
        String companyId = info.getCompany().getId().toString();
        boolean isExistRule = false;
        boolean isUseIntermitNumber = false;
        Object caller = null;
        ICodingRuleManager icrm = null;
        if (companyId != null && companyId.trim().length() > 0) {
            try {
                icrm = CodingRuleManagerFactory.getRemoteInstance();
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            try {
                isExistRule = icrm.isExist((IObjectValue)info, companyId);
            }
            catch (CodingRuleException e1) {
                e1.printStackTrace();
            }
            catch (EASBizException e1) {
                e1.printStackTrace();
            }
            catch (BOSException e1) {
                e1.printStackTrace();
            }
        }
        return isExistRule;
    }

    protected void comboCycleType_actionPerformed(ActionEvent e) throws Exception {
        super.comboCycleType_actionPerformed(e);
        if (this.comboCycleType.getSelectedItem() == CycleTypeEnum.DAY) {
            if (!OprtState.VIEW.equals(this.oprtState)) {
                this.comboCycleInterval.setEnabled(true);
            }
        } else {
            this.comboCycleInterval.setEnabled(false);
            this.comboCycleInterval.setSelectedItem((Object)FPCycleIntervalEnum.ONE);
        }
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        if (this.txtNumber.isEnabled()) {
            FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (String)resourcePath, (KDTextField)this.txtNumber, (String)"NoNumber");
        }
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (String)resourcePath, (KDTextField)this.txtCompany, (String)"NoCompany");
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (String)resourcePath, (KDTextField)this.txtName, (String)"NoName");
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (String)resourcePath, (KDComboBox)this.comboCycleType, (String)"NoCycleType");
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (String)resourcePath, (KDComboBox)this.comboCycleInterval, (String)"NoCycleInterval");
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (String)resourcePath, (KDComboBox)this.comboCurrency, (String)"NoCurrency");
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (String)resourcePath, (KDDatePicker)this.dateBeginDate, (String)"NoBeginDate");
        FPClientHelper.verifyEmpty(this, resourcePath, this.txtAmount, "NoAmount");
        if (this.txtAmount.getNumberValue() != null && new BigDecimal(this.txtAmount.getNumberValue().toString()).compareTo(Constants.ZERO) <= 0) {
            this.txtAmount.requestFocus();
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"PositiveNum"));
            SysUtil.abort();
        }
        if (this.dateBeginDate.getValue() == null) {
            this.dateBeginDate.requestFocus();
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"BeginIsNull"));
            SysUtil.abort();
        }
        if (this.dateEndDate.getValue() == null) {
            Date date = Constants.MAX_DATE;
            if (date.before(this.dateEndDate.getMaximumDate())) {
                this.dateEndDate.setValue((Object)this.dateEndDate.getMaximumDate());
            } else {
                this.dateEndDate.setValue((Object)date);
            }
            this.editData.setEndDate((Date)this.dateEndDate.getValue());
        }
        if (this.dateBeginDate.getValue() != null && this.dateEndDate.getValue() != null && ((Date)this.dateBeginDate.getValue()).after((Date)this.dateEndDate.getValue())) {
            this.dateBeginDate.requestFocus();
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"BeginBigerThanEnd"));
            SysUtil.abort();
        }
    }

    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("currency.*"));
        sic.add(new SelectorItemInfo("amount"));
        return sic;
    }

    public void storeFields() {
        super.storeFields();
    }

    public void loadFields() {
        super.loadFields();
        if (this.oprtState.equals(OprtState.ADDNEW)) {
            FMClientHelper.initNumber((CoreBaseInfo)this.editData, (KDTextField)this.txtNumber, (String)this.editData.getCompany().getId().toString());
            this.dateEndDate.setValue((Object)this.dateEndDate.getMaximumDate());
        }
        FMClientHelper.setSelectObject((KDComboBox)this.comboCurrency, (Object)this.editData.getCurrency());
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        String original = this.getOprtState();
        this.setOprtState("EDIT");
        try {
            super.actionSubmit_actionPerformed(e);
        }
        catch (Exception ex) {
            this.setOprtState(original);
            throw ex;
        }
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        if (this.editData != null && this.editData.getCompany() != null) {
            ObjectUuidPK orgPk = new ObjectUuidPK(this.editData.getCompany().getId());
            return orgPk;
        }
        CompanyOrgUnitInfo info = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        if (info == null) {
            return null;
        }
        ObjectUuidPK orgPk = new ObjectUuidPK(info.getId());
        return orgPk;
    }

    protected void comboCurrency_actionPerformed(ActionEvent e) throws Exception {
        CurrencyInfo currencyInfo = (CurrencyInfo)this.comboCurrency.getSelectedItem();
        int numberFormat = FMClientHelper.getPrecOfCurrency((BOSUuid)currencyInfo.getId());
        this.txtAmount.setDataVerifierType(12);
        this.txtAmount.setSupportedEmpty(true);
        this.txtAmount.setPrecision(numberFormat);
    }
}

