/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.fs.ISettlementBill;
import com.kingdee.eas.fm.fs.SettlementBillFactory;
import com.kingdee.eas.fm.fs.SettlementBillInfo;
import com.kingdee.eas.ma.budget.BgCtrlParamCollection;
import com.kingdee.eas.ma.budget.BgCtrlParamInfo;
import com.kingdee.eas.ma.budget.IBgCtrlHandler;

public class BgCtrlSettleHandler
implements IBgCtrlHandler {
    public BgCtrlParamCollection getParameters(Context ctx, String billId) throws BOSException, EASBizException {
        SettlementBillInfo info = this.getBillInfo(ctx, billId);
        return BgCtrlSettleHandler.getParamColl(info);
    }

    public static BgCtrlParamCollection getParamColl(SettlementBillInfo info) {
        BgCtrlParamCollection coll = new BgCtrlParamCollection();
        coll.add(BgCtrlSettleHandler.getParamByPayer(info));
        coll.add(BgCtrlSettleHandler.getParamByPayee(info));
        return coll;
    }

    public static BgCtrlParamInfo getParamByPayer(SettlementBillInfo info) {
        BgCtrlParamInfo ctrlInfo = new BgCtrlParamInfo();
        if (info.getId() != null) {
            ctrlInfo.setSrcBillId(info.getId().toString());
        }
        ctrlInfo.setSrcBillNumber(info.getNumber());
        ctrlInfo.setOrgUnitId(info.getCompany().getId().toString());
        ctrlInfo.setBizDate(info.getBizDate());
        ctrlInfo.setCurrencyId(info.getCurrency().getId().toString());
        ctrlInfo.setCurrencyNumber(info.getCurrency().getNumber());
        if (info.getPayerPlanItem() != null) {
            ctrlInfo.setItemCombinNumber(info.getPayerPlanItem().getNumber());
            ctrlInfo.setItemCombinName(info.getPayerPlanItem().getName());
        }
        ctrlInfo.setAmount(info.getAmount());
        return ctrlInfo;
    }

    public static BgCtrlParamInfo getParamByPayee(SettlementBillInfo info) {
        BgCtrlParamInfo ctrlInfo = new BgCtrlParamInfo();
        if (info.getId() != null) {
            ctrlInfo.setSrcBillId(info.getId().toString());
        }
        ctrlInfo.setSrcBillNumber(info.getNumber());
        ctrlInfo.setOrgUnitId(info.getCompany().getId().toString());
        ctrlInfo.setBizDate(info.getBizDate());
        ctrlInfo.setCurrencyId(info.getCurrency().getId().toString());
        ctrlInfo.setCurrencyNumber(info.getCurrency().getNumber());
        if (info.getPayeePlanItem() != null) {
            ctrlInfo.setItemCombinNumber(info.getPayeePlanItem().getNumber());
            ctrlInfo.setItemCombinName(info.getPayeePlanItem().getName());
        }
        ctrlInfo.setAmount(info.getAmount());
        return ctrlInfo;
    }

    private SettlementBillInfo getBillInfo(Context ctx, String billId) throws EASBizException, BOSException {
        ISettlementBill iSettlementBill = null;
        iSettlementBill = ctx == null ? SettlementBillFactory.getRemoteInstance() : SettlementBillFactory.getLocalInstance(ctx);
        return iSettlementBill.getSettlementBillInfo((IObjectPK)new ObjectUuidPK(billId), this.getSelector());
    }

    private SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("payerPlanItem.number"));
        sic.add(new SelectorItemInfo("payerPlanItem.name"));
        sic.add(new SelectorItemInfo("payeePlanItem.number"));
        sic.add(new SelectorItemInfo("payeePlanItem.name"));
        sic.add(new SelectorItemInfo("applyUnit.id"));
        sic.add(new SelectorItemInfo("applyUnit.name"));
        sic.add(new SelectorItemInfo("applyUnit.number"));
        sic.add(new SelectorItemInfo("payeeBankAcct.company.id"));
        sic.add(new SelectorItemInfo("payeeBankAcct.company.name"));
        sic.add(new SelectorItemInfo("payeeBankAcct.company.number"));
        sic.add(new SelectorItemInfo("payerBankAcct.company.id"));
        sic.add(new SelectorItemInfo("payerBankAcct.company.name"));
        sic.add(new SelectorItemInfo("payerBankAcct.company.number"));
        sic.add(new SelectorItemInfo("payeeInnerAcct.applyUnit.id"));
        sic.add(new SelectorItemInfo("payeeInnerAcct.applyUnit.name"));
        sic.add(new SelectorItemInfo("payeeInnerAcct.applyUnit.number"));
        sic.add(new SelectorItemInfo("payerInnerAcct.applyUnit.id"));
        sic.add(new SelectorItemInfo("payerInnerAcct.applyUnit.name"));
        sic.add(new SelectorItemInfo("payerInnerAcct.applyUnit.number"));
        return sic;
    }
}

