/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleFactory;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.datatask.AbstractDataImport;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.IContextHelper;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.AccountMgrStrategyCollection;
import com.kingdee.eas.basedata.assistant.AccountMgrStrategyFactory;
import com.kingdee.eas.basedata.assistant.AccountPropertyCollection;
import com.kingdee.eas.basedata.assistant.AccountPropertyFactory;
import com.kingdee.eas.basedata.assistant.AccountPropertyInfo;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.IAccountBank;
import com.kingdee.eas.basedata.assistant.IAccountMgrStrategy;
import com.kingdee.eas.basedata.assistant.IAccountProperty;
import com.kingdee.eas.basedata.assistant.IKAClassfication;
import com.kingdee.eas.basedata.assistant.KAClassficationCollection;
import com.kingdee.eas.basedata.assistant.KAClassficationFactory;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.IAccountView;
import com.kingdee.eas.basedata.master.cssp.app.DataImportUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.fs.IInnerAccount;
import com.kingdee.eas.fm.fs.InnerAccountCollection;
import com.kingdee.eas.fm.fs.InnerAccountFactory;
import com.kingdee.eas.fm.fs.InnerAccountInfo;
import com.kingdee.eas.fm.fs.app.InnerAccountBillImportVerify;
import com.kingdee.eas.fm.im.IntObjectCollection;
import com.kingdee.eas.fm.im.IntObjectFactory;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.TypeConversionUtils;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;
import org.apache.log4j.Logger;

public class InnerAccountBillDataImport
extends AbstractDataImport {
    private static Logger logger = Logger.getLogger((String)InnerAccountBillDataImport.class.getName());
    private InnerAccountBillImportVerify verify;

    protected ICoreBase _getController(Context ctx) throws BOSException, EASBizException {
        return InnerAccountFactory.getLocalInstance(ctx);
    }

    public InnerAccountBillImportVerify getVerify() {
        if (this.verify == null) {
            this.verify = new InnerAccountBillImportVerify();
        }
        return this.verify;
    }

    protected CoreBaseInfo _transmit(Hashtable hsData, Context ctx) throws EASBizException, BOSException {
        Integer datataskMode = (Integer)this.getContextParameter().get("DATATASKMODE");
        int mode = datataskMode;
        InnerAccountInfo innerAccountInfo = new InnerAccountInfo();
        try {
            BOSUuid companyID;
            IContextHelper ctxHelper;
            if (mode == 16) {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.fs.InnerAccountImportResource", (String)"61_InnerAccountBillDataImport", (Locale)ctx.getLocale()));
            }
            BankInfo clearingHouse = InnerAccountBillDataImport.getClearingHouse(ctx);
            innerAccountInfo.setId(BOSUuid.create((BOSObjectType)innerAccountInfo.getBOSType()));
            this.prepareImport(ctx, (IObjectValue)innerAccountInfo, hsData);
            CompanyOrgUnitInfo currCompany = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
            String data = (String)this.getData(hsData, "FNumber");
            boolean flag = false;
            try {
                boolean isUsedParam = DataImportUtils.getImportParam((Context)ctx);
                if (isUsedParam) {
                    String souID = currCompany.getId().toString().trim();
                    ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
                    if (iCodingRuleManager.isExist((IObjectValue)innerAccountInfo, souID)) {
                        data = iCodingRuleManager.getNumber((IObjectValue)innerAccountInfo, souID);
                    }
                } else {
                    flag = true;
                }
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            if (!flag) {
                innerAccountInfo.setNumber(data);
                innerAccountInfo.setCompany(currCompany);
            } else {
                innerAccountInfo.setNumber(data.toString());
            }
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("number", (Object)innerAccountInfo.getNumber()));
            view.setFilter(fi);
            InnerAccountCollection coll = null;
            coll = InnerAccountFactory.getLocalInstance(ctx).getInnerAccountCollection(view);
            if (coll.size() > 0) {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.fs.InnerAccountImportResource", (String)"62_InnerAccountBillDataImport", (Locale)ctx.getLocale()));
            }
            this.parseHead(innerAccountInfo, hsData, ctx);
            if (clearingHouse.isUsed() && this.isAutoAddIntObject(ctxHelper = ContextHelperFactory.getLocalInstance((Context)ctx), companyID = currCompany.getId()) && !this.hasRefIntObject(innerAccountInfo, ctx) && !this.isFixCredit(innerAccountInfo)) {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.fs.InnerAccountImportResource", (String)"63_InnerAccountBillDataImport", (Locale)ctx.getLocale()));
            }
            this.getVerify().verifyHead(ctx, (CoreBaseInfo)innerAccountInfo);
        }
        catch (Exception e) {
            ICodingRuleManager codingRuleManager;
            CodingRuleInfo codingRule;
            boolean isUsedParam = DataImportUtils.getImportParam((Context)ctx);
            CompanyOrgUnitInfo currCompany = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
            if (isUsedParam && innerAccountInfo.getNumber() != null && (codingRule = (codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx)).getCodingRule((IObjectValue)innerAccountInfo, currCompany.getId().toString())) != null) {
                CodingRuleFactory.getLocalInstance((Context)ctx).recycleNumber((IObjectValue)innerAccountInfo, codingRule, innerAccountInfo.getNumber());
            }
            throw new BOSException(e.getMessage());
        }
        return innerAccountInfo;
    }

    public static BankInfo getClearingHouse(Context ctx) throws EASBizException, BOSException {
        CompanyOrgUnitInfo curent = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        BankInfo clearingHouse = BankFactory.getLocalInstance((Context)ctx).getClearingHouse(curent.getId().toString());
        if (clearingHouse == null) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fm.fs.FSClientResource", (String)"NoClearingHouse"));
            SysUtil.abort();
        }
        return clearingHouse;
    }

    public static void checkClearingHouseCompany(Context ctx) throws EASBizException, BOSException {
        CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        if (!BankFactory.getLocalInstance((Context)ctx).isClearinghouseCompany(currentCompany.getId().toString())) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fm.fs.FSClientResource", (String)"mustToChCompany"));
            SysUtil.abort();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private CoreBaseInfo parseHead(InnerAccountInfo innerAccountInfo, Hashtable hsData, Context ctx) throws BOSException, BOSException, EASBizException {
        InnerAccountInfo info = innerAccountInfo;
        Object data = null;
        CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        try {
            InnerAccountBillDataImport.checkClearingHouseCompany(ctx);
        }
        catch (EASBizException e1) {
            SysUtil.abort((Throwable)e1);
        }
        catch (BOSException e1) {
            SysUtil.abort((Throwable)e1);
        }
        info.setIsUsed(true);
        info.setClosed(false);
        UserInfo user = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
        CompanyOrgUnitInfo cur = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        if (user != null) {
            info.setCreator(user);
        }
        try {
            BankInfo bankInfo = BankFactory.getLocalInstance((Context)ctx).getClearingHouse(cur.getId().toString());
            info.setClearingHouse(bankInfo);
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
        catch (BOSException e) {
            throw new BOSException((Throwable)e);
        }
        if (info.getClearingHouse().isUsed()) {
            Date settleDate = info.getClearingHouse().getSettleDate();
            if (settleDate == null) throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.fs.InnerAccountImportResource", (String)"SettleDateIsNull", (Locale)ctx.getLocale()));
            info.setOpenDepositDate((Date)new Timestamp(DateTimeUtils.truncateDate((Date)settleDate).getTime()));
        } else {
            info.setOpenDepositDate((Date)DateUtil.getTimeStampDayBegin());
        }
        info.setCompany(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany());
        data = this.getData(hsData, "FName");
        if (data == null || data.toString().trim().length() <= 0) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.fs.InnerAccountImportResource", (String)"NameIsNull", (Locale)ctx.getLocale()));
        }
        info.setName(data.toString());
        data = this.getData(hsData, "FAcctNumber");
        if (data == null || data.toString().trim().length() <= 0) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.fs.InnerAccountImportResource", (String)"acctNumberIsNull", (Locale)ctx.getLocale()));
        }
        info.setAcctNumber(data.toString());
        data = this.getData(hsData, "FApplyUnit_number");
        if (data == null || data.toString().trim().length() <= 0) throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.fs.InnerAccountImportResource", (String)"applyUnitIsNull", (Locale)ctx.getLocale()));
        CompanyOrgUnitInfo company = null;
        ICompanyOrgUnit iCompanyOrgUnit = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        company = InnerAccountBillDataImport.getCompanyOrgUnitInfoByNumber(ctx, data.toString());
        if (company == null) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.fs.InnerAccountImportResource", (String)"applyUnitIsNull", (Locale)ctx.getLocale()));
        }
        if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)company)) {
            company = null;
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.fs.InnerAccountImportResource", (String)"64_InnerAccountBillDataImport", (Locale)ctx.getLocale()));
        }
        if (company != null) {
            info.setApplyUnit(company);
        }
        data = this.getData(hsData, "FOpenDepositDate");
        if (data != null && data.toString().trim().length() > 0) {
            info.setOpenDepositDate((Date)TypeConversionUtils.objToDate((Object)data));
        }
        if ((data = this.getData(hsData, "FAcctView_number")) == null || data.toString().trim().length() <= 0) throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.fs.InnerAccountImportResource", (String)"acctViewIsNull", (Locale)ctx.getLocale()));
        AccountViewCollection coll = InnerAccountBillDataImport.getAccountViewCollection(ctx, data.toString());
        if (coll.size() > 0) {
            info.setAcctView(coll.get(0));
        }
        data = this.getData(hsData, "FType_number");
        if (data == null || data.toString().trim().length() <= 0) throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.fs.InnerAccountImportResource", (String)"acctPropertyIsNull", (Locale)ctx.getLocale()));
        coll = InnerAccountBillDataImport.getAccountPropertyCollection(ctx, data.toString());
        if (coll.size() > 0) {
            info.setType(coll.get(0));
        }
        data = this.getData(hsData, "FCtrlParam_number");
        if (data == null || data.toString().trim().length() <= 0) throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.fs.InnerAccountImportResource", (String)"ctrlParamIsNull", (Locale)ctx.getLocale()));
        coll = InnerAccountBillDataImport.getAccountMgrStrategyCollection(ctx, data.toString());
        if (coll.size() > 0) {
            info.setCtrlParam(coll.get(0));
        }
        data = this.getData(hsData, "FClhClassification_number");
        if (data != null && data.toString().trim().length() > 0 && (coll = InnerAccountBillDataImport.getKAClassficationCollection(ctx, data.toString())).size() > 0) {
            info.setClhClassification(coll.get(0));
        }
        if ((data = this.getData(hsData, "FClhClassification_number")) != null && data.toString().trim().length() > 0 && (coll = InnerAccountBillDataImport.getKAClassficationCollection(ctx, data.toString())).size() > 0) {
            info.setClhClassification(coll.get(0));
        }
        if ((data = this.getData(hsData, "FIsReckoning")) != null && data.toString().trim().length() > 0) {
            if (!data.equals(Constants.ONE.toString()) && !data.equals(Constants.ZERO.toString())) throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.fs.InnerAccountImportResource", (String)"65_InnerAccountBillDataImport", (Locale)ctx.getLocale()));
            info.setIsReckoning(TypeConversionUtils.objToBoolean((Object)data));
        } else {
            info.setIsReckoning(TypeConversionUtils.objToBoolean((Object)"false"));
        }
        data = this.getData(hsData, "FIsDefaultReck");
        if (data != null && data.toString().trim().length() > 0) {
            if (!data.equals(Constants.ONE.toString()) && !data.equals(Constants.ZERO.toString())) throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.fs.InnerAccountImportResource", (String)"66_InnerAccountBillDataImport", (Locale)ctx.getLocale()));
            info.setIsDefaultReck(TypeConversionUtils.objToBoolean((Object)data));
        } else {
            info.setIsDefaultReck(TypeConversionUtils.objToBoolean((Object)"false"));
        }
        data = this.getData(hsData, "FIsCollect");
        if (data != null && data.toString().trim().length() > 0) {
            if (!data.equals(Constants.ONE.toString()) && !data.equals(Constants.ZERO.toString())) throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.fs.InnerAccountImportResource", (String)"67_InnerAccountBillDataImport", (Locale)ctx.getLocale()));
            info.setIsCollect(TypeConversionUtils.objToBoolean((Object)data));
        } else {
            info.setIsCollect(TypeConversionUtils.objToBoolean((Object)"false"));
        }
        data = this.getData(hsData, "FSimpleCode");
        if (data != null && data.toString().trim().length() > 0) {
            info.setSimpleCode(data.toString());
        }
        if ((data = this.getData(hsData, "FDeFaultAcctBank_number")) != null && data.toString().trim().length() > 0) {
            AccountBankInfo accountBankInfo = InnerAccountBillDataImport.getAccountBankByNumber(ctx, data.toString());
            info.setDeFaultAcctBank(accountBankInfo);
        }
        if ((data = this.getData(hsData, "Fdescription")) == null || data.toString().trim().length() <= 0) return info;
        info.setDescription(data.toString());
        return info;
    }

    public static AccountBankInfo getAccountBankByNumber(Context ctx, String number) throws BOSException {
        AccountBankInfo accountBank = null;
        try {
            IAccountBank iaccountBank = AccountBankFactory.getLocalInstance((Context)ctx);
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("number", (Object)("" + number)));
            fi.getFilterItems().add(new FilterItemInfo("isClosed", (Object)Boolean.FALSE));
            view.setFilter(fi);
            SelectorItemCollection sic = view.getSelector();
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("bank.id"));
            sic.add(new SelectorItemInfo("bank.name"));
            sic.add(new SelectorItemInfo("bank.number"));
            sic.add(new SelectorItemInfo("account.id"));
            AccountBankCollection collection = iaccountBank.getAccountBankCollection(view);
            if (collection != null && collection.size() > 0) {
                accountBank = collection.get(0);
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage());
        }
        return accountBank;
    }

    public static CompanyOrgUnitInfo getCompanyOrgUnitInfoByNumber(Context ctx, String number) throws BOSException {
        CompanyOrgUnitInfo company = null;
        try {
            ICompanyOrgUnit iCompanyOrgUnit = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("number", (Object)("" + number)));
            view.setFilter(fi);
            SelectorItemCollection sic = view.getSelector();
            sic.add(new SelectorItemInfo("*"));
            CompanyOrgUnitCollection collection = iCompanyOrgUnit.getCompanyOrgUnitCollection(view);
            if (collection != null && collection.size() > 0) {
                company = collection.get(0);
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage());
        }
        return company;
    }

    private boolean isAutoAddIntObject(IContextHelper ctxHelper, BOSUuid companyId) {
        return ctxHelper.getBooleanParam("TM006", (IObjectPK)new ObjectUuidPK(companyId));
    }

    private boolean isFixCredit(InnerAccountInfo innerAccountInfo) {
        boolean flag = false;
        AccountPropertyInfo info = innerAccountInfo.getType();
        int inValue = info.getProperty().getValue();
        if (inValue == 2 || inValue == 3) {
            flag = true;
        }
        return flag;
    }

    private boolean hasRefIntObject(InnerAccountInfo innerAccount, Context ctx) throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("sourceType", (Object)new Integer(3)));
        filter.getFilterItems().add(new FilterItemInfo("sourceId", (Object)new ObjectUuidPK(innerAccount.getId())));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        IntObjectCollection col = IntObjectFactory.getLocalInstance((Context)ctx).getIntObjectCollection(evi);
        return col != null && col.size() > 0;
    }

    protected void _submit(CoreBaseInfo info, Context ctx) throws BOSException, EASBizException {
        IInnerAccount j = (IInnerAccount)this._getController(ctx);
        j.save(info);
    }

    public static AccountViewCollection getAccountViewCollection(Context ctx, String number) throws BOSException, EASBizException {
        ICompanyOrgUnit iCompanyOrgUnit = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        String cuId = currentCompany.getId().toString();
        String accountTable = null;
        if (currentCompany.getAccountTable() != null) {
            accountTable = currentCompany.getAccountTable().getId().toString();
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("companyID.id", (Object)cuId));
        filter.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)"1"));
        filter.getFilterItems().add(new FilterItemInfo("accountTableID.id", (Object)accountTable));
        filter.getFilterItems().add(new FilterItemInfo("isGFreeze", (Object)Constants.FALSE));
        filter.getFilterItems().add(new FilterItemInfo("isCFreeze", (Object)Constants.FALSE));
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)("" + number)));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SelectorItemCollection selector = view.getSelector();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("accountCurrency.id"));
        selector.add(new SelectorItemInfo("accountCurrency.currency"));
        selector.add(new SelectorItemInfo("accountCurrency.currency.id"));
        selector.add(new SelectorItemInfo("accountCurrency.currency.name"));
        selector.add(new SelectorItemInfo("accountingcurrency"));
        IAccountView iAccountView = AccountViewFactory.getLocalInstance((Context)ctx);
        AccountViewCollection acctViewCol = iAccountView.getAccountViewCollection(view);
        return acctViewCol;
    }

    public static AccountPropertyCollection getAccountPropertyCollection(Context ctx, String number) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("number", (Object)("" + number)));
        view.setFilter(fi);
        SelectorItemCollection selector = view.getSelector();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("*"));
        IAccountProperty iAccountProperty = AccountPropertyFactory.getLocalInstance((Context)ctx);
        AccountPropertyCollection coll = iAccountProperty.getAccountPropertyCollection(view);
        return coll;
    }

    public static AccountMgrStrategyCollection getAccountMgrStrategyCollection(Context ctx, String number) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("number", (Object)("" + number)));
        view.setFilter(fi);
        SelectorItemCollection selector = view.getSelector();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("*"));
        IAccountMgrStrategy iAccountMgrStrategy = AccountMgrStrategyFactory.getLocalInstance((Context)ctx);
        AccountMgrStrategyCollection coll = iAccountMgrStrategy.getAccountMgrStrategyCollection(view);
        return coll;
    }

    public static KAClassficationCollection getKAClassficationCollection(Context ctx, String number) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("number", (Object)("" + number)));
        view.setFilter(fi);
        SelectorItemCollection selector = view.getSelector();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("*"));
        IKAClassfication iAccountMgrStrategy = KAClassficationFactory.getLocalInstance((Context)ctx);
        KAClassficationCollection coll = iAccountMgrStrategy.getKAClassficationCollection(view);
        return coll;
    }
}

