/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.IBank;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.fs.ClearingHouseHelper;
import com.kingdee.eas.fm.fs.FSException;
import com.kingdee.eas.fm.fs.IReckoningAccount;
import com.kingdee.eas.fm.fs.ReckoningAccountCollection;
import com.kingdee.eas.fm.fs.ReckoningAccountFactory;
import com.kingdee.eas.fm.fs.ReckoningAccountInfo;

public class ReckoningAccountHelper {
    public static ReckoningAccountInfo getReckoningAcct(Context ctx, String companyId, String chId) throws BOSException, EASBizException {
        if (companyId == null || chId == null) {
            return null;
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId));
        filter.getFilterItems().add(new FilterItemInfo("clearingHouse.id", (Object)chId));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSelector().add("*");
        evi.getSelector().add("company.*");
        evi.getSelector().add("clearingHouse.*");
        evi.getSelector().add("acctView.*");
        ReckoningAccountCollection coll = ReckoningAccountHelper.getBizInterface(ctx).getReckoningAccountCollection(evi);
        if (coll.isEmpty()) {
            CompanyOrgUnitInfo companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
            BankInfo chInfo = BankFactory.getLocalInstance((Context)ctx).getBankInfo((IObjectPK)new ObjectUuidPK(chId));
            throw new FSException(FSException.COMPANYRECKACCTERROR, new String[]{companyInfo.getName(), chInfo.getName()});
        }
        return coll.get(0);
    }

    public static ReckoningAccountInfo getReckoningAcct(Context ctx, IObjectPK chPk1, IObjectPK chPk2) throws BOSException, EASBizException {
        if (chPk1 == null || chPk2 == null) {
            return null;
        }
        IBank iBank = null;
        iBank = ctx == null ? BankFactory.getRemoteInstance() : BankFactory.getLocalInstance((Context)ctx);
        BankInfo chInfo1 = iBank.getBankInfo(chPk1);
        if (chInfo1 == null) {
            return null;
        }
        String companyId = chInfo1.getRelatedCompany().getId().toString();
        return ReckoningAccountHelper.getReckoningAcct(ctx, companyId, chPk2.toString());
    }

    public static ReckoningAccountInfo getDirectUpperReckoningAcct1(Context ctx, String companyId) throws BOSException, EASBizException {
        BankInfo chInfo = ClearingHouseHelper.getClearingHouse(ctx, companyId);
        if (chInfo == null) {
            return null;
        }
        BankInfo directUpChInfo = ClearingHouseHelper.getDirectUpperCh(ctx, chInfo.getId().toString());
        return ReckoningAccountHelper.getReckoningAcct(ctx, companyId, directUpChInfo.getId().toString());
    }

    public static ReckoningAccountInfo getDirectUpperReckoningAcct(Context ctx, BankInfo chInfo) throws BOSException, EASBizException {
        String companyId = chInfo.getRelatedCompany().getId().toString();
        BankInfo directUpChInfo = ClearingHouseHelper.getDirectUpperCh(ctx, chInfo.getId().toString());
        return ReckoningAccountHelper.getReckoningAcct(ctx, companyId, directUpChInfo.getId().toString());
    }

    public static ReckoningAccountInfo getDirectUpperReckoningAcct(Context ctx, IObjectPK chPk) throws BOSException, EASBizException {
        IBank iBank = null;
        iBank = ctx == null ? BankFactory.getRemoteInstance() : BankFactory.getLocalInstance((Context)ctx);
        BankInfo chInfo = iBank.getBankInfo(chPk);
        String companyId = chInfo.getRelatedCompany().getId().toString();
        BankInfo directUpChInfo = ClearingHouseHelper.getDirectUpperCh(ctx, chInfo.getId().toString());
        return ReckoningAccountHelper.getReckoningAcct(ctx, companyId, directUpChInfo.getId().toString());
    }

    public static ReckoningAccountCollection getDirectLowerReckoningAcctColl(Context ctx, String companyId) throws BOSException, EASBizException {
        return null;
    }

    public static ReckoningAccountCollection getDirectLowerReckoningAcctColl(Context ctx, BankInfo chInfo) throws BOSException, EASBizException {
        return null;
    }

    public static ReckoningAccountInfo getDirectLowerAndUpperReckoningAcct(Context ctx, String chId1, String chId2) throws BOSException, EASBizException {
        if (ClearingHouseHelper.isDirectLowerCh(ctx, chId2, chId1)) {
            return ReckoningAccountHelper.getReckoningAcct(ctx, (IObjectPK)new ObjectUuidPK(chId1), (IObjectPK)new ObjectUuidPK(chId2));
        }
        if (ClearingHouseHelper.isIndirectLowerCh(ctx, chId2, chId1)) {
            BankInfo middleChInfo = ClearingHouseHelper.getDirectLowerAndUpperCh(ctx, chId1, chId2);
            return ReckoningAccountHelper.getReckoningAcct(ctx, (IObjectPK)new ObjectUuidPK(chId1), (IObjectPK)new ObjectUuidPK(middleChInfo.getId()));
        }
        return null;
    }

    private static IReckoningAccount getBizInterface(Context ctx) throws BOSException {
        if (ctx == null) {
            return ReckoningAccountFactory.getRemoteInstance();
        }
        return ReckoningAccountFactory.getLocalInstance(ctx);
    }
}

