/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.assistant.SettlementTypeFactory;
import com.kingdee.eas.basedata.assistant.SettlementTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMBgItemProp;
import com.kingdee.eas.fm.common.IFMBgUsed;
import com.kingdee.eas.fm.fs.AbstractSettlementBillInfo;
import com.kingdee.eas.fm.fs.IInnerAccount;
import com.kingdee.eas.fm.fs.InnerAccountFactory;
import com.kingdee.eas.fm.fs.InnerAccountInfo;
import com.kingdee.eas.fm.fs.MutilClearHouserHelper;
import com.kingdee.eas.fm.fs.SettBizTypeEnum;
import com.kingdee.eas.fm.fs.SettleMutilTypeEnum;
import com.kingdee.eas.fm.fs.SettlementBillSourceEnum;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.util.marshal.Marshaller;
import com.kingdee.util.marshal.Unmarshaller;
import java.io.IOException;
import java.io.Serializable;

public class SettlementBillInfo
extends AbstractSettlementBillInfo
implements Serializable,
IFMBgUsed {
    private boolean isBotpGen = false;

    public SettlementBillInfo() {
    }

    protected SettlementBillInfo(String pkField) {
        super(pkField);
    }

    public String getLogInfo() {
        return super.getLogInfo();
    }

    public boolean isBotpGen() {
        return this.isBotpGen;
    }

    public void setBotpGen(boolean isBotpGen) {
        this.isBotpGen = isBotpGen;
    }

    public void marshal(Marshaller marshaller) throws IOException {
        super.marshal(marshaller);
        marshaller.writeObject((Object)this.isBotpGen);
    }

    public void unmarshal(Unmarshaller unmarshaller) throws IOException, ClassNotFoundException {
        super.unmarshal(unmarshaller);
        this.isBotpGen = (Boolean)unmarshaller.readObject();
    }

    public SettleMutilTypeEnum genMutilType(Context ctx) {
        SettleMutilTypeEnum mutilType = null;
        SettBizTypeEnum type = this.getType();
        if (type != null) {
            switch (type.getValue()) {
                case 1: {
                    mutilType = SettleMutilTypeEnum.REC;
                    break;
                }
                case 10: {
                    mutilType = SettleMutilTypeEnum.PAY;
                    break;
                }
                case 2: 
                case 100: {
                    mutilType = SettleMutilTypeEnum.PAY;
                    break;
                }
                case 3: {
                    mutilType = SettleMutilTypeEnum.TRANS;
                    break;
                }
                case 4: {
                    mutilType = SettleMutilTypeEnum.TRANS;
                    break;
                }
                default: {
                    InnerAccountInfo acct;
                    IInnerAccount inn;
                    if (this.getMutilType() != null) {
                        return this.getMutilType();
                    }
                    if (this.getPayerInnerAcct() != null && this.getPayerInnerAcct().getCompany() == null) {
                        inn = null;
                        try {
                            inn = ctx == null ? InnerAccountFactory.getRemoteInstance() : InnerAccountFactory.getLocalInstance(ctx);
                            acct = inn.getInnerAccountInfo((IObjectPK)new ObjectUuidPK(this.getPayerInnerAcct().getId()));
                            this.setPayerInnerAcct(acct);
                        }
                        catch (BOSException e) {
                            ExceptionHandler.handle((Throwable)e);
                        }
                        catch (EASBizException e) {
                            ExceptionHandler.handle((Throwable)e);
                        }
                    }
                    if (this.getPayeeInnerAcct() != null && this.getPayeeInnerAcct().getCompany() == null) {
                        inn = null;
                        try {
                            inn = ctx == null ? InnerAccountFactory.getRemoteInstance() : InnerAccountFactory.getLocalInstance(ctx);
                            acct = inn.getInnerAccountInfo((IObjectPK)new ObjectUuidPK(this.getPayeeInnerAcct().getId()));
                            this.setPayeeInnerAcct(acct);
                        }
                        catch (BOSException e) {
                            ExceptionHandler.handle((Throwable)e);
                        }
                        catch (EASBizException e) {
                            ExceptionHandler.handle((Throwable)e);
                        }
                    }
                    if (this.getPayeeInnerAcct() != null && this.getPayerInnerAcct() != null && this.getPayeeInnerAcct().getCompany().getId().equals((Object)this.getPayerInnerAcct().getCompany().getId())) {
                        mutilType = SettleMutilTypeEnum.TRANS;
                        return mutilType;
                    }
                    if (MutilClearHouserHelper.isTopClearHouse(ctx, this.getCompany().getId().toString(), null)) {
                        mutilType = SettleMutilTypeEnum.TRANS;
                        return mutilType;
                    }
                    if (this.getPayerInnerAcct() != null && this.getCompany().getId().equals((Object)this.getPayerInnerAcct().getCompany().getId())) {
                        mutilType = SettleMutilTypeEnum.PAY;
                        return mutilType;
                    }
                    if (this.getPayeeInnerAcct() != null && this.getCompany().getId().equals((Object)this.getPayeeInnerAcct().getCompany().getId())) {
                        mutilType = SettleMutilTypeEnum.REC;
                        return mutilType;
                    }
                    if (this.getPayeeBankAcct() != null) {
                        mutilType = SettleMutilTypeEnum.REC;
                        return mutilType;
                    }
                    if (this.getPayerBankAcct() != null) {
                        mutilType = SettleMutilTypeEnum.PAY;
                        return mutilType;
                    }
                    if (type == SettBizTypeEnum.PAYINSIDEDIF) {
                        mutilType = SettleMutilTypeEnum.PAY;
                        return mutilType;
                    }
                    if (type == SettBizTypeEnum.RECINSIDEDIF) {
                        mutilType = SettleMutilTypeEnum.REC;
                        return mutilType;
                    }
                    mutilType = SettleMutilTypeEnum.TRANS;
                }
            }
        }
        return mutilType;
    }

    public FMBgItemProp[] getBgItemProps() {
        return new FMBgItemProp[]{new FMBgItemProp("outBgItemId", "outBgItemNumber", "outBgItemName"), new FMBgItemProp("oppBgItemId", "oppBgItemNumber", "oppBgItemName")};
    }

    private SettlementTypeInfo getSettlementTypeInfoByID(SettlementTypeInfo info) {
        if (info != null) {
            try {
                return (SettlementTypeInfo)SettlementTypeFactory.getRemoteInstance().getValue((IObjectPK)new ObjectUuidPK(info.getId()));
            }
            catch (EASBizException e) {
                ExceptionHandler.handle((Throwable)e);
            }
            catch (BOSException e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
        return null;
    }

    public SettlementBillInfo copy() {
        SettlementBillInfo info = new SettlementBillInfo();
        info.setBizDate(this.getBizDate());
        info.setDescription(this.getDescription());
        info.setType(this.getType());
        info.setAppendix(this.getAppendix());
        info.setPayeeBankAcctNum(this.getPayeeBankAcctNum());
        info.setPayerBankAcctNum(this.getPayerBankAcctNum());
        info.setPayeePlanItem(this.getPayeePlanItem());
        info.setPayerPlanItem(this.getPayerPlanItem());
        info.setExchange(this.getExchange());
        info.setPayeeBankAcct(this.getPayeeBankAcct());
        info.setPayerBankAcct(this.getPayerBankAcct());
        info.setPayeeInnerAcct(this.getPayeeInnerAcct());
        info.setPayerInnerAcct(this.getPayerInnerAcct());
        info.setApplyUnit(this.getApplyUnit());
        info.setExpectDealTime(this.getExpectDealTime());
        info.setPayeeFullName(this.getPayeeFullName());
        info.setPayerFullName(this.getPayerFullName());
        info.setBizType(this.getBizType());
        info.setPayeeBank(this.getPayeeBank());
        info.setPayerBank(this.getPayerBank());
        info.setCurrency(this.getCurrency());
        info.setAmount(this.getAmount());
        info.setLocalAmt(this.getLocalAmt());
        info.setSettleType(this.getSettleType());
        SettlementTypeInfo settlementTypeInfo = this.getSettlementTypeInfoByID(info.getSettleType());
        if (settlementTypeInfo != null) {
            info.getSettleType().setPayThroughBE(settlementTypeInfo.isPayThroughBE());
        }
        info.setIsUrgent(this.getIsUrgent());
        info.setSettleAcceptCH(this.getSettleAcceptCH());
        info.setSettleConfirmCH(this.getSettleConfirmCH());
        info.setReckoningAcct(this.getReckoningAcct());
        info.setSource(SettlementBillSourceEnum.MANUAL);
        info.setAmountCap(this.getAmountCap());
        info.setFeeType(this.getFeeType());
        info.setProject(this.getProject());
        info.setPayeeAcct(this.getPayeeAcct());
        info.setPayerAcct(this.getPayerAcct());
        info.setInnerSetteType(this.getInnerSetteType());
        info.setPayerProject(this.getPayerProject());
        info.setPayerFeeType(this.getPayerFeeType());
        info.setUsage(this.getUsage());
        info.setRecProvinceStr(this.getRecProvinceStr());
        info.setRecCityStr(this.getRecCityStr());
        info.setFinPayeeInAcct(this.getFinPayeeInAcct());
        info.setFinPayerInAcct(this.getFinPayerInAcct());
        info.setFinPayeeBankAct(this.getFinPayeeBankAct());
        info.setFinPayerBankAct(this.getFinPayerBankAct());
        info.setIsDifferPlace(this.getIsDifferPlace());
        info.setMutilType(this.getMutilType());
        info.setAppendixSRC(this.getAppendixSRC());
        info.setAppendixCOPY(this.getAppendixCOPY());
        info.setInnerSettleNumber(this.getInnerSettleNumber());
        info.setInnerPayerAcct(this.getInnerPayerAcct());
        info.setInnerPayeeAcct(this.getInnerPayeeAcct());
        info.setPayProvinceStr(this.getPayProvinceStr());
        info.setPayCityStr(this.getPayCityStr());
        info.setCompany(this.getCompany());
        info.setIsCopyAdd(true);
        info.setFiVouchered(false);
        info.setFRecCountry(this.getFRecCountry());
        info.setSwiftCode(this.getSwiftCode());
        info.setBankAcctName(this.getBankAcctName());
        info.setBankNumber(this.getBankNumber());
        info.setIsForceManual(this.isIsForceManual());
        info.setFundFlowItemOut(this.getFundFlowItemOut());
        return info;
    }
}

