/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.fs.FSHelper;
import com.kingdee.eas.fm.fs.ISubsidiaryBookProvider;
import com.kingdee.eas.fm.fs.SourceTypeEnum;
import com.kingdee.eas.fm.fs.SubsidiaryBillTypeEnum;
import com.kingdee.eas.fm.fs.SubsidiaryLedgerCollection;
import com.kingdee.eas.fm.fs.SubsidiaryLedgerInfo;
import com.kingdee.eas.fm.fs.TransBillBaseEntryCollection;
import com.kingdee.eas.fm.fs.TransBillBaseEntryInfo;
import com.kingdee.eas.fm.fs.TransBillBaseInfo;
import com.kingdee.eas.fm.fs.TransDownBillInfo;
import com.kingdee.eas.fm.fs.TransUpBillInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.util.DateTimeUtils;
import java.math.BigDecimal;
import java.util.Date;

public abstract class TransBaseBillBookSubsidiaryProvider
implements ISubsidiaryBookProvider {
    @Override
    public SubsidiaryLedgerCollection getCollection(Context ctx, String billId) throws BOSException, EASBizException {
        TransBillBaseInfo info = this.getInfo(ctx, billId);
        TransBillBaseEntryCollection entryColl = this.getEntryColl(info);
        return this.getSubColl(ctx, info, entryColl);
    }

    private SubsidiaryLedgerCollection getSubColl(Context ctx, TransBillBaseInfo info, TransBillBaseEntryCollection entryColl) throws EASBizException, BOSException {
        SubsidiaryLedgerCollection subColl = new SubsidiaryLedgerCollection();
        SubsidiaryLedgerInfo subInfo = null;
        CompanyOrgUnitInfo company = info.getCompany();
        UserInfo user = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
        TransBillBaseEntryInfo entryInfo = null;
        int size = entryColl.size();
        for (int i = 0; i < size; ++i) {
            entryInfo = entryColl.get(i);
            if (EmptyUtil.isEmpty((CoreBaseInfo)entryInfo.getUnitInnerAcct()) && SourceTypeEnum.TRANSDETAIL.equals((Object)info.getSourceType())) {
                entryInfo.setUnitInnerAcct(entryInfo.getUnitAcctBank().getInnerAcct());
            }
            if (!entryInfo.isHasChange() || !entryInfo.isIsSuccessed() || EmptyUtil.isEmpty((CoreBaseInfo)entryInfo.getUnitInnerAcct())) continue;
            subInfo = new SubsidiaryLedgerInfo();
            subInfo.setCompany(company);
            subInfo.setCurrency(info.getCurrency());
            BankInfo clearingHouse = FSHelper.getClearingHouseInfo(ctx, info.getCompany().getId().toString());
            if (info.getBizDate().after(clearingHouse.getSettleDate())) {
                subInfo.setDate(info.getBizDate());
            } else {
                subInfo.setDate(clearingHouse.getSettleDate());
            }
            String tm119 = ContextHelperFactory.getLocalInstance((Context)ctx).getStringParam("TM119", (IObjectPK)new ObjectUuidPK(info.getCompany().getId().toString()));
            if (("1".equals(tm119) || "2".equals(tm119)) && info.getSettleType() != null && info.getSettleType().isPayThroughBE()) {
                Date commitBeTime = null;
                commitBeTime = new TransUpBillInfo().getBOSType().equals((Object)info.getBOSType()) ? ((TransUpBillInfo)info).getCommitBeTime() : ((TransDownBillInfo)info).getCommitBeTime();
                if (commitBeTime != null && subInfo.getDate().before(commitBeTime)) {
                    subInfo.setDate(DateTimeUtils.truncateDate((Date)commitBeTime));
                }
            }
            subInfo.setBizType(this.getBillType());
            subInfo.setBillNumber(info.getNumber() + "_" + entryInfo.getSeq());
            subInfo.setBillId(entryInfo.getId());
            subInfo.setExchangeRate(info.getExchangeRate());
            subInfo.setIsDownLoad(false);
            subInfo.setBookkeeper(user);
            subInfo.setDescription(entryInfo.getDescription());
            subInfo.setApplyUnit(entryInfo.getUnitAcctBank().getCompany());
            subInfo.setInnerAccount(entryInfo.getUnitInnerAcct());
            subInfo.setSettleType(info.getSettleType());
            subInfo.setSettleNumber(info.getSettleNumber());
            subInfo.setDebitAmount(this.getDebitAmt(entryInfo));
            subInfo.setCreditAmount(this.getCreditAmt(entryInfo));
            if (this.getBillType().equals((Object)SubsidiaryBillTypeEnum.TransUpBill)) {
                subInfo.setPayeeBankAcct(info.getMotherAcctBank().getBankAccountNumber());
                subInfo.setPayerBankAcct(entryInfo.getUnitAcctBank().getBankAccountNumber());
            }
            if (this.getBillType().equals((Object)SubsidiaryBillTypeEnum.TransDownBill)) {
                subInfo.setPayeeBankAcct(entryInfo.getUnitAcctBank().getBankAccountNumber());
                subInfo.setPayerBankAcct(info.getMotherAcctBank().getBankAccountNumber());
            }
            subColl.add(subInfo);
        }
        return subColl;
    }

    protected SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("settleType.payThroughBE");
        sic.add("motherAcctBank.bankAccountNumber");
        sic.add("entrys.*");
        sic.add("entrys.unitAcctBank.*");
        return sic;
    }

    protected abstract SubsidiaryBillTypeEnum getBillType();

    protected abstract BigDecimal getDebitAmt(TransBillBaseEntryInfo var1);

    protected abstract BigDecimal getCreditAmt(TransBillBaseEntryInfo var1);

    protected abstract TransBillBaseInfo getInfo(Context var1, String var2) throws EASBizException, BOSException;

    protected abstract TransBillBaseEntryCollection getEntryColl(TransBillBaseInfo var1) throws EASBizException, BOSException;
}

