/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.be.BankPayingBillStateEnum;
import com.kingdee.eas.fm.be.BankTransDownBillEntryInfo;
import com.kingdee.eas.fm.be.BankTransDownBillInfo;
import com.kingdee.eas.fm.be.BillTypeEnum;
import com.kingdee.eas.fm.be.IBankTransDownBillBuilder;
import com.kingdee.eas.fm.be.app.service.beServiceHelper;
import com.kingdee.eas.fm.fs.ITransDownBill;
import com.kingdee.eas.fm.fs.TransDownBillEntryInfo;
import com.kingdee.eas.fm.fs.TransDownBillFactory;
import com.kingdee.eas.fm.fs.TransDownBillInfo;
import java.sql.Timestamp;
import java.util.Calendar;

public class TransDownBill2BankBillBuilder
implements IBankTransDownBillBuilder {
    public BankTransDownBillInfo getBankTransDownBillInfo(Context ctx, String billId) throws BOSException, EASBizException {
        ITransDownBill iTransDownBill = TransDownBillFactory.getLocalInstance(ctx);
        TransDownBillInfo info = iTransDownBill.getTransDownBillInfo((IObjectPK)new ObjectUuidPK(billId), this.getSelector());
        BankTransDownBillInfo bankTransDownInfo = new BankTransDownBillInfo();
        bankTransDownInfo.setSrcBillNumber(info.getNumber());
        bankTransDownInfo.setSourceBillId(info.getId().toString());
        bankTransDownInfo.setSrcBillType(BillTypeEnum.transDownBill);
        bankTransDownInfo.setCompany(info.getCompany());
        Timestamp time = new Timestamp(Calendar.getInstance().getTimeInMillis());
        bankTransDownInfo.setSubmitTime(time);
        bankTransDownInfo.setBizDate(info.getBizDate());
        bankTransDownInfo.setExpectTransTime(time);
        bankTransDownInfo.setCurrency(info.getCurrency());
        bankTransDownInfo.setTotalAmt(info.getTotalAmt());
        bankTransDownInfo.setTotalCounts(info.getTotalCounts());
        bankTransDownInfo.setState(BankPayingBillStateEnum.OS);
        bankTransDownInfo.setDescription(info.getDescription());
        bankTransDownInfo.setMotherAcctBank(info.getMotherAcctBank());
        bankTransDownInfo.setUsage(info.getUsage());
        bankTransDownInfo.setIsUrgent(info.isIsUrgent());
        String[] serialNumbers = beServiceHelper.getSerialNumber((int)1);
        bankTransDownInfo.setSerialNumber(serialNumbers[0]);
        bankTransDownInfo.setBankInterfaceType(info.getMotherAcctBank().getBankInterfaceType());
        for (int i = 0; i < info.getEntrys().size(); ++i) {
            TransDownBillEntryInfo transDownBillEntryInfo = info.getEntrys().get(i);
            BankTransDownBillEntryInfo bankTransDownBillEntryInfo = new BankTransDownBillEntryInfo();
            bankTransDownBillEntryInfo.setParent(bankTransDownInfo);
            bankTransDownBillEntryInfo.setUnitAcctBank(transDownBillEntryInfo.getUnitAcctBank());
            bankTransDownBillEntryInfo.setUnit(transDownBillEntryInfo.getUnit());
            bankTransDownBillEntryInfo.setAmount(transDownBillEntryInfo.getAmount());
            bankTransDownBillEntryInfo.setSrcBillNumber(transDownBillEntryInfo.getId().toString());
            bankTransDownInfo.setSrcBillType(BillTypeEnum.transDownBill);
            Timestamp entryTime = new Timestamp(Calendar.getInstance().getTimeInMillis());
            bankTransDownBillEntryInfo.setSubmitTime(entryTime);
            bankTransDownBillEntryInfo.setExpectTransTime(time);
            bankTransDownBillEntryInfo.setBankInterfaceType(info.getMotherAcctBank().getBankInterfaceType());
            bankTransDownBillEntryInfo.setState(BankPayingBillStateEnum.OS);
            bankTransDownBillEntryInfo.setIsBitBack(false);
            bankTransDownBillEntryInfo.setRecProvince(transDownBillEntryInfo.getRecProvince());
            bankTransDownBillEntryInfo.setRecCity(transDownBillEntryInfo.getRecCity());
            bankTransDownBillEntryInfo.setDescription(transDownBillEntryInfo.getDescription());
            bankTransDownBillEntryInfo.setIsDifBank(transDownBillEntryInfo.getIsDifBank());
            bankTransDownBillEntryInfo.setIsDifferPlace(transDownBillEntryInfo.getIsDifferPlace());
            bankTransDownBillEntryInfo.setRecBank(transDownBillEntryInfo.getRecBank());
            bankTransDownBillEntryInfo.setPayeeArea(transDownBillEntryInfo.getPayeeArea());
            bankTransDownBillEntryInfo.setPayeeBankCode(transDownBillEntryInfo.getPayeeBankCode());
            serialNumbers = beServiceHelper.getSerialNumber((int)1);
            bankTransDownBillEntryInfo.setSerialNumber(serialNumbers[0]);
            bankTransDownInfo.getEntrys().add(bankTransDownBillEntryInfo);
        }
        return bankTransDownInfo;
    }

    private SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("motherAcctBank.id"));
        sic.add(new SelectorItemInfo("motherAcctBank.bank"));
        sic.add(new SelectorItemInfo("motherAcctBank.company"));
        sic.add(new SelectorItemInfo("motherAcctBank.bankInterfaceType"));
        sic.add(new SelectorItemInfo("motherAcctBank.openArea"));
        sic.add(new SelectorItemInfo("motherAcctBank.*"));
        sic.add(new SelectorItemInfo("entrys.*"));
        sic.add(new SelectorItemInfo("entrys.unitAcctBank.*"));
        sic.add(new SelectorItemInfo("entrys.unit.*"));
        sic.add(new SelectorItemInfo("entrys.subAcct.*"));
        return sic;
    }
}

