/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.AccountType;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.IAccountBank;
import com.kingdee.eas.basedata.assistant.IAccountMgrStrategyFacade;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.RecPayException;
import com.kingdee.eas.fm.be.BEException;
import com.kingdee.eas.fm.be.BankTransUpBillFactory;
import com.kingdee.eas.fm.be.BankTransUpBillInfo;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.util.FMARAPUtil;
import com.kingdee.eas.fm.fs.AutoTransCollection;
import com.kingdee.eas.fm.fs.AutoTransCommitTypeEnum;
import com.kingdee.eas.fm.fs.AutoTransEntryInfo;
import com.kingdee.eas.fm.fs.AutoTransHistoryCollection;
import com.kingdee.eas.fm.fs.AutoTransHistoryFactory;
import com.kingdee.eas.fm.fs.AutoTransHistoryInfo;
import com.kingdee.eas.fm.fs.AutoTransInfo;
import com.kingdee.eas.fm.fs.ITransUpBill;
import com.kingdee.eas.fm.fs.ITransUpBillFacade;
import com.kingdee.eas.fm.fs.LaunchModeEnum;
import com.kingdee.eas.fm.fs.TransAmtInfo;
import com.kingdee.eas.fm.fs.TransUpBillCollection;
import com.kingdee.eas.fm.fs.TransUpBillEntryInfo;
import com.kingdee.eas.fm.fs.TransUpBillFacadeFactory;
import com.kingdee.eas.fm.fs.TransUpBillFactory;
import com.kingdee.eas.fm.fs.TransUpBillInfo;
import com.kingdee.eas.fm.fs.TransUpBillStateEnum;
import com.kingdee.eas.fm.fs.TransUpDownBillHelper;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class TransUpBillHelper
extends TransUpDownBillHelper {
    private static Logger logger = Logger.getLogger((String)TransUpBillHelper.class.getName());

    @Override
    protected Map getTransAcctBankAmt(String motherAcctBankId, String currencyId) throws BOSException, EASBizException {
        Date date = new Date();
        ITransUpBillFacade facade = TransUpBillFacadeFactory.getRemoteInstance();
        return facade.getTransUpAcctBankAmt(motherAcctBankId, currencyId, date);
    }

    @Override
    public Map getTransAcctBankAmt(Set acctBankUnitSet, String currencyId) throws BOSException, EASBizException {
        Date date = new Date();
        ITransUpBillFacade facade = TransUpBillFacadeFactory.getRemoteInstance();
        return facade.getTransUpAcctBankAmt(acctBankUnitSet, currencyId, date);
    }

    public static AccountBankCollection getTransUpAcctBankColl(Context ctx, String motherAcctBankId, Date date) throws EASBizException, BOSException {
        IAccountBank iacctBank = TransUpBillHelper.getAccountBankInterface(ctx);
        EntityViewInfo view = TransUpBillHelper.getEntityViewInfo(motherAcctBankId);
        AccountBankCollection unitAcctBankColl = iacctBank.getAccountBankCollection(view);
        for (int i = 0; i < unitAcctBankColl.size(); ++i) {
            AccountBankInfo tmp = unitAcctBankColl.get(i);
            if (!tmp.getId().toString().equals(motherAcctBankId)) continue;
            unitAcctBankColl.remove(tmp);
        }
        IAccountMgrStrategyFacade iAcctMgrFacade = TransUpBillHelper.getAcctMgrFacadeInterface(ctx);
        AccountBankCollection allTransUpAcctBankColl = iAcctMgrFacade.getTransUpAcctBankColl(date);
        HashMap<String, AccountBankInfo> map = new HashMap<String, AccountBankInfo>();
        AccountBankInfo info = null;
        int size = allTransUpAcctBankColl.size();
        for (int i = 0; i < size; ++i) {
            info = allTransUpAcctBankColl.get(i);
            map.put(info.getId().toString(), info);
        }
        AccountBankCollection transUpAcctBankColl = new AccountBankCollection();
        for (int i = 0; i < unitAcctBankColl.size(); ++i) {
            info = unitAcctBankColl.get(i);
            if (!map.containsKey(info.getId().toString()) || !info.getAccountType().equals((Object)AccountType.PAYIN) && !info.getAccountType().equals((Object)AccountType.PAYINOUT)) continue;
            transUpAcctBankColl.add(info);
        }
        return transUpAcctBankColl;
    }

    private static EntityViewInfo getEntityViewInfo(String montherAcctId) {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("subAccount", (Object)montherAcctId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)Boolean.FALSE, CompareType.EQUALS));
        evi.setFilter(filter);
        SelectorItemCollection sic = TransUpBillHelper.getBankAcntSelector();
        evi.setSelector(sic);
        return evi;
    }

    private static SelectorItemCollection getBankAcntSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("ID"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("bankAccountNumber"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("bank.id"));
        sic.add(new SelectorItemInfo("bank.name"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("accountType"));
        sic.add(new SelectorItemInfo("openDate"));
        sic.add(new SelectorItemInfo("closeDate"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("property.id"));
        sic.add(new SelectorItemInfo("property.name"));
        sic.add(new SelectorItemInfo("isMotherAccount"));
        sic.add(new SelectorItemInfo("isSetBankInterface"));
        sic.add(new SelectorItemInfo("ctrlStrategy.id"));
        sic.add(new SelectorItemInfo("ctrlStrategy.name"));
        sic.add(new SelectorItemInfo("InnerAcct.id"));
        sic.add(new SelectorItemInfo("InnerAcct.name"));
        sic.add(new SelectorItemInfo("InnerAcct.number"));
        sic.add(new SelectorItemInfo("InnerAcct.clearingHouse.relatedCompany"));
        sic.add(new SelectorItemInfo("InnerAcct.company.id"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("subAccount.id"));
        sic.add(new SelectorItemInfo("subAccount.name"));
        sic.add(new SelectorItemInfo("subAccount.number"));
        sic.add(new SelectorItemInfo("CtrlStrategy.*"));
        return sic;
    }

    @Override
    public Set getUnitAcctBankIdSet(String motherAcctBankId) throws EASBizException, BOSException {
        return super.getUnitAcctBankIdSet(motherAcctBankId);
    }

    public Set getPayValidIdSetByAction(Context ctx, Set idSet, int action) throws BOSException, EASBizException {
        TransUpBillCollection coll = TransUpBillHelper.getTransUpBillColl(ctx, idSet);
        Set validSet = null;
        switch (action) {
            case 41: {
                validSet = this.getTransUpValidIdSetByCommitBE(ctx, coll);
            }
        }
        if (validSet == null || validSet.isEmpty()) {
            throw new RecPayException(RecPayException.HASNOT_VALID_LISTS);
        }
        return validSet;
    }

    private Set getTransUpValidIdSetByCommitBE(Context ctx, TransUpBillCollection coll) throws EASBizException {
        HashSet<String> set = new HashSet<String>();
        TransUpBillInfo info = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            info = coll.get(i);
            boolean entryValid = true;
            for (int j = 0; j < info.getEntrys().size(); ++j) {
                TransUpBillEntryInfo entryInfo = info.getEntrys().get(j);
                if (entryInfo.getUnitAcctBank().isIsOnlyRead()) {
                    throw new BEException(BEException.ACCOUNTBANKONLYREAD, new Object[]{entryInfo.getUnitAcctBank().getName()});
                }
                if (!info.getState().equals((Object)TransUpBillStateEnum.AUDITED) || entryInfo.getUnitAcctBank() == null || entryInfo.getUnitAcctBank().isIsOnlyRead()) {
                    entryValid = false;
                    break;
                }
                if (!FMHelper.isEmpty((String)info.getRecCity()) && !FMHelper.isEmpty((String)info.getRecProvince())) continue;
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"195_TransUpBillHelper"));
                SysUtil.abort();
            }
            if (!entryValid) continue;
            set.add(info.getId().toString());
        }
        return set;
    }

    public static TransUpBillCollection getTransUpBillColl(Context ctx, Set idSet) throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSelector().add("*");
        evi.getSelector().add("entrys.*");
        evi.getSelector().add("entrys.unit.*");
        evi.getSelector().add("entrys.unitAcctBank.isSetBankInterface");
        evi.getSelector().add("entrys.unitAcctBank.isOnlyRead");
        evi.getSelector().add("entrys.unitAcctBank.id");
        evi.getSelector().add("entrys.unitAcctBank.name");
        evi.getSelector().add("motherAcctBank.*");
        ITransUpBill iTransUpBill = null;
        iTransUpBill = ctx == null ? TransUpBillFactory.getRemoteInstance() : TransUpBillFactory.getLocalInstance(ctx);
        return iTransUpBill.getTransUpBillCollection(evi);
    }

    public Map genTransUpBills(Context ctx, AutoTransCollection colls) throws BOSException, EASBizException {
        HashMap<String, AutoTransHistoryCollection> idSet = new HashMap<String, AutoTransHistoryCollection>();
        for (int i = 0; i < colls.size(); ++i) {
            TransUpBillInfo info;
            AutoTransInfo autoInfo;
            block14: {
                autoInfo = colls.get(i);
                if (TransUpBillHelper.checkIsAutoRun(ctx, autoInfo.getId().toString())) {
                    logger.error((Object)(EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"319_TransUpBillHelper") + autoInfo.getName() + EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"302_TransDownBillHelper")));
                    continue;
                }
                info = new TransUpBillInfo();
                info.setCompany(autoInfo.getCompany());
                info.setBizDate(DateTimeUtils.truncateDate((Date)new Date()));
                info.setLaunchMode(LaunchModeEnum.CH_LAUNCH);
                info.setCurrency(autoInfo.getCompany().getBaseCurrency());
                info.setExchangeRate(Constants.ONE);
                info.setTotalAmt(Constants.ZERO);
                info.setConfirmedAmt(Constants.ZERO);
                info.setCreator(autoInfo.getCreator());
                info.setState(TransUpBillStateEnum.SAVED);
                info.setAccessories(0);
                info.setSettleType(autoInfo.getSettleType());
                info.setUsage(autoInfo.getRemark());
                info.setCurrency(autoInfo.getCurrent());
                info.setFpItem(autoInfo.getFpItem());
                if (!EmptyUtil.isEmpty((String)autoInfo.getOutBgItemId())) {
                    info.setOutBgItemId(autoInfo.getOutBgItemId());
                    info.setOutBgItemName(autoInfo.getOutBgItemName());
                    info.setOutBgItemNumber(autoInfo.getOutBgItemNumber());
                } else {
                    info.setFundFlowItem(autoInfo.getFundFlowItem());
                }
                info.setMotherAcctBank(autoInfo.getParentAcct());
                info.setRecProvince(autoInfo.getRecProvince());
                info.setRecCity(autoInfo.getRecCity());
                String companyId = autoInfo.getCompany().getId().toString();
                ExchangeRateInfo exRateInfo = FMARAPUtil.getExchangeRate((Context)ctx, (CompanyOrgUnitInfo)autoInfo.getCompany(), (CurrencyInfo)autoInfo.getCurrent(), (Date)info.getBizDate());
                if (exRateInfo != null) {
                    info.setExchangeRate(exRateInfo.getConvertRate());
                }
                info.setIsUrgent(autoInfo.isIsUrgent());
                info.setDescription(autoInfo.getRemark());
                boolean rst = FMHelper.hasNumber((Context)ctx, (CoreBaseInfo)info, (String)companyId);
                if (rst) {
                    try {
                        ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
                        String number = codingRuleManager.getNumber((IObjectValue)info, companyId);
                        info.setNumber(number);
                        break block14;
                    }
                    catch (EASBizException e) {
                        logger.error((Object)EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"320_TransUpBillHelper"));
                        TransUpBillHelper.addErrorTransLog(ctx, autoInfo, e.getMessage());
                        continue;
                    }
                }
                logger.error((Object)EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"321_TransUpBillHelper"));
                TransUpBillHelper.addErrorTransLog(ctx, autoInfo, EASResource.getString((String)"com.kingdee.eas.fm.fs.TransBillResource", (String)"isNeedTransUpNumber"));
                continue;
            }
            try {
                logger.error((Object)EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"322_TransUpBillHelper"));
                this.genAutoTransBillEntry(ctx, info, autoInfo);
                info.setTotalCounts(info.getEntrys().size());
                if (autoInfo.getIsCommitBe().equals((Object)AutoTransCommitTypeEnum.COMMITBE)) {
                    info.setState(TransUpBillStateEnum.AUDITED);
                    info.setAuditor(autoInfo.getCreator());
                }
                if (info.getEntrys().size() > 0) {
                    StringBuffer sb = new StringBuffer();
                    logger.error((Object)EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"323_TransUpBillHelper"));
                    IObjectPK pk = TransUpBillFactory.getLocalInstance(ctx).submit((CoreBaseInfo)info);
                    logger.error((Object)(EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"324_TransUpBillHelper") + info.getEntrys().size() + EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"308_TransDownBillHelper")));
                    AutoTransHistoryCollection hisColls = new AutoTransHistoryCollection();
                    for (int index = 0; index < info.getEntrys().size(); ++index) {
                        AutoTransHistoryInfo hisInfo = new AutoTransHistoryInfo();
                        hisInfo.setBizDate(new Date());
                        hisInfo.setTransUpBill(info);
                        hisInfo.setMotherAcct(info.getMotherAcctBank());
                        hisInfo.setTransUnit(info.getEntrys().get(index).getUnit());
                        hisInfo.setUnitAccount(info.getEntrys().get(index).getUnitAcctBank());
                        hisInfo.setSourceBillId(info.getEntrys().get(index).getId().toString());
                        hisInfo.setAutoTrans(autoInfo);
                        hisInfo.setCreator(autoInfo.getCreator());
                        AutoTransHistoryFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)hisInfo);
                        hisColls.add(hisInfo);
                    }
                    if (autoInfo.getIsCommitBe().equals((Object)AutoTransCommitTypeEnum.COMMITBE)) {
                        idSet.put(pk.toString(), hisColls);
                        String logName = EASResource.getString((String)"com.kingdee.eas.fm.fs.TransBillResource", (String)"autoTransUp") + EASResource.getString((String)"com.kingdee.eas.fm.fs.TransBillResource", (String)"titleSet") + EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"309_TransDownBillHelper");
                        IObjectPK pkOut = LogUtil.beginLog((Context)ctx, (String)logName, (BOSObjectType)new AutoTransInfo().getBOSType(), null, (String)autoInfo.getNumber(), (String)"fs_autoTrans_submitBe");
                        LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
                        continue;
                    }
                    TransUpBillHelper.sendTransBillMessage(ctx, false, hisColls, false, false);
                    continue;
                }
                logger.error((Object)(EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"325_TransUpBillHelper") + autoInfo.getName() + EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"326_TransUpBillHelper")));
                TransUpBillHelper.addErrorTransLog(ctx, autoInfo, EASResource.getString((String)"com.kingdee.eas.fm.fs.TransBillResource", (String)"notRecordUpSize"));
                continue;
            }
            catch (EASBizException e) {
                logger.error((Object)"\u81ea\u52a8\u5212\u62e8\u751f\u6210\u4e0a\u5212\u5355\u5931\u8d25\uff1a", (Throwable)e);
                TransUpBillHelper.addErrorTransLog(ctx, autoInfo, e.getMessage());
            }
        }
        return idSet;
    }

    public Map genTransUpBillsNew(Context ctx, AutoTransCollection colls) throws BOSException, EASBizException {
        HashMap<String, AutoTransHistoryCollection> idSet = new HashMap<String, AutoTransHistoryCollection>();
        for (int i = 0; i < colls.size(); ++i) {
            TransUpBillInfo info;
            AutoTransInfo autoInfo;
            block13: {
                autoInfo = colls.get(i);
                info = new TransUpBillInfo();
                info.setCompany(autoInfo.getCompany());
                info.setBizDate(DateTimeUtils.truncateDate((Date)new Date()));
                info.setLaunchMode(LaunchModeEnum.CH_LAUNCH);
                info.setCurrency(autoInfo.getCompany().getBaseCurrency());
                info.setExchangeRate(Constants.ONE);
                info.setTotalAmt(Constants.ZERO);
                info.setConfirmedAmt(Constants.ZERO);
                info.setCreator(autoInfo.getCreator());
                info.setState(TransUpBillStateEnum.SAVED);
                info.setAccessories(0);
                info.setSettleType(autoInfo.getSettleType());
                info.setUsage(autoInfo.getRemark());
                info.setCurrency(autoInfo.getCurrent());
                info.setFpItem(autoInfo.getFpItem());
                if (!EmptyUtil.isEmpty((String)autoInfo.getOutBgItemId())) {
                    info.setOutBgItemId(autoInfo.getOutBgItemId());
                    info.setOutBgItemName(autoInfo.getOutBgItemName());
                    info.setOutBgItemNumber(autoInfo.getOutBgItemNumber());
                } else {
                    info.setFundFlowItem(autoInfo.getFundFlowItem());
                }
                info.setMotherAcctBank(autoInfo.getParentAcct());
                info.setRecProvince(autoInfo.getRecProvince());
                info.setRecCity(autoInfo.getRecCity());
                String companyId = autoInfo.getCompany().getId().toString();
                ExchangeRateInfo exRateInfo = FMARAPUtil.getExchangeRate((Context)ctx, (CompanyOrgUnitInfo)autoInfo.getCompany(), (CurrencyInfo)autoInfo.getCurrent(), (Date)info.getBizDate());
                if (exRateInfo != null) {
                    info.setExchangeRate(exRateInfo.getConvertRate());
                }
                info.setIsUrgent(autoInfo.isIsUrgent());
                info.setDescription(autoInfo.getRemark());
                boolean rst = FMHelper.hasNumber((Context)ctx, (CoreBaseInfo)info, (String)companyId);
                if (rst) {
                    try {
                        ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
                        String number = codingRuleManager.getNumber((IObjectValue)info, companyId);
                        info.setNumber(number);
                        break block13;
                    }
                    catch (EASBizException e) {
                        logger.error((Object)EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"320_TransUpBillHelper"));
                        TransUpBillHelper.addErrorTransLog(ctx, autoInfo, e.getMessage());
                        continue;
                    }
                }
                logger.error((Object)EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"321_TransUpBillHelper"));
                TransUpBillHelper.addErrorTransLog(ctx, autoInfo, EASResource.getString((String)"com.kingdee.eas.fm.fs.TransBillResource", (String)"isNeedTransUpNumber"));
                continue;
            }
            try {
                logger.error((Object)EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"322_TransUpBillHelper"));
                this.genAutoTransBillEntryNew(ctx, info, autoInfo);
                info.setTotalCounts(info.getEntrys().size());
                if (autoInfo.getIsCommitBe().equals((Object)AutoTransCommitTypeEnum.COMMITBE)) {
                    info.setState(TransUpBillStateEnum.AUDITED);
                    info.setAuditor(autoInfo.getCreator());
                }
                if (info.getEntrys().size() > 0) {
                    StringBuffer sb = new StringBuffer();
                    logger.error((Object)EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"323_TransUpBillHelper"));
                    IObjectPK pk = TransUpBillFactory.getLocalInstance(ctx).submit((CoreBaseInfo)info);
                    logger.error((Object)(EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"324_TransUpBillHelper") + info.getEntrys().size() + EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"308_TransDownBillHelper")));
                    AutoTransHistoryCollection hisColls = new AutoTransHistoryCollection();
                    for (int index = 0; index < info.getEntrys().size(); ++index) {
                        AutoTransHistoryInfo hisInfo = new AutoTransHistoryInfo();
                        hisInfo.setBizDate(new Date());
                        hisInfo.setTransUpBill(info);
                        hisInfo.setMotherAcct(info.getMotherAcctBank());
                        hisInfo.setTransUnit(info.getEntrys().get(index).getUnit());
                        hisInfo.setUnitAccount(info.getEntrys().get(index).getUnitAcctBank());
                        hisInfo.setSourceBillId(info.getEntrys().get(index).getId().toString());
                        hisInfo.setAutoTrans(autoInfo);
                        hisInfo.setCreator(autoInfo.getCreator());
                        AutoTransHistoryFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)hisInfo);
                        hisColls.add(hisInfo);
                    }
                    if (autoInfo.getIsCommitBe().equals((Object)AutoTransCommitTypeEnum.COMMITBE)) {
                        idSet.put(pk.toString(), hisColls);
                        String logName = EASResource.getString((String)"com.kingdee.eas.fm.fs.TransBillResource", (String)"autoTransUp") + EASResource.getString((String)"com.kingdee.eas.fm.fs.TransBillResource", (String)"titleSet") + EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"309_TransDownBillHelper");
                        IObjectPK pkOut = LogUtil.beginLog((Context)ctx, (String)logName, (BOSObjectType)new AutoTransInfo().getBOSType(), null, (String)autoInfo.getNumber(), (String)"fs_autoTrans_submitBe");
                        LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
                        continue;
                    }
                    TransUpBillHelper.sendTransBillMessage(ctx, false, hisColls, false, false);
                    continue;
                }
                logger.error((Object)(EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"325_TransUpBillHelper") + autoInfo.getName() + EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"326_TransUpBillHelper")));
                TransUpBillHelper.addErrorTransLog(ctx, autoInfo, EASResource.getString((String)"com.kingdee.eas.fm.fs.TransBillResource", (String)"notRecordUpSize"));
                continue;
            }
            catch (EASBizException e) {
                logger.error((Object)"\u6309\u7f16\u53f7\u81ea\u52a8\u751f\u6210\u4e0a\u5212\u5355\u5931\u8d25\uff1a", (Throwable)e);
                TransUpBillHelper.addErrorTransLog(ctx, autoInfo, e.getMessage());
            }
        }
        return idSet;
    }

    public void genAutoTransBillEntry(Context ctx, TransUpBillInfo info, AutoTransInfo autoInfo) throws EASBizException, BOSException {
        int seq = 1;
        String accountId = autoInfo.getParentAcct().getId().toString();
        String currentId = autoInfo.getCurrent().getId().toString();
        ITransUpBillFacade facade = TransUpBillFacadeFactory.getLocalInstance(ctx);
        List list = this.getAmtSortedList(facade.getTransUpAcctBankAmt(accountId, currentId, new Date()));
        logger.error((Object)(EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"327_TransUpBillHelper") + autoInfo.getEntrys().size() + EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"315_TransDownBillHelper")));
        for (int i = 0; i < autoInfo.getEntrys().size(); ++i) {
            AutoTransEntryInfo autoEntry = autoInfo.getEntrys().get(i);
            TransUpBillEntryInfo entryInfo = new TransUpBillEntryInfo();
            entryInfo.setSeq(seq++);
            entryInfo.setUnit(autoEntry.getTransDownUnit());
            entryInfo.setUnitAcctBank(autoEntry.getUnitAccount());
            if (autoEntry.getUnitAccount() != null) {
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("number"));
                sic.add(new SelectorItemInfo("name"));
                sic.add(new SelectorItemInfo("acctName"));
                sic.add(new SelectorItemInfo("InnerAcct.id"));
                sic.add(new SelectorItemInfo("InnerAcct.name"));
                sic.add(new SelectorItemInfo("InnerAcct.number"));
                sic.add(new SelectorItemInfo("InnerAcct.acctNumber"));
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                view.setFilter(filter);
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)autoEntry.getUnitAccount().getId().toString(), CompareType.EQUALS));
                view.setSelector(sic);
                AccountBankCollection accountBankCollection = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankCollection(view);
                if (accountBankCollection.size() > 0) {
                    entryInfo.setUnitInnerAcct(accountBankCollection.get(0).getInnerAcct());
                }
            }
            entryInfo.setIsSuccessed(false);
            entryInfo.setDescription(autoInfo.getRemark());
            entryInfo.setProject(autoEntry.getProject());
            entryInfo.setAmount(Constants.ZERO);
            for (int index = 0; index < list.size(); ++index) {
                TransAmtInfo amtInfo = (TransAmtInfo)list.get(index);
                if (!amtInfo.getUnit().getId().equals((Object)entryInfo.getUnit().getId()) || !amtInfo.getAcctBank().getId().equals((Object)entryInfo.getUnitAcctBank().getId())) continue;
                entryInfo.setAmount(amtInfo.getAmount());
                break;
            }
            if (entryInfo.getAmount().compareTo(Constants.ZERO) == 0) continue;
            info.getEntrys().add(entryInfo);
        }
        logger.error((Object)(EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"328_TransUpBillHelper") + autoInfo.getEntrys().size() + EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"315_TransDownBillHelper")));
        BigDecimal sumAmt = Constants.ZERO;
        for (int i = 0; i < info.getEntrys().size(); ++i) {
            sumAmt = sumAmt.add(info.getEntrys().get(i).getAmount());
        }
        info.setTotalAmt(sumAmt);
    }

    public void genAutoTransBillEntryNew(Context ctx, TransUpBillInfo info, AutoTransInfo autoInfo) throws EASBizException, BOSException {
        int seq = 1;
        String accountId = autoInfo.getParentAcct().getId().toString();
        String currentId = autoInfo.getCurrent().getId().toString();
        ITransUpBillFacade facade = TransUpBillFacadeFactory.getLocalInstance(ctx);
        List list = this.getAmtSortedList(facade.getTransUpAcctBankAmt(accountId, currentId, new Date()));
        logger.error((Object)(EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"327_TransUpBillHelper") + autoInfo.getEntrys().size() + EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"315_TransDownBillHelper")));
        for (int i = 0; i < autoInfo.getEntrys().size(); ++i) {
            AutoTransEntryInfo autoEntry = autoInfo.getEntrys().get(i);
            TransUpBillEntryInfo entryInfo = new TransUpBillEntryInfo();
            entryInfo.setSeq(seq++);
            entryInfo.setUnit(autoEntry.getTransDownUnit());
            entryInfo.setUnitAcctBank(autoEntry.getUnitAccount());
            if (autoEntry.getUnitAccount() != null) {
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("number"));
                sic.add(new SelectorItemInfo("name"));
                sic.add(new SelectorItemInfo("acctName"));
                sic.add(new SelectorItemInfo("InnerAcct.id"));
                sic.add(new SelectorItemInfo("InnerAcct.name"));
                sic.add(new SelectorItemInfo("InnerAcct.number"));
                sic.add(new SelectorItemInfo("InnerAcct.acctNumber"));
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                view.setFilter(filter);
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)autoEntry.getUnitAccount().getId().toString(), CompareType.EQUALS));
                view.setSelector(sic);
                AccountBankCollection accountBankCollection = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankCollection(view);
                if (accountBankCollection.size() > 0) {
                    entryInfo.setUnitInnerAcct(accountBankCollection.get(0).getInnerAcct());
                }
            }
            entryInfo.setIsSuccessed(false);
            entryInfo.setDescription(autoInfo.getRemark());
            entryInfo.setProject(autoEntry.getProject());
            entryInfo.setAmount(Constants.ZERO);
            for (int index = 0; index < list.size(); ++index) {
                TransAmtInfo amtInfo = (TransAmtInfo)list.get(index);
                if (!amtInfo.getUnit().getId().equals((Object)entryInfo.getUnit().getId()) || !amtInfo.getAcctBank().getId().equals((Object)entryInfo.getUnitAcctBank().getId())) continue;
                entryInfo.setAmount(amtInfo.getAmount());
                break;
            }
            if (entryInfo.getAmount().compareTo(Constants.ZERO) == 0) continue;
            info.getEntrys().add(entryInfo);
        }
        logger.error((Object)(EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"328_TransUpBillHelper") + autoInfo.getEntrys().size() + EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"315_TransDownBillHelper")));
        BigDecimal sumAmt = Constants.ZERO;
        for (int i = 0; i < info.getEntrys().size(); ++i) {
            sumAmt = sumAmt.add(info.getEntrys().get(i).getAmount());
        }
        info.setTotalAmt(sumAmt);
    }

    public void synBankTransUpBillState(Context ctx, Map idMap) throws EASBizException, BOSException {
        Set idSet = idMap.keySet();
        for (String id : idSet) {
            AutoTransHistoryCollection colls = (AutoTransHistoryCollection)((Object)idMap.get(id));
            Set bankTransSet = FMHelper.getDestBillIdSet((Context)ctx, (String)id);
            if (bankTransSet.size() <= 0) continue;
            List idList = FMHelper.set2List((Set)bankTransSet);
            BankTransUpBillInfo bankInfo = BankTransUpBillFactory.getLocalInstance((Context)ctx).getBankTransUpBillInfo((IObjectPK)new ObjectUuidPK((String)idList.get(0)));
            for (int i = 0; i < colls.size(); ++i) {
                AutoTransHistoryInfo autoInfo = colls.get(i);
                for (int k = 0; k < bankInfo.getEntrys().size(); ++k) {
                    if (!bankInfo.getEntrys().get(k).getSrcBillNumber().equals(autoInfo.getSourceBillId())) continue;
                    autoInfo.setIsSuccess(bankInfo.getEntrys().get(k).getState());
                    autoInfo.setDescription(bankInfo.getEntrys().get(k).getBankReturnInfo());
                    AutoTransHistoryFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(autoInfo.getId()), (CoreBaseInfo)autoInfo);
                }
            }
        }
    }

    public Map getPayValidIdMapByAction(Context ctx, Set idSet, int action) throws BOSException, EASBizException {
        TransUpBillCollection coll = TransUpBillHelper.getTransUpBillColl(ctx, idSet);
        Map map = new HashMap();
        switch (action) {
            case 41: {
                map = this.getTransUpValidIdMapByCommitBE(ctx, coll);
            }
        }
        return map;
    }

    private Map getTransUpValidIdMapByCommitBE(Context ctx, TransUpBillCollection coll) throws EASBizException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        HashSet<String> set = new HashSet<String>();
        String errorDetail = "";
        TransUpBillInfo info = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            info = coll.get(i);
            boolean entryValid = true;
            String tmpMsg = "";
            if (info.getState().equals((Object)TransUpBillStateEnum.AUDITED)) {
                for (int j = 0; j < info.getEntrys().size(); ++j) {
                    TransUpBillEntryInfo entryInfo = info.getEntrys().get(j);
                    try {
                        if (entryInfo.getUnitAcctBank().isIsOnlyRead()) {
                            throw new BEException(BEException.ACCOUNTBANKONLYREAD, new Object[]{entryInfo.getUnitAcctBank().getName()});
                        }
                    }
                    catch (Exception e) {
                        String msg = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"407_theEntry"), e.getMessage());
                        tmpMsg = tmpMsg + msg;
                        continue;
                    }
                    if (info.getState().equals((Object)TransUpBillStateEnum.AUDITED) && entryInfo.getUnitAcctBank() != null && entryInfo.getUnitAcctBank().isIsSetBankInterface() && !entryInfo.getUnitAcctBank().isIsOnlyRead()) continue;
                    entryValid = false;
                    String msg = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"408_theEntryHasnotBe"), entryInfo.getUnit().getName(), entryInfo.getUnitAcctBank().getName());
                }
                if (entryValid) {
                    set.add(info.getId().toString());
                }
            } else {
                errorDetail = errorDetail + MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"409_transDownNotBe"), info.getNumber());
            }
            if (tmpMsg.length() <= 1) continue;
            errorDetail = errorDetail + MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"410_theTransDown"), info.getNumber() + "\uff1a" + tmpMsg + "\n");
        }
        map.put("errorDetail", errorDetail);
        map.put("validSet", set);
        return map;
    }
}

