/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.fs.InnerAccountInfo;
import com.kingdee.eas.fm.fs.client.FSClientHelper;
import com.kingdee.eas.fm.fs.client.SettleLedgerFilterParam;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import java.util.Date;
import java.util.Locale;

public abstract class AbstractSettleLedgerHandler {
    protected static final String COL_outterInSettlementAmount = "outterInSettlementAmount";
    protected static final String COL_outterInSettlementMoney = "outterInSettlementMoney";
    protected static final String COL_outeroutSettlementAmount = "outeroutSettlementAmount";
    protected static final String COL_outeroutSettlementMoney = "outeroutSettlementMoney";
    protected static final String COL_innerInSettlementAmount = "innerInSettlementAmount";
    protected static final String COL_innerInSettlementMoney = "innerInSettlementMoney";
    protected static final String COL_innerOutSettlementAmount = "innerOutSettlementAmount";
    protected static final String COL_innerOutSettlementMoney = "innerOutSettlementMoney";
    protected final String COL_SETTLEMENTMONEY = "settlementMoney";
    protected final String COL_SETTLEMENTAMOUNT = "settlementAmount";
    protected final String COL_CURRENCY = "currency";
    protected final String COL_PROJECT = "Project";
    protected final String COL_APPLYUNIT = "APPLYUNIT";
    protected String resourcePath = "com.kingdee.eas.fm.fs.client.SettleLedgerResource";
    protected String loc;

    protected String getCurrencyName(String currencyID) throws Exception {
        CurrencyInfo currencyInfo = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyID));
        return currencyInfo.getName();
    }

    protected void setNumberFormat(IRow row, String columnKey, String currencyID) {
        String numberFormat = currencyID == null ? "%r-[ ]{###,###,##0.00}15.2n" : FMClientHelper.getNumberFtm((BOSUuid)BOSUuid.read((String)currencyID));
        row.getCell(columnKey).getStyleAttributes().setNumberFormat(numberFormat);
    }

    protected IRowSet getRowSet(IMetaDataPK mainQueryPK, EntityViewInfo evi) {
        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)mainQueryPK);
        exec.setObjectView(evi);
        IRowSet rowSet = null;
        try {
            rowSet = exec.executeQuery();
        }
        catch (BOSException e) {
            SysUtil.abort();
        }
        return rowSet;
    }

    protected IRowSet getInitRowSet(String currencyId, Object condition) throws BOSException {
        InnerAccountInfo acctInfo = null;
        CompanyOrgUnitInfo companyInfo = null;
        StringBuffer sqlBuf = new StringBuffer(8);
        this.loc = LocaleUtils.getLocaleString((Locale)SysContext.getSysContext().getLocale());
        sqlBuf.append("select sum(isnull(a.FDebitCounts,0)+isnull(a.FCreditCounts,0)) as settAmt, ");
        sqlBuf.append(" sum(isnull(a.FDebitTotal,0)+isnull(a.FCreditTotal,0)) as moneyAmt, ");
        sqlBuf.append("year(a.FBizDate) as fyear,month(a.FBizDate) as fmonth,");
        sqlBuf.append(" b.FName_").append(this.loc).append("  as currencyName, b.fid as currencyId ");
        sqlBuf.append(" from t_fs_summaryLedger a ");
        sqlBuf.append("INNER JOIN T_BD_Currency AS b  on a.FCurrencyID = b.FID");
        if (condition instanceof InnerAccountInfo) {
            acctInfo = (InnerAccountInfo)condition;
            sqlBuf.append("  where FInnerAccountId='");
            sqlBuf.append(acctInfo.getId().toString());
        } else {
            companyInfo = (CompanyOrgUnitInfo)condition;
            sqlBuf.append("  where FCompanyId='");
            sqlBuf.append(companyInfo.getId().toString());
        }
        sqlBuf.append("' and a.FBizDate<{");
        sqlBuf.append(this.getOpenDate());
        sqlBuf.append("}");
        if (currencyId != null) {
            sqlBuf.append(" and a.FCurrencyId='");
            sqlBuf.append(currencyId);
            sqlBuf.append("'");
        }
        sqlBuf.append("'");
        sqlBuf.append(" group by year(a.FBizDate),month(a.FBizDate),b.FName_").append(this.loc).append(" ,b.fid  ");
        ISQLExecutor sqlExe = SQLExecutorFactory.getRemoteInstance((String)sqlBuf.toString());
        IRowSet rs = sqlExe.executeSQL();
        return rs;
    }

    protected Date getOpenDate() {
        Date openDate = null;
        try {
            openDate = FSClientHelper.getClearingHouse().getOpenDate();
        }
        catch (Exception e) {
            SysUtil.abort((Throwable)e);
        }
        return openDate;
    }

    public abstract void initTree(KDTree var1, SettleLedgerFilterParam var2) throws BOSException, EASBizException;

    public void initTable(KDTable tblMain, SettleLedgerFilterParam param) throws BOSException {
        String column_project = EASResource.getString((String)"com.kingdee.eas.fm.fs.client.SummaryLedgerResource", (String)"Project");
        String column_applyUnit = EASResource.getString((String)"com.kingdee.eas.fm.fs.client.SummaryLedgerResource", (String)"APPLYUNIT");
        String column_currency = EASResource.getString((String)this.resourcePath, (String)"Currency");
        String column_settlementAmount = EASResource.getString((String)this.resourcePath, (String)"SettlementAmount");
        String column_settlementMoney = EASResource.getString((String)this.resourcePath, (String)"SettlementMoney");
        String column_outterInSettlementAmount = EASResource.getString((String)this.resourcePath, (String)COL_outterInSettlementAmount);
        String column_outterInSettlementMoney = EASResource.getString((String)this.resourcePath, (String)COL_outterInSettlementMoney);
        String column_outeroutSettlementAmount = EASResource.getString((String)this.resourcePath, (String)COL_outeroutSettlementAmount);
        String column_outeroutSettlementMoney = EASResource.getString((String)this.resourcePath, (String)COL_outeroutSettlementMoney);
        String column_innerInSettlementAmount = EASResource.getString((String)this.resourcePath, (String)COL_innerInSettlementAmount);
        String column_innerInSettlementMoney = EASResource.getString((String)this.resourcePath, (String)COL_innerInSettlementMoney);
        String column_innerOutSettlementAmount = EASResource.getString((String)this.resourcePath, (String)COL_innerOutSettlementAmount);
        String column_innerOutSettlementMoney = EASResource.getString((String)this.resourcePath, (String)COL_innerOutSettlementMoney);
        tblMain.checkParsed();
        IRow headRow = tblMain.addHeadRow();
        tblMain.addColumn().setKey("APPLYUNIT");
        tblMain.addColumn().setKey("Project");
        tblMain.addColumn().setKey("currency");
        tblMain.addColumn().setKey("settlementAmount");
        tblMain.getColumn("settlementAmount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        tblMain.addColumn().setKey("settlementMoney");
        tblMain.getColumn("settlementMoney").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        tblMain.addColumn().setKey(COL_outterInSettlementAmount);
        tblMain.getColumn(COL_outterInSettlementAmount).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        tblMain.addColumn().setKey(COL_outterInSettlementMoney);
        tblMain.getColumn(COL_outterInSettlementMoney).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        tblMain.addColumn().setKey(COL_outeroutSettlementAmount);
        tblMain.getColumn(COL_outeroutSettlementAmount).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        tblMain.addColumn().setKey(COL_outeroutSettlementMoney);
        tblMain.getColumn(COL_outeroutSettlementMoney).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        tblMain.addColumn().setKey(COL_innerInSettlementAmount);
        tblMain.getColumn(COL_innerInSettlementAmount).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        tblMain.addColumn().setKey(COL_innerInSettlementMoney);
        tblMain.getColumn(COL_innerInSettlementMoney).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        tblMain.addColumn().setKey(COL_innerOutSettlementAmount);
        tblMain.getColumn(COL_innerOutSettlementAmount).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        tblMain.addColumn().setKey(COL_innerOutSettlementMoney);
        tblMain.getColumn(COL_innerOutSettlementMoney).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        headRow.getCell("APPLYUNIT").setValue((Object)column_applyUnit);
        headRow.getCell("Project").setValue((Object)column_project);
        headRow.getCell("currency").setValue((Object)column_currency);
        headRow.getCell("settlementAmount").setValue((Object)column_settlementAmount);
        headRow.getCell("settlementMoney").setValue((Object)column_settlementMoney);
        headRow.getCell(COL_outterInSettlementAmount).setValue((Object)column_outterInSettlementAmount);
        headRow.getCell(COL_outterInSettlementMoney).setValue((Object)column_outterInSettlementMoney);
        headRow.getCell(COL_outeroutSettlementAmount).setValue((Object)column_outeroutSettlementAmount);
        headRow.getCell(COL_outeroutSettlementMoney).setValue((Object)column_outeroutSettlementMoney);
        headRow.getCell(COL_innerInSettlementAmount).setValue((Object)column_innerInSettlementAmount);
        headRow.getCell(COL_innerInSettlementMoney).setValue((Object)column_innerInSettlementMoney);
        headRow.getCell(COL_innerOutSettlementAmount).setValue((Object)column_innerOutSettlementAmount);
        headRow.getCell(COL_innerOutSettlementMoney).setValue((Object)column_innerOutSettlementMoney);
    }

    public abstract void fillData(KDTable var1, SettleLedgerFilterParam var2, Object var3, EntityViewInfo var4, IMetaDataPK var5) throws Exception;
}

