/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.IRptHandler;
import com.kingdee.eas.fm.fs.SummaryLedgerEnum;
import com.kingdee.eas.fm.fs.client.FSClientHelper;
import com.kingdee.eas.fm.fs.client.SummaryLedgerFilterParam;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public abstract class AbstractSummaryLedgerHandler
implements IRptHandler {
    protected final String COL_TOTAL = "Total";
    protected final String COL_APPLYUNIT = "APPLYUNIT";
    protected final String COL_PROJECT = "Project";
    protected final String COL_CURRENCY = "currency";
    protected final String COL_ITEM = "item";
    protected final String BEGINBALANCE_DC = "beginBalanceDc";
    protected final String BEGINBALANCE = "beginBalance";
    protected final String DEBITAMOUNT = "debitAmount";
    protected final String CREDITAMOUNT = "creditAmount";
    protected final String ENDBALANCE_DC = "endBalanceDc";
    protected final String ENDBALANCE = "endBalance";
    protected String resourcePath = "com.kingdee.eas.fm.fs.client.SummaryLedgerResource";

    public abstract void initTree(SummaryLedgerFilterParam var1, KDTree var2) throws BOSException, EASBizException;

    public void initTable(SummaryLedgerFilterParam param, KDTable tblMain) throws BOSException {
        String column_applyUnit = EASResource.getString((String)this.resourcePath, (String)"APPLYUNIT");
        String column_project = EASResource.getString((String)this.resourcePath, (String)"Project");
        tblMain.checkParsed();
        IRow headRow = tblMain.addHeadRow();
        tblMain.addColumn().setKey("APPLYUNIT");
        tblMain.addColumn().setKey("Project");
        tblMain.addColumn().setKey("beginBalanceDc");
        tblMain.addColumn().setKey("beginBalance");
        tblMain.addColumn().setKey("debitAmount");
        tblMain.addColumn().setKey("creditAmount");
        tblMain.addColumn().setKey("endBalanceDc");
        tblMain.addColumn().setKey("endBalance");
        headRow.getCell("APPLYUNIT").setValue((Object)column_applyUnit);
        headRow.getCell("Project").setValue((Object)column_project);
        tblMain.getColumn("Project").setWidth(150);
        String dcDirection = EASResource.getString((String)this.resourcePath, (String)"DcDirection");
        headRow.getCell("beginBalanceDc").setValue((Object)dcDirection);
        headRow.getCell("beginBalance").setValue((Object)SummaryLedgerEnum.BEGINBALANCE.getAlias());
        headRow.getCell("debitAmount").setValue((Object)SummaryLedgerEnum.CREDITAMOUNT.getAlias());
        headRow.getCell("creditAmount").setValue((Object)SummaryLedgerEnum.DEBITAMOUNT.getAlias());
        headRow.getCell("endBalanceDc").setValue((Object)dcDirection);
        headRow.getCell("endBalance").setValue((Object)SummaryLedgerEnum.ENDBALANCE.getAlias());
    }

    public abstract void fillData(KDTable var1, SummaryLedgerFilterParam var2, Object var3, EntityViewInfo var4, String var5) throws Exception;

    public void fillData(KDTable tblMain, SummaryLedgerFilterParam param, String acctNumber, EntityViewInfo mainQuery, String currencyNumber) throws Exception {
    }

    protected void setCurrencyFormat(KDTable tblMain, BOSUuid currencyId) {
        if (currencyId == null) {
            return;
        }
        String numberFtm = FMClientHelper.getNumberFtm((BOSUuid)currencyId);
        for (int i = 2; i < tblMain.getColumnCount(); ++i) {
            tblMain.getColumn(i).getStyleAttributes().setNumberFormat(numberFtm);
            tblMain.getColumn(i).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        }
        tblMain.getColumn("beginBalanceDc").setWidth(50);
        tblMain.getColumn("endBalanceDc").setWidth(50);
        tblMain.getColumn("beginBalanceDc").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.LEFT);
        tblMain.getColumn("endBalanceDc").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.LEFT);
    }

    protected Date adjustDate(Date date) {
        BankInfo clearingHouse = null;
        try {
            clearingHouse = FSClientHelper.getClearingHouse();
            Date openDate = clearingHouse.getOpenDate();
            Date settDate = clearingHouse.getSettleDate();
            if (date.before(openDate)) {
                return openDate;
            }
        }
        catch (Exception e) {
            SysUtil.abort((Throwable)e);
        }
        return date;
    }

    protected Calendar adjustBeginDate(int beginYear, int beginMonth) {
        BankInfo clearingHouse = null;
        GregorianCalendar begincal = new GregorianCalendar(beginYear, beginMonth, 1);
        Date beginDate = begincal.getTime();
        try {
            clearingHouse = FSClientHelper.getClearingHouse();
            Date openDate = clearingHouse.getOpenDate();
            if (beginDate.before(openDate)) {
                begincal.setTime(openDate);
            }
        }
        catch (Exception e) {
            SysUtil.abort((Throwable)e);
        }
        return begincal;
    }
}

