/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.client;

import com.kingdee.bos.ctrl.swing.BasicFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.cas.client.ClientUtils;
import com.kingdee.eas.fm.bond.BondClientUtil;
import com.kingdee.eas.fm.bond.BondUtil;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.common.util.FMBillBigDecimalUtil;
import com.kingdee.eas.fm.fin.FinUtils;
import com.kingdee.eas.fm.fs.FsF7Util;
import com.kingdee.eas.fm.fs.client.AbstractApplyTransBillBaseEditUI;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Locale;
import org.apache.log4j.Logger;

public abstract class ApplyTransBillBaseEditUI
extends AbstractApplyTransBillBaseEditUI {
    private static final Logger logger = CoreUIObject.getLogger(ApplyTransBillBaseEditUI.class);
    protected CurrencyInfo currentCurrency;
    private static boolean TM116 = true;

    public ApplyTransBillBaseEditUI() throws Exception {
        this.setPreferredSize(new Dimension(680, 500));
        this.currentCurrency = BondUtil.initCurrentCurrency((CompanyOrgUnitInfo)this.currentCompany);
    }

    public void onLoad() throws Exception {
        try {
            TM116 = ContextHelperFactory.getRemoteInstance().getBooleanParam("TM116", (IObjectPK)new ObjectUuidPK(this.currentCompany.getId()));
        }
        catch (Exception e) {
            TM116 = true;
            e.printStackTrace();
        }
        if (!this.getOprtState().equals("FINDVIEW")) {
            ClientUtils.checkCompany((Component)((Object)this), (CompanyOrgUnitInfo)this.currentCompany);
        }
        this.initializeHeaders();
        this.pkBizDate.setSupportedEmpty(false);
        this.pkplanTransDate.setSupportedEmpty(false);
        super.onLoad();
        this.resetActionStatus();
    }

    private void initializeHeaders() throws Exception {
        this.initF7Control();
        this.initUIFormat();
    }

    protected void initF7Control() throws Exception {
        FinUtils.initCurrencyComboBox((KDComboBox)this.cbbCurrency);
        FsF7Util.setPayAccountBankF7(this.prmtaccountBank, this.currentCompany, (CurrencyInfo)this.cbbCurrency.getSelectedItem());
    }

    protected void initUIFormat() {
        CurrencyInfo currency = (CurrencyInfo)this.cbbCurrency.getSelectedItem();
        if (currency != null) {
            BondClientUtil.numberControlFormat((KDFormattedTextField)this.txtamount, (int)currency.getPrecision());
            try {
                int precOfExRate = FMClientHelper.getPrecOfExRate((String)this.currentCompany.getId().toString(), (String)currency.getId().toString(), null, (Date)new Date());
                BondClientUtil.numberControlFormat((KDFormattedTextField)this.txtLocalCurExRate, (int)precOfExRate);
            }
            catch (Exception e1) {
                this.handUIExceptionAndAbort(e1);
            }
        }
        BondClientUtil.numberControlFormat((KDFormattedTextField)this.txtAmountLocalCur, (int)this.currentCurrency.getPrecision());
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void setDataObject(IObjectValue dataObject) {
        super.setDataObject(dataObject);
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        FMClientVerifyHelper.verifyRequire((CoreUIObject)this);
        BondClientUtil.verifyGtZero((CoreUIObject)this, (KDFormattedTextField)this.txtamount);
        BondClientUtil.verifyGtZero((CoreUIObject)this, (KDFormattedTextField)this.txtLocalCurExRate);
        super.verifyInput(e);
    }

    protected void initDataStatus() {
        super.initDataStatus();
    }

    protected void initCommonOprtStatus() {
    }

    protected void initAddNewStatus() {
    }

    protected void initEditStatus() {
    }

    protected void initViewStatus() {
    }

    protected void initFindViewStatus() {
    }

    protected void initOtherOprtStatus() {
    }

    protected void initBillStatus() {
    }

    protected void initWorkButton() {
        super.initWorkButton();
    }

    protected void resetActionStatus() {
        this.actionAddNew.setVisible(false);
        this.actionEdit.setVisible(false);
        this.actionRemove.setVisible(false);
        this.actionCopy.setVisible(false);
        this.actionCopyFrom.setVisible(false);
        this.actionCancelCancel.setVisible(false);
        this.actionCancel.setVisible(false);
        this.actionFirst.setVisible(false);
        this.actionLast.setVisible(false);
        this.actionPre.setVisible(false);
        this.actionNext.setVisible(false);
        this.actionTraceUp.setVisible(false);
        this.actionTraceDown.setVisible(false);
        this.actionPrint.setVisible(false);
        this.actionPrintPreview.setVisible(false);
        this.actionAddLine.setVisible(false);
        this.actionInsertLine.setVisible(false);
        this.actionRemoveLine.setVisible(false);
        this.actionCreateTo.setVisible(false);
        this.actionCreateFrom.setVisible(false);
        this.actionViewBdgBalance.setVisible(true);
        this.actionViewBdgBalance.setEnabled(true);
    }

    public boolean useScrollPane() {
        return true;
    }

    public int getVerticalScrollPolicy() {
        return 20;
    }

    public int getHorizontalScrollPolicy() {
        return 30;
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
    }

    @Override
    protected void prmtaccountBank_willShow(SelectorEvent e) throws Exception {
        FsF7Util.setPayAccountBankF7(this.prmtaccountBank, this.currentCompany, (CurrencyInfo)this.cbbCurrency.getSelectedItem());
    }

    @Override
    protected void prmtaccountBank_dataChanged(DataChangeEvent e) throws Exception {
        AccountBankInfo subAccountBank;
        if (this.prmtaccountBank.getValue() == null) {
            this.prmtsubAccountBank.setValue(null);
            this.prmttransCompany.setValue(null);
            SysUtil.abort();
        }
        BOSUuid accountBankId = ((AccountBankInfo)this.prmtaccountBank.getValue()).getId();
        AccountBankInfo accountBankInfo = AccountBankFactory.getRemoteInstance().getAccountBankInfo((IObjectPK)new ObjectUuidPK(accountBankId), this.getAccountBankSelector());
        if (accountBankInfo.getSubAccount() != null && (subAccountBank = accountBankInfo.getSubAccount()) != null) {
            this.prmtsubAccountBank.setValue((Object)subAccountBank);
            if (!TM116 && !this.getOprtState().equals(OprtState.VIEW)) {
                this.prmtsubAccountBank.setEnabled(true);
                this.prmtsubAccountBank.setEditable(true);
                this.prmtsubAccountBank.setRequired(true);
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("isClosed", (Object)new Integer(0)));
                filterInfo.getFilterItems().add(new FilterItemInfo("isMotherAccount", (Object)new Integer(1)));
                filterInfo.getFilterItems().add(new FilterItemInfo("company.id", (Object)subAccountBank.getCompany().getId().toString()));
                EntityViewInfo evi = new EntityViewInfo();
                evi.setFilter(filterInfo);
                this.prmtsubAccountBank.setEntityViewInfo(evi);
            }
            this.prmttransCompany.setValue((Object)subAccountBank.getCompany());
        }
    }

    @Override
    protected void prmtsubAccountBank_dataChanged(DataChangeEvent e) throws Exception {
        if (this.prmtsubAccountBank.getValue() == null) {
            this.prmttransCompany.setValue(null);
            SysUtil.abort();
        }
        BOSUuid subAccountBankId = ((AccountBankInfo)this.prmtsubAccountBank.getValue()).getId();
        AccountBankInfo subAccountBankInfo = AccountBankFactory.getRemoteInstance().getAccountBankInfo((IObjectPK)new ObjectUuidPK(subAccountBankId), this.getAccountBankSelector());
        if (subAccountBankInfo != null) {
            this.prmttransCompany.setValue((Object)subAccountBankInfo.getCompany());
        }
    }

    private SelectorItemCollection getAccountBankSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("bankAccountNumber"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("subAccount.id"));
        sic.add(new SelectorItemInfo("subAccount.name"));
        sic.add(new SelectorItemInfo("subAccount.number"));
        sic.add(new SelectorItemInfo("subAccount.bankAccountNumber"));
        sic.add(new SelectorItemInfo("subAccount.company.id"));
        sic.add(new SelectorItemInfo("subAccount.company.name"));
        sic.add(new SelectorItemInfo("subAccount.company.number"));
        return sic;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("project.*"));
        sic.add(new SelectorItemInfo("feeType.*"));
        sic.add(new SelectorItemInfo("accountBank.*"));
        sic.add(new SelectorItemInfo("accountBank.subAccount.*"));
        sic.add(new SelectorItemInfo("accountBank.subAccount.accountBank.*"));
        sic.add(new SelectorItemInfo("subAccountBank.*"));
        sic.add(new SelectorItemInfo("Currency.*"));
        sic.add(new SelectorItemInfo("company.*"));
        sic.add(new SelectorItemInfo("transCompany.*"));
        sic.add(new SelectorItemInfo("creator.*"));
        return sic;
    }

    @Override
    protected void cbbCurrency_itemStateChanged(ItemEvent event) throws Exception {
        CurrencyInfo currency = (CurrencyInfo)this.cbbCurrency.getSelectedItem();
        if (currency == null) {
            SysUtil.abort();
        }
        this.initUIFormat();
        try {
            FinUtils.initExchangeRate((BasicFormattedTextField)this.txtLocalCurExRate, (CompanyOrgUnitInfo)this.currentCompany, (CurrencyInfo)currency, (CurrencyInfo)this.currentCurrency, (Date)((Date)this.pkBizDate.getValue()));
        }
        catch (EASBizException e) {
            this.cbbCurrency.setSelectedItem(null);
            throw e;
        }
        this.txtLocalCurExRate.setEnabled(true);
        this.prmtaccountBank.setValue(null);
        this.prmtsubAccountBank.setValue(null);
        this.prmttransCompany.setValue(null);
    }

    @Override
    protected void pkBizDate_dataChanged(DataChangeEvent e) throws Exception {
        CurrencyInfo currency = (CurrencyInfo)this.cbbCurrency.getSelectedItem();
        if (currency == null) {
            SysUtil.abort();
        }
        FinUtils.initExchangeRate((BasicFormattedTextField)this.txtLocalCurExRate, (CompanyOrgUnitInfo)this.currentCompany, (CurrencyInfo)currency, (CurrencyInfo)this.currentCurrency, (Date)((Date)this.pkBizDate.getValue()));
    }

    @Override
    protected void txtamount_dataChanged(DataChangeEvent e) throws Exception {
        this.resetAmountLocalCurWithRate();
    }

    @Override
    protected void txtLocalCurExRate_dataChanged(DataChangeEvent e) throws Exception {
        this.resetAmountLocalCurWithRate();
    }

    private void resetAmountLocalCurWithRate() {
        FMClientHelper.setCutValue((KDFormattedTextField)this.txtAmountLocalCur, (Number)FMHelper.getLocalAmount((BigDecimal)this.txtamount.getBigDecimalValue(), (BigDecimal)this.txtLocalCurExRate.getBigDecimalValue()));
        if (FMBillBigDecimalUtil.eq((Object)this.txtAmountLocalCur.getBigDecimalValue(), (Object)FMBillBigDecimalUtil.MAX_VALUE)) {
            MsgBox.showInfo((String)ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"261_ApplyTransBillBaseEditUI", (Locale)SysContext.getSysContext().getLocale()));
            this.txtamount.setValue((Object)FMConstants.ZERO);
        }
    }
}

