/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fm.be.BEException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.DefaultExRatePrecProvider;
import com.kingdee.eas.fm.common.client.DefaultKDTCurrencyProvider;
import com.kingdee.eas.fm.common.client.DefaultKDTablePrecisionFormater;
import com.kingdee.eas.fm.common.client.DefaultLocalCurrencyPrecProvider;
import com.kingdee.eas.fm.common.client.DefaultTablePrecisionFormat;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.common.client.IKDTPrecisionProvider;
import com.kingdee.eas.fm.common.client.IKDTablePrecisionFormater;
import com.kingdee.eas.fm.common.client.ITablePrecisionFormat;
import com.kingdee.eas.fm.common.client.ITablePrecisionProvider;
import com.kingdee.eas.fm.fs.ApplyTransDownCollection;
import com.kingdee.eas.fm.fs.ApplyTransDownFactory;
import com.kingdee.eas.fm.fs.ApplyTransDownFilterViewContentEnum;
import com.kingdee.eas.fm.fs.ApplyTransDownInfo;
import com.kingdee.eas.fm.fs.ApplyTransDownStateEnum;
import com.kingdee.eas.fm.fs.IApplyTransDown;
import com.kingdee.eas.fm.fs.TransDownBillInfo;
import com.kingdee.eas.fm.fs.TransDownBillOverdraftChecker;
import com.kingdee.eas.fm.fs.client.AbstractApplyTransDownListUI;
import com.kingdee.eas.fm.fs.client.ApplyTransDownCommonDataProvider;
import com.kingdee.eas.fm.fs.client.ApplyTransDownEditUI;
import com.kingdee.eas.fm.fs.client.ApplyTransDownFilterUI;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class ApplyTransDownListUI
extends AbstractApplyTransDownListUI {
    private static final Logger logger = CoreUIObject.getLogger(ApplyTransDownListUI.class);
    protected ApplyTransDownFilterUI filterUI = null;
    private IKDTablePrecisionFormater currencyPrecisionFormater = new DefaultKDTablePrecisionFormater();
    private ITablePrecisionFormat ratePrecisionFormater = null;
    private ITablePrecisionFormat localCurrencyPrecisionFormater = null;

    public ApplyTransDownListUI() throws Exception {
        this.currencyPrecisionFormater.setPrecProvider((IKDTPrecisionProvider)new DefaultKDTCurrencyProvider("Currency.id"));
        this.ratePrecisionFormater = new DefaultTablePrecisionFormat();
        this.ratePrecisionFormater.setPrecProvider((ITablePrecisionProvider)new DefaultExRatePrecProvider("company.id", "Currency.id", "bizDate"));
        this.localCurrencyPrecisionFormater = new DefaultTablePrecisionFormat();
        this.localCurrencyPrecisionFormater.setPrecProvider((ITablePrecisionProvider)new DefaultLocalCurrencyPrecProvider("company.id"));
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.currencyPrecisionFormater.init(this.getMainTable(), new String[]{"amount"});
        this.ratePrecisionFormater.initFormat(this.getMainTable(), new String[]{"LocalCurExRate"});
        this.localCurrencyPrecisionFormater.initFormat(this.getMainTable(), new String[]{"AmountLocalCur"});
        String dformat = CtrlFormatUtilities.getDateTimeFormatString();
        this.tblMain.getColumn("planTransDate").getStyleAttributes().setNumberFormat(dformat);
        this.tblMain.getColumn("auditDate").getStyleAttributes().setNumberFormat(dformat);
        this.execQuery();
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return ApplyTransDownFactory.getRemoteInstance();
    }

    @Override
    protected String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UINewTabFactory";
    }

    @Override
    protected String getEditUIName() {
        return ApplyTransDownEditUI.class.getName();
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new ApplyTransDownFilterUI();
        }
        return this.filterUI;
    }

    @Override
    protected void setListUITable(KDTable tblMain, KDTDataRequestEvent e) {
        super.setListUITable(tblMain, e);
    }

    protected void execQuery() {
        FilterInfo extFilter = this.getFilter();
        if (extFilter != null && extFilter.getFilterItems().size() > 0) {
            try {
                this.mainQuery.getFilter().mergeFilter(extFilter, "AND");
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        }
        if (this.isIgnoreCUFilter()) {
            for (FilterItemInfo filterItem : this.mainQuery.getFilter().getFilterItems()) {
                if (!"company.id".equals(filterItem.getPropertyName())) continue;
                filterItem.setCompareType(CompareType.NOTEMPTY);
                filterItem.setCompareValue(null);
                break;
            }
        }
        super.execQuery();
    }

    protected boolean isIgnoreCUFilter() {
        if (this.filterUI != null && this.filterUI.cbbViewContent != null && this.filterUI.cbbViewContent.getSelectedItem() != null) {
            return !ApplyTransDownFilterViewContentEnum.APPLY_ORG.equals(this.filterUI.cbbViewContent.getSelectedItem());
        }
        return false;
    }

    private FilterInfo getFilter() {
        Map botpCtx = (Map)this.getUIContext().get("BTPEDITPARAMETER");
        if (botpCtx == null) {
            return null;
        }
        String targetBill = (String)botpCtx.get("TargetBill");
        String companyId = (String)botpCtx.get("companyId");
        if (targetBill == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"80_TransDetailListUI"));
            SysUtil.abort();
        }
        if (companyId == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"81_TransDetailListUI"));
            SysUtil.abort();
        }
        FilterInfo filter = new FilterInfo();
        if (targetBill != null && (targetBill.equals("TransUpBill") || targetBill.equals("TransDownBill"))) {
            filter.getFilterItems().add(new FilterItemInfo("state", (Object)new Integer(3)));
            filter.getFilterItems().add(new FilterItemInfo("transNumber", null, CompareType.IS));
            filter.getFilterItems().add(new FilterItemInfo("transCompany.id", (Object)this.currentCompany.getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("accountBank.subAccount.id", null, CompareType.ISNOT));
        }
        return filter;
    }

    public String[] getMergeColumnKeys() {
        return null;
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        String msg;
        ApplyTransDownInfo info = this.getSelectedInfo();
        if (!info.getCompany().getId().toString().equals(this.currentCompany.getId().toString())) {
            msg = EASResource.getString((String)"com.kingdee.eas.fm.fs.TransBillResource", (String)"notTransDownCompany");
            MsgBox.showInfo((Component)((Object)this), (String)msg);
            SysUtil.abort();
        }
        msg = ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"264_ApplyTransDownListUI", (Locale)SysContext.getSysContext().getLocale());
        this.checkState(ApplyTransDownStateEnum.AUDIT, msg, true);
        super.actionEdit_actionPerformed(e);
    }

    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkIsApplyCompany();
        super.actionRemove_actionPerformed(e);
    }

    @Override
    public void actionTDPrint_actionPerformed(ActionEvent e) throws Exception {
        this.tdPrint(false);
    }

    @Override
    public void actionTDPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.tdPrint(true);
    }

    private void tdPrint(boolean isPreview) {
        this.checkSelected();
        ArrayList idList = super.getSelectedIdValues();
        if (idList == null || idList.size() == 0) {
            return;
        }
        ApplyTransDownCommonDataProvider data = new ApplyTransDownCommonDataProvider(idList, this.getTDQueryPK());
        KDNoteHelper appHlp = new KDNoteHelper();
        if (isPreview) {
            appHlp.printPreview("/FM/TR/DOWN", (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        } else {
            appHlp.print("/FM/TR/DOWN", (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        }
    }

    protected IMetaDataPK getTDQueryPK() {
        return new MetaDataPK("com.kingdee.eas.fm.fs.app.ApplyTransDownTDQuery");
    }

    public void actionViewBdgBalance_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        FMClientHelper.viewBgBalance4ListUI((Component)((Object)this), (String)id);
    }

    private SelectorItemCollection getSelectorsForViewBdgBalance() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("creator.*"));
        sic.add(new SelectorItemInfo("auditor.*"));
        sic.add(new SelectorItemInfo("usePayableCo.*"));
        sic.add(new SelectorItemInfo("provideCoAccount.*"));
        sic.add(new SelectorItemInfo("payBank.*"));
        sic.add(new SelectorItemInfo("receiverSp.*"));
        sic.add(new SelectorItemInfo("receiveCoAccount.*"));
        sic.add(new SelectorItemInfo("applayCompany.*"));
        sic.add(new SelectorItemInfo("noteType.*"));
        sic.add(new SelectorItemInfo("provideCo.*"));
        sic.add(new SelectorItemInfo("Currency.*"));
        sic.add(new SelectorItemInfo("receiverCp.*"));
        sic.add(new SelectorItemInfo("receiveCoBank.*"));
        sic.add(new SelectorItemInfo("project.*"));
        sic.add(new SelectorItemInfo("company.*"));
        sic.add(new SelectorItemInfo("transCompany.*"));
        sic.add(new SelectorItemInfo("fundFlowItem.*"));
        sic.add(new SelectorItemInfo("mbgNumber"));
        sic.add(new SelectorItemInfo("mbgName"));
        return sic;
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        if (idList == null || idList.size() <= 0) {
            return;
        }
        HashSet idSet = new HashSet(idList);
        this.checkIsApplyCompany();
        boolean hasWfInstance = FMHelper.hasWFInstance(null, (List)idList);
        if (hasWfInstance) {
            this.actionMultiapprove_actionPerformed(e);
            return;
        }
        boolean tm108 = ContextHelperFactory.getRemoteInstance().getBooleanParam("TM108", (IObjectPK)new ObjectUuidPK(this.currentCompany.getId()));
        if (!tm108) {
            ((IApplyTransDown)this.getBizInterface()).audit(idSet);
        } else {
            ApplyTransDownCollection coll = this.getSelectedColl();
            ApplyTransDownInfo info = null;
            boolean allowAudit = true;
            StringBuffer message = new StringBuffer();
            for (int i = 0; i < coll.size(); ++i) {
                TransDownBillOverdraftChecker checker = new TransDownBillOverdraftChecker();
                info = coll.get(i);
                Map result = checker.checkApplyOverdraft((CoreUIObject)this, info);
                if (Boolean.parseBoolean(result.get("pass").toString())) continue;
                idSet.remove(info.getId().toString());
                message.append(result.get("message")).append("\n");
                if (!allowAudit) continue;
                allowAudit = false;
            }
            if (idList != null && idList.size() > 0) {
                ((IApplyTransDown)this.getBizInterface()).audit(idSet);
            }
            if (!allowAudit) {
                String error = EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"416_someAuditUnsuccess");
                MsgBox.showDetailAndOK((Component)((Object)this), (String)error, (String)message.toString(), (int)2);
            }
        }
        this.execQuery();
    }

    @Override
    public void actionCancelAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        if (idList == null || idList.size() <= 0) {
            return;
        }
        this.checkIsApplyCompany();
        HashSet idSet = new HashSet(idList);
        ((IApplyTransDown)this.getBizInterface()).cancelAudit(idSet);
        this.execQuery();
    }

    private void checkState(ApplyTransDownStateEnum state, String msg, boolean flag) throws Exception {
        ApplyTransDownInfo info = this.getSelectedInfo();
        if (info != null && state.equals((Object)info.getState()) == flag) {
            MsgBox.showInfo((Component)((Object)this), (String)msg);
            SysUtil.abort();
        }
    }

    private ApplyTransDownInfo getSelectedInfo() throws Exception {
        this.checkSelected();
        return ApplyTransDownFactory.getRemoteInstance().getApplyTransDownInfo((IObjectPK)new ObjectUuidPK(this.getSelectedKeyValue()));
    }

    private ApplyTransDownCollection getSelectedColl() throws BOSException {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        HashSet idSet = new HashSet(idList);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        return ApplyTransDownFactory.getRemoteInstance().getApplyTransDownCollection(view);
    }

    private void checkIsApplyCompany() throws BOSException {
        ApplyTransDownCollection coll = this.getSelectedColl();
        for (int i = 0; i < coll.size(); ++i) {
            ApplyTransDownInfo info = coll.get(i);
            if (info.getCompany().getId().toString().equals(this.currentCompany.getId().toString())) continue;
            String msg = EASResource.getString((String)"com.kingdee.eas.fm.fs.TransBillResource", (String)"notTransDownCompany");
            MsgBox.showInfo((Component)((Object)this), (String)msg);
            SysUtil.abort();
        }
    }

    public void beforeTransform(IObjectCollection srcObjCols, String destBillBosType) {
        if (srcObjCols == null) {
            return;
        }
        if (destBillBosType.equals(TransDownBillInfo.BOSTypeString()) || destBillBosType.equals(TransDownBillInfo.BOSTypeString()) && srcObjCols.size() > 0) {
            try {
                this.verifyBotpTransDownbill((CoreBillBaseCollection)srcObjCols);
            }
            catch (EASBizException e) {
                this.handUIExceptionAndAbort((Exception)((Object)e));
            }
        }
    }

    private void verifyBotpTransDownbill(CoreBillBaseCollection cols) throws EASBizException {
        if (FMHelper.isEmpty((AbstractObjectCollection)cols)) {
            return;
        }
        ApplyTransDownInfo lastInfo = (ApplyTransDownInfo)cols.get(0);
        int n = cols.size();
        for (int i = 1; i < n; ++i) {
            ApplyTransDownInfo info = (ApplyTransDownInfo)cols.get(i);
            if (!info.getSubAccountBank().equalsPK((IObjectValue)lastInfo.getSubAccountBank())) {
                throw new BEException(BEException.COMMON, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"265_ApplyTransDownListUI", (Locale)SysContext.getSysContext().getLocale())});
            }
            if (!info.getCurrency().equalsPK((IObjectValue)lastInfo.getCurrency())) {
                throw new BEException(BEException.COMMON, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"265_ApplyTransDownListUI", (Locale)SysContext.getSysContext().getLocale())});
            }
            lastInfo = info;
        }
    }
}

