/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.IContextHelper;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.fi.cas.BatchFetchParamFacadeFactory;
import com.kingdee.eas.fi.cas.CodingRuleMsgInfo;
import com.kingdee.eas.fi.cas.SettlementStatusEnum;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.fs.AutoMatchAcctFilterEntryInfo;
import com.kingdee.eas.fm.fs.AutoMatchAcctSettingEntryInfo;
import com.kingdee.eas.fm.fs.AutoMatchAcctSettingFactory;
import com.kingdee.eas.fm.fs.AutoMatchAcctSettingInfo;
import com.kingdee.eas.fm.fs.AutoMatchLeftBracket;
import com.kingdee.eas.fm.fs.AutoMatchLeftProperties;
import com.kingdee.eas.fm.fs.AutoMatchLogicChara;
import com.kingdee.eas.fm.fs.AutoMatchRightBracket;
import com.kingdee.eas.fm.fs.FSException;
import com.kingdee.eas.fm.fs.IAutoMatchAcctSetting;
import com.kingdee.eas.fm.fs.client.AbstractAutoMatchAcctSettingEditUI;
import com.kingdee.eas.fm.fs.client.AutoMatchAcctLinkPayBillListUI;
import com.kingdee.eas.fm.ss.SmartType;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.enums.EnumUtils;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.swing.JComboBox;
import org.apache.log4j.Logger;

public class AutoMatchAcctSettingEditUI
extends AbstractAutoMatchAcctSettingEditUI {
    private static final Logger logger = CoreUIObject.getLogger(AutoMatchAcctSettingEditUI.class);
    private CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
    private IContextHelper contextHelper = ContextHelperFactory.getRemoteInstance();
    private int selectedEntrys = 0;

    @Override
    public void storeFields() {
        long zero;
        long day;
        Date zeroTimeDay = this.pkStartDate.getSqlDate();
        if (!EmptyUtil.isEmpty((Object)zeroTimeDay)) {
            day = zeroTimeDay.getTime();
            zero = day / 86400000L * 86400000L - (long)TimeZone.getDefault().getRawOffset();
            zeroTimeDay = new Date(zero);
            this.editData.setStartDate(zeroTimeDay);
        }
        if (!EmptyUtil.isEmpty((Object)(zeroTimeDay = this.pkEndDate.getSqlDate()))) {
            day = zeroTimeDay.getTime();
            zero = day / 86400000L * 86400000L - (long)TimeZone.getDefault().getRawOffset();
            zeroTimeDay = new Date(zero);
            this.editData.setEndDate(zeroTimeDay);
        }
        super.storeFields();
        IRow row = null;
        Object cell = null;
        int count = this.kdtFilterEntrys.getRowCount();
        for (int rowIndex = 0; rowIndex < count; ++rowIndex) {
            row = this.kdtFilterEntrys.getRow(rowIndex);
            if (!EmptyUtil.isEmpty((Object)row.getCell("leftProperties").getValue()) && row.getCell("leftProperties").getValue().equals((Object)AutoMatchLeftProperties.settlementStatus)) {
                SettlementStatusEnum settleEnum = (SettlementStatusEnum)row.getCell("compareValue").getEditor().getValue();
                this.editData.getFilterEntrys().get(rowIndex).setCompareValue(String.valueOf(settleEnum.getValue()));
                continue;
            }
            if (EmptyUtil.isEmpty((Object)row.getCell("leftProperties").getValue()) || !row.getCell("leftProperties").getValue().equals((Object)AutoMatchLeftProperties.isSmart)) continue;
            SmartType smartType = (SmartType)row.getCell("compareValue").getEditor().getValue();
            this.editData.getFilterEntrys().get(rowIndex).setCompareValue(String.valueOf(smartType.getValue()));
        }
    }

    @Override
    public void loadFields() {
        int i;
        super.loadFields();
        this.initTxtNumber();
        this.actionCancelCancel.setEnabled(false);
        this.actionCancel.setEnabled(false);
        if (!this.getOprtState().equals(OprtState.ADDNEW)) {
            if (this.editData.isIsOn()) {
                this.actionCancelCancel.setEnabled(false);
                this.actionCancel.setEnabled(true);
                this.actionSave.setEnabled(false);
            } else {
                this.actionCancel.setEnabled(false);
                this.actionCancelCancel.setEnabled(true);
                this.actionSave.setEnabled(true);
            }
            if (this.getOprtState().equals(OprtState.VIEW)) {
                this.actionSave.setEnabled(false);
                this.actionCopy.setEnabled(true);
            }
        }
        int n = this.editData.getEntrys().size();
        for (i = 0; i < n; ++i) {
            AutoMatchAcctSettingEntryInfo info = this.editData.getEntrys().get(i);
            try {
                if (EmptyUtil.isEmpty((CoreBaseInfo)info.getAccountBank())) continue;
                BigDecimal amount = info.getPayRemainAmt(null);
                this.kdtEntrys.getCell(i, "payRemainAmt").setValue((Object)amount);
                if (this.kdtEntrys.getCell(i, "payLimitAmt").getValue().equals(amount)) continue;
                KDBizPromptBox promptBox = new KDBizPromptBox();
                promptBox.setEnabled(false);
                promptBox.setEditFormat("$number$;$name$;$bankAccountNumber$");
                promptBox.setDisplayFormat("$number$;$name$;$bankAccountNumber$");
                promptBox.setCommitFormat("$number$;$name$;$bankAccountNumber$");
                KDTDefaultCellEditor editor = new KDTDefaultCellEditor((IKDEditor)promptBox);
                this.kdtEntrys.getCell(i, "accountBank").setEditor((ICellEditor)editor);
                continue;
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        n = this.editData.getFilterEntrys().size();
        for (i = 0; i < n; ++i) {
            try {
                ICell cell = this.kdtFilterEntrys.getCell(i, "leftProperties");
                IRow row = this.kdtFilterEntrys.getRow(i);
                this.initComb(cell, row, true);
                continue;
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initTable();
        this.actionAuditResult.setVisible(false);
        this.actionAttachment.setVisible(false);
    }

    private void initTable() {
        this.kDSplitPane1.setOrientation(1);
        this.kDSplitPane1.setDividerLocation(this.getWidth() / 3 * 2);
    }

    protected void initDataStatus() {
        super.initDataStatus();
        this.actionCancel.setVisible(true);
        this.actionCancelCancel.setVisible(true);
        this.actionAuditResult.setVisible(false);
        this.actionAttachment.setVisible(false);
    }

    private void initTxtNumber() {
        String oprtS;
        CodingRuleMsgInfo codeRule = null;
        try {
            codeRule = BatchFetchParamFacadeFactory.getRemoteInstance().getCodingMsg(this.editData.getCompany().getId().toString(), (IObjectValue)new AutoMatchAcctSettingInfo());
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        boolean hasCodingRule = false;
        boolean isAddView = false;
        boolean isModifiable = false;
        if (codeRule != null) {
            hasCodingRule = codeRule.isExistCodingRule();
            isAddView = codeRule.isAddView();
            isModifiable = codeRule.isModifiable();
        }
        if (!(oprtS = this.getOprtState()).equals(OprtState.ADDNEW) && !oprtS.equals(OprtState.EDIT) || oprtS.equals(OprtState.ADDNEW) && hasCodingRule && (!isAddView || isAddView && !isModifiable) || oprtS.equals(OprtState.EDIT) && hasCodingRule && !isModifiable) {
            this.txtNumber.setEnabled(false);
        } else {
            this.txtNumber.setEnabled(true);
        }
        if (oprtS.equals(OprtState.ADDNEW) && EmptyUtil.isEmpty((String)this.editData.getNumber())) {
            FMClientHelper.initNumber((CoreBaseInfo)this.editData, (KDTextField)this.txtNumber, (String)this.editData.getCompany().getId().toString());
        }
    }

    protected IObjectValue createNewData() {
        AutoMatchAcctSettingInfo info = null;
        Map map = this.getUIContext();
        String actionCopy = (String)map.get("COPY");
        String id = null;
        if (map.get("ID") != null) {
            id = map.get("ID").toString();
        }
        if (actionCopy != null && id != null && actionCopy.equals("COPY")) {
            try {
                AutoMatchAcctSettingInfo oldInfo = (AutoMatchAcctSettingInfo)this.getValue((IObjectPK)new ObjectUuidPK(id));
                info = oldInfo.copy();
                info.setCreator(this.userinfo);
                info.setCreateTime(new Timestamp(System.currentTimeMillis()));
                map.remove("COPY");
            }
            catch (Exception e) {
                logger.error((Object)e);
                this.handUIException(e);
                SysUtil.abort();
            }
        } else {
            info = new AutoMatchAcctSettingInfo();
            info.setIsOn(true);
            info.setCreator(this.contextHelper.getCurrentUser());
            info.setStartDate(DateTimeUtils.truncateDate((Date)new Date()));
            info.setEndDate(DateTimeUtils.truncateDate((Date)new Date()));
            info.setCompany(this.contextHelper.getCurrentCompany());
            info.getEntrys().add(new AutoMatchAcctSettingEntryInfo());
            info.getFilterEntrys().add(new AutoMatchAcctFilterEntryInfo());
        }
        return info;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return AutoMatchAcctSettingFactory.getRemoteInstance();
    }

    protected KDTable getDetailTable() {
        if (this.selectedEntrys == 0) {
            return this.kdtFilterEntrys;
        }
        return this.kdtEntrys;
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        if (this.selectedEntrys == 0) {
            AutoMatchAcctFilterEntryInfo entryInfo = new AutoMatchAcctFilterEntryInfo();
            return entryInfo;
        }
        AutoMatchAcctSettingEntryInfo entryInfo = new AutoMatchAcctSettingEntryInfo();
        return entryInfo;
    }

    protected void initUIProp() throws Exception {
        super.initUIProp();
        this.kdtEntrys.checkParsed();
        this.kdtFilterEntrys.checkParsed();
        this.initHead();
        this.initFilterEntrys();
        this.initEntrys();
    }

    private void initHead() throws EASBizException, BOSException {
        this.prmtNoDefAcct.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7AccountBankQuery");
        this.setAcctBankEntityView(this.prmtNoDefAcct, this.currentCompany.getId().toString());
    }

    private void initFilterEntrys() {
        KDComboBox kdtFilterEntrys_leftBracket_cmb = new KDComboBox();
        kdtFilterEntrys_leftBracket_cmb.addItems(EnumUtils.getEnumList((String)"com.kingdee.eas.fm.fs.AutoMatchLeftBracket").toArray());
        KDTDefaultCellEditor kdtFilterEntrys_leftBracket_cellEditor = new KDTDefaultCellEditor((JComboBox)kdtFilterEntrys_leftBracket_cmb);
        this.kdtFilterEntrys.getColumn("leftBracket").setEditor((ICellEditor)kdtFilterEntrys_leftBracket_cellEditor);
        KDComboBox kdtFilterEntrys_leftProperties_cmb = new KDComboBox();
        kdtFilterEntrys_leftProperties_cmb.addItems(EnumUtils.getEnumList((String)"com.kingdee.eas.fm.fs.AutoMatchLeftProperties").toArray());
        KDTDefaultCellEditor kdtFilterEntrys_leftProperties_cellEditor = new KDTDefaultCellEditor((JComboBox)kdtFilterEntrys_leftProperties_cmb);
        this.kdtFilterEntrys.getColumn("leftProperties").setEditor((ICellEditor)kdtFilterEntrys_leftProperties_cellEditor);
        KDComboBox kdtFilterEntrys_compareChar_cmb = new KDComboBox();
        kdtFilterEntrys_compareChar_cmb.addItems(EnumUtils.getEnumList((String)"com.kingdee.eas.fm.fs.AutoMatchCompare").toArray());
        KDTDefaultCellEditor kdtFilterEntrys_compareChar_cellEditor = new KDTDefaultCellEditor((JComboBox)kdtFilterEntrys_compareChar_cmb);
        this.kdtFilterEntrys.getColumn("compareChar").setEditor((ICellEditor)kdtFilterEntrys_compareChar_cellEditor);
        KDComboBox kdtFilterEntrys_rightBracket_cmb = new KDComboBox();
        kdtFilterEntrys_rightBracket_cmb.addItems(EnumUtils.getEnumList((String)"com.kingdee.eas.fm.fs.AutoMatchRightBracket").toArray());
        KDTDefaultCellEditor kdtFilterEntrys_rightBracket_cellEditor = new KDTDefaultCellEditor((JComboBox)kdtFilterEntrys_rightBracket_cmb);
        this.kdtFilterEntrys.getColumn("rightBracket").setEditor((ICellEditor)kdtFilterEntrys_rightBracket_cellEditor);
        KDComboBox kdtFilterEntrys_logicChar_cmb = new KDComboBox();
        kdtFilterEntrys_logicChar_cmb.addItems(EnumUtils.getEnumList((String)"com.kingdee.eas.fm.fs.AutoMatchLogicChara").toArray());
        KDTDefaultCellEditor kdtFilterEntrys_logicChar_cellEditor = new KDTDefaultCellEditor((JComboBox)kdtFilterEntrys_logicChar_cmb);
        this.kdtFilterEntrys.getColumn("logicChar").setEditor((ICellEditor)kdtFilterEntrys_logicChar_cellEditor);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionCopy.putValue("SmallIcon", (Object)EASResource.getIcon((String)"imgTbtn_copy"));
    }

    private void initEntrys() throws EASBizException, BOSException {
        KDBizPromptBox kdtEntrys_acct_PromptBox = new KDBizPromptBox();
        kdtEntrys_acct_PromptBox.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7AccountBankQuery");
        this.setAcctBankEntityView(kdtEntrys_acct_PromptBox, this.currentCompany.getId().toString());
        kdtEntrys_acct_PromptBox.setVisible(true);
        kdtEntrys_acct_PromptBox.setEditable(true);
        kdtEntrys_acct_PromptBox.setDisplayFormat("$number$");
        kdtEntrys_acct_PromptBox.setEditFormat("$number$");
        kdtEntrys_acct_PromptBox.setCommitFormat("$number$");
        KDTDefaultCellEditor kdtEntrys_acct_CellEditor = new KDTDefaultCellEditor((IKDEditor)kdtEntrys_acct_PromptBox);
        this.kdtEntrys.getColumn("accountBank").setEditor((ICellEditor)kdtEntrys_acct_CellEditor);
        ObjectValueRender kdtEntrys_acct_OVR = new ObjectValueRender();
        kdtEntrys_acct_OVR.setFormat((IDataFormat)new BizDataFormat("$number$;$name$;$bankAccountNumber$"));
        this.kdtEntrys.getColumn("accountBank").setRenderer((IBasicRender)kdtEntrys_acct_OVR);
        CurrencyInfo currenyInfo = this.contextHelper.getCompanyBaseCurrency(this.contextHelper.getCurrentCompany());
        String currencyID = null;
        if (!EmptyUtil.isEmpty((CoreBaseInfo)currenyInfo)) {
            currencyID = currenyInfo.getId().toString();
        }
        FMClientHelper.setNumberFormat((KDTable)this.kdtEntrys, (String)"payLimitAmt", (String)currencyID);
        FMClientHelper.setNumberFormat((KDTable)this.kdtEntrys, (String)"payRemainAmt", (String)currencyID);
    }

    private void setAcctBankEntityView(KDBizPromptBox f7BankAcct, String companyId) throws EASBizException, BOSException {
        if (FMHelper.isEmpty((String)companyId)) {
            companyId = ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId().toString();
        }
        FilterInfo filter = new FilterInfo();
        BankInfo chInfo = BankFactory.getRemoteInstance().getClearingHouse(companyId);
        if (chInfo != null) {
            filter.getFilterItems().add(new FilterItemInfo("bank.id", (Object)chInfo.getId().toString(), CompareType.NOTEQUALS));
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId));
        }
        filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)new Integer(0)));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        f7BankAcct.setEntityViewInfo(view);
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("entrys.*"));
        sic.add(new SelectorItemInfo("filterEntrys.*"));
        return sic;
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        FMClientVerifyHelper.verifyUIControlEmpty((CoreUI)this);
        this.verifyHead();
        this.verifyEntryInput();
        this.verifyFilterEntryInput();
    }

    private void verifyHead() throws FSException {
        if (this.pkStartDate.getSqlDate().after(this.pkEndDate.getSqlDate())) {
            throw new FSException(FSException.BEGINLARGEREND);
        }
    }

    private void verifyEntryInput() throws FSException {
        FMClientVerifyHelper.verifyInput((CoreUIObject)this, (KDTable)this.kdtEntrys, (String)"accountBank");
        FMClientVerifyHelper.verifyInput((CoreUIObject)this, (KDTable)this.kdtEntrys, (String)"payLimitAmt");
        IRow row = null;
        AccountBankInfo info = null;
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        String key = null;
        if (this.kdtEntrys.getRowCount() <= 0) {
            throw new FSException(FSException.ACCTENTRYNOTNULL);
        }
        int count = this.kdtEntrys.getRowCount();
        for (int rowIndex = 0; rowIndex < count; ++rowIndex) {
            row = this.kdtEntrys.getRow(rowIndex);
            if (!(row.getCell("accountBank").getValue() instanceof AccountBankInfo)) continue;
            info = (AccountBankInfo)row.getCell("accountBank").getValue();
            key = info.getId().toString();
            if (map.containsKey(key)) {
                Object[] params = new Object[]{(Integer)map.get(key), new Integer(rowIndex + 1), info.getName()};
                throw new FSException(FSException.UNITACCOUNTBANK, params);
            }
            map.put(key, new Integer(rowIndex + 1));
        }
        if (!EmptyUtil.isEmpty((CoreBaseInfo)this.editData.getNoDefAcct()) && !map.containsKey(key = this.editData.getNoDefAcct().getId().toString())) {
            throw new FSException(FSException.NODEFACCTINENTRY);
        }
    }

    private void verifyFilterEntryInput() throws FSException {
        FMClientVerifyHelper.verifyInput((CoreUIObject)this, (KDTable)this.kdtFilterEntrys, (String)"leftProperties");
        FMClientVerifyHelper.verifyInput((CoreUIObject)this, (KDTable)this.kdtFilterEntrys, (String)"compareChar");
        IRow row = null;
        int leftBrackets = 0;
        int rightBrackets = 0;
        int count = this.kdtFilterEntrys.getRowCount();
        for (int rowIndex = 0; rowIndex < count; ++rowIndex) {
            row = this.kdtFilterEntrys.getRow(rowIndex);
            if (!EmptyUtil.isEmpty((Object)row.getCell("leftBracket").getValue())) {
                leftBrackets += ((AutoMatchLeftBracket)((Object)row.getCell("leftBracket").getValue())).getValue();
            }
            if (!EmptyUtil.isEmpty((Object)row.getCell("rightBracket").getValue())) {
                rightBrackets += ((AutoMatchRightBracket)((Object)row.getCell("rightBracket").getValue())).getValue();
            }
            if (rowIndex + 1 >= this.kdtFilterEntrys.getRowCount() || !EmptyUtil.isEmpty((Object)row.getCell("logicChar").getValue()) && !row.getCell("logicChar").getValue().equals((Object)AutoMatchLogicChara.NO_CHAR)) continue;
            throw new FSException(FSException.FILTERERROR);
        }
        if (leftBrackets != rightBrackets) {
            throw new FSException(FSException.BRACKETSERROR);
        }
        try {
            this.editData.getFilter();
        }
        catch (ParserException e) {
            e.printStackTrace();
            throw new FSException(FSException.FILTEREXCEPTION);
        }
    }

    @Override
    protected void kdtEntrys_editStopped(KDTEditEvent e) throws Exception {
        if (e.getOldValue() != null && e.getOldValue().equals(e.getValue())) {
            return;
        }
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        IRow row = this.kdtEntrys.getRow(rowIndex);
        ICell cell = this.kdtEntrys.getCell(rowIndex, colIndex);
        if (colIndex == this.kdtEntrys.getColumn("payLimitAmt").getColumnIndex()) {
            try {
                if (BigDecimal.valueOf(Double.parseDouble((String)row.getCell("payLimitAmt").getValue())).compareTo(BigDecimal.ZERO) >= 0) {
                    row.getCell("payRemainAmt").setValue(cell.getValue());
                } else {
                    row.getCell("payRemainAmt").setValue(null);
                    row.getCell("payLimitAmt").setValue(null);
                }
            }
            catch (Exception e1) {
                row.getCell("payRemainAmt").setValue(null);
                row.getCell("payLimitAmt").setValue(null);
            }
        }
    }

    @Override
    protected void kdtFilterEntrys_editStopped(KDTEditEvent e) throws Exception {
        if (e.getOldValue() != null && e.getOldValue().equals(e.getValue())) {
            return;
        }
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        IRow row = this.kdtFilterEntrys.getRow(rowIndex);
        ICell cell = this.kdtFilterEntrys.getCell(rowIndex, colIndex);
        if (colIndex == this.kdtFilterEntrys.getColumn("leftProperties").getColumnIndex()) {
            this.initComb(cell, row, false);
        }
    }

    private void initComb(ICell cell, IRow row, boolean flag) {
        String value = null;
        if (flag && !EmptyUtil.isEmpty((Object)row.getCell("compareValue").getValue())) {
            value = (String)row.getCell("compareValue").getValue();
        }
        if (!flag) {
            row.getCell("compareValue").setEditor(null);
            row.getCell("compareValue").setValue(null);
        }
        if (!EmptyUtil.isEmpty((Object)cell.getValue()) && cell.getValue().equals((Object)AutoMatchLeftProperties.settlementStatus)) {
            KDComboBox set = new KDComboBox();
            set.addItems(EnumUtils.getEnumList((String)"com.kingdee.eas.fi.cas.SettlementStatusEnum").toArray());
            if (value != null) {
                set.setSelectedItem((Object)SettlementStatusEnum.getEnum((int)Integer.parseInt(value)));
                row.getCell("compareValue").setValue((Object)SettlementStatusEnum.getEnum((int)Integer.parseInt(value)).getAlias());
            } else {
                row.getCell("compareValue").setValue(null);
            }
            KDTDefaultCellEditor set_cellEditor = new KDTDefaultCellEditor((JComboBox)set);
            row.getCell("compareValue").setEditor((ICellEditor)set_cellEditor);
        }
        if (!EmptyUtil.isEmpty((Object)cell.getValue()) && cell.getValue().equals((Object)AutoMatchLeftProperties.isSmart)) {
            KDComboBox isSmart = new KDComboBox();
            List enumList = EnumUtils.getEnumList((String)"com.kingdee.eas.fm.ss.SmartType");
            ArrayList newList = new ArrayList();
            for (int i = 0; i < enumList.size() - 1; ++i) {
                newList.add(enumList.get(i));
            }
            isSmart.addItems(newList.toArray());
            if (value != null) {
                isSmart.setSelectedItem((Object)SmartType.getEnum((int)Integer.parseInt(value)));
                row.getCell("compareValue").setValue((Object)SmartType.getEnum((int)Integer.parseInt(value)).getAlias());
            } else {
                row.getCell("compareValue").setValue(null);
            }
            KDTDefaultCellEditor isSmart_cellEditor = new KDTDefaultCellEditor((JComboBox)isSmart);
            row.getCell("compareValue").setEditor((ICellEditor)isSmart_cellEditor);
        }
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        HashSet<String> set = new HashSet<String>();
        set.add(this.editData.getId().toString());
        ((IAutoMatchAcctSetting)this.getBizInterface()).setIsOnStatus(set, false);
        this.actionCancel.setEnabled(false);
        this.actionCancelCancel.setEnabled(true);
        this.loadData();
        this.loadFields();
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        HashSet<String> set = new HashSet<String>();
        set.add(this.editData.getId().toString());
        ((IAutoMatchAcctSetting)this.getBizInterface()).setIsOnStatus(set, true);
        this.actionCancel.setEnabled(true);
        this.actionCancelCancel.setEnabled(false);
        this.setOprtState("VIEW");
        this.loadData();
        this.loadFields();
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        boolean state = this.editData.isIsOn();
        if (state) {
            throw new FSException(FSException.SETTINGNOTEDIT);
        }
        if (this.editData.isIsOn()) {
            this.actionCancelCancel.setEnabled(false);
            this.actionCancel.setEnabled(true);
        } else {
            this.actionCancel.setEnabled(false);
            this.actionCancelCancel.setEnabled(true);
        }
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        boolean state = this.editData.isIsOn();
        if (state) {
            throw new FSException(FSException.SETTINGNOTDEL);
        }
        super.actionRemove_actionPerformed(e);
    }

    @Override
    public void actionShowLinkPayBill_actionPerformed(ActionEvent e) throws Exception {
        if (!EmptyUtil.isEmpty((Object)this.editData.getId())) {
            AutoMatchAcctLinkPayBillListUI.showAutoMatchAcctLinkPayBillListUI((CoreUIObject)this, this.editData.getId().toString());
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.fs.FSResource", (String)"NO_LINK_BILL"));
        }
    }

    @Override
    protected void kdtFilterEntrys_tableClicked(KDTMouseEvent e) throws Exception {
        this.selectedEntrys = 0;
    }

    @Override
    protected void kdtEntrys_tableClicked(KDTMouseEvent e) throws Exception {
        this.selectedEntrys = 1;
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        this.checkModified();
        if (this.editData != null) {
            AutoMatchAcctSettingInfo newEditData = this.editData.copy();
            newEditData.setId(null);
            this.setNotCopyValues(newEditData);
            this.unLockUI();
            this.setOprtState("ADDNEW");
            this.setDataObject((IObjectValue)newEditData);
            this.loadFields();
            this.showCopyAddNew();
            this.actionCopy.setEnabled(false);
        }
    }

    private void setNotCopyValues(AutoMatchAcctSettingInfo info) {
        info.setNumber(null);
        info.setSourceBillId(null);
        info.setAuditor(null);
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionSave_actionPerformed(e);
        if (this.editData.isIsOn()) {
            this.setOprtState("VIEW");
            this.loadData();
            this.loadFields();
        }
    }
}

