/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.IContextHelper;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.fs.AutoMatchAcctSettingFactory;
import com.kingdee.eas.fm.fs.AutoMatchAcctSettingInfo;
import com.kingdee.eas.fm.fs.FSException;
import com.kingdee.eas.fm.fs.IAutoMatchAcctSetting;
import com.kingdee.eas.fm.fs.client.AbstractAutoMatchAcctSettingListUI;
import com.kingdee.eas.fm.fs.client.AutoMatchAcctLinkPayBillListUI;
import com.kingdee.eas.fm.fs.client.AutoMatchAcctSettingEditUI;
import com.kingdee.eas.fm.fs.client.FSClientHelper;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class AutoMatchAcctSettingListUI
extends AbstractAutoMatchAcctSettingListUI {
    private static final Logger logger = CoreUIObject.getLogger(AutoMatchAcctSettingListUI.class);
    private IContextHelper contextHelper = ContextHelperFactory.getRemoteInstance();

    public void onLoad() throws Exception {
        FSClientHelper.checkClearingHouseCompany();
        super.onLoad();
        this.actionAttachment.setVisible(false);
        this.actionAuditResult.setVisible(false);
        CurrencyInfo currenyInfo = this.contextHelper.getCompanyBaseCurrency(this.contextHelper.getCurrentCompany());
        String currencyID = null;
        if (!EmptyUtil.isEmpty((CoreBaseInfo)currenyInfo)) {
            currencyID = currenyInfo.getId().toString();
        }
        FMClientHelper.setNumberFormat((KDTable)this.tblMain, (String)"payLimitAmt", null);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionCopy.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_copy"));
    }

    protected String getEditUIName() {
        return AutoMatchAcctSettingEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return AutoMatchAcctSettingFactory.getRemoteInstance();
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        return null;
    }

    public String[] getMergeColumnKeys() {
        String[] list = new String[]{"name", "number", "id", "description", "startDate", "endDate", "isOn", "creator"};
        return list;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("isOn"));
        return sic;
    }

    protected void execQuery() {
        FilterInfo filter = new FilterInfo();
        CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)currentCompany.getId().toString()));
        SorterItemInfo sortInfo = new SorterItemInfo("number");
        sortInfo.setSortType(SortType.DESCEND);
        try {
            this.mainQuery.getFilter().mergeFilter(filter, "and");
            this.mainQuery.getSorter().add(sortInfo);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            SysUtil.abort((Throwable)e);
        }
        super.execQuery();
    }

    private void changeButtonStatus() throws EASBizException, BOSException, Exception {
        int rowNumber = FMClientHelper.getSelectedRow((KDTable)this.tblMain);
        if (rowNumber == -1) {
            return;
        }
        IRow row = this.tblMain.getRow(rowNumber);
        String id = row.getCell("id").getValue().toString();
        AutoMatchAcctSettingInfo info = ((IAutoMatchAcctSetting)this.getBizInterface()).getAutoMatchAcctSettingInfo((IObjectPK)new ObjectUuidPK(id));
        if (info.isIsOn()) {
            this.actionCancelCancel.setEnabled(false);
            this.actionCancel.setEnabled(true);
        } else {
            this.actionCancel.setEnabled(false);
            this.actionCancelCancel.setEnabled(true);
        }
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        super.tblMain_tableSelectChanged(e);
        this.changeButtonStatus();
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        boolean state;
        int i = this.tblMain.getSelectManager().getActiveRowIndex();
        if (i >= 0 && (state = Boolean.valueOf(this.tblMain.getRow(i).getCell("isOn").getValue().toString()).booleanValue())) {
            throw new FSException(FSException.SETTINGNOTEDIT);
        }
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        boolean state;
        int i = this.tblMain.getSelectManager().getActiveRowIndex();
        if (i >= 0 && (state = Boolean.valueOf(this.tblMain.getRow(i).getCell("isOn").getValue().toString()).booleanValue())) {
            throw new FSException(FSException.SETTINGNOTDEL);
        }
        super.actionRemove_actionPerformed(e);
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        ((IAutoMatchAcctSetting)this.getBizInterface()).setIsOnStatus(FMHelper.list2Set((List)idList), false);
        this.refresh(e);
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        ((IAutoMatchAcctSetting)this.getBizInterface()).setIsOnStatus(FMHelper.list2Set((List)idList), true);
        this.refresh(e);
    }

    @Override
    public void actionShowLinkPayBill_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        if (idList.size() > 0) {
            String id = idList.get(0).toString();
            AutoMatchAcctLinkPayBillListUI.showAutoMatchAcctLinkPayBillListUI((CoreUIObject)this, id);
        }
    }

    @Override
    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        AutoMatchAcctSettingInfo info = ((IAutoMatchAcctSetting)this.getBizInterface()).getAutoMatchAcctSettingInfo((IObjectPK)new ObjectUuidPK(id), sic);
        IPermission iPermission = PermissionFactory.getRemoteInstance();
        iPermission.checkFunctionPermission(this.getUserPk(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId().toString()), "FS_AUTO_01ADDNEW");
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)id);
        uiContext.put((Object)"COPY", (Object)"COPY");
        this.prepareUIContext(uiContext, e);
        uiContext.put((Object)"IDList", null);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(this.getEditUIName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
    }
}

