/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.fp.CycleRangeCollection;
import com.kingdee.eas.fm.fp.CycleRangeInfo;
import com.kingdee.eas.fm.fp.CycleTypeEnum;
import com.kingdee.eas.fm.fp.FPCycleIntervalEnum;
import com.kingdee.eas.fm.fp.FPHelper;
import com.kingdee.eas.fm.fs.AvgTypeEnum;
import com.kingdee.eas.fm.fs.IInAcct;
import com.kingdee.eas.fm.fs.InAcctFactory;
import com.kingdee.eas.fm.fs.client.AbstractAvgAnalysisHandler;
import com.kingdee.eas.fm.fs.client.AvgAnalysisFilterParam;
import com.kingdee.eas.fm.fs.client.FSClientHelper;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.sql.SQLException;

public class AvgAnalysisByCompanyHandler
extends AbstractAvgAnalysisHandler {
    private String resourcePath = "com.kingdee.eas.fm.fs.client.AvgAnalysisResource";

    @Override
    public void fillData(AvgAnalysisFilterParam param, Object condition, KDTable tblMain, EntityViewInfo mainQuery) throws EASBizException, BOSException, SQLException {
        CurrencyInfo currency;
        CycleTypeEnum cycleType;
        int beginYear = param.getBeginYear();
        int beginMonth = param.getBeginMonth() - 1;
        int endYear = param.getEndYear();
        int endMonth = param.getEndMonth() - 1;
        CompanyOrgUnitInfo company = null;
        if (condition instanceof OrgStructureInfo) {
            OrgStructureInfo structInfo = (OrgStructureInfo)condition;
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("name");
            sic.add("number");
            sic.add("accountTable.id");
            sic.add("accountTable.number");
            company = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(structInfo.getUnit().getId()), sic);
        }
        PeriodInfo periodInfo = null;
        if (company != null && company.getId() != null) {
            periodInfo = SystemStatusCtrolFactory.getRemoteInstance().getStartPeriod(SystemEnum.CASHMANAGEMENT.getValue(), company.getId().toString());
        }
        if (periodInfo == null) {
            MsgBox.showInfo((String)EASResource.getString((String)this.resourcePath, (String)"cashMustStart"));
            SysUtil.abort();
        }
        IInAcct inacct = InAcctFactory.getRemoteInstance();
        if (param.getAvgRptType() == 0) {
            cycleType = CycleTypeEnum.MONTH;
        } else if (param.getAvgRptType() == 1) {
            cycleType = CycleTypeEnum.QUARTER;
            beginMonth *= 3;
            endMonth *= 3;
        } else {
            cycleType = CycleTypeEnum.YEAR;
        }
        CycleRangeCollection coll = FPHelper.genCycleRanges((CycleTypeEnum)cycleType, (FPCycleIntervalEnum)FPCycleIntervalEnum.ONE, (int)beginYear, (int)beginMonth, (int)endYear, (int)endMonth);
        ICurrency iCurrency = CurrencyFactory.getRemoteInstance();
        CurrencyCollection currencyCollection = new CurrencyCollection();
        if (param.getCurrencyId() != null) {
            currency = iCurrency.getCurrencyInfo((IObjectPK)new ObjectUuidPK(param.getCurrencyId()));
            currencyCollection.add(currency);
        } else {
            currencyCollection = iCurrency.getCurrencyCollection(true);
        }
        int currencyColSize = currencyCollection.size();
        int CycleRangeColSize = coll.size();
        for (int i = 0; i < CycleRangeColSize; ++i) {
            CycleRangeInfo info = coll.get(i);
            for (int j = 0; j < currencyColSize; ++j) {
                currency = currencyCollection.get(j);
                this.fillEnumData(param, company, inacct, info, tblMain, currency, "period");
            }
        }
    }

    @Override
    public void initTable(AvgAnalysisFilterParam param, KDTable tblMain) throws BOSException {
        tblMain.checkParsed();
        FMClientHelper.clearTable((KDTable)tblMain);
        IRow headRow = tblMain.addHeadRow();
        tblMain.addColumn().setKey("period");
        tblMain.addColumn().setKey("currency");
        headRow.getCell("period").setValue((Object)EASResource.getString((String)this.resourcePath, (String)"Period"));
        headRow.getCell("currency").setValue((Object)EASResource.getString((String)this.resourcePath, (String)"Currency"));
        tblMain.addColumn().setKey(AvgTypeEnum.CASH.getName());
        headRow.getCell(AvgTypeEnum.CASH.getName()).setValue((Object)AvgTypeEnum.CASH.getAlias());
        tblMain.addColumn().setKey(AvgTypeEnum.DEPOSIT.getName());
        headRow.getCell(AvgTypeEnum.DEPOSIT.getName()).setValue((Object)AvgTypeEnum.DEPOSIT.getAlias());
    }

    @Override
    public void initTree(AvgAnalysisFilterParam param, KDTree treeList) throws BOSException {
        String[] companyIds = param.getCompanyIds();
        if (companyIds == null) {
            return;
        }
        CompanyOrgUnitCollection companyCol = null;
        companyCol = FMClientHelper.getCompanyOrgUnitCollection((String[])companyIds);
        int companyColSize = companyCol.size();
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode((Object)EASResource.getString((String)this.resourcePath, (String)"Company"));
        if (companyCol != null && companyCol.size() != 0) {
            FSClientHelper.fillCompanyTreeByCompany(treeList, companyCol);
        }
    }
}

