/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.NewCompanyF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.FMSysDefinedEnum;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.fs.AvgTypeEnum;
import com.kingdee.eas.fm.fs.client.AbstractAvgAnalysisFilterUI;
import com.kingdee.eas.fm.fs.client.AvgAnalysisFilterParam;
import com.kingdee.eas.fm.fs.client.FSClientHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.enums.IntEnum;
import java.awt.Component;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;

public class AvgAnalysisFilterUI
extends AbstractAvgAnalysisFilterUI {
    private static final int ORDER_BY_TYPE = 2;
    private static final int ORDER_BY_PERIOD = 1;
    private static final int ORDER_BY_COMPANY = 0;
    private static final int AVG_YEAR = 2;
    private static final int AVG_QUARTER = 1;
    private static final int AVG_MONTH = 0;
    private static final String resourcePath1 = "com.kingdee.eas.fm.fs.FSClientResource";
    private static final String resourcePath = "com.kingdee.eas.fm.fs.client.AvgAnalysisResource";
    private Map paramMap = new HashMap();

    public AvgAnalysisFilterUI(Map hm) throws Exception {
        this.paramMap = hm;
    }

    protected void init() throws Exception {
        if (this.paramMap.get("currencyCol") == null) {
            FMClientHelper.initCurrency((KDComboBox)this.cboCurrency);
        } else {
            FMClientHelper.initCurrency((KDComboBox)this.cboCurrency, (CurrencyCollection)((CurrencyCollection)this.paramMap.get("currencyCol")));
        }
        this.cboCurrency.addItem((Object)FMSysDefinedEnum.SELECT_ALL);
        super.init();
        FMClientHelper.manageAccountLevelRange((KDSpinner)this.spiFromYear, (KDSpinner)this.spiToYear, (KDSpinner)this.spiFromMonth, (KDSpinner)this.spiToMonth);
    }

    protected NewCompanyF7 getNewCompanyF7() {
        if (FSClientHelper.isCHUser()) {
            try {
                return super.getAllCompanyOrg();
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        return super.getNewCompanyF7();
    }

    @Override
    protected void rdbByMonth_stateChanged(ChangeEvent e) throws Exception {
        this.spiFromMonth.setVisible(false);
        this.spiToMonth.setVisible(false);
        this.lblBeginMonth.setVisible(false);
        this.lblEndMonth.setVisible(false);
        this.lblBeginQuarter.setVisible(false);
        this.lblEndQuarter.setVisible(false);
        Calendar instance = Calendar.getInstance();
        int thisQuarter = instance.get(2) / 3 + 1;
        if (this.rdbByMonth.isSelected()) {
            this.spiFromMonth.setVisible(true);
            this.spiToMonth.setVisible(true);
            this.lblBeginMonth.setVisible(true);
            this.lblEndMonth.setVisible(true);
            FMClientHelper.initSpinFromTO((KDSpinner)this.spiFromYear, (KDSpinner)this.spiFromMonth, (KDSpinner)this.spiToYear, (KDSpinner)this.spiToMonth);
        } else if (this.rdbByQuarter.isSelected()) {
            this.spiFromMonth.setVisible(true);
            this.spiToMonth.setVisible(true);
            this.lblBeginQuarter.setVisible(true);
            this.lblEndQuarter.setVisible(true);
            SpinnerNumberModel mModel = new SpinnerNumberModel(thisQuarter, 1, 4, 1);
            SpinnerNumberModel mModel1 = new SpinnerNumberModel(thisQuarter, 1, 4, 1);
            this.spiFromMonth.setModel((SpinnerModel)mModel);
            this.spiToMonth.setModel((SpinnerModel)mModel1);
        }
    }

    @Override
    protected void rdbByQuarter_stateChanged(ChangeEvent e) throws Exception {
        this.spiFromMonth.setVisible(false);
        this.spiToMonth.setVisible(false);
        this.lblBeginMonth.setVisible(false);
        this.lblEndMonth.setVisible(false);
        this.lblBeginQuarter.setVisible(false);
        this.lblEndQuarter.setVisible(false);
        Calendar instance = Calendar.getInstance();
        int thisQuarter = instance.get(2) / 3 + 1;
        if (this.rdbByMonth.isSelected()) {
            this.spiFromMonth.setVisible(true);
            this.spiToMonth.setVisible(true);
            this.lblBeginMonth.setVisible(true);
            this.lblEndMonth.setVisible(true);
            FMClientHelper.initSpinFromTO((KDSpinner)this.spiFromYear, (KDSpinner)this.spiFromMonth, (KDSpinner)this.spiToYear, (KDSpinner)this.spiToMonth);
        } else if (this.rdbByQuarter.isSelected()) {
            this.spiFromMonth.setVisible(true);
            this.spiToMonth.setVisible(true);
            this.lblBeginQuarter.setVisible(true);
            this.lblEndQuarter.setVisible(true);
            SpinnerNumberModel mModel = new SpinnerNumberModel(thisQuarter, 1, 4, 1);
            SpinnerNumberModel mModel1 = new SpinnerNumberModel(thisQuarter, 1, 4, 1);
            this.spiFromMonth.setModel((SpinnerModel)mModel);
            this.spiToMonth.setModel((SpinnerModel)mModel1);
        }
    }

    public Object getParam() {
        AvgAnalysisFilterParam para = new AvgAnalysisFilterParam();
        String[] companyIds = this.getCompanyIds();
        para.setCompanyIds(companyIds);
        if (this.cboCurrency.getSelectedItem() != null && !(this.cboCurrency.getSelectedItem() instanceof FMSysDefinedEnum)) {
            para.setCurrencyId(((CurrencyInfo)this.cboCurrency.getSelectedItem()).getId().toString());
        }
        if (!(this.cboCurrency.getSelectedItem() instanceof FMSysDefinedEnum)) {
            para.setCurrencyName((String)AccessHelper.getCboAttribute((KDComboBox)this.cboCurrency, (String)"name"));
        } else {
            para.setCurrencyName(FMSysDefinedEnum.SELECT_ALL.getAlias());
        }
        para.setIA(this.chkIA.isSelected());
        para.setBeginMonth(AccessHelper.getSpiValue((KDSpinner)this.spiFromMonth));
        para.setBeginYear(AccessHelper.getSpiValue((KDSpinner)this.spiFromYear));
        para.setEndMonth(AccessHelper.getSpiValue((KDSpinner)this.spiToMonth));
        para.setEndYear(AccessHelper.getSpiValue((KDSpinner)this.spiToYear));
        para.setAvgType(((IntEnum)this.cboType.getSelectedItem()).getValue());
        if (this.rdbByCompany.isSelected()) {
            para.setOrder(0);
        } else if (this.rdbPeriod.isSelected()) {
            para.setOrder(1);
        } else {
            para.setOrder(2);
        }
        if (this.rdbByMonth.isSelected()) {
            para.setAvgRptType(0);
        } else if (this.rdbByQuarter.isSelected()) {
            para.setAvgRptType(1);
        } else {
            para.setAvgRptType(2);
        }
        return para;
    }

    public void setParam(Object param) {
        if (param == null) {
            return;
        }
        if (!(param instanceof AvgAnalysisFilterParam)) {
            return;
        }
        AvgAnalysisFilterParam filterParam = (AvgAnalysisFilterParam)param;
        String[] companyIds = filterParam.getCompanyIds();
        try {
            this.setCompanyIds(companyIds);
        }
        catch (Exception e) {
            this.handUIException(e);
            SysUtil.abort((Throwable)e);
        }
        String currencyId = filterParam.getCurrencyId();
        CurrencyInfo currencyInfo = null;
        try {
            if (currencyId != null) {
                ICurrency iCurrency = CurrencyFactory.getRemoteInstance();
                currencyInfo = iCurrency.getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyId));
                FMClientHelper.setSelectObject((KDComboBox)this.cboCurrency, (Object)currencyInfo);
            } else {
                this.cboCurrency.setSelectedItem((Object)FMSysDefinedEnum.SELECT_ALL);
            }
        }
        catch (Exception e1) {
            SysUtil.abort((Throwable)e1);
        }
        this.chkIA.setSelected(filterParam.isIA());
        this.spiFromYear.setValue((Object)new Integer(filterParam.getBeginYear()));
        this.spiFromMonth.setValue((Object)new Integer(filterParam.getBeginMonth()));
        this.spiToYear.setValue((Object)new Integer(filterParam.getEndYear()));
        this.spiToMonth.setValue((Object)new Integer(filterParam.getEndMonth()));
        this.cboType.setSelectedItem((Object)AvgTypeEnum.getEnum(filterParam.getAvgType()));
        if (filterParam.getOrder() == 0) {
            this.rdbByCompany.setSelected(true);
        } else if (filterParam.getOrder() == 1) {
            this.rdbPeriod.setSelected(true);
        } else {
            this.rdbType.setSelected(true);
        }
        if (filterParam.getAvgRptType() == 0) {
            this.rdbByMonth.setSelected(true);
        } else if (filterParam.getAvgRptType() == 1) {
            this.rdbByQuarter.setSelected(true);
        } else {
            this.rdbByYear.setSelected(true);
        }
    }

    public boolean verify() {
        if (this.getCompanyIds() == null || this.getCompanyIds().length == 0) {
            this.btnCompanySelect.requestFocus(true);
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"NoOrgUnit"));
            SysUtil.abort();
        }
        if (this.rdbByMonth.isSelected() || this.rdbByQuarter.isSelected()) {
            if (AccessHelper.getSpiValue((KDSpinner)this.spiFromYear) * 12 + AccessHelper.getSpiValue((KDSpinner)this.spiFromMonth) > AccessHelper.getSpiValue((KDSpinner)this.spiToYear) * 12 + AccessHelper.getSpiValue((KDSpinner)this.spiToMonth)) {
                this.spiFromYear.requestFocus(true);
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath1, (String)"CheckDateFromTo"));
                SysUtil.abort();
            }
        } else if (AccessHelper.getSpiValue((KDSpinner)this.spiFromYear) > AccessHelper.getSpiValue((KDSpinner)this.spiToYear)) {
            this.spiFromYear.requestFocus(true);
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath1, (String)"CheckDateFromTo"));
            SysUtil.abort();
        }
        return true;
    }

    protected void initCompanyState() {
        super.initCompanyState();
        boolean isClearingH = (Boolean)this.paramMap.get("isClearingHourse");
        if (isClearingH) {
            this.chkIA.setEnabled(true);
            this.btnCompanySelect.setEnabled(true);
            this.btnCompanySelect.setVisible(true);
        }
    }

    protected void companyValueChange(Object object) throws Exception {
        Object[] array = (Object[])object;
        super.companyValueChange((Object)array);
    }

    protected void setDefaultValue() {
        try {
            super.setDefaultValue();
            FMClientHelper.initSpinFromTO((KDSpinner)this.spiFromYear, (KDSpinner)this.spiFromMonth, (KDSpinner)this.spiToYear, (KDSpinner)this.spiToMonth);
            FMClientHelper.setSelectObject((KDComboBox)this.cboCurrency, (Object)((CompanyOrgUnitInfo)this.paramMap.get("currentCompany")).getBaseCurrency());
            String currentUserId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
            Set idSet = FMClientHelper.getUserCompanyIds((String)currentUserId);
            this.setCompanyIdSet(idSet);
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        this.rdbByMonth.setSelected(true);
        this.rdbByQuarter.setSelected(false);
        this.rdbByYear.setSelected(false);
        this.rdbByCompany.setSelected(true);
        this.rdbPeriod.setSelected(false);
        this.rdbType.setSelected(false);
    }

    protected Class getParamClass() {
        return AvgAnalysisFilterParam.class;
    }
}

