/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.fs.AvgAnalysisByCompanyHandlerFacadeFactory;
import com.kingdee.eas.fm.fs.client.AbstractAvgAnalysisHandler;
import com.kingdee.eas.fm.fs.client.AbstractAvgAnalysisUI;
import com.kingdee.eas.fm.fs.client.AvgAnalysisFilterParam;
import com.kingdee.eas.fm.fs.client.AvgAnalysisFilterUI;
import com.kingdee.eas.fm.fs.client.FSAnalysisHandlerFactory;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.TreePath;

public class AvgAnalysisUI
extends AbstractAvgAnalysisUI {
    private static final int AVG_YEAR = 2;
    Map hm = new HashMap();
    private AvgAnalysisFilterUI filterUI;
    private boolean isVilad = false;

    public void onLoad() throws Exception {
        this.prepare();
        boolean isClearingH = (Boolean)this.hm.get("isClearingHourse");
        if (!isClearingH) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fm.fs.FSClientResource", (String)"mustToChCompany"));
            SysUtil.abort();
        }
        this.setTitle();
        super.onLoad();
        this.tHelper.getDisabledTables().add(this.tblMain);
        this.isVilad = true;
    }

    private void setTitle() {
        CompanyOrgUnitInfo curC = (CompanyOrgUnitInfo)this.hm.get("currentCompany");
        if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)curC)) {
            return;
        }
        BankInfo clearingHouse = (BankInfo)this.hm.get("clearingHouse");
        if (clearingHouse == null) {
            return;
        }
        Date settleDate = clearingHouse.getSettleDate();
        if (settleDate == null) {
            return;
        }
        this.sysStatusBarTitle = EASResource.getString((String)"com.kingdee.eas.fm.common.client.FMCommonClientResource", (String)"CHDateTile") + Constants.FORMAT_DAY.format(settleDate);
    }

    private void prepare() throws Exception {
        this.hm = AvgAnalysisByCompanyHandlerFacadeFactory.getRemoteInstance().fetchData(this.hm);
    }

    protected void execQuery() throws BOSException {
        AvgAnalysisFilterParam p = (AvgAnalysisFilterParam)this.getFilterParam();
        AbstractAvgAnalysisHandler handler = FSAnalysisHandlerFactory.getHandler(p);
        this.txtCurrency.setText(p.getCurrencyName());
        this.txtCurrency.setEditable(false);
        String datePeriod = "";
        datePeriod = p.getAvgRptType() == 2 ? p.getBeginYear() + " - " + p.getEndYear() : p.getBeginYear() + "-" + p.getBeginMonth() + " - " + p.getEndYear() + "-" + p.getEndMonth();
        this.txtPeriodRange.setText(datePeriod);
        this.txtPeriodRange.setEditable(false);
        this.tblMain.checkParsed();
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblMain.getSelectManager().setSelectMode(2);
        handler.initTree(p, this.treeList);
        handler.initTable(p, this.tblMain);
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new AvgAnalysisFilterUI(this.hm);
        }
        return this.filterUI;
    }

    @Override
    protected void treeList_valueChanged(TreeSelectionEvent e) throws Exception {
        super.treeList_valueChanged(e);
        AvgAnalysisFilterParam param = (AvgAnalysisFilterParam)this.getFilterParam();
        TreePath path = e.getNewLeadSelectionPath();
        if (path == null) {
            return;
        }
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.treeList.getModel().getRoot();
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)path.getLastPathComponent();
        if (node == root) {
            return;
        }
        this.tblMain.removeRows();
        Object info = node.getUserObject();
        AbstractAvgAnalysisHandler handler = FSAnalysisHandlerFactory.getHandler(param);
        handler.setCurrencyFormat(this.tblMain, param);
        handler.fillData(param, info, this.tblMain, this.mainQuery);
    }

    protected KDTable getMainTable() {
        return this.tblMain;
    }
}

