/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.client;

import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FilterParam;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.util.Date;
import java.util.HashSet;

public class CapitalStockFilterParam
implements FilterParam {
    private static final long serialVersionUID = 3360788424963475316L;
    private String currencyId;
    private String currencyName;
    private String[] companyIds;
    private Date beginDate;
    private Date endDate;
    private boolean isDispCompanyTotal;
    private boolean isDispTotal;
    private boolean isIA;
    private int capitalSource;
    private int capitalStockRptType;

    public boolean isDispTotal() {
        return this.isDispTotal;
    }

    public void setDispTotal(boolean isDispTotal) {
        this.isDispTotal = isDispTotal;
    }

    public Date getBeginDate() {
        return this.beginDate;
    }

    public void setBeginDate(Date beginDate) {
        this.beginDate = beginDate;
    }

    public String[] getCompanyIds() {
        return this.companyIds;
    }

    public void setCompanyIds(String[] companyIds) {
        this.companyIds = companyIds;
    }

    public String getCurrencyId() {
        return this.currencyId;
    }

    public void setCurrencyId(String currencyId) {
        this.currencyId = currencyId;
    }

    public String getCurrencyName() {
        return this.currencyName;
    }

    public void setCurrencyName(String currencyName) {
        this.currencyName = currencyName;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public boolean isDispCompanyTotal() {
        return this.isDispCompanyTotal;
    }

    public void setDispCompanyTotal(boolean isDispCompanyTotal) {
        this.isDispCompanyTotal = isDispCompanyTotal;
    }

    public boolean isIA() {
        return this.isIA;
    }

    public void setIA(boolean isIA) {
        this.isIA = isIA;
    }

    public int getCapitalSource() {
        return this.capitalSource;
    }

    public void setCapitalSource(int capitalSource) {
        this.capitalSource = capitalSource;
    }

    public int getCapitalStockRptType() {
        return this.capitalStockRptType;
    }

    public void setCapitalStockRptType(int capitalStockRptType) {
        this.capitalStockRptType = capitalStockRptType;
    }

    public FilterInfo getFilter() {
        FilterInfo filterInfo = new FilterInfo();
        HashSet<Integer> typeList = new HashSet<Integer>(3);
        typeList.add(new Integer(1));
        typeList.add(new Integer(2));
        typeList.add(new Integer(3));
        filterInfo.getFilterItems().add(new FilterItemInfo("capitalType", typeList, CompareType.INCLUDE));
        if (!FMHelper.isEmpty((Object[])this.companyIds)) {
            HashSet<String> list = new HashSet<String>(this.companyIds.length);
            for (int i = 0; i < this.companyIds.length; ++i) {
                list.add(this.companyIds[i]);
            }
            filterInfo.getFilterItems().add(new FilterItemInfo("company.id", list, CompareType.INCLUDE));
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("type", (Object)new Integer(1)));
        if (this.currencyId != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("currency.id", (Object)this.currencyId));
        }
        if (this.capitalStockRptType == 1) {
            if (this.endDate != null) {
                filterInfo.getFilterItems().add(new FilterItemInfo("BizDate", (Object)this.adjustDate(this.endDate), CompareType.EQUALS));
            }
        } else {
            if (this.beginDate != null) {
                filterInfo.getFilterItems().add(new FilterItemInfo("BizDate", (Object)this.adjustDate(this.beginDate), CompareType.GREATER_EQUALS));
            }
            if (this.endDate != null) {
                filterInfo.getFilterItems().add(new FilterItemInfo("BizDate", (Object)this.adjustDate(this.endDate), CompareType.LESS_EQUALS));
            }
        }
        return filterInfo;
    }

    public SorterItemCollection getSorterItems() {
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("company.id"));
        sorter.add(new SorterItemInfo("currency.id"));
        return sorter;
    }

    private Date adjustDate(Date date) {
        BankInfo clearingHouse = null;
        try {
            String curr = ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId().toString();
            clearingHouse = BankFactory.getRemoteInstance().getClearingHouse(curr);
            if (null == clearingHouse) {
                return date;
            }
            Date openDate = clearingHouse.getOpenDate();
            Date settDate = clearingHouse.getSettleDate();
            if (date.before(openDate)) {
                return openDate;
            }
            if (settDate == null) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"83_CapitalStockFilterParam"));
                SysUtil.abort();
            }
            if (!date.before(settDate)) {
                return DateUtil.getBeforeDay((Date)settDate);
            }
        }
        catch (Exception e) {
            SysUtil.abort((Throwable)e);
        }
        return DateTimeUtils.truncateDate((Date)date);
    }
}

