/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.fs.client.AbstractCompanyReconcileFilterUI;
import com.kingdee.eas.fm.fs.client.CompanyReconcileFilterParam;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Date;
import java.util.GregorianCalendar;

public class CompanyReconcileFilterUI
extends AbstractCompanyReconcileFilterUI {
    private String resourcePath = "com.kingdee.eas.fm.fs.FSClientResource";

    protected void init() throws Exception {
        super.init();
        this.customInit();
    }

    protected Class getParamClass() {
        return CompanyReconcileFilterParam.class;
    }

    protected boolean isNeedEachSerializable() {
        return true;
    }

    private void customInit() throws BOSException, EASBizException {
        boolean isByPeriod = true;
        this.radioByPeriod.setSelected(isByPeriod);
        this.radioByDate.setSelected(!isByPeriod);
        this.setByPeriodOrByDate(isByPeriod);
        this.cbxIncludeUnPostVoucher.setSelected(false);
        FMClientHelper.initSpinFromTO((KDSpinner)this.spiYearFrom, (KDSpinner)this.spiMonthFrom, (KDSpinner)this.spiYearTo, (KDSpinner)this.spiMonthTo);
        FMClientHelper.initCurrency((KDComboBox)this.cboCurrency);
        CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        FMClientHelper.setSelectObject((KDComboBox)this.cboCurrency, (Object)ContextHelperFactory.getRemoteInstance().getCompanyBaseCurrency(company));
        CompanyOrgUnitCollection coll = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection();
        this.setCompanyIdSet(AccessHelper.getIds((Object[])coll.toArray()));
    }

    public void clear() {
        super.clear();
        try {
            this.customInit();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
    }

    public Object getParam() {
        CompanyReconcileFilterParam param = new CompanyReconcileFilterParam();
        String[] companyIds = new String[]{ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId().toString()};
        param.setCompanyIds(companyIds);
        param.setBeginMonth(AccessHelper.getSpiValue((KDSpinner)this.spiMonthFrom));
        param.setBeginYear(AccessHelper.getSpiValue((KDSpinner)this.spiYearFrom));
        param.setEndMonth(AccessHelper.getSpiValue((KDSpinner)this.spiMonthTo));
        param.setEndYear(AccessHelper.getSpiValue((KDSpinner)this.spiYearTo));
        param.setCurrencyId(AccessHelper.getCboId((KDComboBox)this.cboCurrency));
        param.setIA(this.chkIA.isSelected());
        param.setByPeriod(this.radioByPeriod.isSelected());
        param.setBeginDate(DateTimeUtils.truncateDate((Date)((Date)this.datePkBeginDate.getValue())));
        param.setEndDate(DateTimeUtils.truncateDate((Date)((Date)this.datePkEndDate.getValue())));
        param.setIncludeUnPostVoucher(this.cbxIncludeUnPostVoucher.isSelected());
        return param;
    }

    public void setParam(Object param) {
        if (param == null) {
            return;
        }
        if (!(param instanceof CompanyReconcileFilterParam)) {
            return;
        }
        CompanyReconcileFilterParam filterParam = (CompanyReconcileFilterParam)param;
        String[] companyIds = filterParam.getCompanyIds();
        this.setCompanyIds(companyIds);
        String currencyId = filterParam.getCurrencyId();
        CurrencyInfo currencyInfo = null;
        try {
            if (currencyId != null) {
                ICurrency iCurrency = CurrencyFactory.getRemoteInstance();
                currencyInfo = iCurrency.getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyId));
                FMClientHelper.setSelectObject((KDComboBox)this.cboCurrency, (Object)currencyInfo);
            }
        }
        catch (Exception e1) {
            SysUtil.abort((Throwable)e1);
        }
        this.chkIA.setSelected(filterParam.isIA());
        this.spiYearFrom.setValue((Object)new Integer(filterParam.getBeginYear()));
        this.spiMonthFrom.setValue((Object)new Integer(filterParam.getBeginMonth()));
        this.spiYearTo.setValue((Object)new Integer(filterParam.getEndYear()));
        this.spiMonthTo.setValue((Object)new Integer(filterParam.getEndMonth()));
        this.radioByPeriod.setSelected(filterParam.isByPeriod());
        this.radioByDate.setSelected(!filterParam.isByPeriod());
        this.datePkBeginDate.setValue((Object)filterParam.getBeginDate());
        this.datePkEndDate.setValue((Object)filterParam.getEndDate());
        this.cbxIncludeUnPostVoucher.setSelected(filterParam.isIncludeUnPostVoucher());
        boolean isByPeriod = filterParam.isByPeriod();
        this.setByPeriodOrByDate(isByPeriod);
    }

    private void setByPeriodOrByDate(boolean isByPeriod) {
        this.contBeginDate.setVisible(!isByPeriod);
        this.contEndDate.setVisible(!isByPeriod);
        this.lblYearFrom.setVisible(isByPeriod);
        this.lbYearFrom.setVisible(isByPeriod);
        this.spiMonthFrom.setVisible(isByPeriod);
        this.lblMonthFrom.setVisible(isByPeriod);
        this.lblYearTo.setVisible(isByPeriod);
        this.lbYearTo.setVisible(isByPeriod);
        this.spiMonthTo.setVisible(isByPeriod);
        this.lblMonthTo.setVisible(isByPeriod);
    }

    public boolean verify() {
        if (this.getCompanyIds() == null || this.getCompanyIds().length == 0) {
            this.btnCompanySelect.requestFocus(true);
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"NoOrgUnit"));
            SysUtil.abort();
        }
        if (this.radioByPeriod.isSelected()) {
            if (AccessHelper.getSpiValue((KDSpinner)this.spiYearFrom) * 12 + AccessHelper.getSpiValue((KDSpinner)this.spiMonthFrom) > AccessHelper.getSpiValue((KDSpinner)this.spiYearTo) * 12 + AccessHelper.getSpiValue((KDSpinner)this.spiMonthTo)) {
                this.spiYearFrom.requestFocus(true);
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"CheckDateFromTo"));
                SysUtil.abort();
            }
        } else {
            FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDDatePicker)this.datePkBeginDate);
            FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDDatePicker)this.datePkEndDate);
            FMClientVerifyHelper.verifyBeginEndDateRel((CoreUIObject)this, (KDDatePicker)this.datePkBeginDate, (KDDatePicker)this.datePkEndDate);
        }
        BankInfo bank = null;
        try {
            bank = BankFactory.getRemoteInstance().getClearingHouse(ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId().toString());
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        if (bank != null) {
            Date date = bank.getOpenDate();
            GregorianCalendar endcal = new GregorianCalendar(this.spiYearTo.getIntegerVlaue(), this.spiMonthTo.getIntegerVlaue(), 0, 23, 59, 59);
            Date enddate = endcal.getTime();
            if (date != null && date.compareTo(enddate) > 0) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"86_CompanyReconcileFilterUI"));
                SysUtil.abort();
            }
        }
        return true;
    }

    protected void initCompanyState() {
        super.initCompanyState();
    }

    protected void companyValueChange(Object object) throws Exception {
        Object[] array = (Object[])object;
        super.companyValueChange((Object)array);
    }

    @Override
    protected void radioByDate_actionPerformed(ActionEvent e) throws Exception {
        super.radioByDate_actionPerformed(e);
        boolean isByPeriod = false;
        this.setByPeriodOrByDate(isByPeriod);
    }

    @Override
    protected void radioByPeriod_actionPerformed(ActionEvent e) throws Exception {
        super.radioByPeriod_actionPerformed(e);
        boolean isByPeriod = true;
        this.setByPeriodOrByDate(isByPeriod);
    }
}

