/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.IBank;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.fi.cas.client.ClientUtils;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.fs.IInnerAccount;
import com.kingdee.eas.fm.fs.InnerAccountCollection;
import com.kingdee.eas.fm.fs.InnerAccountFactory;
import com.kingdee.eas.fm.fs.InnerAccountInfo;
import com.kingdee.eas.fm.fs.client.AbstractCompanyReconcileUI;
import com.kingdee.eas.fm.fs.client.CompanyReconcileDetailParam;
import com.kingdee.eas.fm.fs.client.CompanyReconcileDetailUI;
import com.kingdee.eas.fm.fs.client.CompanyReconcileFilterParam;
import com.kingdee.eas.fm.fs.client.CompanyReconcileFilterUI;
import com.kingdee.eas.fm.fs.client.CompanyReconcileHandler;
import com.kingdee.eas.fm.fs.client.FSAnalysisHandlerFactory;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class CompanyReconcileUI
extends AbstractCompanyReconcileUI {
    private static final Logger logger = CoreUIObject.getLogger(CompanyReconcileUI.class);
    private String resourcePath = "com.kingdee.eas.fm.fs.FSClientResource";
    private CompanyReconcileFilterParam param;
    InnerAccountCollection coll = null;
    private static Map openDateMap = new HashMap();
    private CompanyReconcileFilterUI filterUI;

    @Override
    protected void treeList_valueChanged(TreeSelectionEvent e) throws Exception {
        super.treeList_valueChanged(e);
        TreePath path = e.getNewLeadSelectionPath();
        if (path == null) {
            return;
        }
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.treeList.getModel().getRoot();
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)path.getLastPathComponent();
        CompanyReconcileFilterParam param = (CompanyReconcileFilterParam)this.getFilterParam();
        Object info = node.getUserObject();
        this.coll = this.getInnerAcctColl(info);
        CompanyReconcileHandler handler = new CompanyReconcileHandler();
        FMClientHelper.clearTable((KDTable)this.tblMain);
        if (this.coll == null || this.coll.size() == 0) {
            return;
        }
        handler.initTable(this.tblMain);
        if (this.tblMain.getRowCount() == 0) {
            return;
        }
        handler.setColumnFormat(this.tblMain, param);
        handler.fillData(param, this.coll, this.tblMain);
        InnerAccountInfo innerAcctInfo = this.coll.get(0);
        String chCompanyId = innerAcctInfo.getCompany().getId().toString();
        this.showChOpenDate(chCompanyId);
    }

    private void showChOpenDate(String companyId) throws EASBizException, BOSException {
        Date date = null;
        if (openDateMap.containsKey(companyId)) {
            date = (Date)openDateMap.get(companyId);
        }
        IBank iBank = BankFactory.getRemoteInstance();
        BankInfo chInfo = iBank.getClearingHouse(companyId);
        date = chInfo.getOpenDate();
        openDateMap.put(companyId, date);
        String msgStr = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"358_CompanyReconcileUI"), chInfo.getName(), FMHelper.getDateFormat().format(date));
        this.setMessageText(msgStr);
        this.showMessage();
    }

    private InnerAccountCollection getInnerAcctColl(Object info) throws BOSException {
        AccountBankInfo acBank;
        InnerAccountInfo innerAcct;
        InnerAccountCollection coll = new InnerAccountCollection();
        if (info instanceof InnerAccountInfo) {
            coll.add((InnerAccountInfo)info);
        }
        if (info instanceof AccountBankInfo && (innerAcct = (acBank = (AccountBankInfo)info).getInnerAcct()) != null) {
            coll.add(innerAcct);
        }
        if (info instanceof CompanyOrgUnitInfo) {
            CompanyOrgUnitInfo chCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
            CompanyOrgUnitInfo com = (CompanyOrgUnitInfo)info;
            String lnumber = com.getLongNumber();
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            String sql = "select fid from t_org_company where flongnumber like '" + lnumber + "!%' or flongnumber='" + lnumber + "'";
            filter.getFilterItems().add(new FilterItemInfo("applyUnit.id", (Object)sql, CompareType.INNER));
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)chCompany.getId().toString()));
            ev.setFilter(filter);
            ev.getSelector().add("*");
            ev.getSelector().add("applyUnit.*");
            ev.getSelector().add("acctView.*");
            IInnerAccount ia = InnerAccountFactory.getRemoteInstance();
            coll.addCollection(ia.getInnerAccountCollection(ev));
        }
        return coll;
    }

    protected void execQuery() throws BOSException {
        this.param = (CompanyReconcileFilterParam)this.getFilterParam();
        CompanyReconcileHandler handler = FSAnalysisHandlerFactory.getHandler(this.param);
        CurrencyInfo currency = null;
        try {
            currency = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)this.param.getCurrencyId())));
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        this.txtCurrency.setText(currency.getName());
        String datePeriod = "";
        if (this.param.isByPeriod()) {
            datePeriod = this.param.getBeginYear() + "-" + this.param.getBeginMonth() + " - " + this.param.getEndYear() + "-" + this.param.getEndMonth();
        } else {
            DateFormat dateFormat = CtrlFormatUtilities.getDateFormat();
            datePeriod = dateFormat.format(this.param.getBeginDate()) + " - " + dateFormat.format(this.param.getEndDate());
        }
        this.txtPeriodRange.setText(datePeriod);
        this.txtPeriodRange.setEditable(false);
        this.tblMain.checkParsed();
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblMain.getSelectManager().setSelectMode(10);
        handler.initTree(this.param, this.treeList);
        FMClientHelper.goLeaf((KDTree)this.treeList);
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new CompanyReconcileFilterUI();
        }
        return this.filterUI;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionViewDetail.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_differentia"));
    }

    public void onLoad() throws Exception {
        CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        ClientUtils.checkCompany((Component)((Object)this), (CompanyOrgUnitInfo)company);
        this.actionViewDetail.setEnabled(true);
        super.onLoad();
    }

    @Override
    public void actionViewDetail_actionPerformed(ActionEvent e) throws Exception {
        if (this.tblMain.getRowCount() == 0) {
            return;
        }
        if (this.coll == null || this.coll.size() == 0) {
            return;
        }
        CompanyReconcileDetailParam detailParam = new CompanyReconcileDetailParam();
        detailParam.setCompanyId(ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId().toString());
        detailParam.setInnAcctColl(this.coll);
        AccountBankInfo bankAccountByInnerAccount = CompanyReconcileHandler.getBankAccountByInnerAccount(this.coll.get(0).getId().toString());
        if (bankAccountByInnerAccount == null) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"90_CompanyReconcileUI"));
            this.abort();
        }
        detailParam.setAccountBank(bankAccountByInnerAccount);
        detailParam.setCurrencyId(this.param.getCurrencyId());
        detailParam.setByPeriod(this.param.isByPeriod());
        if (detailParam.isByPeriod()) {
            detailParam.setBeginYear(this.param.getBeginYear());
            detailParam.setEndYear(this.param.getEndYear());
            detailParam.setBeginPeriod(this.param.getBeginMonth());
            detailParam.setEndPeriod(this.param.getEndMonth());
        } else {
            detailParam.setBeginDate(this.param.getBeginDate());
            detailParam.setEndDate(this.param.getEndDate());
        }
        detailParam.setIncludeUnPostVoucher(this.param.isIncludeUnPostVoucher());
        BigDecimal beginBalanceDiff = (BigDecimal)this.tblMain.getCell(0, "Difference").getValue();
        if (beginBalanceDiff == null) {
            beginBalanceDiff = SysConstant.BIGZERO;
        }
        detailParam.setBeginBalanceDiff(beginBalanceDiff);
        BigDecimal debitAmountDiff = (BigDecimal)this.tblMain.getCell(1, "Difference").getValue();
        BigDecimal creditAmountDiff = (BigDecimal)this.tblMain.getCell(2, "Difference").getValue();
        if (debitAmountDiff == null) {
            debitAmountDiff = SysConstant.BIGZERO;
        }
        if (creditAmountDiff == null) {
            creditAmountDiff = SysConstant.BIGZERO;
        }
        detailParam.setDiff(debitAmountDiff.subtract(creditAmountDiff));
        BigDecimal endBalanceDiff = (BigDecimal)this.tblMain.getCell(3, "Difference").getValue();
        if (endBalanceDiff == null) {
            endBalanceDiff = SysConstant.BIGZERO;
        }
        detailParam.setEndBalanceDiff(endBalanceDiff);
        CompanyReconcileDetailUI.showDialogWindow((IUIObject)this, detailParam);
        super.actionViewDetail_actionPerformed(e);
    }

    protected KDTable getMainTable() {
        return this.tblMain;
    }

    public void onShow() throws Exception {
        super.onShow();
        this.treeList.requestFocus();
    }
}

