/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.client;

import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateFactory;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.IExchangeRate;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fm.fs.SettlementBillRpcCacheInfo;
import java.math.BigDecimal;
import java.util.Calendar;

public final class CurrencyUtil {
    private static CurrencyCollection coll = null;

    public static void fillCombCurrency(KDComboBox cboCurrency, SettlementBillRpcCacheInfo rpcCacheInfo) throws Exception {
        cboCurrency.removeAllItems();
        if (coll == null || coll.isEmpty()) {
            if (rpcCacheInfo != null && rpcCacheInfo.getAllCurrencyColl() != null) {
                coll = rpcCacheInfo.getAllCurrencyColl();
            } else {
                ICurrency iCurrency = CurrencyFactory.getRemoteInstance();
                coll = iCurrency.getCurrencyCollection(true);
            }
        }
        cboCurrency.addItems(coll.toArray());
    }

    public static void fillCombCurrency(KDComboBox cboCurrency) throws Exception {
        cboCurrency.removeAllItems();
        if (coll == null || coll.isEmpty()) {
            ICurrency iCurrency = CurrencyFactory.getRemoteInstance();
            coll = iCurrency.getCurrencyCollection(true);
        }
        cboCurrency.addItems(coll.toArray());
    }

    public static void fillCombCurrency(KDComboBox cboCurrency, Object coll) throws Exception {
        cboCurrency.removeAllItems();
        cboCurrency.addItems(((CurrencyCollection)coll).toArray());
    }

    public static CurrencyInfo getLocalCurrency() throws Exception {
        return ContextHelperFactory.getRemoteInstance().getCompanyBaseCurrency(ContextHelperFactory.getRemoteInstance().getCurrentCompany());
    }

    public static BigDecimal getExchangeRate() throws Exception {
        return CurrencyUtil.getExchangeRate(null, null);
    }

    public static BigDecimal getExchangeRate(CurrencyInfo sourceCur) throws Exception {
        return CurrencyUtil.getExchangeRate(null, sourceCur);
    }

    public static BigDecimal getExchangeRate(CompanyOrgUnitInfo companyOrgUnitInfo, CurrencyInfo sourceCur) throws Exception {
        IExchangeRate iexchangRate = null;
        ObjectUuidPK excTablepk = null;
        ObjectUuidPK destCurrpk = null;
        BigDecimal rate = null;
        if (companyOrgUnitInfo == null) {
            companyOrgUnitInfo = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        }
        if (companyOrgUnitInfo.getBaseExchangeTable() == null) {
            return Constants.ZERO;
        }
        excTablepk = new ObjectUuidPK(companyOrgUnitInfo.getBaseExchangeTable().getId());
        CurrencyInfo baseCur = companyOrgUnitInfo.getBaseCurrency();
        if (sourceCur == null) {
            sourceCur = baseCur;
        }
        if (baseCur != null) {
            if (baseCur.getId().equals((Object)sourceCur.getId())) {
                return new BigDecimal("1");
            }
        } else {
            return new BigDecimal("0");
        }
        destCurrpk = new ObjectUuidPK(baseCur.getId());
        iexchangRate = ExchangeRateFactory.getRemoteInstance();
        ObjectUuidPK sourceCurrpk = new ObjectUuidPK(sourceCur.getId());
        ExchangeRateInfo erInfo = iexchangRate.getExchangeRate((IObjectPK)excTablepk, (IObjectPK)sourceCurrpk, (IObjectPK)destCurrpk, Calendar.getInstance().getTime());
        rate = erInfo != null ? erInfo.getConvertRate() : new BigDecimal("1");
        return rate;
    }
}

