/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.client;

import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.be.BankLogFacadeFactory;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.fs.client.AbstractEntityBankAcntRelationFilerUI;
import com.kingdee.eas.fm.fs.client.EntityBankAcntRelationParam;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class EntityBankAcntRelationFilerUI
extends AbstractEntityBankAcntRelationFilerUI {
    private static final String F7_ACNT_BANK_QUERY = "com.kingdee.eas.basedata.assistant.app.F7AccountBankQuery";
    private static final Logger logger = CoreUIObject.getLogger(EntityBankAcntRelationFilerUI.class);
    EntityBankAcntRelationParam param = null;

    public EntityBankAcntRelationFilerUI() throws Exception {
        this.initMotherAccount();
    }

    private void initMotherAccount() {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        Set companyIdSet = this.getCompanyIdSet();
        CompanyOrgUnitInfo currentCompany = SysContext.getSysContext().getCurrentFIUnit();
        companyIdSet.add(currentCompany.getId().toString());
        if (companyIdSet != null && companyIdSet.size() > 0) {
            filterInfo.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyIdSet, CompareType.INCLUDE));
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("isMotherAccount", (Object)Boolean.TRUE, CompareType.EQUALS));
        evi.setFilter(filterInfo);
        this.prtBoxMotherAccount.setDisplayFormat("$name$");
        this.prtBoxMotherAccount.setCommitFormat("$name$");
        this.prtBoxMotherAccount.setEditFormat("$name$");
        this.prtBoxMotherAccount.setEnabledMultiSelection(true);
        this.prtBoxMotherAccount.setQueryInfo(F7_ACNT_BANK_QUERY);
        this.prtBoxMotherAccount.setEntityViewInfo(evi);
    }

    public Object getParam() {
        if (this.param == null) {
            this.param = new EntityBankAcntRelationParam();
        }
        AccountBankInfo[] motherAccount = this.getMotherBankAccount();
        this.param.setMotherAccount((CoreBaseInfo[])motherAccount);
        Set companyIdSet = this.getCompanyIdSet();
        CompanyOrgUnitInfo currentCompany = SysContext.getSysContext().getCurrentFIUnit();
        companyIdSet.add(currentCompany.getId().toString());
        this.param.setCompanyIdSet(companyIdSet);
        this.param.setQueryType(this.kDBtnGropRadio.getValue());
        return this.param;
    }

    private AccountBankInfo[] getMotherBankAccount() {
        if (this.prtBoxMotherAccount == null || this.prtBoxMotherAccount.getValue() == null) {
            return null;
        }
        Object[] accts = (Object[])this.prtBoxMotherAccount.getValue();
        return FMHelper.turnObjectsToAccts((Object[])accts);
    }

    public void setParam(Object param) {
        if (param == null) {
            return;
        }
        this.param = (EntityBankAcntRelationParam)param;
        this.prtBoxMotherAccount.setValue((Object)this.param.getMotherAccount());
        if (this.param.getQueryType() == 0) {
            this.kDRadioCompany.setSelected(true);
        } else {
            this.kDRadioBank.setSelected(true);
        }
    }

    protected void setDefaultValue() {
        this.prtBoxMotherAccount.setValue(null);
        this.kDRadioCompany.setSelected(true);
    }

    @Override
    protected void prtBoxMotherAccount_willShow(SelectorEvent e) throws Exception {
        this.initMotherAccount();
    }

    protected void btnCompanySelect_actionPerformed(ActionEvent e) throws Exception {
        super.btnCompanySelect_actionPerformed(e);
        this.prtBoxMotherAccount.setValue(null);
        this.initMotherAccount();
    }

    protected void initCompanyState() {
        if (this.currentCompany == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.be.beResourse", (String)"NoCompany"));
            SysUtil.abort();
        }
        this.btnCompanySelect.setEnabled(false);
        this.btnCompanySelect.setVisible(false);
    }

    private void initCompanyValue() {
        HashMap<String, CompanyOrgUnitInfo> param = new HashMap<String, CompanyOrgUnitInfo>();
        param.put("company", this.currentCompany);
        List idList = null;
        try {
            idList = BankLogFacadeFactory.getRemoteInstance().getAllLowLevelCompany(param);
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
        String[] companyId = new String[idList.size()];
        for (int i = 0; i < idList.size(); ++i) {
            companyId[i] = idList.get(i).toString();
        }
        this.setCompanyIds(companyId);
    }

    protected void init() throws Exception {
        super.init();
        if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)this.currentCompany)) {
            this.initCompanyValue();
            this.initMotherAccount();
        }
    }

    protected Class getParamClass() {
        return EntityBankAcntRelationParam.class;
    }
}

