/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.NewCompanyF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.fs.DepositContrastFilterParam;
import com.kingdee.eas.fm.fs.FSHelper;
import com.kingdee.eas.fm.fs.client.AbstractFMDepositContrastFilterUI;
import com.kingdee.eas.fm.fs.client.FSClientHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.util.Date;
import java.util.Set;
import org.apache.log4j.Logger;

public class FMDepositContrastFilterUI
extends AbstractFMDepositContrastFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(FMDepositContrastFilterUI.class);
    private static final String resourcePath1 = "com.kingdee.eas.fm.fs.FSClientResource";
    private CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
    BankInfo cleanHouse = BankFactory.getRemoteInstance().getClearingHouse(this.currentCompany.getId().toString());

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public Object getParam() {
        DepositContrastFilterParam para = new DepositContrastFilterParam();
        String[] companyIds = this.getCompanyIds();
        para.setCompanyIds(companyIds);
        para.setCurrencyId(((CurrencyInfo)this.kDComboBoxCurrency.getSelectedItem()).getId().toString());
        para.setClosedShow(this.chkIsClosedShow.isSelected());
        para.setOrderByCompany(this.chkIsOrderByCompany.isSelected());
        para.setDate(this.kdDate.getSqlDate());
        return para;
    }

    public void setParam(Object param) {
        if (param == null) {
            return;
        }
        DepositContrastFilterParam filterParam = (DepositContrastFilterParam)param;
        String[] companyIds = filterParam.getCompanyIds();
        this.setCompanyIds(companyIds);
        if (filterParam.getCurrencyId() != null && filterParam.getCurrencyId().trim().length() != 0) {
            try {
                CurrencyInfo info = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectStringPK(filterParam.getCurrencyId()));
                this.kDComboBoxCurrency.setSelectedItem((Object)info);
            }
            catch (EASBizException e) {
                this.handUIException(e);
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        }
        this.chkIsClosedShow.setSelected(filterParam.isClosedShow());
        this.chkIsOrderByCompany.setSelected(filterParam.isOrderByCompany());
        this.kdDate.setValue((Object)filterParam.getDate());
    }

    public void onLoad() throws Exception {
        super.onLoad();
        FMDepositContrastFilterUI.initCurrencyComboBox(this.kDComboBoxCurrency, true);
    }

    protected void setDefaultValue() {
        super.setDefaultValue();
        this.chkIsClosedShow.setSelected(false);
        this.chkIsOrderByCompany.setSelected(false);
        this.kDComboBoxCurrency.setSelectedItem((Object)this.currentCompany.getBaseCurrency());
        try {
            String currentUserId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
            Set idSet = FMClientHelper.getUserCompanyIds((String)currentUserId);
            this.setCompanyIdSet(idSet);
            String companyid = SysContext.getSysContext().getCurrentFIUnit().getId().toString();
            Date settleDate1 = FSHelper.getClearingHouseInfo(null, companyid).getSettleDate();
            this.kdDate.setValue((Object)settleDate1);
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
    }

    public static void initCurrencyComboBox(KDComboBox comboCurrency, boolean isSelBaseCurr) throws EASBizException, BOSException {
        int i;
        ActionListener[] l = comboCurrency.getActionListeners();
        int n = l.length;
        for (int i2 = 0; i2 < n; ++i2) {
            comboCurrency.removeActionListener(l[i2]);
        }
        ItemListener[] itemListener = comboCurrency.getItemListeners();
        int n2 = itemListener.length;
        for (int i3 = 0; i3 < n2; ++i3) {
            comboCurrency.removeItemListener(itemListener[i3]);
        }
        FMClientHelper.initComboCurrency((KDComboBox)comboCurrency);
        if (isSelBaseCurr) {
            CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
            CurrencyInfo currency = FMClientHelper.getBaseCurrency((CompanyOrgUnitInfo)company);
            FMClientHelper.setSelectObject((KDComboBox)comboCurrency, (Object)currency);
        }
        n2 = l.length;
        for (i = 0; i < n2; ++i) {
            comboCurrency.addActionListener(l[i]);
            comboCurrency.addItemListener(itemListener[i]);
        }
        n2 = itemListener.length;
        for (i = 0; i < n2; ++i) {
            comboCurrency.addItemListener(itemListener[i]);
        }
    }

    protected NewCompanyF7 getNewCompanyF7() {
        if (FSClientHelper.isCHUser()) {
            try {
                return super.getAllCompanyOrg();
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        return super.getNewCompanyF7();
    }

    protected void companyValueChange(Object object) throws Exception {
        Object[] array = (Object[])object;
        Object[] result = FMClientHelper.removeVirtualCompany((Object[])array);
        super.companyValueChange((Object)result);
    }

    protected void initCompanyState() {
        super.initCompanyState();
        if (this.cleanHouse != null) {
            this.chkIA.setEnabled(true);
            this.btnCompanySelect.setEnabled(true);
            this.btnCompanySelect.setVisible(true);
        }
    }

    public boolean verify() {
        if (this.getCompanyIds() == null || this.getCompanyIds().length == 0) {
            this.btnCompanySelect.requestFocus(true);
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.common.FMResource", (String)"NoOrgUnit"));
            SysUtil.abort();
        }
        if (this.cleanHouse != null && !this.cleanHouse.isUsed()) {
            this.btnCompanySelect.requestFocus(true);
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath1, (String)"ClearingHouseNotUsed"));
            SysUtil.abort();
        }
        if (EmptyUtil.isEmpty((Object)((Date)this.kdDate.getValue()))) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.common.FMResource", (String)"dateNotNull"));
            SysUtil.abort();
        }
        if (this.cleanHouse != null) {
            Date date = this.cleanHouse.getOpenDate();
            Date queryDate = (Date)this.kdDate.getValue();
            if (date != null && date.compareTo(queryDate) > 0) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"86_CompanyReconcileFilterUI"));
                SysUtil.abort();
            }
        }
        return true;
    }

    protected Class getParamClass() {
        return DepositContrastFilterParam.class;
    }
}

