/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.fs.DepositContrastFilterParam;
import com.kingdee.eas.fm.fs.client.AbstractFMDepositContrastUI;
import com.kingdee.eas.fm.fs.client.DepositContrastHandler;
import com.kingdee.eas.fm.fs.client.FMDepositContrastFilterUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.text.DateFormat;
import org.apache.log4j.Logger;

public class FMDepositContrastUI
extends AbstractFMDepositContrastUI {
    private static final Logger logger = CoreUIObject.getLogger(FMDepositContrastUI.class);
    private FMDepositContrastFilterUI filterUI;
    DepositContrastHandler handler = new DepositContrastHandler();

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new FMDepositContrastFilterUI();
        }
        return this.filterUI;
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
        this.execQuery();
    }

    protected String getKeyFieldName() {
        return "company.number";
    }

    public void onLoad() throws Exception {
        if (!BankFactory.getRemoteInstance().isClearinghouseCompany(SysContext.getSysContext().getCurrentFIUnit().getId().toString())) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"95_FMDepositContrastUI"));
            SysUtil.abort();
        }
        this.tblMain.checkParsed();
        this.tblMain.getDataRequestManager().setDataRequestMode(0);
        this.handler.initTalbe(this.getMainTable());
        super.onLoad();
    }

    public void setTableFormat() {
        this.tblMain.getColumn("currentDeposit").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("fixedDeposit").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("sumDeposit").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("compareToYesterday").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("compareToUltimo").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("compareToLastYear").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("currentDeposit").getStyleAttributes().setNumberFormat("#,##0.00");
        this.tblMain.getColumn("fixedDeposit").getStyleAttributes().setNumberFormat("#,##0.00");
        this.tblMain.getColumn("sumDeposit").getStyleAttributes().setNumberFormat("#,##0.00");
        this.tblMain.getColumn("compareToYesterday").getStyleAttributes().setNumberFormat("#,##0.00");
        this.tblMain.getColumn("compareToUltimo").getStyleAttributes().setNumberFormat("#,##0.00");
        this.tblMain.getColumn("compareToLastYear").getStyleAttributes().setNumberFormat("#,##0.00");
    }

    protected KDTable getMainTable() {
        return this.tblMain;
    }

    protected void execQuery() throws BOSException {
        DepositContrastFilterParam param = (DepositContrastFilterParam)this.getFilterParam();
        String currencyPK = param.getCurrencyId();
        CurrencyInfo selectCurrency = null;
        try {
            selectCurrency = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyPK));
        }
        catch (EASBizException e1) {
            ExceptionHandler.handle((Throwable)e1);
        }
        this.tblMain.getDataRequestManager().setDataRequestMode(0);
        try {
            this.handler.fillData(this.tblMain, param);
            this.setTableFormat();
            this.tblMain.getStyleAttributes().setLocked(true);
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        this.txtCurrency.setText(selectCurrency.getName());
        if (EmptyUtil.isEmpty((Object)param.getDate())) {
            this.txtDate.setText("");
            return;
        }
        DateFormat df = CtrlFormatUtilities.getDateFormat();
        String date = df.format(param.getDate());
        this.txtDate.setText(date);
        this.tblMain.getGroupManager().group();
        if (!param.isOrderByCompany()) {
            for (int i = 0; i < this.tblMain.getRowCount3() - 1; ++i) {
                IRow row = this.tblMain.getRow(i);
                if (!row.isStat()) continue;
                row.getStyleAttributes().setHided(true);
            }
        }
    }
}

