/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.client;

import com.kingdee.eas.fm.fs.client.AbstractAvgAnalysisHandler;
import com.kingdee.eas.fm.fs.client.AbstractSettleLedgerHandler;
import com.kingdee.eas.fm.fs.client.AbstractSubsidiaryLedgerHandler;
import com.kingdee.eas.fm.fs.client.AbstractSummaryLedgerHandler;
import com.kingdee.eas.fm.fs.client.AvgAnalysisByCompanyHandler;
import com.kingdee.eas.fm.fs.client.AvgAnalysisByPeriodHandler;
import com.kingdee.eas.fm.fs.client.AvgAnalysisByTypeHandler;
import com.kingdee.eas.fm.fs.client.AvgAnalysisFilterParam;
import com.kingdee.eas.fm.fs.client.CapitalStockFilterParam;
import com.kingdee.eas.fm.fs.client.CapitalStockHandler;
import com.kingdee.eas.fm.fs.client.CompanyReconcileFilterParam;
import com.kingdee.eas.fm.fs.client.CompanyReconcileHandler;
import com.kingdee.eas.fm.fs.client.OutstandingFilterParam;
import com.kingdee.eas.fm.fs.client.OutstandingHandler;
import com.kingdee.eas.fm.fs.client.PileOfMoneyFilterParam;
import com.kingdee.eas.fm.fs.client.PileOfMoneyHandler;
import com.kingdee.eas.fm.fs.client.ReconcileDetailHandler;
import com.kingdee.eas.fm.fs.client.ReconcileDetailParam;
import com.kingdee.eas.fm.fs.client.ReconcileFilterParam;
import com.kingdee.eas.fm.fs.client.ReconcileHandler;
import com.kingdee.eas.fm.fs.client.SettleLedgerByCompanyHandler;
import com.kingdee.eas.fm.fs.client.SettleLedgerByPeriodHandler;
import com.kingdee.eas.fm.fs.client.SettleLedgerFilterParam;
import com.kingdee.eas.fm.fs.client.SubsidiaryLedgerByCompanyHandler;
import com.kingdee.eas.fm.fs.client.SubsidiaryLedgerByTypeHandler;
import com.kingdee.eas.fm.fs.client.SubsidiaryLedgerFilterParam;
import com.kingdee.eas.fm.fs.client.SummaryLedgerByCompanyDateHandler;
import com.kingdee.eas.fm.fs.client.SummaryLedgerByCompanyHandler;
import com.kingdee.eas.fm.fs.client.SummaryLedgerByPeriodDateHandler;
import com.kingdee.eas.fm.fs.client.SummaryLedgerByPeriodHandler;
import com.kingdee.eas.fm.fs.client.SummaryLedgerFilterParam;

public class FSAnalysisHandlerFactory {
    public static OutstandingHandler getHandler(OutstandingFilterParam p) {
        return new OutstandingHandler();
    }

    public static AbstractSettleLedgerHandler getHandler(SettleLedgerFilterParam p) {
        if (p.isByCompany()) {
            return new SettleLedgerByCompanyHandler();
        }
        return new SettleLedgerByPeriodHandler();
    }

    public static AbstractSubsidiaryLedgerHandler getHandler(SubsidiaryLedgerFilterParam p) {
        if (p.isOrderByCompany()) {
            return new SubsidiaryLedgerByCompanyHandler();
        }
        return new SubsidiaryLedgerByTypeHandler();
    }

    public static AbstractSummaryLedgerHandler getHandler(SummaryLedgerFilterParam p) {
        if (p.isByCompany()) {
            if (p.isByDay()) {
                return new SummaryLedgerByCompanyDateHandler();
            }
            return new SummaryLedgerByCompanyHandler();
        }
        if (p.isByDay()) {
            return new SummaryLedgerByPeriodDateHandler();
        }
        return new SummaryLedgerByPeriodHandler();
    }

    public static ReconcileHandler getHandler(ReconcileFilterParam p) {
        return new ReconcileHandler();
    }

    public static CompanyReconcileHandler getHandler(CompanyReconcileFilterParam p) {
        return new CompanyReconcileHandler();
    }

    public static ReconcileDetailHandler getHandler(ReconcileDetailParam p) {
        return new ReconcileDetailHandler();
    }

    public static PileOfMoneyHandler getHandler(PileOfMoneyFilterParam p) {
        return new PileOfMoneyHandler();
    }

    public static CapitalStockHandler getHandler(CapitalStockFilterParam p) {
        return new CapitalStockHandler();
    }

    public static AbstractAvgAnalysisHandler getHandler(AvgAnalysisFilterParam p) {
        switch (p.getOrder()) {
            case 0: {
                return new AvgAnalysisByCompanyHandler();
            }
            case 1: {
                return new AvgAnalysisByPeriodHandler();
            }
            case 2: {
                return new AvgAnalysisByTypeHandler();
            }
        }
        return null;
    }
}

