/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.fs.client.AbstractInitBalanceUI;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.util.Map;
import org.apache.log4j.Logger;

public class InitBalanceUI
extends AbstractInitBalanceUI {
    String resPath = "com.kingdee.eas.fm.fs.FSClientResource";
    private static final String DIFF_RS = "diff_rs";
    private boolean isConfirmed = false;
    private static final Logger logger = CoreUIObject.getLogger(InitBalanceUI.class);

    public static void showDialogWindows(IUIObject ui, IRowSet rs) throws Exception {
        UIContext uiContext = new UIContext((Object)ui);
        uiContext.put((Object)DIFF_RS, (Object)rs);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(InitBalanceUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    @Override
    protected void btnConfirm_actionPerformed(ActionEvent e) throws Exception {
        this.isConfirmed = true;
        this.destroyWindow();
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.isConfirmed = false;
        this.destroyWindow();
    }

    public boolean getReturnValue() {
        return this.isConfirmed;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        IRowSet rs = (IRowSet)this.getUIContext().get(DIFF_RS);
        this.fillData(this.tblMain, rs);
    }

    private void fillData(KDTable table, IRowSet rs) throws BOSException {
        this.tblMain.checkParsed();
        this.tblMain.getStyleAttributes().setLocked(true);
        IRow row = null;
        try {
            String temp = null;
            rs.beforeFirst();
            while (rs.next()) {
                row = this.tblMain.addRow();
                temp = this.getValidString(rs.getString("FAcctViewNumber")) + " " + this.getValidString(rs.getString("FAcctViewName"));
                row.getCell("acctView").setValue((Object)temp);
                temp = this.getValidString(rs.getString("FCurrencyName"));
                row.getCell("currency").setValue((Object)temp);
                temp = this.getValidString(rs.getString("glInnerAcctNumber")) + " " + this.getValidString(rs.getString("glInnerAcctName"));
                row.getCell("glInnerAcct").setValue((Object)temp);
                row.getCell("glBalance").setValue((Object)rs.getBigDecimal("glBalance"));
                temp = this.getValidString(rs.getString("fsInnerAcctNumber")) + " " + this.getValidString(rs.getString("fsInnerAcctName"));
                row.getCell("fsInnerAcct").setValue((Object)temp);
                row.getCell("fsBalance").setValue((Object)rs.getBigDecimal("fsBalance"));
                row.getCell("diff").setValue((Object)rs.getBigDecimal("diff"));
                String currencyId = rs.getString("FCurrencyId");
                FMClientHelper.setNumberFormat((IRow)row, (String)"glBalance", (String)currencyId);
                FMClientHelper.setNumberFormat((IRow)row, (String)"fsBalance", (String)currencyId);
                FMClientHelper.setNumberFormat((IRow)row, (String)"diff", (String)currencyId);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    private String getValidString(String str) {
        return str == null ? "" : str;
    }
}

