/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.assistant.AccountPropertyFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.NewCompanyF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMSysDefinedEnum;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.common.util.FMBillUtil;
import com.kingdee.eas.fm.fs.AvgTypeEnum;
import com.kingdee.eas.fm.fs.InAcctFactory;
import com.kingdee.eas.fm.fs.InnerAccountFactory;
import com.kingdee.eas.fm.fs.client.AbstractInnerAvgAnalysisFilterUI;
import com.kingdee.eas.fm.fs.client.FSClientHelper;
import com.kingdee.eas.fm.fs.client.InnerAvgAnalysisParam;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.enums.IntEnum;
import java.awt.Component;
import java.util.Calendar;
import java.util.Map;
import java.util.Set;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import org.apache.log4j.Logger;

public class InnerAvgAnalysisFilterUI
extends AbstractInnerAvgAnalysisFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(InnerAvgAnalysisFilterUI.class);
    CompanyOrgUnitCollection coll = null;
    private static final int ORDER_BY_TYPE = 2;
    private static final int ORDER_BY_PERIOD = 1;
    private static final int ORDER_BY_COMPANY = 0;
    private static final int AVG_DATE = 3;
    private static final int AVG_YEAR = 2;
    private static final int AVG_QUARTER = 1;
    private static final int AVG_MONTH = 0;
    private static final String resourcePath1 = "com.kingdee.eas.fm.fs.FSClientResource";
    private static final String resourcePath = "com.kingdee.eas.fm.fs.client.AvgAnalysisResource";
    private Map paramMap;

    public InnerAvgAnalysisFilterUI(Map paramMap1) throws Exception {
        this.paramMap = paramMap1;
    }

    protected void init() throws Exception {
        super.init();
        FMClientHelper.initSpinFromTO((KDSpinner)this.spiFromYear, (KDSpinner)this.spiFromMonth, (KDSpinner)this.spiToYear, (KDSpinner)this.spiToMonth);
        if (this.paramMap.get("currencyCol") == null) {
            FMClientHelper.initCurrency((KDComboBox)this.cboCurrency);
        } else {
            FMClientHelper.initCurrency((KDComboBox)this.cboCurrency, (CurrencyCollection)((CurrencyCollection)this.paramMap.get("currencyCol")));
        }
        this.cboCurrency.addItem((Object)FMSysDefinedEnum.SELECT_ALL);
        if (this.paramMap.get("currentCompany") == null) {
            CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
            FMClientHelper.setSelectObject((KDComboBox)this.cboCurrency, (Object)ContextHelperFactory.getRemoteInstance().getCompanyBaseCurrency(company));
        } else {
            FMClientHelper.setSelectObject((KDComboBox)this.cboCurrency, (Object)((CompanyOrgUnitInfo)this.paramMap.get("currentCompany")).getBaseCurrency());
        }
        this.setCompanyIdSet((Set)this.paramMap.get("companyIDSet"));
        FMClientHelper.manageAccountLevelRange((KDSpinner)this.spiFromYear, (KDSpinner)this.spiToYear, (KDSpinner)this.spiFromMonth, (KDSpinner)this.spiToMonth);
    }

    protected NewCompanyF7 getNewCompanyF7() {
        if (FSClientHelper.isCHUser()) {
            try {
                return super.getAllCompanyOrg();
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        return super.getNewCompanyF7();
    }

    @Override
    protected void rdbByMonth_stateChanged(ChangeEvent e) throws Exception {
        this.spiFromMonth.setVisible(false);
        this.spiToMonth.setVisible(false);
        this.lblBeginMonth.setVisible(false);
        this.lblEndMonth.setVisible(false);
        this.lblBeginQuarter.setVisible(false);
        this.lblEndQuarter.setVisible(false);
        Calendar instance = Calendar.getInstance();
        int thisQuarter = instance.get(2) / 3 + 1;
        if (this.rdbByMonth.isSelected()) {
            this.spiFromMonth.setVisible(true);
            this.spiToMonth.setVisible(true);
            this.lblBeginMonth.setVisible(true);
            this.lblEndMonth.setVisible(true);
            FMClientHelper.initSpinFromTO((KDSpinner)this.spiFromYear, (KDSpinner)this.spiFromMonth, (KDSpinner)this.spiToYear, (KDSpinner)this.spiToMonth);
        } else if (this.rdbByQuarter.isSelected()) {
            this.spiFromMonth.setVisible(true);
            this.spiToMonth.setVisible(true);
            this.lblBeginQuarter.setVisible(true);
            this.lblEndQuarter.setVisible(true);
            SpinnerNumberModel mModel = new SpinnerNumberModel(thisQuarter, 1, 4, 1);
            SpinnerNumberModel mModel1 = new SpinnerNumberModel(thisQuarter, 1, 4, 1);
            this.spiFromMonth.setModel((SpinnerModel)mModel);
            this.spiToMonth.setModel((SpinnerModel)mModel1);
        }
    }

    @Override
    protected void rdbByQuarter_stateChanged(ChangeEvent e) throws Exception {
        this.spiFromMonth.setVisible(false);
        this.spiToMonth.setVisible(false);
        this.lblBeginMonth.setVisible(false);
        this.lblEndMonth.setVisible(false);
        this.lblBeginQuarter.setVisible(false);
        this.lblEndQuarter.setVisible(false);
        Calendar instance = Calendar.getInstance();
        int thisQuarter = instance.get(2) / 3 + 1;
        if (this.rdbByMonth.isSelected()) {
            this.spiFromMonth.setVisible(true);
            this.spiToMonth.setVisible(true);
            this.lblBeginMonth.setVisible(true);
            this.lblEndMonth.setVisible(true);
            FMClientHelper.initSpinFromTO((KDSpinner)this.spiFromYear, (KDSpinner)this.spiFromMonth, (KDSpinner)this.spiToYear, (KDSpinner)this.spiToMonth);
        } else if (this.rdbByQuarter.isSelected()) {
            this.spiFromMonth.setVisible(true);
            this.spiToMonth.setVisible(true);
            this.lblBeginQuarter.setVisible(true);
            this.lblEndQuarter.setVisible(true);
            SpinnerNumberModel mModel = new SpinnerNumberModel(thisQuarter, 1, 4, 1);
            SpinnerNumberModel mModel1 = new SpinnerNumberModel(thisQuarter, 1, 4, 1);
            this.spiFromMonth.setModel((SpinnerModel)mModel);
            this.spiToMonth.setModel((SpinnerModel)mModel1);
        }
    }

    public Object getParam() {
        InnerAvgAnalysisParam para = new InnerAvgAnalysisParam();
        String[] companyIds = this.getCompanyIds();
        para.setCompanyIds(companyIds);
        if (this.cboCurrency.getSelectedItem() != null && !(this.cboCurrency.getSelectedItem() instanceof FMSysDefinedEnum)) {
            para.setCurrencyId(((CurrencyInfo)this.cboCurrency.getSelectedItem()).getId().toString());
        }
        if (!(this.cboCurrency.getSelectedItem() instanceof FMSysDefinedEnum)) {
            para.setCurrencyName((String)AccessHelper.getCboAttribute((KDComboBox)this.cboCurrency, (String)"name"));
        } else {
            para.setCurrencyName(FMSysDefinedEnum.SELECT_ALL.getAlias());
        }
        para.setFromDate(this.dtpDateFrom.getSqlDate());
        para.setToDate(this.dtpDateTo.getSqlDate());
        para.setIA(this.chkIA.isSelected());
        para.setBeginMonth(AccessHelper.getSpiValue((KDSpinner)this.spiFromMonth));
        para.setBeginYear(AccessHelper.getSpiValue((KDSpinner)this.spiFromYear));
        para.setEndMonth(AccessHelper.getSpiValue((KDSpinner)this.spiToMonth));
        para.setEndYear(AccessHelper.getSpiValue((KDSpinner)this.spiToYear));
        para.setAvgType(((IntEnum)this.cboType.getSelectedItem()).getValue());
        if (this.rdbByCompany.isSelected()) {
            para.setOrder(0);
        } else if (this.rdbPeriod.isSelected()) {
            para.setOrder(1);
        } else {
            para.setOrder(2);
        }
        if (this.rdbByMonth.isSelected()) {
            para.setAvgRptType(0);
        } else if (this.rdbByQuarter.isSelected()) {
            para.setAvgRptType(1);
        } else if (this.rdbByYear.isSelected()) {
            para.setAvgRptType(2);
        } else {
            para.setAvgRptType(3);
        }
        para.setAccountPropertyIds(AccessHelper.getF7Ids((KDBizPromptBox)this.prmtAccountProperty));
        para.setInnerAccountIds(AccessHelper.getF7Ids((KDBizPromptBox)this.prmtInnerAccount));
        return para;
    }

    public void setParam(Object param) {
        Object coll;
        FilterInfo filter;
        EntityViewInfo ev;
        Set set;
        if (param == null) {
            return;
        }
        if (!(param instanceof InnerAvgAnalysisParam)) {
            return;
        }
        InnerAvgAnalysisParam filterParam = (InnerAvgAnalysisParam)param;
        String[] companyIds = filterParam.getCompanyIds();
        try {
            this.setCompanyIds(companyIds);
        }
        catch (Exception e) {
            this.handUIException(e);
            SysUtil.abort((Throwable)e);
        }
        String currencyId = filterParam.getCurrencyId();
        CurrencyInfo currencyInfo = null;
        try {
            if (currencyId != null) {
                ICurrency iCurrency = CurrencyFactory.getRemoteInstance();
                currencyInfo = iCurrency.getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyId));
                FMClientHelper.setSelectObject((KDComboBox)this.cboCurrency, (Object)currencyInfo);
            } else {
                this.cboCurrency.setSelectedItem((Object)FMSysDefinedEnum.SELECT_ALL);
            }
        }
        catch (Exception e1) {
            SysUtil.abort((Throwable)e1);
        }
        this.dtpDateFrom.setValue((Object)filterParam.getFromDate());
        this.dtpDateTo.setValue((Object)filterParam.getToDate());
        this.chkIA.setSelected(filterParam.isIA());
        this.spiFromYear.setValue((Object)new Integer(filterParam.getBeginYear()));
        this.spiFromMonth.setValue((Object)new Integer(filterParam.getBeginMonth()));
        this.spiToYear.setValue((Object)new Integer(filterParam.getEndYear()));
        this.spiToMonth.setValue((Object)new Integer(filterParam.getEndMonth()));
        this.cboType.setSelectedItem((Object)AvgTypeEnum.getEnum(filterParam.getAvgType()));
        if (filterParam.getOrder() == 0) {
            this.rdbByCompany.setSelected(true);
        } else if (filterParam.getOrder() == 1) {
            this.rdbPeriod.setSelected(true);
        } else {
            this.rdbType.setSelected(true);
        }
        if (filterParam.getAvgRptType() == 0) {
            this.rdbByMonth.setSelected(true);
        } else if (filterParam.getAvgRptType() == 1) {
            this.rdbByQuarter.setSelected(true);
        } else if (filterParam.getAvgRptType() == 2) {
            this.rdbByYear.setSelected(true);
        } else {
            this.rdbByYear.setSelected(true);
        }
        if (!FMHelper.isEmpty((Object[])filterParam.getAccountPropertyIds())) {
            set = FMHelper.asSet((String[])filterParam.getAccountPropertyIds());
            ev = new EntityViewInfo();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)set, CompareType.INCLUDE));
            ev.setFilter(filter);
            try {
                coll = AccountPropertyFactory.getRemoteInstance().getAccountPropertyCollection(ev);
                this.prmtAccountProperty.setData((Object)coll.toArray());
            }
            catch (BOSException e) {
                this.handUIException(e);
                SysUtil.abort();
            }
        }
        if (!FMHelper.isEmpty((Object[])filterParam.getInnerAccountIds())) {
            set = FMHelper.asSet((String[])filterParam.getInnerAccountIds());
            ev = new EntityViewInfo();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)set, CompareType.INCLUDE));
            ev.setFilter(filter);
            try {
                coll = InnerAccountFactory.getRemoteInstance().getInnerAccountCollection(ev);
                this.prmtInnerAccount.setData((Object)coll.toArray());
            }
            catch (BOSException e) {
                this.handUIException(e);
                SysUtil.abort();
            }
        }
    }

    public boolean verify() {
        if (this.getCompanyIds() == null || this.getCompanyIds().length == 0) {
            this.btnCompanySelect.requestFocus(true);
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"NoOrgUnit"));
            SysUtil.abort();
        }
        try {
            BankInfo bankInfo = (BankInfo)this.paramMap.get("clearingHouse");
            if (!bankInfo.isUsed()) {
                this.btnCompanySelect.requestFocus(true);
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath1, (String)"ClearingHouseNotUsed"));
                SysUtil.abort();
            }
        }
        catch (Exception e) {
            this.handUIException(e);
            SysUtil.abort();
        }
        if (this.rdbByMonth.isSelected() || this.rdbByQuarter.isSelected()) {
            if (AccessHelper.getSpiValue((KDSpinner)this.spiFromYear) * 12 + AccessHelper.getSpiValue((KDSpinner)this.spiFromMonth) > AccessHelper.getSpiValue((KDSpinner)this.spiToYear) * 12 + AccessHelper.getSpiValue((KDSpinner)this.spiToMonth)) {
                this.spiFromYear.requestFocus(true);
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath1, (String)"CheckDateFromTo"));
                SysUtil.abort();
            }
        } else if (this.rdbByYear.isSelected()) {
            if (AccessHelper.getSpiValue((KDSpinner)this.spiFromYear) > AccessHelper.getSpiValue((KDSpinner)this.spiToYear)) {
                this.spiFromYear.requestFocus(true);
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath1, (String)"CheckDateFromTo"));
                SysUtil.abort();
            }
        } else {
            FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (String)resourcePath1, (KDDatePicker)this.dtpDateTo, (String)"NoDate");
            FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (String)resourcePath1, (KDDatePicker)this.dtpDateFrom, (String)"NoDate");
            if (this.dtpDateTo.getSqlDate().before(this.dtpDateFrom.getSqlDate())) {
                this.dtpDateFrom.requestFocus(true);
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath1, (String)"CheckDateFromTo"));
                SysUtil.abort();
            }
        }
        return true;
    }

    protected void initCompanyState() {
        super.initCompanyState();
        if (FSClientHelper.isClearingHouseCompanyId(null)) {
            this.chkIA.setEnabled(true);
            this.btnCompanySelect.setEnabled(true);
            this.btnCompanySelect.setVisible(true);
        }
    }

    protected void companyValueChange(Object object) throws Exception {
        Object[] array = (Object[])object;
        Object[] result = FMClientHelper.removeVirtualCompany((Object[])array);
        super.companyValueChange((Object)result);
    }

    protected void setDefaultValue() {
        super.setDefaultValue();
        FMClientHelper.initSpinFromTO((KDSpinner)this.spiFromYear, (KDSpinner)this.spiFromMonth, (KDSpinner)this.spiToYear, (KDSpinner)this.spiToMonth);
        if (this.paramMap.get("currentCompany") == null) {
            CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
            try {
                FMClientHelper.setSelectObject((KDComboBox)this.cboCurrency, (Object)ContextHelperFactory.getRemoteInstance().getCompanyBaseCurrency(company));
            }
            catch (EASBizException e) {
                this.handUIException(e);
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        } else {
            FMClientHelper.setSelectObject((KDComboBox)this.cboCurrency, (Object)((CompanyOrgUnitInfo)this.paramMap.get("currentCompany")).getBaseCurrency());
        }
        try {
            if (this.coll == null) {
                this.coll = InAcctFactory.getRemoteInstance().getInAcctApplyCompany();
            }
            this.setCompanyIdSet(AccessHelper.getIds((Object[])this.coll.toArray()));
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        this.rdbByMonth.setSelected(true);
        this.rdbByQuarter.setSelected(false);
        this.rdbByYear.setSelected(false);
        this.prmtAccountProperty.setValue(null);
        this.prmtInnerAccount.setValue(null);
    }

    @Override
    protected void rdbByDate_stateChanged(ChangeEvent e) throws Exception {
        this.palDate.setVisible(false);
        this.palOther.setVisible(false);
        if (this.rdbByDate.isSelected()) {
            this.palDate.setVisible(true);
            if (this.dtpDateTo.getValue() == null || this.dtpDateFrom.getValue() == null) {
                Calendar date = Calendar.getInstance();
                this.dtpDateTo.setValue((Object)date.getTime());
                this.dtpDateFrom.setValue((Object)date.getTime());
            }
        } else {
            this.palOther.setVisible(true);
        }
    }

    @Override
    protected void prmtAccountProperty_dataChanged(DataChangeEvent e) throws Exception {
        this.prmtInnerAccount.setValue(null);
    }

    @Override
    protected void prmtInnerAccount_willShow(SelectorEvent e) throws Exception {
        Object[] innerAccoutF7Ids = AccessHelper.getF7Ids((KDBizPromptBox)this.prmtAccountProperty);
        this.prmtInnerAccount.setQueryInfo("com.kingdee.eas.fm.fs.F7InnerAccountQuery");
        this.prmtInnerAccount.setDisplayFormat("$name$");
        this.prmtInnerAccount.setEditFormat("$number$");
        this.prmtInnerAccount.setCommitFormat("$number$");
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("clearingHouse.relatedCompany.id", (Object)FMBillUtil.getCurrentCompany().getId()));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("applyUnit.id", (Object)FMHelper.asSet((String[])this.companyIds), CompareType.INCLUDE));
        if (!FMHelper.isEmpty((Object[])innerAccoutF7Ids)) {
            Set idSet = FMHelper.asSet((String[])innerAccoutF7Ids);
            evi.getFilter().getFilterItems().add(new FilterItemInfo("type.id", (Object)idSet, CompareType.INCLUDE));
        }
        this.prmtInnerAccount.setEntityViewInfo(evi);
        this.prmtInnerAccount.setEnabledMultiSelection(true);
        this.prmtInnerAccount.setDisplay(true);
        this.prmtInnerAccount.setEditable(false);
        this.prmtInnerAccount.getQueryAgent().resetRuntimeEntityView();
    }

    protected Class getParamClass() {
        return InnerAvgAnalysisParam.class;
    }
}

