/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.fs.DailyBalanceFormCollection;
import com.kingdee.eas.fm.fs.DailyBalanceFormFactory;
import com.kingdee.eas.fm.fs.FSSwitchFactory;
import com.kingdee.eas.fm.fs.FSSwitchStatusEnum;
import com.kingdee.eas.fm.fs.IDailyBalanceForm;
import com.kingdee.eas.fm.fs.IFSSwitch;
import com.kingdee.eas.fm.fs.client.AbstractOpenUI;
import com.kingdee.eas.fm.fs.client.FSClientHelper;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Date;
import org.apache.log4j.Logger;

public class OpenUI
extends AbstractOpenUI {
    public static final String resourcePath = "com.kingdee.eas.fm.fs.client.SwitchResource";
    private static final Logger logger = CoreUIObject.getLogger(OpenUI.class);

    @Override
    public void actionOpen_actionPerformed(ActionEvent e) throws Exception {
        super.actionOpen_actionPerformed(e);
        if (this.hasNotSettleBTable()) {
            if (MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"IfDeleteBalane")))) {
                this.deleteBTable();
            } else {
                this.destroyWindow();
                return;
            }
        }
        if (this.IsSettled()) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"IsSettled"));
            this.abort();
        }
        IFSSwitch biz = FSSwitchFactory.getRemoteInstance();
        MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"OpenSuccess"));
        this.destroyWindow();
    }

    private void deleteBTable() {
        try {
            IDailyBalanceForm iDailyBalance = DailyBalanceFormFactory.getRemoteInstance();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("isSettled", (Object)new Integer(0)));
            iDailyBalance.delete(filter);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        try {
            DailyBalanceFormFactory.getRemoteInstance().deleteDailyBalance(null);
        }
        catch (EASBizException e1) {
            logger.error((Object)e1.getMessage(), (Throwable)e1);
        }
        catch (BOSException e1) {
            logger.error((Object)e1.getMessage(), (Throwable)e1);
        }
    }

    private boolean hasNotSettleBTable() {
        try {
            IDailyBalanceForm iDailyBalance = DailyBalanceFormFactory.getRemoteInstance();
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("isSettled", (Object)new Integer(0)));
            filter.getFilterItems().add(new FilterItemInfo("isSettled", null));
            filter.setMaskString("#0 or #1");
            view.setFilter(filter);
            DailyBalanceFormCollection co = iDailyBalance.getDailyBalanceFormCollection(view);
            if (co.size() > 0) {
                return true;
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return false;
    }

    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        this.destroyWindow();
    }

    public void onLoad() throws Exception {
        FSClientHelper.checkClearingHouseCompany();
        super.onLoad();
        this.cboState.setSelectedItem((Object)FSSwitchStatusEnum.CLOSED);
        if (FSClientHelper.clearingHouseIsOpen()) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"switchIsOpen"));
            this.abort();
        }
        this.dptDate.setValue((Object)FSClientHelper.getClearingHouse().getSettleDate());
    }

    private boolean IsSettled() {
        Date openDate = DateTimeUtils.truncateDate((Date)this.dptDate.getSqlDate());
        try {
            IDailyBalanceForm iDailyBalance = DailyBalanceFormFactory.getRemoteInstance();
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("isSettled", (Object)new Integer(1)));
            filter.getFilterItems().add(new FilterItemInfo("date", (Object)openDate));
            view.setFilter(filter);
            DailyBalanceFormCollection co = iDailyBalance.getDailyBalanceFormCollection(view);
            if (co.size() > 0) {
                return true;
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return false;
    }
}

