/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.IRptHandler;
import com.kingdee.eas.fm.fs.SettBizTypeEnum;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.util.Calendar;
import java.util.Date;

public class OutstandingHandler
implements IRptHandler {
    private String resourcePath = "com.kingdee.eas.fm.fs.FSClientResource";

    public void fillData(KDTable tblMain, EntityViewInfo evi, IMetaDataPK mainQueryPK) throws Exception {
        IRowSet rowSet = FMClientHelper.getRowSet((IMetaDataPK)mainQueryPK, (EntityViewInfo)evi);
        this.dealFillData(tblMain, rowSet);
        this.statAmount(tblMain);
    }

    private void statAmount(KDTable tblMain) {
        tblMain.getColumn("companyName").setGroup(true);
        tblMain.getColumn("currencyName").setGroup(true);
        tblMain.getColumn("companyName").setMergeable(false);
        tblMain.getColumn("currencyName").setMergeable(false);
        tblMain.getColumn("currencyName").setStat(true);
        IRow row = tblMain.getGroupManager().getStatRowTemplate(1);
        row.getStyleAttributes().setBackground(FMClientHelper.KDTABLE_TOTAL_BG_COLOR);
        row.getCell("companyName").setExpressions("=cell(ROW_INDEX-1,COLUMN_INDEX).getValue()");
        row.getCell("bizDate").setValue((Object)EASResource.getString((String)this.resourcePath, (String)"Total"));
        IRow rowBefore = tblMain.getRow(row.getRowIndex() - 1);
        if (rowBefore != null) {
            String currencyID = rowBefore.getCell("currencyName").getUserObject().toString();
            FMClientHelper.setNumberFormat((IRow)row, (String)"payeeAmount", (String)currencyID);
            FMClientHelper.setNumberFormat((IRow)row, (String)"payerAmount", (String)currencyID);
            FMClientHelper.setNumberFormat((IRow)row, (String)"totalAmount", (String)currencyID);
        }
        row.getCell("payeeAmount").setExpressions("SUM");
        row.getCell("payerAmount").setExpressions("SUM");
        row.getCell("totalAmount").setExpressions("=cell(ROW_INDEX,COLUMN_INDEX-2).getValue()-cell(ROW_INDEX,COLUMN_INDEX-1).getValue()");
        tblMain.getGroupManager().group();
        tblMain.reLayoutAndPaint();
    }

    private void dealFillData(KDTable tblMain, IRowSet rowSet) throws Exception {
        tblMain.removeRows();
        Calendar cal = Calendar.getInstance();
        Date curDate = DateUtil.getDayBegin();
        java.sql.Date createDate = null;
        java.sql.Date acctDate = null;
        long days = 0L;
        while (rowSet.next()) {
            String billID = rowSet.getString("id");
            int type = rowSet.getInt("type");
            int dc = 0;
            if (type == 1) {
                dc = 1;
            } else if (type == 2) {
                dc = -1;
            }
            if (this.isReachableBill(billID)) continue;
            IRow row = tblMain.addRow();
            row.getCell("id").setValue((Object)rowSet.getString("id"));
            row.getCell("companyName").setValue((Object)rowSet.getString("applyUnit.name"));
            row.getCell("number").setValue((Object)rowSet.getString("number"));
            createDate = rowSet.getDate("bizDate");
            acctDate = rowSet.getDate("acceptedDate");
            row.getCell("bizDate").setValue((Object)createDate);
            row.getCell("acceptedDate").setValue((Object)acctDate);
            if (createDate != null) {
                days = DateTimeUtils.dateDiff((String)"d", (Date)DateTimeUtils.truncateDate((Date)createDate), (Date)curDate);
            }
            if (acctDate != null) {
                days = DateTimeUtils.dateDiff((String)"d", (Date)acctDate, (Date)curDate);
            }
            row.getCell("days").setValue((Object)new Long(days));
            row.getCell("type").setValue((Object)SettBizTypeEnum.getEnum(type).getAlias());
            String payeeBankAcct = rowSet.getString("payeeBankAcct.name");
            if (payeeBankAcct == null || payeeBankAcct.equals("")) {
                payeeBankAcct = rowSet.getString("payeeBankAcctNum");
            }
            row.getCell("payeeBankAcct").setValue((Object)payeeBankAcct);
            String payerBankAcct = rowSet.getString("payerBankAcct.name");
            if (payerBankAcct == null || payerBankAcct.equals("")) {
                payerBankAcct = rowSet.getString("payerBankAcctNum");
            }
            row.getCell("payerBankAcct").setValue((Object)payerBankAcct);
            row.getCell("currencyName").setValue((Object)rowSet.getString("currency.name"));
            row.getCell("currencyName").setUserObject((Object)rowSet.getString("currency.id"));
            FMClientHelper.setNumberFormat((IRow)row, (String)"payeeAmount", (String)rowSet.getString("currency.id"));
            FMClientHelper.setNumberFormat((IRow)row, (String)"payerAmount", (String)rowSet.getString("currency.id"));
            if (dc == 1) {
                row.getCell("payeeAmount").setValue((Object)rowSet.getBigDecimal("payeeAmount"));
                continue;
            }
            if (dc != -1) continue;
            row.getCell("payerAmount").setValue((Object)rowSet.getBigDecimal("payerAmount"));
        }
    }

    private boolean isReachableBill(String billID) {
        return false;
    }
}

