/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDTextArea;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.fs.IReceiveAccount;
import com.kingdee.eas.fm.fs.ReceiveAccountCollection;
import com.kingdee.eas.fm.fs.ReceiveAccountFactory;
import com.kingdee.eas.fm.fs.client.AbstractReceiveAccountCheckUI;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class ReceiveAccountCheckUI
extends AbstractReceiveAccountCheckUI {
    private static final Logger logger = CoreUIObject.getLogger(ReceiveAccountCheckUI.class);
    private static final String ID_SET = "idSet";
    private static final String DISPOSE_MODE = "disposeMode";
    private int result = 0;
    private Set idSet = null;
    private int disposeMode = 0;

    public void onLoad() throws Exception {
        super.onLoad();
        this.idSet = (Set)this.getUIContext().get(ID_SET);
        this.disposeMode = (Integer)this.getUIContext().get(DISPOSE_MODE);
        this.initUIProp(this.disposeMode);
    }

    private void initUIProp(int disposeMode) throws BOSException {
        this.btnSubmit.setIcon(EASResource.getIcon((String)"imgTbtn_submit"));
        this.radDispose.setVisible(false);
        this.radBack.setVisible(false);
        String resPath = "com.kingdee.eas.fm.fs.client.FsResource";
        if (disposeMode == 1) {
            this.radDispose.setVisible(true);
            this.radBack.setVisible(true);
            this.radBack.setEnabled(this.isCanBack(this.idSet));
            this.setUITitle(EASResource.getString((String)resPath, (String)"Check"));
        } else {
            this.setUITitle(EASResource.getString((String)resPath, (String)"BackBill"));
        }
    }

    private boolean isCanBack(Set idSet) throws BOSException {
        ReceiveAccountCollection coll = this.getColl(idSet);
        boolean isCanBack = true;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            if (!coll.get(i).isIsBackBill()) continue;
            isCanBack = false;
            break;
        }
        return isCanBack;
    }

    private ReceiveAccountCollection getColl(Set idSet) throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSelector().add(new SelectorItemInfo("*"));
        IReceiveAccount iReceiveAcct = ReceiveAccountFactory.getRemoteInstance();
        return iReceiveAcct.getReceiveAccountCollection(evi);
    }

    public static IUIWindow showDialogWindows(IUIObject ui, Set idSet, int disposeMode) throws UIException {
        if (idSet == null || idSet.isEmpty()) {
            return null;
        }
        UIContext uiContext = new UIContext((Object)ui);
        uiContext.put((Object)ID_SET, (Object)idSet);
        uiContext.put((Object)DISPOSE_MODE, (Object)new Integer(disposeMode));
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(ReceiveAccountCheckUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
        return uiWindow;
    }

    @Override
    protected void radDispose_actionPerformed(ActionEvent e) throws Exception {
    }

    @Override
    protected void radBack_actionPerformed(ActionEvent e) throws Exception {
    }

    private int getCheckMode() {
        if (this.radDispose.isSelected()) {
            return 10;
        }
        return 11;
    }

    private void verify() {
        String resPath = "com.kingdee.eas.fm.fs.client.FsResource";
        String resName = "Result";
        String msg = EASResource.getString((String)resPath, (String)resName);
        if (this.disposeMode == 1 && this.getCheckMode() == 11) {
            FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDTextArea)this.txtResult, (String)msg);
        } else if (this.disposeMode == 2) {
            FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDTextArea)this.txtResult, (String)msg);
        }
    }

    @Override
    protected void btnSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.verify();
        IReceiveAccount iReceiveAcct = ReceiveAccountFactory.getRemoteInstance();
        String desc = this.txtResult.getText();
        if (this.disposeMode == 1) {
            iReceiveAcct.check(this.idSet, this.getCheckMode(), desc);
        } else if (this.disposeMode == 2) {
            iReceiveAcct.backBill(this.idSet, desc);
        } else {
            return;
        }
        this.result = 1;
        FMClientHelper.showSuccessInfo((Component)((Object)this), (Component)((Component)e.getSource()));
        this.disposeUIWindow();
    }

    public int getResult() {
        return this.result;
    }
}

