/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FilterParam;
import com.kingdee.eas.fm.fs.InnerAccountCollection;
import com.kingdee.eas.fm.fs.InnerAccountFactory;
import com.kingdee.eas.fm.fs.client.FSClientHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.TypeConversionUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class ReconcileDetailParam
implements FilterParam {
    private int beginYear;
    private int endYear;
    private int beginPeriod;
    private int endPeriod;
    private String companyId;
    private String currencyId;
    private boolean isByPeriod;
    private Date beginDate;
    private Date endDate;
    private boolean isIncludeUnPostVoucher;
    private static final Logger logger = CoreUIObject.getLogger(ReconcileDetailParam.class);
    private BigDecimal beginBalanceDiff;
    private BigDecimal diff;
    private BigDecimal endBalanceDiff;
    private Set innAcctSet = new HashSet();

    public boolean isIncludeUnPostVoucher() {
        return this.isIncludeUnPostVoucher;
    }

    public void setIncludeUnPostVoucher(boolean isIncludeUnPostVoucher) {
        this.isIncludeUnPostVoucher = isIncludeUnPostVoucher;
    }

    public BigDecimal getBeginBalanceDiff() {
        return this.beginBalanceDiff;
    }

    public void setBeginBalanceDiff(BigDecimal beginBalanceDiff) {
        this.beginBalanceDiff = beginBalanceDiff;
    }

    public BigDecimal getDiff() {
        return this.diff;
    }

    public void setDiff(BigDecimal diff) {
        this.diff = diff;
    }

    public BigDecimal getEndBalanceDiff() {
        return this.endBalanceDiff;
    }

    public void setEndBalanceDiff(BigDecimal endBalanceDiff) {
        this.endBalanceDiff = endBalanceDiff;
    }

    public FilterInfo getFilter() {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("currency.Id", (Object)this.getCurrencyId()));
        if (this.isByPeriod()) {
            GregorianCalendar beginDate = new GregorianCalendar(this.getBeginYear(), this.getBeginPeriod() - 1, 1);
            filter.getFilterItems().add(new FilterItemInfo("date", (Object)beginDate.getTime(), CompareType.GREATER_EQUALS));
            GregorianCalendar endDate = new GregorianCalendar(this.getEndYear(), this.getEndPeriod(), 0);
            filter.getFilterItems().add(new FilterItemInfo("date", (Object)endDate.getTime(), CompareType.LESS_EQUALS));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("date", (Object)DateTimeUtils.truncateDate((Date)this.getBeginDate()), CompareType.GREATER_EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("date", (Object)DateTimeUtils.truncateDate((Date)this.getEndDate()), CompareType.LESS_EQUALS));
        }
        CompanyOrgUnitInfo clearingHouseCompany = null;
        try {
            clearingHouseCompany = FSClientHelper.getClearingHouseCompany();
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            SysUtil.abort();
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            SysUtil.abort();
        }
        if (clearingHouseCompany == null) {
            SysUtil.abort();
        }
        filter.getFilterItems().add(new FilterItemInfo("company.Id", (Object)this.getCompanyId()));
        filter.getFilterItems().add(new FilterItemInfo("innerAccount.id", (Object)this.innAcctSet, CompareType.INCLUDE));
        return filter;
    }

    public int getBeginPeriod() {
        return this.beginPeriod;
    }

    public void setBeginPeriod(int beginPeriod) {
        this.beginPeriod = beginPeriod;
    }

    public int getBeginYear() {
        return this.beginYear;
    }

    public void setBeginYear(int beginYear) {
        this.beginYear = beginYear;
    }

    public int getEndPeriod() {
        return this.endPeriod;
    }

    public void setEndPeriod(int endPeriod) {
        this.endPeriod = endPeriod;
    }

    public int getEndYear() {
        return this.endYear;
    }

    public void setEndYear(int endYear) {
        this.endYear = endYear;
    }

    public String getCompanyId() {
        return this.companyId;
    }

    public void setCompanyId(String companyId) {
        this.companyId = companyId;
    }

    public String getCurrencyId() {
        return this.currencyId;
    }

    public void setCurrencyId(String currencyId) {
        this.currencyId = currencyId;
    }

    public SorterItemCollection getSorterItems() {
        return null;
    }

    public Set getContrastAcct(boolean isCH) throws BOSException, SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append("select faccountlinkid as acctId from T_BD_KAClassificationDetail  where fkaclassficlink in ( select  ");
        if (!isCH) {
            sql.append("FClientClassifictionID from t_fs_inneraccount ");
            sql.append("where fapplyUnitid ='");
            sql.append(this.getCompanyId()).append("'");
        } else {
            sql.append("fclhclassificationid from t_fs_inneraccount ");
        }
        sql.append(")");
        sql.append(" and faccountitemlinkid ='");
        sql.append("00000000-0000-0000-0000-000000000035F9F423C0").append("'");
        ISQLExecutor iExe = SQLExecutorFactory.getRemoteInstance((String)sql.toString());
        IRowSet rs = iExe.executeSQL();
        HashSet<String> acctIds = new HashSet<String>();
        while (rs.next()) {
            String acctId = rs.getString("acctId");
            if (acctId != null) {
                acctIds.add(acctId);
                continue;
            }
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.fs.client.ReconcileResource", (String)"KAClassificationError"));
            SysUtil.abort();
        }
        if (acctIds.size() == 0) {
            return null;
        }
        CtrlUnitInfo cu = ContextHelperFactory.getRemoteInstance().getCurrentCtrlUnit();
        return FMHelper.getAllRefAcctIdSet(null, (String)cu.getId().toString(), acctIds);
    }

    public FilterInfo getGLFilter() {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)this.getCurrencyId()));
        filter.getFilterItems().add(new FilterItemInfo("bizStatus", (Object)new Integer(5)));
        if (this.isByPeriod()) {
            GregorianCalendar beginDate = new GregorianCalendar(this.getBeginYear(), this.getBeginPeriod() - 1, 1);
            filter.getFilterItems().add(new FilterItemInfo("bookedDate", (Object)TypeConversionUtils.objToDate((Object)beginDate.getTime()), CompareType.GREATER_EQUALS));
            GregorianCalendar endDate = new GregorianCalendar(this.getEndYear(), this.getEndPeriod(), 0);
            filter.getFilterItems().add(new FilterItemInfo("bookedDate", (Object)TypeConversionUtils.objToDate((Object)endDate.getTime()), CompareType.LESS_EQUALS));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("bookedDate", (Object)DateTimeUtils.truncateDate((Date)this.getBeginDate()), CompareType.GREATER_EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("bookedDate", (Object)DateTimeUtils.truncateDate((Date)this.getEndDate()), CompareType.LESS_EQUALS));
        }
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.getCompanyId()));
        try {
            Set contrastAcct = this.getContrastAcct(this.getInnAcctColl());
            FilterInfo infiliter = new FilterInfo();
            infiliter.getFilterItems().add(new FilterItemInfo("innerAccount.id", (Object)AccessHelper.getIds((Object[])this.getInnAcctColl().toArray()), CompareType.INCLUDE));
            if (contrastAcct.size() > 0) {
                infiliter.getFilterItems().add(new FilterItemInfo("accountId", (Object)contrastAcct, CompareType.INCLUDE));
                infiliter.setMaskString("#0 or #1");
            }
            filter.mergeFilter(infiliter, "and");
        }
        catch (BOSException e1) {
            logger.error((Object)e1.getMessage(), (Throwable)e1);
            SysUtil.abort();
        }
        return filter;
    }

    private Set getContrastAcct(InnerAccountCollection innAcctColl2) throws BOSException {
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < innAcctColl2.size(); ++i) {
            set.add(innAcctColl2.get(i).getAcctView().getId().toString());
        }
        HashSet<String> rst = new HashSet<String>();
        for (String id : set) {
            if (FMHelper.hasAsstInnerAcct(null, (String)id)) continue;
            rst.add(id);
        }
        return rst;
    }

    public InnerAccountCollection getInnAcctColl() {
        InnerAccountCollection innerAcctColl = new InnerAccountCollection();
        if (this.innAcctSet != null && this.innAcctSet.size() > 0) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)this.innAcctSet, CompareType.INCLUDE));
            view.setFilter(filter);
            view.getSelector().add("*");
            try {
                innerAcctColl = InnerAccountFactory.getRemoteInstance().getInnerAccountCollection(view);
            }
            catch (BOSException e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
        return innerAcctColl;
    }

    public void setInnAcctColl(InnerAccountCollection innAcctColl) {
        if (innAcctColl != null && innAcctColl.size() > 0) {
            this.innAcctSet.clear();
            for (int i = 0; i < innAcctColl.size(); ++i) {
                this.innAcctSet.add(innAcctColl.get(i).getId().toString());
            }
        }
    }

    public Date getBeginDate() {
        return this.beginDate;
    }

    public void setBeginDate(Date beginDate) {
        this.beginDate = beginDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public boolean isByPeriod() {
        return this.isByPeriod;
    }

    public void setByPeriod(boolean isByPeriod) {
        this.isByPeriod = isByPeriod;
    }
}

