/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.cas.CasConstants;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.fs.InnerAccountCollection;
import com.kingdee.eas.fm.fs.SubsidiaryBillTypeEnum;
import com.kingdee.eas.fm.fs.client.AbstractReconcileDetailUI;
import com.kingdee.eas.fm.fs.client.FSAnalysisHandlerFactory;
import com.kingdee.eas.fm.fs.client.FSClientHelper;
import com.kingdee.eas.fm.fs.client.ReconcileDetailHandler;
import com.kingdee.eas.fm.fs.client.ReconcileDetailParam;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.TypeConversionUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.JCheckBox;
import org.apache.log4j.Logger;

public class ReconcileDetailUI
extends AbstractReconcileDetailUI {
    private String resourcePath = "com.kingdee.eas.fm.fs.client.ReconcileResource";
    private static final Logger logger = CoreUIObject.getLogger(ReconcileDetailUI.class);
    private Boolean currencyShowStatus = Boolean.FALSE;
    ReconcileDetailHandler handler;
    private static int group;
    CompanyOrgUnitInfo clearingHouse = FSClientHelper.getClearingHouseCompany();
    boolean isClearingHouse;
    private ReconcileDetailParam param;
    private String loc;

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblGLDetail.checkParsed();
        this.tblInnerDetail.checkParsed();
        this.tblGLDetail.addColumn().setKey("group");
        this.tblInnerDetail.addColumn().setKey("group");
        this.tblGLDetail.getColumn("group").getStyleAttributes().setHided(true);
        this.tblInnerDetail.getColumn("group").getStyleAttributes().setHided(true);
        this.actionQuery.setVisible(false);
        this.actionRefresh.setVisible(false);
        this.txtBeginBalanceDiff.setDataType(1);
        this.txtDiff.setDataType(1);
        this.txtEndBalanceDiff.setDataType(1);
    }

    public static void showDialogWindow(IUIObject ui, ReconcileDetailParam param) throws Exception {
        UIContext uiContext = new UIContext((Object)ui);
        uiContext.put((Object)"filterParam", (Object)param);
        String innerAcctString = "";
        InnerAccountCollection innerAcctColl = param.getInnAcctColl();
        int size = innerAcctColl.size();
        for (int i = 0; i < size; ++i) {
            innerAcctString = innerAcctString + innerAcctColl.get(i).getId().toString();
        }
        uiContext.put((Object)"innerAcctString", (Object)innerAcctString);
        uiContext.put((Object)"isDirectShow", (Object)new Boolean(true));
        IUIWindow uiWindow = null;
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(ReconcileDetailUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    @Override
    public void actionAutoContrast_actionPerformed(ActionEvent e) throws Exception {
        this.autoContrast(e);
    }

    private void autoContrast(ActionEvent e) throws Exception {
        super.actionAutoContrast_actionPerformed(e);
        long t1 = System.currentTimeMillis();
        int count = this.tblInnerDetail.getRowCount();
        for (int i = 0; i < count; ++i) {
            IRow[] searchRows;
            ++group;
            IRow rowIn = this.tblInnerDetail.getRow(i);
            if (((Boolean)rowIn.getCell("isContrasted").getValue()).booleanValue() || (searchRows = this.searchRowInGL(rowIn)).length == 0) continue;
            IRow rowGL = searchRows[0];
            ArrayList<IRow> fullRows = new ArrayList<IRow>();
            rowIn.getCell("group").setValue((Object)new Integer(group));
            rowGL.getCell("group").setValue((Object)new Integer(group));
            fullRows.add(rowIn);
            fullRows.add(rowGL);
            this.changeAssociateState(fullRows);
            this.changeContrastState(fullRows, true);
        }
        long t2 = System.currentTimeMillis();
        logger.info((Object)((t2 - t1) / 1000L + "s1"));
        this.refreshList();
        long t3 = System.currentTimeMillis();
        logger.info((Object)((t3 - t2) / 1000L + " s2"));
    }

    @Override
    public void actionAutoSearch_actionPerformed(ActionEvent e) throws Exception {
        List inSelectedRows = this.getInSelectedRows();
        List glSelectedRows = this.getGlSelectedRows();
        if (inSelectedRows.size() > 0) {
            int i;
            for (i = 0; i < this.tblGLDetail.getRowCount(); ++i) {
                this.tblGLDetail.getRow(i).getStyleAttributes().setHided(true);
            }
            for (i = 0; i < inSelectedRows.size(); ++i) {
                IRow rowIn = (IRow)inSelectedRows.get(i);
                IRow[] rows = this.searchRowInGL(rowIn);
                for (int j = 0; j < rows.length; ++j) {
                    rows[j].getStyleAttributes().setHided(false);
                }
                this.tblGLDetail.getColumn("selected").getStyleAttributes().setLocked(false);
            }
        } else if (glSelectedRows.size() > 0) {
            int i;
            for (i = 0; i < this.tblInnerDetail.getRowCount(); ++i) {
                this.tblInnerDetail.getRow(i).getStyleAttributes().setHided(true);
            }
            for (i = 0; i < glSelectedRows.size(); ++i) {
                IRow rowIn = (IRow)glSelectedRows.get(i);
                IRow[] rows = this.searchRowInInner(rowIn);
                for (int j = 0; j < rows.length; ++j) {
                    rows[j].getStyleAttributes().setHided(false);
                }
            }
            this.tblInnerDetail.getColumn("selected").getStyleAttributes().setLocked(false);
        } else {
            return;
        }
        super.actionAutoSearch_actionPerformed(e);
    }

    @Override
    public void actionCancelContrast_actionPerformed(ActionEvent e) throws Exception {
        int i;
        List inSelectedRows = this.getInSelectedRows();
        List glSelectedRows = this.getGlSelectedRows();
        HashSet<ICell> groupSet = new HashSet<ICell>();
        if (inSelectedRows.size() > 0) {
            for (i = 0; i < inSelectedRows.size(); ++i) {
                IRow rowIn = (IRow)inSelectedRows.get(i);
                if (!((Boolean)rowIn.getCell("isContrasted").getValue()).booleanValue()) {
                    this.setMessageText(EASResource.getString((String)this.resourcePath, (String)"HasNoContrasted"));
                    this.showMessage();
                    break;
                }
                groupSet.add(rowIn.getCell("group"));
                List associateRows = (List)rowIn.getUserObject();
                this.changeContrastState(associateRows, false);
            }
        } else if (glSelectedRows.size() > 0) {
            for (i = 0; i < glSelectedRows.size(); ++i) {
                IRow rowIn = (IRow)glSelectedRows.get(i);
                if (!((Boolean)rowIn.getCell("isContrasted").getValue()).booleanValue()) continue;
                groupSet.add(rowIn.getCell("group"));
                List associateRows = (List)rowIn.getUserObject();
                this.changeContrastState(associateRows, false);
            }
        }
        List sameGroupRows = this.getTheSameGroupRows(groupSet);
        this.changeContrastState(sameGroupRows, false);
        this.changeSelectState(false);
        this.refreshList();
    }

    private List getTheSameGroupRows(Set groupSet) {
        ICell groupObj;
        IRow row;
        int i;
        ArrayList<IRow> rows = new ArrayList<IRow>();
        for (i = 0; i < this.tblInnerDetail.getRowCount(); ++i) {
            row = this.tblInnerDetail.getRow(i);
            groupObj = row.getCell("group");
            if (!groupSet.contains(groupObj)) continue;
            rows.add(row);
        }
        for (i = 0; i < this.tblGLDetail.getRowCount(); ++i) {
            row = this.tblGLDetail.getRow(i);
            groupObj = row.getCell("group");
            if (!groupSet.contains(groupObj)) continue;
            rows.add(row);
        }
        return rows;
    }

    @Override
    public void actionClearAll_actionPerformed(ActionEvent e) throws Exception {
        this.changeSelectState(false);
        super.actionClearAll_actionPerformed(e);
    }

    @Override
    public void actionManualContrast_actionPerformed(ActionEvent e) throws Exception {
        List fullRows;
        List glSelectedRows = this.getGlSelectedRows();
        List inSelectedRows = this.getInSelectedRows();
        this.verifyForContrast(glSelectedRows);
        this.verifyForContrast(inSelectedRows);
        BigDecimal inDebitAmount = this.getRowsSum(inSelectedRows, "debitAmount");
        BigDecimal increditAmount = this.getRowsSum(inSelectedRows, "creditAmount");
        BigDecimal glDebitAmount = this.getRowsSum(glSelectedRows, "debitAmount");
        BigDecimal glcreditAmount = this.getRowsSum(glSelectedRows, "creditAmount");
        BigDecimal debitAmt = inDebitAmount.add(glcreditAmount);
        BigDecimal creditAmt = increditAmount.add(glDebitAmount);
        if (debitAmt.compareTo(creditAmt) == 0) {
            ++group;
            fullRows = this.unionList(glSelectedRows, inSelectedRows);
            this.changeContrastState(fullRows, true);
            for (IRow row : fullRows) {
                row.getCell("group").setValue((Object)new Integer(group));
            }
        } else {
            this.showMessage(EASResource.getString((String)this.resourcePath, (String)"AmountNotEquel"));
            return;
        }
        this.changeAssociateState(fullRows);
        this.refreshList();
        this.changeSelectState(false);
        super.actionManualContrast_actionPerformed(e);
    }

    @Override
    public void actionSelectAll_actionPerformed(ActionEvent e) throws Exception {
        this.changeSelectState(true);
        super.actionSelectAll_actionPerformed(e);
    }

    @Override
    public void actionShowAll_actionPerformed(ActionEvent e) throws Exception {
        this.currencyShowStatus = null;
        this.refreshList();
        super.actionShowAll_actionPerformed(e);
    }

    @Override
    public void actionShowContrasted_actionPerformed(ActionEvent e) throws Exception {
        this.currencyShowStatus = Boolean.TRUE;
        this.refreshList();
        super.actionShowContrasted_actionPerformed(e);
    }

    @Override
    public void actionShowNoContrasted_actionPerformed(ActionEvent e) throws Exception {
        this.currencyShowStatus = Boolean.FALSE;
        this.refreshList();
        super.actionShowNoContrasted_actionPerformed(e);
    }

    private void changeAssociateState(List fullRows) {
        for (int i = 0; i < fullRows.size(); ++i) {
            IRow row = (IRow)fullRows.get(i);
            row.setUserObject((Object)fullRows);
        }
    }

    private void changeContrastState(List rows, boolean isContrasted) {
        for (int i = 0; i < rows.size(); ++i) {
            IRow row = (IRow)rows.get(i);
            row.getCell("isContrasted").setValue((Object)isContrasted);
        }
    }

    private void changeSelectState(boolean isSelected) {
        IRow row;
        int i;
        for (i = 0; i < this.tblGLDetail.getRowCount(); ++i) {
            row = this.tblGLDetail.getRow(i);
            if (row.getStyleAttributes().isHided()) continue;
            row.getCell("selected").setValue((Object)isSelected);
        }
        for (i = 0; i < this.tblInnerDetail.getRowCount(); ++i) {
            row = this.tblInnerDetail.getRow(i);
            if (row.getStyleAttributes().isHided()) continue;
            row.getCell("selected").setValue((Object)isSelected);
        }
    }

    protected void checkTableParsed() {
        super.checkTableParsed();
        this.tblGLDetail.checkParsed();
        this.tblInnerDetail.checkParsed();
        this.tblGLDetail.getSelectManager().setSelectMode(2);
        this.tblGLDetail.getStyleAttributes().setLocked(true);
        this.tblInnerDetail.getSelectManager().setSelectMode(2);
        this.tblInnerDetail.getStyleAttributes().setLocked(true);
    }

    protected void execQuery() throws BOSException {
        group = 0;
        this.param = (ReconcileDetailParam)this.getFilterParam();
        this.handler = FSAnalysisHandlerFactory.getHandler(this.param);
        this.initUIHead();
        this.tblInnerDetail.removeRows();
        this.tblGLDetail.removeRows();
        this.fillInnerDetailTable();
        this.fillGLDetailTable();
        String companyId = this.param.getCompanyId();
        this.isClearingHouse = companyId.equals(this.clearingHouse.getId().toString());
        this.refreshList();
    }

    private void fillGLDetailTable() throws BOSException {
        this.fillDLDetailTable_B();
    }

    private void fillDLDetailTable_B() throws BOSException {
        IRowSet rs = this.getRowSetNew();
        this.fillTableNew(rs);
    }

    private void fillDLDetailTable_A() throws BOSException {
        IRowSet rs = this.getRowSet();
        this.fillTable(rs);
    }

    private void fillTable(IRowSet rs) {
        try {
            while (rs.next()) {
                IRow row = this.tblGLDetail.addRow();
                GregorianCalendar date = new GregorianCalendar();
                date.setTime(rs.getDate("bookedDate"));
                row.getCell("selected").setValue((Object)Boolean.FALSE);
                row.getCell("date").setValue((Object)Constants.FORMAT_DAY.format(date.getTime()));
                row.getCell("accountView").setValue((Object)rs.getString("accountName"));
                row.getCell("innerAcct").setValue((Object)rs.getString("innerAccount.name"));
                row.getCell("voucherType").setValue((Object)rs.getString("voucherTypeName"));
                row.getCell("voucherNumber").setValue((Object)rs.getString("number"));
                row.getCell("description").setValue((Object)rs.getString("entryDescription"));
                BigDecimal amount = rs.getBigDecimal("entrylAmount");
                int dc = rs.getInt("entryDC");
                logger.info((Object)amount);
                if (dc == 1) {
                    row.getCell("debitAmount").setValue((Object)amount);
                    row.getCell("creditAmount").setValue((Object)SysConstant.BIGZERO);
                } else {
                    row.getCell("debitAmount").setValue((Object)SysConstant.BIGZERO);
                    row.getCell("creditAmount").setValue((Object)amount);
                }
                row.getCell("accountant").setValue((Object)rs.getString("creatorName"));
                row.getCell("isContrasted").setValue((Object)Boolean.FALSE);
                row.getCell("id").setValue((Object)rs.getString("id"));
            }
        }
        catch (SQLException e) {
            this.handleException(e);
        }
    }

    private void fillTableNew(IRowSet rs) {
        try {
            while (rs.next()) {
                IRow row = this.tblGLDetail.addRow();
                GregorianCalendar date = new GregorianCalendar();
                date.setTime(rs.getDate("bookedDate"));
                row.getCell("selected").setValue((Object)Boolean.FALSE);
                row.getCell("date").setValue((Object)Constants.FORMAT_DAY.format(date.getTime()));
                row.getCell("accountView").setValue((Object)rs.getString("accountName"));
                row.getCell("innerAcct").setValue((Object)rs.getString("innerAccountname"));
                row.getCell("voucherType").setValue((Object)rs.getString("voucherTypeName"));
                row.getCell("voucherNumber").setValue((Object)rs.getString("vouchernumber"));
                row.getCell("description").setValue((Object)rs.getString("entryDescription"));
                BigDecimal amount = rs.getBigDecimal("entrylAmount");
                int dc = rs.getInt("entryDC");
                if (dc == 1) {
                    row.getCell("debitAmount").setValue((Object)amount);
                    row.getCell("creditAmount").setValue((Object)SysConstant.BIGZERO);
                } else {
                    row.getCell("debitAmount").setValue((Object)SysConstant.BIGZERO);
                    row.getCell("creditAmount").setValue((Object)amount);
                }
                row.getCell("accountant").setValue((Object)rs.getString("creatorName"));
                row.getCell("isContrasted").setValue((Object)Boolean.FALSE);
                row.getCell("id").setValue((Object)rs.getString("id"));
            }
        }
        catch (SQLException e) {
            this.handleException(e);
        }
    }

    private IRowSet getRowSetNew() throws BOSException {
        StringBuffer sbSql = new StringBuffer("select * from ( ");
        sbSql.append(this.getSeg1());
        sbSql.append(" union all ");
        sbSql.append(this.getSeg2());
        sbSql.append(" ) tmp\torder by tmp.BOOKEDDATE");
        return SQLExecutorFactory.getRemoteInstance((String)sbSql.toString()).executeSQL();
    }

    private StringBuffer getSeg2() throws BOSException {
        StringBuffer sbSeg2 = new StringBuffer();
        this.loc = LocaleUtils.getLocaleString((Locale)SysContext.getSysContext().getLocale());
        sbSeg2.append("\t\tSELECT   VOUCHER.fid ID,                                           \t\n");
        sbSeg2.append("\t\t         VOUCHER.fbookeddate BOOKEDDATE,                            \n");
        sbSeg2.append("\t\t         CURRENCY1.fid CURRENCYID,                                  \n");
        sbSeg2.append("\t\t         VOUCHERTYPE.fname_").append(this.loc).append("  VOUCHERTYPENAME,                      \n");
        sbSeg2.append("\t\t         ACCOUNT.fname_").append(this.loc).append("  ACCOUNTNAME,                              \n");
        sbSeg2.append("\t\t         ENTRIES.fdescription ENTRYDESCRIPTION,                     \n");
        sbSeg2.append("\t\t         VOUCHER.fnumber VOUCHERnumber,                             \n");
        sbSeg2.append("\t\t         ENTRIES.fentrydc ENTRYDC,                                  \n");
        sbSeg2.append("\t\t         CASE                                                       \n");
        sbSeg2.append("\t\t           WHEN (ASSISTRECORDS.foriginalamount IS NULL )            \n");
        sbSeg2.append("\t\t           THEN ENTRIES.foriginalamount                             \n");
        sbSeg2.append("\t\t           ELSE ASSISTRECORDS.foriginalamount                       \n");
        sbSeg2.append("\t\t         END ENTRYLAMOUNT,                                          \n");
        sbSeg2.append("\t\t         ACCOUNT.fid ACCOUNTID,                                     \n");
        sbSeg2.append("\t\t         CREATOR.fname_").append(this.loc).append("  CREATORNAME,                              \n");
        sbSeg2.append("\t\t         COMPANY.fid COMPANYID,                                     \n");
        sbSeg2.append("\t\t         VOUCHER.fbizstatus BIZSTATUS,                              \n");
        sbSeg2.append("\t\t         INNERACCOUNT.fid INNERACCOUNTID,                           \n");
        sbSeg2.append("\t\t         INNERACCOUNT.fname_").append(this.loc).append("  INNERACCOUNTNAME,                    \n");
        sbSeg2.append("\t\t         INNERACCOUNT.fnumber INNERACCOUNTNUMBER                    \n");
        sbSeg2.append("\t\tFROM     t_gl_voucher VOUCHER                                       \n");
        sbSeg2.append("\t\t         INNER JOIN t_pm_user as CREATOR                            \n");
        sbSeg2.append("\t\t                 ON VOUCHER.fcreatorid = CREATOR.fid                \n");
        sbSeg2.append("\t\t         INNER JOIN t_bd_vouchertypes as VOUCHERTYPE                \n");
        sbSeg2.append("\t\t                 ON VOUCHER.fvouchertypeid = VOUCHERTYPE.fid        \n");
        sbSeg2.append("\t\t         INNER JOIN t_org_company as COMPANY                        \n");
        sbSeg2.append("\t\t                 ON VOUCHER.fcompanyid = COMPANY.fid                \n");
        sbSeg2.append("\t\t         inner JOIN t_gl_voucherentry as ENTRIES                    \n");
        sbSeg2.append("\t\t                       ON VOUCHER.fid = ENTRIES.fbillid             \n");
        sbSeg2.append("\t\t         INNER JOIN t_bd_accountview as ACCOUNT                     \n");
        sbSeg2.append("\t\t                 ON ENTRIES.faccountid = ACCOUNT.fid                \n");
        sbSeg2.append("\t\t         INNER JOIN t_bd_currency as CURRENCY1                      \n");
        sbSeg2.append("\t\t                 ON ENTRIES.fcurrencyid = CURRENCY1.fid             \n");
        sbSeg2.append("\t\t         inner JOIN t_gl_voucherassistrecord as ASSISTRECORDS       \n");
        sbSeg2.append("\t\t                      ON ENTRIES.fid = ASSISTRECORDS.fentryid       \n");
        sbSeg2.append("\t\t         inner JOIN t_bd_assistanthg as ASSGRP                      \n");
        sbSeg2.append("\t\t                      ON ASSISTRECORDS.fassgrpid = ASSGRP.fid       \n");
        sbSeg2.append("\t\t         inner JOIN t_fs_inneraccount as INNERACCOUNT               \n");
        sbSeg2.append("\t\t                      ON ASSGRP.finneraccountid = INNERACCOUNT.fid  \n");
        sbSeg2.append(this.getCommonFilter());
        sbSeg2.append(this.getInnerAccountFilter());
        return sbSeg2;
    }

    private String getInnerAccountFilter() throws BOSException {
        InnerAccountCollection inc = this.param.getInnAcctColl();
        StringBuffer sbinacctFilter = new StringBuffer();
        if (inc != null && inc.size() > 0) {
            sbinacctFilter.append(" AND INNERACCOUNT.fid IN ").append(this.getIDWhereClause(inc.toArray()));
            HashSet<String> set = new HashSet<String>();
            for (int i = 0; i < inc.size(); ++i) {
                if (EmptyUtil.isEmpty((CoreBaseInfo)inc.get(i).getAcctView())) continue;
                set.add(inc.get(i).getAcctView().getId().toString());
            }
            sbinacctFilter.append(" AND ACCOUNT.fid IN ").append(this.getIDWhereClause(set.toArray()));
        }
        return sbinacctFilter.toString();
    }

    private String getAccountFilter() throws BOSException {
        Set contrastAcct = this.getContrastAcct(this.param.getInnAcctColl());
        StringBuffer sb = new StringBuffer();
        if (contrastAcct.size() > 0) {
            String[] ids = contrastAcct.toArray(new String[contrastAcct.size()]);
            int size = ids.length;
            for (int i = 0; i < size; ++i) {
                sb.append("'").append(ids[i]).append("'");
                if (i == size - 1) continue;
                sb.append(",");
            }
            return " and ACCOUNT.fid IN (" + sb.toString() + ")";
        }
        return " and ACCOUNT.fid IN ('')";
    }

    private StringBuffer getSeg1() throws BOSException {
        StringBuffer sbSeg1 = new StringBuffer();
        this.loc = LocaleUtils.getLocaleString((Locale)SysContext.getSysContext().getLocale());
        sbSeg1.append("\tSELECT   VOUCHER.fid ID,                                            \n");
        sbSeg1.append("\t         VOUCHER.fbookeddate BOOKEDDATE,                            \n");
        sbSeg1.append("\t         CURRENCY1.fid CURRENCY1ID,                                 \n");
        sbSeg1.append("\t         VOUCHERTYPE.fname_").append(this.loc).append("  VOUCHERTYPENAME,                      \n");
        sbSeg1.append("\t         ACCOUNT.fname_").append(this.loc).append("  ACCOUNTNAME,                              \n");
        sbSeg1.append("\t         ENTRIES.fdescription ENTRYDESCRIPTION,                     \n");
        sbSeg1.append("\t         VOUCHER.fnumber VOUCHERnumber,                             \n");
        sbSeg1.append("\t         ENTRIES.fentrydc ENTRYDC,                                  \n");
        sbSeg1.append("\t         CASE                                                       \n");
        sbSeg1.append("\t           WHEN (ASSISTRECORDS.foriginalamount IS NULL )            \n");
        sbSeg1.append("\t           THEN ENTRIES.foriginalamount                             \n");
        sbSeg1.append("\t           ELSE ASSISTRECORDS.foriginalamount                       \n");
        sbSeg1.append("\t         END ENTRYLAMOUNT,                                          \n");
        sbSeg1.append("\t         ACCOUNT.fid ACCOUNTID,                                     \n");
        sbSeg1.append("\t         CREATOR.fname_").append(this.loc).append("  CREATORNAME,                              \n");
        sbSeg1.append("\t         COMPANY.fid COMPANYID,                                     \n");
        sbSeg1.append("\t         VOUCHER.fbizstatus BIZSTATUS,                              \n");
        sbSeg1.append("\t         INNERACCOUNT.fid INNERACCOUNTID,                           \n");
        sbSeg1.append("\t         INNERACCOUNT.fname_").append(this.loc).append("  INNERACCOUNTNAME,                    \n");
        sbSeg1.append("\t         INNERACCOUNT.fnumber INNERACCOUNTNUMBER                    \n");
        sbSeg1.append("\tFROM     t_gl_voucher as VOUCHER                                    \n");
        sbSeg1.append("\t         INNER JOIN t_pm_user as CREATOR                            \n");
        sbSeg1.append("\t                 ON VOUCHER.fcreatorid = CREATOR.fid                \n");
        sbSeg1.append("\t         INNER JOIN t_bd_vouchertypes as VOUCHERTYPE                \n");
        sbSeg1.append("\t                 ON VOUCHER.fvouchertypeid = VOUCHERTYPE.fid        \n");
        sbSeg1.append("\t         INNER JOIN t_org_company as COMPANY                        \n");
        sbSeg1.append("\t                 ON VOUCHER.fcompanyid = COMPANY.fid                \n");
        sbSeg1.append("\t         left OUTER JOIN t_gl_voucherentry as ENTRIES               \n");
        sbSeg1.append("\t                       ON VOUCHER.fid = ENTRIES.fbillid             \n");
        sbSeg1.append("\t         INNER JOIN t_bd_accountview as ACCOUNT                     \n");
        sbSeg1.append("\t                 ON ENTRIES.faccountid = ACCOUNT.fid                \n");
        sbSeg1.append("\t         INNER JOIN t_bd_currency as CURRENCY1                      \n");
        sbSeg1.append("\t                 ON ENTRIES.fcurrencyid = CURRENCY1.fid             \n");
        sbSeg1.append("\t         LEFT OUTER JOIN t_gl_voucherassistrecord as ASSISTRECORDS  \n");
        sbSeg1.append("\t                      ON ENTRIES.fid = ASSISTRECORDS.fentryid       \n");
        sbSeg1.append("\t         LEFT OUTER JOIN t_bd_assistanthg as ASSGRP                 \n");
        sbSeg1.append("\t                      ON ASSISTRECORDS.fassgrpid = ASSGRP.fid       \n");
        sbSeg1.append("\t         LEFT OUTER JOIN t_fs_inneraccount as INNERACCOUNT          \n");
        sbSeg1.append("\t                      ON ASSGRP.finneraccountid = INNERACCOUNT.fid  \n");
        sbSeg1.append(this.getCommonFilter());
        sbSeg1.append(this.getAccountFilter());
        return sbSeg1;
    }

    private String getIDWhereClause(Object[] values) {
        int size = values.length;
        StringBuffer sb = new StringBuffer("(");
        if (size > 0) {
            for (int i = 0; i < size; ++i) {
                sb.append("'").append(AccessHelper.getId((Object)values[i])).append("'");
                if (i == size - 1) continue;
                sb.append(",");
            }
        } else {
            sb.append("''");
        }
        sb.append(")");
        return sb.toString();
    }

    private StringBuffer getCommonFilter() {
        StringBuffer where = new StringBuffer();
        where.append(" WHERE    CURRENCY1.fid = '").append(this.param.getCurrencyId()).append("' \n");
        if (!this.param.isIncludeUnPostVoucher()) {
            where.append(" AND VOUCHER.fbizstatus = 5 \n");
        } else {
            where.append(" AND VOUCHER.fbizstatus IN (1, 3, 5) \n");
        }
        Date begin = null;
        if (this.param.isByPeriod()) {
            GregorianCalendar beginDate = new GregorianCalendar(this.param.getBeginYear(), this.param.getBeginPeriod() - 1, 1);
            begin = TypeConversionUtils.objToDate((Object)beginDate.getTime());
        } else {
            begin = DateTimeUtils.truncateDate((Date)this.param.getBeginDate());
        }
        where.append(" AND VOUCHER.fbookeddate >= {").append(FMConstants.FORMAT_TIME.format(begin)).append("}\n");
        Date end = null;
        if (this.param.isByPeriod()) {
            GregorianCalendar endDate = new GregorianCalendar(this.param.getEndYear(), this.param.getEndPeriod(), 0);
            end = TypeConversionUtils.objToDate((Object)endDate.getTime());
        } else {
            end = DateTimeUtils.truncateDate((Date)this.param.getEndDate());
        }
        where.append(" AND VOUCHER.fbookeddate <= {").append(FMConstants.FORMAT_TIME.format(end)).append("} \n");
        where.append(" AND COMPANY.fid = '").append(this.param.getCompanyId()).append("' \n");
        return where;
    }

    private Set getContrastAcct(InnerAccountCollection innAcctColl2) throws BOSException {
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < innAcctColl2.size(); ++i) {
            if (EmptyUtil.isEmpty((CoreBaseInfo)innAcctColl2.get(i).getAcctView())) continue;
            set.add(innAcctColl2.get(i).getAcctView().getId().toString());
        }
        HashSet<String> rst = new HashSet<String>();
        for (String id : set) {
            if (FMHelper.hasAsstInnerAcct(null, (String)id)) continue;
            rst.add(id);
        }
        return rst;
    }

    private IRowSet getRowSet() throws BOSException {
        this.glContrastQuery = new EntityViewInfo();
        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)this.glContrastQueryPK);
        FilterInfo filter = this.param.getGLFilter();
        if (filter == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"NoAccountErrer"));
            SysUtil.abort();
        }
        this.glContrastQuery.setFilter(filter);
        this.glContrastQuery.getSorter().add(new SorterItemInfo("bookedDate"));
        exec.setObjectView(this.glContrastQuery);
        IRowSet rs = exec.executeQuery();
        logger.info((Object)exec.getSQL());
        return rs;
    }

    private void fillInnerDetailTable() throws BOSException {
        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)this.mainQueryPK);
        FilterInfo filter = this.param.getFilter();
        this.mainQuery.setFilter(filter);
        this.mainQuery.getSorter().add(new SorterItemInfo("date"));
        exec.setObjectView(this.mainQuery);
        IRowSet rs = exec.executeQuery();
        KDCheckBox checkBox = new KDCheckBox();
        KDTDefaultCellEditor editor = new KDTDefaultCellEditor((JCheckBox)checkBox);
        this.tblInnerDetail.getColumn("selected").setEditor((ICellEditor)editor);
        try {
            while (rs.next()) {
                IRow row = this.tblInnerDetail.addRow();
                GregorianCalendar date = new GregorianCalendar();
                date.setTime(rs.getDate("date"));
                row.getCell("selected").setValue((Object)Boolean.FALSE);
                row.getCell("date").setValue((Object)Constants.FORMAT_DAY.format(date.getTime()));
                String sBizType = rs.getString("bizType");
                if (sBizType != null) {
                    SubsidiaryBillTypeEnum bizType = SubsidiaryBillTypeEnum.getEnum(Integer.parseInt(sBizType));
                    row.getCell("bizType").setValue((Object)bizType.toString());
                }
                row.getCell("billNumber").setValue((Object)rs.getString("billNumber"));
                row.getCell("innerAcct").setValue((Object)rs.getString("innerAccount.name"));
                row.getCell("payeeBankAcct").setValue((Object)rs.getString("payeeBankAcct"));
                row.getCell("payerBankAcct").setValue((Object)rs.getString("payerBankAcct"));
                row.getCell("description").setValue((Object)rs.getString("description"));
                BigDecimal creditAmount = rs.getBigDecimal("creditAmount");
                BigDecimal debitAmount = rs.getBigDecimal("debitAmount");
                row.getCell("creditAmount").setValue((Object)debitAmount);
                row.getCell("debitAmount").setValue((Object)creditAmount);
                row.getCell("booker").setValue((Object)rs.getString("bookerName"));
                row.getCell("isContrasted").setValue((Object)Boolean.FALSE);
                row.getCell("id").setValue((Object)rs.getString("id"));
                row.getCell("billId").setValue((Object)rs.getString("billId"));
            }
        }
        catch (SQLException e) {
            this.handleException(e);
        }
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        return null;
    }

    private List getGlSelectedRows() {
        ArrayList<IRow> rows = new ArrayList<IRow>();
        for (int i = 0; i < this.tblGLDetail.getRowCount(); ++i) {
            IRow row = this.tblGLDetail.getRow(i);
            if (!((Boolean)row.getCell("selected").getValue()).booleanValue()) continue;
            rows.add(row);
        }
        return rows;
    }

    private List getInSelectedRows() {
        ArrayList<IRow> rows = new ArrayList<IRow>();
        for (int i = 0; i < this.tblInnerDetail.getRowCount(); ++i) {
            IRow row = this.tblInnerDetail.getRow(i);
            if (!((Boolean)row.getCell("selected").getValue()).booleanValue()) continue;
            rows.add(row);
        }
        return rows;
    }

    protected KDTable getMainTable() {
        return this.tblInnerDetail;
    }

    private BigDecimal getRowsSum(List rows, String field) {
        BigDecimal sum = SysConstant.BIGZERO;
        for (int i = 0; i < rows.size(); ++i) {
            sum = sum.add(FMHelper.getBigDecimal((Object)((IRow)rows.get(i)).getCell(field).getValue()));
        }
        return sum;
    }

    private void initUIHead() {
        String datePeriod = "";
        datePeriod = this.param.isByPeriod() ? this.param.getBeginYear() + "-" + this.param.getBeginPeriod() + EASResource.getString((String)this.resourcePath, (String)"To") + this.param.getEndYear() + "-" + this.param.getEndPeriod() : Constants.FORMAT_DAY.format(this.param.getBeginDate()) + EASResource.getString((String)this.resourcePath, (String)"To") + Constants.FORMAT_DAY.format(this.param.getEndDate());
        this.txtPeriodRange.setText(datePeriod);
        int precision = FMClientHelper.getPrecOfCurrency((BOSUuid)BOSUuid.read((String)this.param.getCurrencyId()));
        this.txtBeginBalanceDiff.setPrecision(precision);
        this.txtDiff.setPrecision(precision);
        this.txtEndBalanceDiff.setPrecision(precision);
        CompanyOrgUnitInfo companyInfo = null;
        CurrencyInfo currency = null;
        try {
            companyInfo = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)this.param.getCompanyId())));
            currency = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)this.param.getCurrencyId())));
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
        }
        this.txtCompany.setText(companyInfo.getName());
        this.txtCurrency.setText(currency.getName());
        this.txtBeginBalanceDiff.setValue((Object)this.param.getBeginBalanceDiff());
        this.txtDiff.setValue((Object)this.param.getDiff());
        this.txtEndBalanceDiff.setValue((Object)this.param.getEndBalanceDiff());
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    private void refreshList() {
        this.setHideRow(this.currencyShowStatus);
    }

    private IRow[] searchRowInGL(IRow rowIn) {
        ArrayList<IRow> rows = new ArrayList<IRow>();
        for (int i = 0; i < this.tblGLDetail.getRowCount(); ++i) {
            IRow rowGL = this.tblGLDetail.getRow(i);
            if (((Boolean)rowGL.getCell("isContrasted").getValue()).booleanValue()) continue;
            BigDecimal debitAmountIn = (BigDecimal)rowIn.getCell("debitAmount").getValue();
            BigDecimal creditAmountIn = (BigDecimal)rowIn.getCell("creditAmount").getValue();
            BigDecimal debitAmountGL = (BigDecimal)rowGL.getCell("debitAmount").getValue();
            BigDecimal creditAmountGL = (BigDecimal)rowGL.getCell("creditAmount").getValue();
            if (debitAmountIn.compareTo(debitAmountGL) != 0 || creditAmountIn.compareTo(creditAmountGL) != 0) continue;
            rows.add(rowGL);
        }
        return rows.toArray(new IRow[0]);
    }

    private IRow[] searchRowInInner(IRow rowGL) {
        ArrayList<IRow> rows = new ArrayList<IRow>();
        for (int i = 0; i < this.tblInnerDetail.getRowCount(); ++i) {
            IRow rowIn = this.tblInnerDetail.getRow(i);
            if (((Boolean)rowIn.getCell("isContrasted").getValue()).booleanValue()) continue;
            BigDecimal debitAmountIn = (BigDecimal)rowGL.getCell("debitAmount").getValue();
            BigDecimal creditAmountIn = (BigDecimal)rowGL.getCell("creditAmount").getValue();
            BigDecimal debitAmountGL = (BigDecimal)rowIn.getCell("debitAmount").getValue();
            BigDecimal creditAmountGL = (BigDecimal)rowIn.getCell("creditAmount").getValue();
            if (debitAmountIn.compareTo(debitAmountGL) != 0 || creditAmountIn.compareTo(creditAmountGL) != 0) continue;
            rows.add(rowIn);
        }
        return rows.toArray(new IRow[0]);
    }

    public void setHideRow(Boolean isShowCollate) {
        int innerRowCount = this.tblInnerDetail.getRowCount();
        BigDecimal fsDebitTotal = SysConstant.BIGZERO;
        BigDecimal fsCreditTotal = SysConstant.BIGZERO;
        BigDecimal glDebitTotal = SysConstant.BIGZERO;
        BigDecimal glCreditTotal = SysConstant.BIGZERO;
        for (int i = 0; i < innerRowCount; ++i) {
            IRow row = this.tblInnerDetail.getRow(i);
            if (isShowCollate == null) {
                row.getStyleAttributes().setHided(false);
                if (((Boolean)row.getCell("isContrasted").getValue()).booleanValue()) {
                    row.getStyleAttributes().setBackground(CasConstants.KDTABLE_YELLOW_COLOR);
                } else {
                    row.getStyleAttributes().setBackground(CasConstants.KDTABLE_WHITE_COLOR);
                }
            } else if (isShowCollate.booleanValue()) {
                row.getStyleAttributes().setHided((Boolean)row.getCell("isContrasted").getValue() == false);
                row.getStyleAttributes().setBackground(CasConstants.KDTABLE_YELLOW_COLOR);
            } else {
                row.getStyleAttributes().setHided(((Boolean)row.getCell("isContrasted").getValue()).booleanValue());
                row.getStyleAttributes().setBackground(CasConstants.KDTABLE_WHITE_COLOR);
            }
            if (row.getStyleAttributes().isHided()) continue;
            fsDebitTotal = fsDebitTotal.add(FMHelper.getBigDecimal((Object)row.getCell("debitAmount").getValue()));
            fsCreditTotal = fsCreditTotal.add(FMHelper.getBigDecimal((Object)row.getCell("creditAmount").getValue()));
        }
        int glRowCount = this.tblGLDetail.getRowCount();
        for (int i = 0; i < glRowCount; ++i) {
            IRow row = this.tblGLDetail.getRow(i);
            if (isShowCollate == null) {
                row.getStyleAttributes().setHided(false);
                if (((Boolean)row.getCell("isContrasted").getValue()).booleanValue()) {
                    row.getStyleAttributes().setBackground(CasConstants.KDTABLE_YELLOW_COLOR);
                } else {
                    row.getStyleAttributes().setBackground(CasConstants.KDTABLE_WHITE_COLOR);
                }
            } else if (isShowCollate.booleanValue()) {
                row.getStyleAttributes().setHided((Boolean)row.getCell("isContrasted").getValue() == false);
                row.getStyleAttributes().setBackground(CasConstants.KDTABLE_YELLOW_COLOR);
            } else {
                row.getStyleAttributes().setHided(((Boolean)row.getCell("isContrasted").getValue()).booleanValue());
                row.getStyleAttributes().setBackground(CasConstants.KDTABLE_WHITE_COLOR);
            }
            if (row.getStyleAttributes().isHided()) continue;
            glDebitTotal = glDebitTotal.add(FMHelper.getBigDecimal((Object)row.getCell("debitAmount").getValue()));
            glCreditTotal = glCreditTotal.add(FMHelper.getBigDecimal((Object)row.getCell("creditAmount").getValue()));
        }
        this.tblGLDetail.getColumn("selected").getStyleAttributes().setLocked(false);
        this.tblInnerDetail.getColumn("selected").getStyleAttributes().setLocked(false);
        int scale = FMClientHelper.getPrecOfCurrency((BOSUuid)BOSUuid.read((String)this.param.getCurrencyId()));
        this.contInnerDetail.setTitle(EASResource.getString((String)this.resourcePath, (String)"InnerDetailTitleMsg") + "  " + EASResource.getString((String)this.resourcePath, (String)"DebitTotalMsg") + ": " + FMHelper.formatDecimal((BigDecimal)fsDebitTotal, (int)scale) + "   " + EASResource.getString((String)this.resourcePath, (String)"CreditTotalMsg") + ": " + FMHelper.formatDecimal((BigDecimal)fsCreditTotal, (int)scale));
        this.contGLDetail.setTitle(EASResource.getString((String)this.resourcePath, (String)"GLDetailTitleMsg") + "  " + EASResource.getString((String)this.resourcePath, (String)"DebitTotalMsg") + ": " + FMHelper.formatDecimal((BigDecimal)glDebitTotal, (int)scale) + "   " + EASResource.getString((String)this.resourcePath, (String)"CreditTotalMsg") + ": " + FMHelper.formatDecimal((BigDecimal)glCreditTotal, (int)scale));
        this.setInnerTableFormate();
        this.setGLTableFormate();
    }

    protected void initWorkButton() {
        this.btnAutoContrast.setIcon(EASResource.getIcon((String)"imgTbtn_autocollate"));
        this.btnAutoSearch.setIcon(EASResource.getIcon((String)"imgTbtn_find"));
        this.btnCancelContrast.setIcon(EASResource.getIcon((String)"imgTbtn_cancelcollate"));
        this.btnClearAll.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
        this.btnManualContrast.setIcon(EASResource.getIcon((String)"imgTbtn_handworkcollate"));
        this.btnSelectAll.setIcon(EASResource.getIcon((String)"imgTbtn_selectall"));
        this.btnShowAll.setIcon(EASResource.getIcon((String)"imgTbtn_entirely"));
        this.btnShowContrasted.setIcon(EASResource.getIcon((String)"imgTbtn_alreadycollate"));
        this.btnShowNoContrasted.setIcon(EASResource.getIcon((String)"imgTbtn_nocollate"));
        this.actionViewBill.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_sequencecheck"));
        this.actionViewVoucher.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_linkviewbill"));
        super.initWorkButton();
    }

    private void setInnerTableFormate() {
        String strFormat = FMClientHelper.getNumberFtm((BOSUuid)BOSUuid.read((String)this.param.getCurrencyId()));
        String dtformat = CtrlFormatUtilities.getDateFormatString();
        this.tblInnerDetail.getColumn("date").getStyleAttributes().setNumberFormat(dtformat);
        this.tblInnerDetail.getColumn("creditAmount").getStyleAttributes().setNumberFormat(strFormat);
        this.tblInnerDetail.getColumn("creditAmount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblInnerDetail.getColumn("debitAmount").getStyleAttributes().setNumberFormat(strFormat);
        this.tblInnerDetail.getColumn("debitAmount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
    }

    private void setGLTableFormate() {
        String strFormat = FMClientHelper.getNumberFtm((BOSUuid)BOSUuid.read((String)this.param.getCurrencyId()));
        String dtformat = CtrlFormatUtilities.getDateFormatString();
        this.tblGLDetail.getColumn("date").getStyleAttributes().setNumberFormat(dtformat);
        this.tblGLDetail.getColumn("creditAmount").getStyleAttributes().setNumberFormat(strFormat);
        this.tblGLDetail.getColumn("creditAmount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblGLDetail.getColumn("debitAmount").getStyleAttributes().setNumberFormat(strFormat);
        this.tblGLDetail.getColumn("debitAmount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    private List unionList(List list1, List list2) {
        int i;
        ArrayList fullList = new ArrayList();
        for (i = 0; i < list1.size(); ++i) {
            fullList.add(list1.get(i));
        }
        for (i = 0; i < list2.size(); ++i) {
            fullList.add(list2.get(i));
        }
        return fullList;
    }

    public void verifyForCancelContrast(List rows) {
        for (int i = 0; i < rows.size(); ++i) {
            IRow row = (IRow)rows.get(i);
            if (row.getStyleAttributes().isHided() || ((Boolean)row.getCell("isContrasted").getValue()).booleanValue()) continue;
            this.showMessage(EASResource.getString((String)this.resourcePath, (String)"HasNotContrasted"));
            SysUtil.abort();
        }
    }

    public void verifyForContrast(List rows) {
        for (int i = 0; i < rows.size(); ++i) {
            IRow row = (IRow)rows.get(i);
            if (row.getStyleAttributes().isHided() || !((Boolean)row.getCell("isContrasted").getValue()).booleanValue()) continue;
            this.showMessage(EASResource.getString((String)this.resourcePath, (String)"HasContrasted"));
            SysUtil.abort();
        }
    }

    @Override
    public void actionViewBill_actionPerformed(ActionEvent e) throws Exception {
        this.viewDetailBill(this.tblInnerDetail, "billId");
    }

    @Override
    public void actionViewVoucher_actionPerformed(ActionEvent e) throws Exception {
        this.viewDetailBill(this.tblGLDetail, "id");
    }

    private void viewDetailBill(KDTable table, String key) throws Exception {
        String rscPath = "com.kingdee.eas.fm.fs.client.SubsidiaryLedgerResource";
        int rowIndex = FMClientHelper.getSelectedRow((KDTable)table);
        if (rowIndex < 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)rscPath, (String)"SelectValidRecord"));
            return;
        }
        IRow row = table.getRow(rowIndex);
        if (FMHelper.isEmpty((Object)row.getCell(key).getValue())) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)rscPath, (String)"SelectValidRecord"));
            return;
        }
        String id = row.getCell(key).getValue().toString();
        if (FMHelper.isEmpty((String)id)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)rscPath, (String)"SelectValidRecord"));
            return;
        }
        CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
        company.setId(BOSUuid.read((String)this.param.getCompanyId()));
        FMClientHelper.viewDetailBill((CoreUIObject)this, (String)id, (CompanyOrgUnitInfo)company);
    }
}

