/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.CommitEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.client.BankF7Selector;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.CashHelper;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.common.util.CoreBaseInfoArrayUtil;
import com.kingdee.eas.fm.fs.client.AbstractRptTransUpAndDownDetailFilterUI;
import com.kingdee.eas.fm.fs.client.RptTransUpAndDownDetailParam;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.util.Date;
import org.apache.log4j.Logger;

public class RptTransUpAndDownDetailFilterUI
extends AbstractRptTransUpAndDownDetailFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(RptTransUpAndDownDetailFilterUI.class);
    private static final String RPTTRANSUPANDDOWNRESOUORCE = "com.kingdee.eas.fm.fs.RptTransUpAndDownResource";
    private static CompanyOrgUnitCollection companyColl;
    private RptTransUpAndDownDetailParam param = null;
    private CompanyOrgUnitInfo defCompany = null;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public Object getParam() {
        if (this.param == null) {
            this.param = new RptTransUpAndDownDetailParam();
        }
        this.param.setBeginDate((Date)this.kdBeginDate.getValue());
        this.param.setEndDate(DateUtil.getAfterDay((Date)((Date)this.kDEndDate.getValue())));
        this.param.setMontherAcctBankCompany((CompanyOrgUnitInfo)this.kDPrmtMontherAcctCompany.getValue());
        BankInfo[] bank = CoreBaseInfoArrayUtil.convertBankInfoArray((Object[])((Object[])this.kdPrmtBank.getValue()));
        if (bank != null && !EmptyUtil.isEmpty((CoreBaseInfo)bank[0])) {
            this.param.setBank((CoreBaseInfo[])bank);
        } else {
            this.param.setBank(null);
        }
        CompanyOrgUnitInfo[] transComapny = CoreBaseInfoArrayUtil.convertCompanyOrgUnitInfoArray((Object[])((Object[])this.kDPrmtTranCompany.getValue()));
        if (transComapny != null && !EmptyUtil.isEmpty((CoreBaseInfo)transComapny[0])) {
            this.param.setTransCompanySet((CoreBaseInfo[])transComapny);
        } else {
            this.param.setTransCompanySet(null);
        }
        this.param.setCurrency((CurrencyInfo)this.kDComCurrency.getSelectedItem());
        return this.param;
    }

    public void setParam(Object param) {
        if (param == null) {
            return;
        }
        this.param = (RptTransUpAndDownDetailParam)((Object)param);
        this.kdBeginDate.setValue((Object)this.param.getBeginDate());
        this.kDEndDate.setValue((Object)this.param.getEndDate());
        this.kDPrmtMontherAcctCompany.setValue((Object)this.param.getMontherAcctBankCompany());
        if (!EmptyUtil.isEmpty((Object[])this.param.getBank())) {
            this.kdPrmtBank.setValue((Object)this.param.getBank());
        } else {
            this.kdPrmtBank.setValue(null);
        }
        if (!EmptyUtil.isEmpty((Object[])this.param.getTransCompanySet())) {
            this.kDPrmtTranCompany.setValue((Object)this.param.getTransCompanySet());
        } else {
            this.kDPrmtTranCompany.setValue(null);
        }
        this.kDComCurrency.setSelectedItem((Object)this.param.getCurrency());
    }

    protected void setDefaultValue() {
        this.initBeginDate();
        this.kDEndDate.setValue((Object)new Date());
        CashHelper.initCombCurrency((KDComboBox)this.kDComCurrency, (boolean)false);
        if (!EmptyUtil.isEmpty((CoreBaseInfo)this.defCompany)) {
            this.kDPrmtMontherAcctCompany.setValue((Object)this.defCompany);
        } else {
            EntityViewInfo evi = this.getCompanyEvi();
            try {
                this.setCompanyValue(evi);
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        }
        this.kdPrmtBank.setValue(null);
        this.kDPrmtTranCompany.setValue(null);
    }

    public void init() throws EASBizException, BOSException {
        this.initBeginDate();
        CashHelper.initCombCurrency((KDComboBox)this.kDComCurrency, (boolean)false);
        this.initCombCompany(this.kDPrmtMontherAcctCompany);
        this.initPrmtBank();
        this.initPrmtTranCompany();
    }

    private void initBeginDate() {
        this.kdBeginDate.setValue((Object)DateUtil.getFirstDayOfMonth((Date)new Date()));
    }

    private void initPrmtBank() {
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)this.kDPrmtMontherAcctCompany.getValue();
        EntityViewInfo evi = this.getBankEntityViewByCompany(company);
        this.kdPrmtBank.setDisplayFormat("$Name$");
        this.kdPrmtBank.setCommitFormat("$Name$");
        this.kdPrmtBank.setEditFormat("$Name$");
        this.kdPrmtBank.setEnabledMultiSelection(true);
        this.kdPrmtBank.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7LeafBankQuery");
        this.kdPrmtBank.setEntityViewInfo(evi);
        BankF7Selector arg0 = new BankF7Selector((IUIObject)this, this.kdPrmtBank);
        this.kdPrmtBank.setSelector((KDPromptSelector)arg0);
        this.kdPrmtBank.getQueryAgent().resetRuntimeEntityView();
    }

    private void initPrmtTranCompany() throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)this.kDPrmtMontherAcctCompany.getValue();
        EntityViewInfo evi = this.getMontherAcctBankEntityViewByComnay(company);
        AccountBankCollection acctBankColl = AccountBankFactory.getRemoteInstance().getAccountBankCollection(evi);
        String[] accountIds = new String[acctBankColl.size()];
        for (int i = 0; i < acctBankColl.size(); ++i) {
            accountIds[i] = acctBankColl.get(i).getId().toString();
        }
        acctBankColl = AccountBankFactory.getRemoteInstance().getAccountTreeByids(accountIds);
        evi = this.getPrmtTranEntityViewbyAcct(acctBankColl);
        this.kDPrmtTranCompany.setDisplayFormat("$Name$");
        this.kDPrmtTranCompany.setCommitFormat("$Name$");
        this.kDPrmtTranCompany.setEditFormat("$Name$");
        this.kDPrmtTranCompany.setEnabledMultiSelection(true);
        this.kDPrmtTranCompany.setQueryInfo("com.kingdee.eas.basedata.org.app.CompanyOrgUnitQuery");
        this.kDPrmtTranCompany.setEntityViewInfo(evi);
        this.kDPrmtTranCompany.getQueryAgent().resetRuntimeEntityView();
    }

    private EntityViewInfo getBankEntityViewByCompany(CompanyOrgUnitInfo company) {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        String innerSql = "";
        innerSql = EmptyUtil.isEmpty((CoreBaseInfo)company) ? "SELECT FBank FROM T_BD_AccountBanks WHERE FCOMPANYID = ''" : "SELECT FBank FROM T_BD_AccountBanks WHERE FIsMotherAccount = 1 AND FIsClosed = 0 AND FCOMPANYID = '" + company.getId().toString() + "'";
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)innerSql, CompareType.INNER));
        evi.setFilter(filterInfo);
        SelectorItemCollection selectorItem = this.getBankSelector();
        evi.setSelector(selectorItem);
        return evi;
    }

    private SelectorItemCollection getBankSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("ID"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        return sic;
    }

    private EntityViewInfo getPrmtTranEntityViewbyAcct(AccountBankCollection acctBankColl) {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        StringBuffer strBuf = new StringBuffer();
        for (int i = 0; i < acctBankColl.size(); ++i) {
            if (i == 0) {
                strBuf.append("'" + acctBankColl.get(i).getId().toString() + "'");
                continue;
            }
            strBuf.append(", '" + acctBankColl.get(i).getId().toString() + "'");
        }
        String innerSql = "SELECT FCompanyID FROM T_BD_AccountBanks WHERE fid in (" + strBuf.toString() + ")";
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)innerSql, CompareType.INNER));
        evi.setFilter(filterInfo);
        SelectorItemCollection selectorItem = this.getBankSelector();
        evi.setSelector(selectorItem);
        return evi;
    }

    private EntityViewInfo getMontherAcctBankEntityViewByComnay(CompanyOrgUnitInfo company) {
        EntityViewInfo evi = new EntityViewInfo();
        SelectorItemCollection selectorItem = this.getEntryBankAcntSelector();
        evi.setSelector(selectorItem);
        FilterInfo filterInfo = new FilterInfo();
        String companyId = this.currentCompany.getId().toString();
        if (!EmptyUtil.isEmpty((CoreBaseInfo)company)) {
            companyId = company.getId().toString();
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("isClosed", (Object)Boolean.FALSE, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("isMotherAccount", (Object)Boolean.TRUE, CompareType.EQUALS));
        evi.setFilter(filterInfo);
        return evi;
    }

    private SelectorItemCollection getEntryBankAcntSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("ID"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("bankAccountNumber"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("bank.id"));
        sic.add(new SelectorItemInfo("bank.name"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.name"));
        return sic;
    }

    private void initCombCompany(KDBizPromptBox kDPrmtMontherAcctCompany) throws BOSException {
        if (!GlUtils.isCompanyUnion((CompanyOrgUnitInfo)this.currentCompany)) {
            kDPrmtMontherAcctCompany.setValue((Object)this.currentCompany);
            kDPrmtMontherAcctCompany.setEnabled(false);
        } else {
            EntityViewInfo evi = this.getCompanyEvi();
            this.setCompanyValue(evi);
            kDPrmtMontherAcctCompany.setEntityViewInfo(evi);
        }
    }

    private EntityViewInfo getCompanyEvi() {
        EntityViewInfo evi = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("ID"));
        sic.add(new SelectorItemInfo("NAME"));
        sic.add(new SelectorItemInfo("Number"));
        FilterInfo filterInfo = new FilterInfo();
        String innerSql = "SELECT FCompanyID FROM T_BD_AccountBanks WHERE T_BD_AccountBanks.FIsMotherAccount = 1";
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)innerSql, CompareType.INNER));
        filterInfo.getFilterItems().add(new FilterItemInfo("longnumber", (Object)(this.currentCompany.getLongNumber() + "%"), CompareType.LIKE));
        evi.setFilter(filterInfo);
        evi.setSelector(sic);
        return evi;
    }

    private void setCompanyValue(EntityViewInfo evi) throws BOSException {
        CompanyOrgUnitCollection coll = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection(evi);
        if (coll.size() > 0) {
            this.kDPrmtMontherAcctCompany.setValue((Object)coll.get(0));
            this.defCompany = coll.get(0);
        } else {
            this.kDPrmtMontherAcctCompany.setValue((Object)this.currentCompany);
            this.defCompany = this.currentCompany;
        }
    }

    @Override
    protected void kDPrmtMontherAcctCompany_dataChanged(DataChangeEvent e) throws Exception {
        this.initPrmtBank();
        this.initPrmtTranCompany();
        this.kdPrmtBank.setValue(null);
        this.kDPrmtTranCompany.setValue(null);
        super.kDPrmtMontherAcctCompany_dataChanged(e);
    }

    protected void initCompanyState() {
        if (this.currentCompany == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.be.beResourse", (String)"NoCompany"));
            SysUtil.abort();
        }
        this.btnCompanySelect.setEnabled(false);
        this.btnCompanySelect.setVisible(false);
    }

    public boolean verify() {
        Date endDate;
        Date beginDate;
        if (EmptyUtil.isEmpty((Object)this.kdBeginDate.getValue())) {
            MsgBox.showInfo((String)EASResource.getString((String)RPTTRANSUPANDDOWNRESOUORCE, (String)"beginDateIsNull"));
            SysUtil.abort();
        }
        if (EmptyUtil.isEmpty((Object)this.kDEndDate.getValue())) {
            MsgBox.showInfo((String)EASResource.getString((String)RPTTRANSUPANDDOWNRESOUORCE, (String)"endDateIsNull"));
            SysUtil.abort();
        }
        if ((beginDate = (Date)this.kdBeginDate.getValue()).after(endDate = (Date)this.kDEndDate.getValue())) {
            MsgBox.showInfo((String)EASResource.getString((String)RPTTRANSUPANDDOWNRESOUORCE, (String)"checkBeginDateEndDate"));
            SysUtil.abort();
        }
        if (EmptyUtil.isEmpty((Object)this.kDPrmtMontherAcctCompany.getValue())) {
            MsgBox.showInfo((String)EASResource.getString((String)RPTTRANSUPANDDOWNRESOUORCE, (String)"MontherAcctCompanyIsNull"));
            SysUtil.abort();
        }
        return super.verify();
    }

    @Override
    protected void kDPrmtTranCompany_willShow(SelectorEvent e) throws Exception {
        super.kDPrmtTranCompany_willShow(e);
        this.checkMontherAcctCompany();
    }

    @Override
    protected void kDPrmtTranCompany_willCommit(CommitEvent e) throws Exception {
        super.kDPrmtTranCompany_willCommit(e);
        this.checkMontherAcctCompany();
    }

    @Override
    protected void kdPrmtBank_willShow(SelectorEvent e) throws Exception {
        super.kdPrmtBank_willShow(e);
        this.checkMontherAcctCompany();
    }

    @Override
    protected void kdPrmtBank_willCommit(CommitEvent e) throws Exception {
        super.kdPrmtBank_willCommit(e);
        this.checkMontherAcctCompany();
    }

    private void checkMontherAcctCompany() {
        if (EmptyUtil.isEmpty((Object)this.kDPrmtMontherAcctCompany.getValue())) {
            MsgBox.showInfo((String)EASResource.getString((String)RPTTRANSUPANDDOWNRESOUORCE, (String)"MontherAcctCompanyIsNull"));
            SysUtil.abort();
        }
    }

    protected Class getParamClass() {
        return RptTransUpAndDownDetailParam.class;
    }
}

