/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMDetailRptBaseHandler;
import com.kingdee.eas.fm.common.client.IFMDetailRptHandler;
import com.kingdee.eas.fm.fs.client.RptTransUpAndDownDetailParam;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Color;
import java.sql.SQLException;
import java.text.MessageFormat;
import org.apache.log4j.Logger;

public class RptTransUpAndDownDetailHander
extends FMDetailRptBaseHandler
implements IFMDetailRptHandler {
    private static final Logger logger = CoreUIObject.getLogger(RptTransUpAndDownDetailHander.class);
    RptTransUpAndDownDetailParam param = null;
    private static final String FLD_BILLTYPE = "BILLTYPE";
    private static final String FLD_BANK = "BANK";
    private static final String FLD_TRANSCOMPANY = "TRANSCOMPANY";
    private static final String FLD_INNERACCT = "INNERACCT";
    private static final String FLD_BANKACCOUNT = "BANKACCOUNT";
    private static final String FLD_BILLNUMBER = "BILLNUMBER";
    private static final String FLD_BIZDATE = "TDATE";
    private static final String FLD_UPAMOUNT = "UPAMOUNT";
    private static final String FLD_DOWNAMOUNT = "DOWNAMOUNT";
    private static final String FLD_ISSENDRECEIPT = "ISSENDRECEIPT";
    private static final String FLD_FPITEM = "FPITEM";
    private static final String FLD_PROJECT = "PROJECT";
    private static final String FLD_FEETYPE = "FEETYPE";
    private static final String FLD_FID = "FID";
    private int precisionLocalCurrency = 2;
    private static final String RESOURCE = "com.kingdee.eas.fm.fs.RptTransUpAndDownResource";
    private static String allSql = "select * from ({0}) as transBill ORDER BY BILLTYPE, BANK, TDATE, TRANSCOMPANY";
    private static final String upSql = "SELECT * FROM (SELECT ''{6}'' as BILLTYPE, BANK.FNAME_{7} AS BANK, TRANSUPBILL.FNUMBER AS BILLNUMBER, TRANSUPBILL.FBIZDATE AS TDATE, \n ENTRYCOMPANY.Fname_{7} AS TRANSCOMPANY, ENTRYBANKACNT.FNAME_{7} AS BANKACCOUNT, TransUpBillEntry.FAMOUNT AS UPAMOUNT, \n 0 AS DOWNAMOUNT, TransUpBillEntry.FISSENDRECEIPT AS ISSENDRECEIPT, TRANSUPBILL.FOutBgItemName AS FPITEM, \nEntryProject.fname_{7} AS PROJECT, FEETYPE.FNAME_{7} AS FEETYPE, TRANSUPBILL.FID AS FID ,INNERACCOUNT.FNAME_{7} AS INNERACCT \n FROM T_FS_TransUpBill AS TRANSUPBILL \n LEFT OUTER JOIN T_BD_AccountBanks AS MONTHERBANKACNT \n ON TRANSUPBILL.FMOTHERACCTBANKID = MONTHERBANKACNT.FID \n LEFT OUTER JOIN T_ORG_BaseUnit AS MONTHERCOMPANY \n ON MONTHERBANKACNT.FCompanyID = MONTHERCOMPANY.FID \n LEFT OUTER JOIN T_BD_Bank AS BANK \n ON MONTHERBANKACNT.FBANK = BANK.FID \n LEFT OUTER JOIN T_BD_Currency AS CURRENCY \n ON TRANSUPBILL.FCURRENCYID = CURRENCY.FID \n LEFT OUTER JOIN T_FS_TransUpBillEntry AS TransUpBillEntry \n ON TRANSUPBILL.FID = TransUpBillEntry.FPARENTID \n LEFT OUTER JOIN T_BD_AccountBanks as UNITYACCOUNTBANKS \n ON TransUpBillEntry.FUnitAcctBankID = UNITYACCOUNTBANKS.FID \nLEFT OUTER JOIN T_FS_InnerAccount as INNERACCOUNT \nON UNITYACCOUNTBANKS.FInnerAcctId = INNERACCOUNT.FID \nLEFT OUTER JOIN T_ORG_BaseUnit AS ENTRYCOMPANY \n ON TransUpBillEntry.FUNITID = ENTRYCOMPANY.FID \n LEFT OUTER JOIN T_BD_AccountBanks AS ENTRYBANKACNT \n ON TransUpBillEntry.FUNITACCTBANKID = ENTRYBANKACNT.FID \n LEFT OUTER JOIN T_BD_Project AS EntryProject \n ON TransUpBillEntry.FProjectId = EntryProject.fid \nLEFT OUTER JOIN T_BD_PROJECT AS PROJECT \n ON TRANSUPBILL.FProjectId = PROJECT.FID \n LEFT OUTER JOIN T_CAS_FeeType AS FEETYPE \n ON TransUpBillEntry.FFEETYPEID = FEETYPE.FID \n WHERE TransUpBillEntry.FISSUCCESSED = 1 AND TRANSUPBILL.FBIZDATE >= {0} AND TRANSUPBILL.FBIZDATE < {1} \n AND MONTHERBANKACNT.FCompanyID = ''{2}'' AND TRANSUPBILL.FCURRENCYID = ''{3}'' \n {4} {5} ) As upBill \n";
    private static final String downSql = "SELECT * FROM (SELECT ''{6}'' as BILLTYPE, BANK.FNAME_{7} AS BANK, TRANSDOWNBILL.FNUMBER AS BILLNUMBER, TRANSDOWNBILL.FBIZDATE AS TDATE, \n ENTRYCOMPANY.Fname_{7} AS TRANSCOMPANY, ENTRYBANKACNT.FNAME_{7} AS BANKACCOUNT, 0 AS UPAMOUNT, \n TRANSDOWNBILLEntry.FAMOUNT AS DOWNAMOUNT, TRANSDOWNBILLEntry.FISSENDRECEIPT AS ISSENDRECEIPT, TRANSDOWNBILL.FOutBgItemName AS FPITEM, \nEntryProject.fname_{7} AS PROJECT, FEETYPE.FNAME_{7} AS FEETYPE, TRANSDOWNBILL.FID AS FID ,INNERACCOUNT.FNAME_{7} AS INNERACCT \n FROM T_FS_TRANSDOWNBILL AS TRANSDOWNBILL \n LEFT OUTER JOIN T_BD_AccountBanks AS MONTHERBANKACNT \n ON TRANSDOWNBILL.FMOTHERACCTBANKID = MONTHERBANKACNT.FID \n LEFT OUTER JOIN T_ORG_BaseUnit AS MONTHERCOMPANY \n ON MONTHERBANKACNT.FCompanyID = MONTHERCOMPANY.FID \n LEFT OUTER JOIN T_BD_Bank AS BANK \n ON MONTHERBANKACNT.FBANK = BANK.FID \n LEFT OUTER JOIN T_BD_Currency AS CURRENCY \n ON TRANSDOWNBILL.FCURRENCYID = CURRENCY.FID \n LEFT OUTER JOIN T_FS_TRANSDOWNBILLEntry AS TRANSDOWNBILLEntry \n ON TRANSDOWNBILL.FID = TRANSDOWNBILLEntry.FPARENTID \n LEFT OUTER JOIN T_BD_AccountBanks as UNITYACCOUNTBANKS \n ON TRANSDOWNBILLEntry.FUnitAcctBankID = UNITYACCOUNTBANKS.FID \nLEFT OUTER JOIN T_FS_InnerAccount as INNERACCOUNT \nON UNITYACCOUNTBANKS.FInnerAcctId = INNERACCOUNT.FID \nLEFT OUTER JOIN T_ORG_BaseUnit AS ENTRYCOMPANY \n ON TRANSDOWNBILLEntry.FUNITID = ENTRYCOMPANY.FID \n LEFT OUTER JOIN T_BD_AccountBanks AS ENTRYBANKACNT \n ON TRANSDOWNBILLEntry.FUNITACCTBANKID = ENTRYBANKACNT.FID \n LEFT OUTER JOIN T_BD_Project AS EntryProject \n ON TRANSDOWNBILLEntry.FProjectId = EntryProject.fid \nLEFT OUTER JOIN T_BD_PROJECT AS PROJECT \n ON TRANSDOWNBILL.FProjectId = PROJECT.FID \n LEFT OUTER JOIN T_CAS_FeeType AS FEETYPE \n ON TRANSDOWNBILLEntry.FFEETYPEID = FEETYPE.FID \n WHERE TRANSDOWNBILLEntry.FISSUCCESSED = 1 AND TRANSDOWNBILL.FBIZDATE >= {0} AND TRANSDOWNBILL.FBIZDATE < {1} \n AND MONTHERBANKACNT.FCompanyID = ''{2}'' AND TRANSDOWNBILL.FCURRENCYID = ''{3}'' \n {4} {5}) AS DOWNBILL \n";

    public RptTransUpAndDownDetailHander(FilterInfo filter, KDTable tblMain, RptTransUpAndDownDetailParam filterParam) {
        super(filter, tblMain);
        this.param = filterParam;
    }

    protected String getQueryPath() {
        return "";
    }

    public void setTableStateRow() {
        this.setStat();
        this.setSubTotalRow();
        this.setRowSummation();
    }

    private void setStat() {
        this.kdt.getColumn(FLD_BANK).setStat(true);
    }

    private void setRowSummation() {
        IRow summationRow = this.kdt.getGroupManager().getStatRowTemplate(-1);
        summationRow.getStyleAttributes().setBackground(new Color(0xF6F6B6));
        summationRow.getCell(FLD_BILLTYPE).setValue((Object)EASResource.getString((String)RESOURCE, (String)"Summation"));
        this.setMoneyRowExpressionsSum(summationRow);
    }

    private void setSubTotalRow() {
        IRow subtotalRow = this.kdt.getGroupManager().getStatRowTemplate(1);
        subtotalRow.getStyleAttributes().setBackground(new Color(16119270));
        subtotalRow.getCell(FLD_BANK).setValue((Object)EASResource.getString((String)RESOURCE, (String)"SubTotal"));
        this.setMoneyRowExpressionsSum(subtotalRow);
    }

    private void setMoneyRowExpressionsSum(IRow row) {
        this.setRowExpressionsSum(row, FLD_UPAMOUNT);
        this.setRowExpressionsSum(row, FLD_DOWNAMOUNT);
    }

    private void setRowExpressionsSum(IRow row, String fieldName) {
        row.getCell(fieldName).setExpressions("SUM");
    }

    public void initHeader() {
        super.initHeader();
        this.initTable();
    }

    private void initTable() {
        this.kdt.getGroupManager().setTotalize(true);
        this.initCustomHeader();
    }

    protected void initCustomHeader() {
        this.addCustomRow();
        this.setHeadRowTitle();
    }

    private void setHeadRowTitle() {
        IRow rowH = this.kdt.addHeadRow();
        rowH.getCell(FLD_BILLTYPE).setValue((Object)EASResource.getString((String)RESOURCE, (String)FLD_BILLTYPE));
        rowH.getCell(FLD_BANK).setValue((Object)EASResource.getString((String)RESOURCE, (String)FLD_BANK));
        rowH.getCell(FLD_TRANSCOMPANY).setValue((Object)EASResource.getString((String)RESOURCE, (String)FLD_TRANSCOMPANY));
        rowH.getCell(FLD_INNERACCT).setValue((Object)EASResource.getString((String)RESOURCE, (String)FLD_INNERACCT));
        rowH.getCell(FLD_BANKACCOUNT).setValue((Object)EASResource.getString((String)RESOURCE, (String)FLD_BANKACCOUNT));
        rowH.getCell(FLD_BILLNUMBER).setValue((Object)EASResource.getString((String)RESOURCE, (String)FLD_BILLNUMBER));
        rowH.getCell(FLD_BIZDATE).setValue((Object)EASResource.getString((String)RESOURCE, (String)"BIZDATE"));
        rowH.getCell(FLD_UPAMOUNT).setValue((Object)EASResource.getString((String)RESOURCE, (String)FLD_UPAMOUNT));
        rowH.getCell(FLD_DOWNAMOUNT).setValue((Object)EASResource.getString((String)RESOURCE, (String)FLD_DOWNAMOUNT));
        rowH.getCell(FLD_ISSENDRECEIPT).setValue((Object)EASResource.getString((String)RESOURCE, (String)FLD_ISSENDRECEIPT));
        rowH.getCell(FLD_PROJECT).setValue((Object)EASResource.getString((String)RESOURCE, (String)FLD_PROJECT));
        rowH.getCell(FLD_FEETYPE).setValue((Object)EASResource.getString((String)RESOURCE, (String)FLD_FEETYPE));
        rowH.getCell(FLD_FID).setValue((Object)"ID");
    }

    private void addCustomRow() {
        this.addColumn(FLD_BILLTYPE, true);
        this.addColumn(FLD_BANK, true);
        this.addColumn(FLD_TRANSCOMPANY, true);
        this.addColumn(FLD_INNERACCT, true);
        this.addColumn(FLD_BANKACCOUNT, false);
        this.addColumn(FLD_BILLNUMBER, true);
        this.addColumn(FLD_BIZDATE, true);
        this.addMoneyColumn(FLD_UPAMOUNT);
        this.addMoneyColumn(FLD_DOWNAMOUNT);
        this.addColumn(FLD_ISSENDRECEIPT, false);
        this.addColumn(FLD_PROJECT, false);
        this.addColumn(FLD_FEETYPE, false);
        this.addColumn(FLD_FID, false);
        this.kdt.getColumn(FLD_FID).getStyleAttributes().setHided(true);
    }

    private void addMoneyColumn(String fieldName) {
        IColumn moneyColumn = this.kdt.addColumn();
        moneyColumn.setKey(fieldName);
        this.formatCol(moneyColumn, this.precisionLocalCurrency);
    }

    protected void formatCol(IColumn col, int precision) {
        col.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        col.getStyleAttributes().setNumberFormat(FMClientHelper.getNumberFtm((int)precision));
    }

    private void addColumn(String fieldName, boolean isGroup) {
        IColumn column = this.kdt.addColumn();
        column.setKey(fieldName);
        column.setGroup(isGroup);
    }

    public IRowSet getRowSet() throws BOSException {
        return SQLExecutorFactory.getRemoteInstance((String)this.getDetailSQL()).executeSQL();
    }

    private String getDetailSQL() {
        StringBuffer beginDate = new StringBuffer("{");
        beginDate.append(FMConstants.FORMAT_DAY.format(this.param.getBeginDate())).append("}");
        StringBuffer endDate = new StringBuffer("{");
        endDate.append(FMConstants.FORMAT_DAY.format(this.param.getEndDate()));
        endDate.append("}");
        String sql1 = this.getBankFilter();
        String[] tempSql = this.getTransCompanyFilter();
        String montherAcctBankCompanyId = "";
        if (!EmptyUtil.isEmpty((CoreBaseInfo)this.param.getMontherAcctBankCompany())) {
            montherAcctBankCompanyId = this.param.getMontherAcctBankCompany().getId().toString();
        }
        String currency = "";
        if (!EmptyUtil.isEmpty((CoreBaseInfo)this.param.getCurrency())) {
            currency = this.param.getCurrency().getId().toString();
        }
        Object[] args1 = new Object[]{beginDate.toString(), endDate.toString(), montherAcctBankCompanyId, currency, sql1, tempSql[0], EASResource.getString((String)RESOURCE, (String)"UPTYPENAME"), SysContext.getSysContext().getLocale().toString()};
        Object[] args2 = new Object[]{beginDate.toString(), endDate.toString(), montherAcctBankCompanyId, currency, sql1, tempSql[1], EASResource.getString((String)RESOURCE, (String)"DOWNTYPENAME"), SysContext.getSysContext().getLocale().toString()};
        String upSql1 = MessageFormat.format(upSql, args1);
        String downSql1 = MessageFormat.format(downSql, args2);
        String sql = upSql1 + "union all \n" + downSql1;
        sql = MessageFormat.format(allSql, sql);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("RptTransUpAndDownDetailHander sql is:" + sql));
        }
        return sql;
    }

    private String[] getTransCompanyFilter() {
        String[] sql = new String[]{new String(), new String()};
        if (!EmptyUtil.isEmpty((Object[])this.param.getTransCompanySet())) {
            StringBuffer strBuf = new StringBuffer();
            boolean isFirst = true;
            for (CoreBaseInfo info : this.param.getTransCompanySet()) {
                if (EmptyUtil.isEmpty((CoreBaseInfo)info)) continue;
                if (isFirst) {
                    strBuf.append("'" + info.getId().toString() + "'");
                    isFirst = false;
                    continue;
                }
                strBuf.append(",'" + info.getId().toString() + "'");
            }
            if (strBuf.length() > 0) {
                sql[0] = " AND TransUpBillEntry.FUNITID IN (" + strBuf.toString() + ")";
                sql[1] = " AND TransDOWNBillEntry.FUNITID IN (" + strBuf.toString() + ")";
            }
        }
        return sql;
    }

    private String getBankFilter() {
        String sql1 = "";
        if (!EmptyUtil.isEmpty((Object[])this.param.getBank())) {
            StringBuffer strBuf = new StringBuffer();
            boolean isFirst = true;
            for (CoreBaseInfo info : this.param.getBank()) {
                if (EmptyUtil.isEmpty((CoreBaseInfo)info)) continue;
                if (isFirst) {
                    strBuf.append("'" + info.getId().toString() + "'");
                    isFirst = false;
                    continue;
                }
                strBuf.append(",'" + info.getId().toString() + "'");
            }
            if (strBuf.length() > 0) {
                sql1 = " AND BANK.FID IN (" + strBuf.toString() + ")";
            }
        }
        return sql1;
    }

    public void filldata(IRowSet rs) throws SQLException, EASBizException, BOSException {
        super.filldata(rs);
        this.kdt.setRefresh(false);
        while (rs.next()) {
            IRow row = this.kdt.addRow();
            row.getCell(FLD_BILLTYPE).setValue(rs.getObject(FLD_BILLTYPE));
            row.getCell(FLD_BANK).setValue(rs.getObject(FLD_BANK));
            row.getCell(FLD_TRANSCOMPANY).setValue(rs.getObject(FLD_TRANSCOMPANY));
            row.getCell(FLD_INNERACCT).setValue(rs.getObject(FLD_INNERACCT));
            row.getCell(FLD_BANKACCOUNT).setValue(rs.getObject(FLD_BANKACCOUNT));
            row.getCell(FLD_BILLNUMBER).setValue(rs.getObject(FLD_BILLNUMBER));
            String[] tempDate = rs.getObject(FLD_BIZDATE).toString().split(" ");
            row.getCell(FLD_BIZDATE).setValue((Object)tempDate[0]);
            row.getCell(FLD_UPAMOUNT).setValue(rs.getObject(FLD_UPAMOUNT));
            row.getCell(FLD_DOWNAMOUNT).setValue(rs.getObject(FLD_DOWNAMOUNT));
            if (EmptyUtil.isEmpty((Object)rs.getObject(FLD_ISSENDRECEIPT)) || rs.getObject(FLD_ISSENDRECEIPT).toString().equals("0")) {
                row.getCell(FLD_ISSENDRECEIPT).setValue((Object)Boolean.FALSE);
            } else {
                row.getCell(FLD_ISSENDRECEIPT).setValue((Object)Boolean.TRUE);
            }
            row.getCell(FLD_PROJECT).setValue(rs.getObject(FLD_PROJECT));
            row.getCell(FLD_FEETYPE).setValue(rs.getObject(FLD_FEETYPE));
            row.getCell(FLD_FID).setValue(rs.getObject(FLD_FID));
        }
    }
}

