/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.fs.FSHelper;
import com.kingdee.eas.fm.fs.InnerAccountInfo;
import com.kingdee.eas.fm.fs.SummaryLedgerCollection;
import com.kingdee.eas.fm.fs.SummaryLedgerInfo;
import com.kingdee.eas.fm.fs.client.AbstractInitHandler;
import java.math.BigDecimal;
import java.util.Iterator;
import javax.swing.JTextField;

public class SettleInitHandler
extends AbstractInitHandler {
    public final String DCO_COL = "debitCount";
    public final String CCO_COL = "creditCount";

    @Override
    public void initTable(KDTable table, boolean isFirstDay) {
        String[] columnKeys = new String[]{"depositor", "innerAccount", "credit", "creditCount", "debit", "debitCount", "balance"};
        String[] columnNames = new String[]{DEPOSITOR, INNERACCT, YEARCREDITAMT, YEARCREDITCOUNT, YEARDEBITAMT, YEARDEBITCOUNT, OPENBALANCE};
        table.addColumns(columnKeys.length);
        IRow hRow = table.addHeadRow();
        for (int i = 0; i < columnKeys.length; ++i) {
            table.getColumn(i).setKey(columnKeys[i]);
            hRow.getCell(i).setValue((Object)columnNames[i]);
        }
        table.getColumn("debitCount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        table.getColumn("creditCount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        FMClientHelper.setNumberFormat((KDTable)table, (String)"debit", (String)this.getCurrency().getId().toString());
        FMClientHelper.setNumberFormat((KDTable)table, (String)"credit", (String)this.getCurrency().getId().toString());
        FMClientHelper.setNumberFormat((KDTable)table, (String)"balance", (String)this.getCurrency().getId().toString());
        this.setColumnLocked(table);
        table.getColumn("debit").setWidth(150);
        table.getColumn("credit").setWidth(150);
        table.getColumn("balance").setWidth(150);
        table.getColumn("debitCount").setWidth(110);
        table.getColumn("creditCount").setWidth(110);
        int prec = FMClientHelper.getPrecOfCurrency((BOSUuid)this.getCurrency().getId());
        KDFormattedTextField txtField1 = new KDFormattedTextField(0);
        txtField1.setPrecision(prec);
        txtField1.setSupportedEmpty(true);
        txtField1.setNegatived(false);
        table.getColumn("debitCount").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtField1));
        KDFormattedTextField txtField2 = new KDFormattedTextField(0);
        txtField2.setPrecision(prec);
        txtField2.setSupportedEmpty(true);
        txtField2.setNegatived(false);
        table.getColumn("creditCount").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtField2));
        KDFormattedTextField txtField3 = new KDFormattedTextField(1);
        txtField3.setPrecision(prec);
        txtField3.setSupportedEmpty(true);
        table.getColumn("debit").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtField3));
        KDFormattedTextField txtField4 = new KDFormattedTextField(1);
        txtField4.setPrecision(prec);
        txtField4.setSupportedEmpty(true);
        table.getColumn("credit").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtField4));
        KDFormattedTextField txtField5 = new KDFormattedTextField(1);
        txtField5.setPrecision(prec);
        txtField5.setSupportedEmpty(true);
        table.getColumn("balance").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtField5));
        if (isFirstDay) {
            table.getColumn("debit").getStyleAttributes().setHided(true);
            table.getColumn("credit").getStyleAttributes().setHided(true);
            table.getColumn("debitCount").getStyleAttributes().setHided(true);
            table.getColumn("creditCount").getStyleAttributes().setHided(true);
        }
    }

    @Override
    public void setColumnLocked(KDTable table) {
        table.getColumn("depositor").getStyleAttributes().setLocked(true);
        table.getColumn("innerAccount").getStyleAttributes().setLocked(true);
    }

    @Override
    public void loadField(KDTable table) throws Exception {
        SummaryLedgerCollection slc = this.getColl();
        table.removeRows();
        FMHelper.sortCollection((AbstractObjectCollection)slc, (String[])this.strArray);
        Iterator iter = slc.iterator();
        while (iter.hasNext()) {
            SummaryLedgerInfo sli = (SummaryLedgerInfo)iter.next();
            IRow row = table.addRow();
            ICell depositor = row.getCell("depositor");
            depositor.setValue((Object)sli.getApplyUnit());
            ICell innerAccount = row.getCell("innerAccount");
            innerAccount.setValue((Object)sli.getInnerAccount());
            ICell debit = row.getCell("debit");
            debit.setValue((Object)FMHelper.getBigDecimalNULL((BigDecimal)sli.getDebitTotal()));
            ICell debitCount = row.getCell("debitCount");
            debitCount.setValue((Object)new Integer(sli.getDebitCounts()));
            ICell credit = row.getCell("credit");
            credit.setValue((Object)FMHelper.getBigDecimalNULL((BigDecimal)sli.getCreditTotal()));
            ICell creditCount = row.getCell("creditCount");
            creditCount.setValue((Object)new Integer(sli.getCreditCounts()));
            ICell openBalance = row.getCell("balance");
            BigDecimal endBalance = FMHelper.getBigDecimalNULL((BigDecimal)sli.getEndBalance());
            if (endBalance != null) {
                endBalance = endBalance.negate();
            }
            openBalance.setValue((Object)endBalance);
        }
        super.loadField(table);
    }

    @Override
    public SummaryLedgerCollection storeField(KDTable table) throws Exception {
        table.getEditManager().stopEditing();
        int rowCount = table.getRowCount();
        SummaryLedgerCollection slc = null;
        if (rowCount > 0) {
            slc = new SummaryLedgerCollection();
            for (int i = 0; i < rowCount; ++i) {
                IRow row = table.getRow(i);
                SummaryLedgerInfo summaryLedgerInfo = new SummaryLedgerInfo();
                summaryLedgerInfo.setCurrency(this.getCurrency());
                summaryLedgerInfo.setInnerAccount((InnerAccountInfo)row.getCell("innerAccount").getValue());
                summaryLedgerInfo.setApplyUnit((CompanyOrgUnitInfo)row.getCell("depositor").getValue());
                summaryLedgerInfo.setCompany(ContextHelperFactory.getRemoteInstance().getCurrentCompany());
                BigDecimal debitTotal = row.getCell("debit").getValue() == null ? Constants.ZERO : new BigDecimal(row.getCell("debit").getValue().toString());
                summaryLedgerInfo.setDebitTotal(debitTotal);
                Integer debitCount = row.getCell("debitCount").getValue() == null ? Integer.valueOf("0") : Integer.valueOf(row.getCell("debitCount").getValue().toString());
                summaryLedgerInfo.setDebitCounts(debitCount);
                BigDecimal creditTotal = row.getCell("credit").getValue() == null ? Constants.ZERO : new BigDecimal(row.getCell("credit").getValue().toString());
                summaryLedgerInfo.setCreditTotal(creditTotal);
                Integer creditCount = row.getCell("creditCount").getValue() == null ? Integer.valueOf("0") : Integer.valueOf(row.getCell("creditCount").getValue().toString());
                summaryLedgerInfo.setCreditCounts(creditCount);
                BigDecimal balance = row.getCell("balance").getValue() == null ? Constants.ZERO : new BigDecimal(row.getCell("balance").getValue().toString());
                balance = balance.negate();
                summaryLedgerInfo.setEndBalance(balance);
                summaryLedgerInfo.setBeginBalance(Constants.ZERO);
                summaryLedgerInfo.setLocalBeginBalance(Constants.ZERO);
                summaryLedgerInfo.setLocalDebitTotal(Constants.ZERO);
                summaryLedgerInfo.setLocalCreditTotal(Constants.ZERO);
                summaryLedgerInfo.setLocalEndBalance(Constants.ZERO);
                summaryLedgerInfo.setBeginBalanceDC(FSHelper.getBalanceDirection(summaryLedgerInfo.getBeginBalance()));
                summaryLedgerInfo.setEndBalanceDC(FSHelper.getBalanceDirection(summaryLedgerInfo.getEndBalance()));
                slc.add(summaryLedgerInfo);
            }
        }
        return slc;
    }
}

