/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.fs.InnerAccountInfo;
import com.kingdee.eas.fm.fs.client.AbstractSettleLedgerHandler;
import com.kingdee.eas.fm.fs.client.AbstractSettleLedgerUI;
import com.kingdee.eas.fm.fs.client.FSAnalysisHandlerFactory;
import com.kingdee.eas.fm.fs.client.FSClientHelper;
import com.kingdee.eas.fm.fs.client.SettleLedgerFilterParam;
import com.kingdee.eas.fm.fs.client.SettleLedgerFilterUI;
import com.kingdee.eas.fm.fs.client.SubsidiaryLedgerFilterParam;
import com.kingdee.eas.fm.fs.client.SubsidiaryLedgerUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.TreePath;

public class SettleLedgerUI
extends AbstractSettleLedgerUI {
    private String resourcePath = "com.kingdee.eas.fm.fs.client.SettleLedgerResource";
    private SettleLedgerFilterUI filterUI;
    private BankInfo clearingHouse;

    public void onShow() throws Exception {
        super.onShow();
        this.treeList.requestFocus();
    }

    protected void execQuery() throws BOSException {
        this.tblMain.checkParsed();
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblMain.getSelectManager().setSelectMode(10);
        SettleLedgerFilterParam param = (SettleLedgerFilterParam)this.getFilterParam();
        if (param.isByCompany()) {
            this.actionSubsidiaryLedger.setEnabled(true);
        } else {
            this.actionSubsidiaryLedger.setEnabled(false);
        }
        AbstractSettleLedgerHandler handler = FSAnalysisHandlerFactory.getHandler(param);
        try {
            handler.initTree(this.treeList, param);
        }
        catch (EASBizException e) {
            SysUtil.abort();
        }
        if (param.isByCompany()) {
            FSClientHelper.setFirstInnerAcctNodeSelected(this.treeList);
        } else {
            FMClientHelper.goLeaf((KDTree)this.treeList);
        }
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new SettleLedgerFilterUI();
        }
        return this.filterUI;
    }

    @Override
    protected void treeList_valueChanged(TreeSelectionEvent e) throws Exception {
        super.treeList_valueChanged(e);
        FMClientHelper.clearTable((KDTable)this.tblMain);
        SettleLedgerFilterParam param = (SettleLedgerFilterParam)this.getFilterParam();
        TreePath path = e.getNewLeadSelectionPath();
        if (path == null) {
            return;
        }
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.treeList.getModel().getRoot();
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)path.getLastPathComponent();
        Object info = node.getUserObject();
        if (info == null) {
            return;
        }
        AbstractSettleLedgerHandler handler = FSAnalysisHandlerFactory.getHandler(param);
        handler.initTable(this.tblMain, param);
        handler.fillData(this.tblMain, param, info, this.mainQuery, this.mainQueryPK);
        this.tblMain.getGroupManager().group();
    }

    @Override
    public void actionSubsidiaryLedger_actionPerformed(ActionEvent e) throws Exception {
        DefaultKingdeeTreeNode node;
        Object info;
        boolean isValiNode;
        SubsidiaryLedgerFilterParam param = new SubsidiaryLedgerFilterParam();
        SettleLedgerFilterParam settleParam = (SettleLedgerFilterParam)this.getFilterParam();
        TreePath path = this.treeList.getSelectionPath();
        if (path == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
        if (!(isValiNode = (info = (node = (DefaultKingdeeTreeNode)path.getLastPathComponent()).getUserObject()) instanceof InnerAccountInfo)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
        param.setByDay(false);
        param.setBeginYear(settleParam.getBeginYear());
        param.setEndYear(settleParam.getEndYear());
        param.setBeginMonth(settleParam.getBeginMonth());
        param.setEndMonth(settleParam.getEndMonth());
        param.setCompanyIds(settleParam.getCompanyIdAry());
        param.setDispBalance(true);
        param.setDispMouthTotal(true);
        param.setDispYearTotal(true);
        param.setOrderByCompany(true);
        String currencyId = settleParam.getCurrencyId();
        CurrencyInfo currencyInfo = null;
        if (currencyId != null) {
            currencyInfo = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyId));
        }
        SubsidiaryLedgerUI.showSubsidiaryLedgerUI((IUIObject)this, param, node, currencyInfo);
    }

    private void checkClearHourse() throws Exception {
        FSClientHelper.checkClearingHouseCompany();
    }

    public void onLoad() throws Exception {
        this.checkClearHourse();
        CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        super.onLoad();
        this.btnQuery.setText(this.resHelper.getString("ActionQuery.SHORT_DESCRIPTION"));
        this.btnPrint.setText(this.resHelper.getString("ActionPrint.SHORT_DESCRIPTION"));
        this.btnPrintPre.setText(this.resHelper.getString("ActionPrintPre.SHORT_DESCRIPTION"));
        this.btnRefresh.setText(this.resHelper.getString("ActionRefresh.NAME"));
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionSubsidiaryLedger.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_list"));
    }

    protected KDTable getMainTable() {
        return this.tblMain;
    }
}

