/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.client.f7.NewCompanyF7;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMSysDefinedEnum;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.fs.InnerAccountFactory;
import com.kingdee.eas.fm.fs.SettBizTypeEnum;
import com.kingdee.eas.fm.fs.SettlementBillFilterParam;
import com.kingdee.eas.fm.fs.SettlementBillRpcCacheInfo;
import com.kingdee.eas.fm.fs.client.AbstractSettlementBillFilterUI;
import com.kingdee.eas.fm.fs.client.CurrencyUtil;
import com.kingdee.eas.fm.fs.client.FSClientHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.util.Collection;
import java.util.Date;
import javax.swing.border.TitledBorder;

public class SettlementBillFilterUI
extends AbstractSettlementBillFilterUI {
    private static String resourcePath = "com.kingdee.eas.fm.fs.FSClientResource";
    private SettBizTypeEnum type = null;
    private CurrencyInfo localCurrencyInfo = null;
    private boolean isBOTP = false;
    private boolean isSimple = false;
    private boolean isViewSettle = true;
    private SettlementBillRpcCacheInfo rpcCacheInfo = new SettlementBillRpcCacheInfo();

    public SettlementBillFilterUI() throws Exception {
    }

    public SettlementBillFilterUI(boolean isSimple) throws Exception {
        this.isSimple = isSimple;
    }

    public SettlementBillFilterUI(boolean isSimple, boolean isViewSettle, SettlementBillRpcCacheInfo rpcCacheInfo) throws Exception {
        this.isSimple = isSimple;
        this.isViewSettle = isViewSettle;
        this.rpcCacheInfo = rpcCacheInfo;
    }

    public SettlementBillFilterUI(SettBizTypeEnum type, boolean isBOTP) throws Exception {
        this.type = type;
        this.isBOTP = isBOTP;
    }

    public SettlementBillFilterUI(SettBizTypeEnum bizType, boolean isBOTP, SettlementBillRpcCacheInfo rpcCacheInfo) throws Exception {
        this(bizType, isBOTP);
        this.rpcCacheInfo = rpcCacheInfo;
    }

    protected void init() throws Exception {
        super.init();
        this.chkIA_actionPerformed(null);
        this.cboType.addItem((Object)FMSysDefinedEnum.SELECT_ALL);
        this.cboType.setSelectedItem((Object)FMSysDefinedEnum.SELECT_ALL);
        if (this.rpcCacheInfo.getAllCurrencyColl() == null) {
            CurrencyUtil.fillCombCurrency(this.cboCurrency);
        } else {
            CurrencyUtil.fillCombCurrency(this.cboCurrency, this.rpcCacheInfo.getAllCurrencyColl());
        }
        this.cboCurrency.addItem((Object)FMSysDefinedEnum.SELECT_ALL);
        this.localCurrencyInfo = this.currentCompany.getBaseCurrency();
        this.f7InnerAcct.setQueryInfo("com.kingdee.eas.fm.fs.F7InnerAccountQuery");
        this.f7InnerAcct.setDisplayFormat("$number$ $name$");
        this.f7InnerAcct.setEditFormat("$number$");
        this.f7InnerAcct.setCommitFormat("$number$");
        this.f7InnerAcct.setEditable(true);
        this.f7InnerAcct.setEnabledMultiSelection(true);
        String curCompanyId = this.currentCompany.getId().toString();
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        ev.setFilter(filter);
        if (!this.isBOTP) {
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)curCompanyId));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("applyUnit.id", (Object)curCompanyId));
        }
        this.f7InnerAcct.setEntityViewInfo(ev);
        this.initProps();
    }

    private void initProps() {
        Date beginDate = new Date();
        Date endDate = new Date();
        if (!this.isBOTP) {
            BankInfo chInfo = this.rpcCacheInfo.getClearHouse();
            String strValue = this.rpcCacheInfo.getTM023();
            Date selectDate = this.rpcCacheInfo.getServerDate();
            if (this.rpcCacheInfo.isEmpty()) {
                try {
                    chInfo = FSClientHelper.getClearingHouse();
                    selectDate = FMClientHelper.getServerDate();
                    strValue = ContextHelperFactory.getRemoteInstance().getStringParam("TM023", (IObjectPK)new ObjectUuidPK(this.currentCompany.getId()));
                }
                catch (Exception e) {
                    this.handUIException(e);
                }
            }
            if ((selectDate = strValue == null || "0".equals(strValue) ? chInfo.getSettleDate() : ("1".equals(strValue) ? this.rpcCacheInfo.getServerDate() : chInfo.getSettleDate())) != null) {
                beginDate = selectDate;
                endDate = selectDate;
            }
        }
        this.dtpFrom.setValue((Object)beginDate);
        this.dtpTo.setValue((Object)endDate);
        FMClientHelper.setSelectObject((KDComboBox)this.cboCurrency, (Object)this.localCurrencyInfo);
        if (this.isSimple) {
            this.rdbAll.setSelected(true);
            this.rbAllSettleState.setSelected(true);
        } else {
            this.rdbNotAccept.setSelected(true);
            this.rbNotSettledState.setSelected(true);
        }
        this.setCompanyIds(new String[]{this.currentCompany.getId().toString()});
        this.f7InnerAcct.setValue(null);
    }

    public void clear() {
        super.clear();
        this.initProps();
    }

    public FilterInfo getFilterInfo() {
        return super.getFilterInfo();
    }

    public void setFilterInfo(FilterInfo filterInfo) {
        super.setFilterInfo(filterInfo);
    }

    protected NewCompanyF7 getNewCompanyF7() {
        if (FSClientHelper.isCHUser()) {
            try {
                return super.getAllCompanyOrg();
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        return super.getNewCompanyF7();
    }

    protected void initCompanyState() {
        super.initCompanyState();
    }

    public void onLoad() throws Exception {
        FSClientHelper.checkClearingHouseCompany();
        this.initSettlePanel();
        super.onLoad();
    }

    private void initSettlePanel() {
        boolean isSettleIn;
        String have = EASResource.getString((String)resourcePath, (String)"have");
        String not = EASResource.getString((String)resourcePath, (String)"not");
        boolean other = false;
        boolean isPayOut = this.type != null && (this.type.equals((Object)SettBizTypeEnum.PAYOUTSIDE) || this.type.equals((Object)SettBizTypeEnum.PAYINSIDEDIF));
        boolean isRecOut = this.type != null && (this.type.equals((Object)SettBizTypeEnum.RECOUTSIDE) || this.type.equals((Object)SettBizTypeEnum.RECINSIDEDIF));
        boolean bl = isSettleIn = this.type != null && (this.type.equals((Object)SettBizTypeEnum.PAYINSIDE) || this.type.equals((Object)SettBizTypeEnum.RECINSIDE));
        if (isPayOut) {
            String payName = EASResource.getString((String)resourcePath, (String)"payment");
            TitledBorder border = (TitledBorder)this.pnlSettle.getBorder();
            border.setTitle(payName);
            this.rbSettledState.setText(have + payName);
            this.rbNotSettledState.setText(not + payName);
        } else if (isRecOut) {
            String recName = EASResource.getString((String)resourcePath, (String)"receive");
            TitledBorder border = (TitledBorder)this.pnlSettle.getBorder();
            border.setTitle(recName);
            this.rbSettledState.setText(have + recName);
            this.rbNotSettledState.setText(not + recName);
        } else if (isSettleIn) {
            this.pnlSettle.setVisible(false);
        } else {
            String settleName = EASResource.getString((String)resourcePath, (String)"settlement");
            TitledBorder border = (TitledBorder)this.pnlSettle.getBorder();
            border.setTitle(settleName);
            this.rbSettledState.setText(have + settleName);
            this.rbNotSettledState.setText(not + settleName);
        }
        if (!this.isViewSettle) {
            this.pnlSettle.setVisible(false);
        }
    }

    public void setParam(Object param) {
        if (param == null) {
            return;
        }
        SettlementBillFilterParam settlementParam = (SettlementBillFilterParam)param;
        if (settlementParam.getIsAcceptted() == -1) {
            this.rdbAll.setSelected(true);
        } else if (settlementParam.getIsAcceptted() == 1) {
            this.rdbIsAccept.setSelected(true);
        } else {
            this.rdbNotAccept.setSelected(true);
        }
        if (settlementParam.getIsSettled() == 0) {
            this.rbSettledState.setSelected(true);
        } else if (settlementParam.getIsSettled() == 1) {
            this.rbNotSettledState.setSelected(true);
        } else {
            this.rbAllSettleState.setSelected(true);
        }
        String[] companyIds = settlementParam.getCompanyIdAry();
        this.setCompanyIds(companyIds);
        if (settlementParam.getCurrencyId() != null) {
            CurrencyInfo currency = new CurrencyInfo();
            currency.setId(BOSUuid.read((String)settlementParam.getCurrencyId()));
            FMClientHelper.setSelectObject((KDComboBox)this.cboCurrency, (Object)currency);
        } else {
            this.cboCurrency.setSelectedIndex(this.cboCurrency.getItemCount() - 1);
        }
        if (!FMHelper.isEmpty((Collection)settlementParam.getInnerAcctId())) {
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)settlementParam.getInnerAcctId(), CompareType.INCLUDE));
            ev.setFilter(filter);
            try {
                this.f7InnerAcct.setValue((Object)InnerAccountFactory.getRemoteInstance().getCollection(ev).toArray());
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        } else {
            this.f7InnerAcct.setValue(null);
        }
        if (settlementParam.getBizType() != -1) {
            this.cboType.setSelectedItem((Object)SettBizTypeEnum.getEnum(settlementParam.getBizType()));
        } else {
            this.cboType.setSelectedIndex(this.cboType.getItemCount() - 1);
        }
        this.dtpFrom.setValue((Object)settlementParam.getDateFrom());
        this.dtpTo.setValue((Object)settlementParam.getDateTo());
    }

    public Object getParam() {
        SettlementBillFilterParam param = new SettlementBillFilterParam();
        String[] companyIds = this.getCompanyIds();
        param.setCompanyIdAry(companyIds);
        if (this.rdbAll.isSelected()) {
            param.setIsAcceptted(-1);
        } else if (this.rdbIsAccept.isSelected()) {
            param.setIsAcceptted(1);
        } else {
            param.setIsAcceptted(0);
        }
        if (!this.pnlSettle.isVisible() || this.rbAllSettleState.isSelected()) {
            param.setIsSettled(2);
        } else if (this.rbNotSettledState.isSelected()) {
            param.setIsSettled(1);
        } else {
            param.setIsSettled(0);
        }
        if (this.type != null) {
            param.setBizType(this.type.getValue());
        } else {
            param.setBizType(-1);
        }
        if (!(this.cboCurrency.getSelectedItem() instanceof FMSysDefinedEnum)) {
            param.setCurrencyId(((CurrencyInfo)this.cboCurrency.getSelectedItem()).getId().toString());
        } else {
            param.setCurrencyId(null);
        }
        param.setInnerAcctId(FMHelper.asSet((String[])AccessHelper.getF7Ids((KDBizPromptBox)this.f7InnerAcct)));
        param.setDateFrom((Date)this.dtpFrom.getValue());
        param.setDateTo((Date)this.dtpTo.getValue());
        return param;
    }

    public boolean verify() {
        if (this.getCompanyIds() == null || this.getCompanyIds().length == 0) {
            this.btnCompanySelect.requestFocus(true);
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"NoOrgUnit"));
            SysUtil.abort();
        }
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (String)resourcePath, (KDDatePicker)this.dtpFrom, (String)"NoDate");
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (String)resourcePath, (KDDatePicker)this.dtpTo, (String)"NoDate");
        FMClientVerifyHelper.verifyDateFromTo((CoreUIObject)this, (String)resourcePath, (Date)((Date)this.dtpFrom.getValue()), (Date)((Date)this.dtpTo.getValue()), (String)"CheckDateFromTo");
        return true;
    }

    protected Class getParamClass() {
        return SettlementBillFilterParam.class;
    }

    protected boolean isNeedEachSerializable() {
        return true;
    }
}

