/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankException;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankGroupInfo;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.AccountMgrStrategyFactory;
import com.kingdee.eas.basedata.assistant.AccountMgrStrategyInfo;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateFactory;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.ExchangeTableInfo;
import com.kingdee.eas.basedata.assistant.IExchangeRate;
import com.kingdee.eas.basedata.assistant.OverdraftCtrlEnum;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.CashDataSourceEnum;
import com.kingdee.eas.fi.cas.CashDataTypeEnum;
import com.kingdee.eas.fi.cas.CashManagementFactory;
import com.kingdee.eas.fi.cas.PaymentBillFactory;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fi.cas.RecPayAcctBankStratageCtrl;
import com.kingdee.eas.fi.cas.RecPayHelper;
import com.kingdee.eas.fi.cas.ReceivingBillInfo;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.fpl.client.FpItemClientHelper;
import com.kingdee.eas.fm.fs.FSException;
import com.kingdee.eas.fm.fs.ISettlementBill;
import com.kingdee.eas.fm.fs.InAcctDataTypeEnum;
import com.kingdee.eas.fm.fs.InAcctFactory;
import com.kingdee.eas.fm.fs.InnerAccountFactory;
import com.kingdee.eas.fm.fs.InnerAccountInfo;
import com.kingdee.eas.fm.fs.InnerAcctGroupEntryCollection;
import com.kingdee.eas.fm.fs.InnerAcctGroupEntryFactory;
import com.kingdee.eas.fm.fs.InnerAcctGroupEntryInfo;
import com.kingdee.eas.fm.fs.InnerAcctGroupFactory;
import com.kingdee.eas.fm.fs.InnerAcctGroupInfo;
import com.kingdee.eas.fm.fs.InnerFrozenDepositFactory;
import com.kingdee.eas.fm.fs.MutilClearHouserHelper;
import com.kingdee.eas.fm.fs.SettBizTypeEnum;
import com.kingdee.eas.fm.fs.SettleFacadeFactory;
import com.kingdee.eas.fm.fs.SettlementBillFactory;
import com.kingdee.eas.fm.fs.SettlementBillInfo;
import com.kingdee.eas.fm.fs.SettlementBillRpcCacheInfo;
import com.kingdee.eas.fm.fs.SettlementBillSourceEnum;
import com.kingdee.eas.fm.fs.client.FSClientHelper;
import com.kingdee.eas.fm.fs.client.InnerFrozenBillHandler;
import com.kingdee.eas.fm.fs.client.SettlementBillEditUI;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.TypeConversionUtils;
import java.awt.Component;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class SettlementBillHandler {
    private static final String resourcePath = "com.kingdee.eas.fm.fs.SettlementBillUI";
    private static final int ROUND = 4;
    private InnerFrozenBillHandler handler = InnerFrozenBillHandler.create();
    public static final String BIZTYPE = "BizType";
    static Map exchangeRatePrecMap = new HashMap();
    private RecPayInstanceAmountBean instanceBean = new RecPayInstanceAmountBean(Constants.ZERO, null, null);

    public static SettlementBillHandler create() {
        return new SettlementBillHandler();
    }

    public void setListUITable(KDTable tblMain, KDTDataRequestEvent e, SettlementBillRpcCacheInfo rpcCacheInfo) {
        if (e == null || e.getLastRow() == -1) {
            return;
        }
        tblMain.checkParsed();
        IRow row = null;
        String currencyId = null;
        CompanyOrgUnitInfo companyInfo = rpcCacheInfo.getChCompany();
        if (companyInfo == null) {
            row = tblMain.getRow(0);
            String id = (String)row.getCell("id").getValue();
            companyInfo = this.getCompanyInfo(id);
        }
        for (int i = e.getFirstRow(); i <= e.getLastRow(); ++i) {
            row = tblMain.getRow(i);
            ICell cell = row.getCell("status");
            currencyId = (String)row.getCell("currencyID").getValue();
            if (currencyId != null) {
                FMClientHelper.setNumberFormat((IRow)row, (String)"amount", (String)currencyId);
            }
            if (companyInfo != null && companyInfo.getBaseCurrency() != null) {
                String baseCurrency = companyInfo.getBaseCurrency().getId().toString();
                FMClientHelper.setNumberFormat((IRow)row, (String)"localAmt", (String)baseCurrency);
            }
            if (tblMain.getColumn("exchange") != null) {
                Date date = (Date)row.getCell("createDate").getValue();
                int prec = SettlementBillHandler.getExRatePrec(currencyId, null, companyInfo, date);
                row.getCell("exchange").getStyleAttributes().setNumberFormat(FMClientHelper.getNumberFtm((int)prec));
            }
            if (row.getCell("cashier").getValue() != null) {
                cell.setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.fs.SettlementBillStatusResource", (String)"SETTLEMENTED"));
                continue;
            }
            if (row.getCell("auditor").getValue() != null) {
                cell.setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.fs.SettlementBillStatusResource", (String)"AUDIT"));
                continue;
            }
            if (row.getCell("acceptor").getValue() != null) {
                cell.setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.fs.SettlementBillStatusResource", (String)"ACCEPTED"));
                continue;
            }
            if (Boolean.valueOf(row.getCell("isSubmit").getValue().toString()).booleanValue()) {
                cell.setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.fs.SettlementBillStatusResource", (String)"SUBMITED"));
                continue;
            }
            cell.setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.fs.SettlementBillStatusResource", (String)"SAVED"));
        }
    }

    private CompanyOrgUnitInfo getCompanyInfo(String settleBillId) {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("company.*"));
        sic.add(new SelectorItemInfo("company.baseCurrency.*"));
        sic.add(new SelectorItemInfo("company.baseExchangeTable.*"));
        try {
            ISettlementBill iSettle = SettlementBillFactory.getRemoteInstance();
            SettlementBillInfo settleInfo = iSettle.getSettlementBillInfo((IObjectPK)new ObjectUuidPK(settleBillId), sic);
            return settleInfo.getCompany();
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return null;
    }

    public static int getExRatePrec(String srcCurrId, String destCurrId, CompanyOrgUnitInfo company, Date date) {
        if (srcCurrId == null || date == null) {
            return 0;
        }
        try {
            if (destCurrId == null) {
                if (company == null) {
                    company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
                }
                destCurrId = company.getBaseCurrency().getId().toString();
            }
            return SettlementBillHandler.getExchangeRatePrec(srcCurrId, destCurrId);
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return 0;
    }

    public static int getExchangeRatePrec(String sourceCurID, String desCurID) throws BOSException, EASBizException {
        String key = sourceCurID + "+" + desCurID;
        if (exchangeRatePrecMap.containsKey(key)) {
            return (Integer)exchangeRatePrecMap.get(key);
        }
        int prec = FMClientHelper.getExchangeRatePrec((String)sourceCurID, (String)desCurID);
        exchangeRatePrecMap.put(key, new Integer(prec));
        return prec;
    }

    public static SettBizTypeEnum getBizType(String type) throws EASBizException {
        if (type == null || FMHelper.isEmpty((String)type)) {
            throw new FSException(FSException.UIPARAMERROR);
        }
        SettBizTypeEnum bizType = SettBizTypeEnum.getEnum(type);
        if (bizType == null) {
            throw new FSException(FSException.UIPARAMERROR);
        }
        return bizType;
    }

    protected BigDecimal getBalanceValue(CurrencyInfo currencyInfo, InnerAccountInfo innerAcctInfo) throws EASBizException, BOSException {
        if (currencyInfo == null || innerAcctInfo == null) {
            return Constants.ZERO;
        }
        String key = innerAcctInfo.getId().toString() + currencyInfo.getId().toString();
        ObjectUuidPK chCompanyPk = new ObjectUuidPK(innerAcctInfo.getCompany().getId());
        CompanyOrgUnitInfo chCompany = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)chCompanyPk);
        BankInfo clearingHouse = BankFactory.getRemoteInstance().getClearingHouse(chCompany.getId().toString());
        Date unSettleDate = clearingHouse.getSettleDate();
        BigDecimal balance = InAcctFactory.getRemoteInstance().inAcct(chCompany.getNumber(), innerAcctInfo.getNumber(), currencyInfo.getNumber(), unSettleDate, unSettleDate, InAcctDataTypeEnum.K);
        if (balance == null) {
            return Constants.ZERO;
        }
        balance = balance.setScale(currencyInfo.getPrecision(), 4);
        return balance;
    }

    protected BigDecimal getBalanceValue(CurrencyInfo currencyInfo, AccountBankInfo acctBankInfo) throws EASBizException, BOSException {
        if (currencyInfo == null || acctBankInfo == null || acctBankInfo.getCompany() == null) {
            return Constants.ZERO;
        }
        String key = acctBankInfo.getId().toString() + currencyInfo.getId().toString();
        CompanyOrgUnitInfo companyInfo = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(acctBankInfo.getCompany().getId()));
        BigDecimal balance = BigDecimal.ZERO;
        if (!EmptyUtil.isEmpty((CoreBaseInfo)acctBankInfo) && acctBankInfo.isIsSetBankInterface()) {
            balance = PaymentBillFactory.getRemoteInstance().getBalanceValue(acctBankInfo.getId().toString(), currencyInfo.getId().toString());
        } else {
            balance = CashManagementFactory.getRemoteInstance().cash(companyInfo.getNumber(), CashDataSourceEnum.B, null, null, acctBankInfo.getNumber(), currencyInfo.getNumber(), new Date(), new Date(), CashDataTypeEnum.Y, false);
            BigDecimal totalAmt = CashManagementFactory.getRemoteInstance().getTotalSettleBillAmtByAccount(companyInfo.getId().toString(), acctBankInfo.getId().toString(), currencyInfo.getId().toString());
            if (balance == null) {
                balance = Constants.ZERO;
            }
            if (totalAmt != null) {
                balance = balance.add(totalAmt);
            }
        }
        balance = balance.setScale(currencyInfo.getPrecision(), 4);
        return balance;
    }

    protected BigDecimal getBalanceValueByCS132(CurrencyInfo currencyInfo, AccountBankInfo acctBankInfo, String CS132) throws EASBizException, BOSException {
        if (currencyInfo == null || acctBankInfo == null || acctBankInfo.getCompany() == null) {
            return Constants.ZERO;
        }
        String key = acctBankInfo.getId().toString() + currencyInfo.getId().toString();
        CompanyOrgUnitInfo companyInfo = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(acctBankInfo.getCompany().getId()));
        BigDecimal balance = BigDecimal.ZERO;
        if (!EmptyUtil.isEmpty((CoreBaseInfo)acctBankInfo) && acctBankInfo.isIsSetBankInterface() && !"1".equals(CS132)) {
            balance = PaymentBillFactory.getRemoteInstance().getBalanceValue(acctBankInfo.getId().toString(), currencyInfo.getId().toString());
        } else {
            balance = CashManagementFactory.getRemoteInstance().cash(companyInfo.getNumber(), CashDataSourceEnum.B, null, null, acctBankInfo.getNumber(), currencyInfo.getNumber(), new Date(), new Date(), CashDataTypeEnum.Y, false);
            BigDecimal totalAmt = CashManagementFactory.getRemoteInstance().getTotalSettleBillAmtByAccount(companyInfo.getId().toString(), acctBankInfo.getId().toString(), currencyInfo.getId().toString());
            if (balance == null) {
                balance = Constants.ZERO;
            }
            if (totalAmt != null) {
                balance = balance.add(totalAmt);
            }
        }
        balance = balance.setScale(currencyInfo.getPrecision(), 4);
        return balance;
    }

    public static String getUITitle(SettBizTypeEnum bizType) {
        if (bizType == null) {
            return "";
        }
        switch (bizType.getValue()) {
            case 2: {
                return EASResource.getString((String)resourcePath, (String)"PAYOUTSIDE_VALUE");
            }
            case 1: {
                return EASResource.getString((String)resourcePath, (String)"RECOUTSIDE_VALUE");
            }
            case 4: {
                return EASResource.getString((String)resourcePath, (String)"PAYINSIDE_VALUE");
            }
            case 3: {
                return EASResource.getString((String)resourcePath, (String)"RECINSIDE_VALUE");
            }
            case 51: {
                return EASResource.getString((String)resourcePath, (String)"RECINSIDEDIF_VALUE");
            }
            case 52: {
                return EASResource.getString((String)resourcePath, (String)"PAYINSIDEDIF_VALUE");
            }
            case 100: {
                return EASResource.getString((String)resourcePath, (String)"PAYOUTDIFFCUR_VALUE");
            }
            case 10: {
                return EASResource.getString((String)resourcePath, (String)"LINKPAY_VALUE");
            }
        }
        return EASResource.getString((String)resourcePath, (String)"RECOUTSIDE_VALUE");
    }

    public ExchangeRateInfo getExchangeRate(ExchangeTableInfo baseExchangeTable, CurrencyInfo sourceCur, CurrencyInfo desCur) throws BOSException, EASBizException {
        ObjectUuidPK destCurrpk = new ObjectUuidPK(desCur.getId());
        ObjectUuidPK excTablepk = new ObjectUuidPK(baseExchangeTable.getId());
        IExchangeRate iexchangRate = ExchangeRateFactory.getRemoteInstance();
        ObjectUuidPK sourceCurrpk = new ObjectUuidPK(sourceCur.getId());
        ExchangeRateInfo erInfo = iexchangRate.getExchangeRate((IObjectPK)excTablepk, (IObjectPK)sourceCurrpk, (IObjectPK)destCurrpk, new Date(System.currentTimeMillis()));
        return erInfo;
    }

    public void setInnerAcctF7(KDBizPromptBox f7InnerAccount, boolean isCUControl, String companyId, int type, String payeeOrPayer, boolean isInner, SettlementBillRpcCacheInfo rpcCacheInfo) throws EASBizException, BOSException {
        EntityViewInfo info = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("closed", (Object)Boolean.FALSE));
        filter.getFilterItems().add(new FilterItemInfo("isUsed", (Object)Boolean.TRUE));
        if (isInner) {
            StringBuffer sql = new StringBuffer();
            sql.append(" select a.FInnerAcctId from t_bd_accountbanks a  ").append(" join t_bd_bank b on a.FBank=b.fid ").append(" where b.FIsInGroup =0 and a.FInnerAcctId is not null ");
        }
        if (isCUControl && FMHelper.isEmpty((String)companyId)) {
            companyId = ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId().toString();
        }
        MutilClearHouserHelper helper = new MutilClearHouserHelper();
        boolean curTopClearHouseCur = MutilClearHouserHelper.isTopClearHouse(null, companyId, rpcCacheInfo);
        if (!(type == 51 && "payer".equals(payeeOrPayer) && !curTopClearHouseCur || type == 52 && "payee".equals(payeeOrPayer) && !curTopClearHouseCur)) {
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId));
        }
        int tm102 = 0;
        tm102 = !EmptyUtil.isEmpty((Object)((Object)rpcCacheInfo)) ? rpcCacheInfo.getTM102() : ContextHelperFactory.getRemoteInstance().getIntParam("TM102", (IObjectPK)new ObjectUuidPK(BOSUuid.read((String)companyId)));
        switch (tm102) {
            case 0: {
                break;
            }
            case 1: {
                filter.getFilterItems().add(new FilterItemInfo("type.property", (Object)new Integer(1).toString()));
                break;
            }
            case 2: {
                filter.getFilterItems().add(new FilterItemInfo("type.property", (Object)new Integer(2).toString()));
                break;
            }
            case 3: {
                filter.getFilterItems().add(new FilterItemInfo("type.property", (Object)new Integer(3).toString()));
                break;
            }
        }
        info.setFilter(filter);
        f7InnerAccount.setEntityViewInfo(info);
    }

    public void setBankAcctF7(KDBizPromptBox f7BankAcct, SettBizTypeEnum type, String companyId) throws EASBizException, BOSException {
        if (FMHelper.isEmpty((String)companyId)) {
            companyId = ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId().toString();
        }
        FilterInfo filter = new FilterInfo();
        BankInfo chInfo = BankFactory.getRemoteInstance().getClearingHouse(companyId);
        if (chInfo != null) {
            filter.getFilterItems().add(new FilterItemInfo("bank.id", (Object)chInfo.getId().toString(), CompareType.NOTEQUALS));
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId));
        }
        filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)new Integer(0)));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        f7BankAcct.setEntityViewInfo(view);
    }

    public void setBankAcctF7(KDBizPromptBox f7BankAcct, SettBizTypeEnum type, String companyId, BankInfo clearingHouse) throws EASBizException, BOSException {
        if (FMHelper.isEmpty((String)companyId)) {
            companyId = ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId().toString();
        }
        FilterInfo filter = new FilterInfo();
        if (clearingHouse != null) {
            filter.getFilterItems().add(new FilterItemInfo("bank.id", (Object)clearingHouse.getId().toString(), CompareType.NOTEQUALS));
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId));
        }
        filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)new Integer(0)));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        f7BankAcct.setEntityViewInfo(view);
    }

    public void initFPItemF7(KDBizPromptBox fpItemF7, String companyId, String currencyId, boolean isPayee) {
        Set itemTypeAry = this.getItemTypeAry(isPayee);
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId));
        filter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)currencyId));
        filter.getFilterItems().add(new FilterItemInfo("type", (Object)itemTypeAry, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("beginDate", (Object)DateUtil.getDayBegin(), CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("endDate", (Object)DateUtil.getDayBegin(), CompareType.GREATER_EQUALS));
        ev.setFilter(filter);
        fpItemF7.setEntityViewInfo(ev);
    }

    private Set getItemTypeAry(boolean isPayee) {
        HashSet<Integer> set = new HashSet<Integer>();
        if (isPayee) {
            set.add(new Integer(3));
            set.add(new Integer(4));
            set.add(new Integer(2));
        } else {
            set.add(new Integer(-3));
            set.add(new Integer(-4));
            set.add(new Integer(-2));
        }
        return set;
    }

    public KDTDefaultCellEditor getFPItemEditor() {
        KDBizPromptBox f7 = new KDBizPromptBox();
        f7.setQueryInfo("com.kingdee.eas.fm.fp.F7FPItemQuery");
        f7.setEditable(true);
        f7.setCommitFormat("$lineNo$");
        f7.setDisplayFormat("$name$");
        f7.setEditFormat("$lineNo$");
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)"null"));
        ev.setFilter(filter);
        f7.setEntityViewInfo(ev);
        FpItemClientHelper.setOrgView((KDBizPromptBox)f7);
        KDTDefaultCellEditor fpItemeditor = new KDTDefaultCellEditor((IKDEditor)f7);
        return fpItemeditor;
    }

    public KDTDefaultCellEditor getInnerAcctEditor() {
        KDBizPromptBox f7InnerAccountEditor = new KDBizPromptBox();
        f7InnerAccountEditor.setQueryInfo("com.kingdee.eas.fm.fs.InnerAccountQuery");
        f7InnerAccountEditor.setCommitFormat("$number$");
        f7InnerAccountEditor.setEditFormat("$number$");
        f7InnerAccountEditor.setDisplayFormat("$name$");
        f7InnerAccountEditor.setEditable(true);
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)"null"));
        ev.setFilter(filter);
        f7InnerAccountEditor.setEntityViewInfo(ev);
        KDTDefaultCellEditor f7Editor = new KDTDefaultCellEditor((IKDEditor)f7InnerAccountEditor);
        return f7Editor;
    }

    private void verifyInfoNormalData(CoreUIObject ui, SettlementBillInfo info) {
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)ui, (String)resourcePath, (Object)((Object)info.getType()), (String)"NoneType");
        FMClientVerifyHelper.verifyEmptyAndNoZero((CoreUIObject)ui, (String)resourcePath, (Object)info.getAmount(), (String)"NoneAmount");
        FMClientVerifyHelper.verifyEmptyAndNoZero((CoreUIObject)ui, (String)resourcePath, (Object)info.getExchange(), (String)"NoneExchangeRate");
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)ui, (String)resourcePath, (Object)info.getCreator(), (String)"NoneCreator");
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)ui, (String)resourcePath, (Object)info.getBizDate(), (String)"NoneCreateTime");
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)ui, (String)resourcePath, (Object)info.getCurrency(), (String)"NoneCurrency");
    }

    private void verifyRowNormalData(CoreUIObject ui, IRow row) {
        String number;
        if (row.getCell("acceptor").getValue() != null) {
            MsgBox.showWarning((String)EASResource.getString((String)resourcePath, (String)"HasAccepted"));
            SysUtil.abort();
        }
        if (((Boolean)row.getCell("isSubmit").getValue()).equals(Boolean.FALSE)) {
            MsgBox.showWarning((String)EASResource.getString((String)resourcePath, (String)"BillInvalidation"));
            SysUtil.abort();
        }
        if ((number = (String)row.getCell("number").getValue()) == null || number.equals("")) {
            MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)resourcePath, (String)"NoneNumber"));
            SysUtil.abort();
        }
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)ui, (String)resourcePath, (Object)row.getCell("type").getValue(), (String)"NoneType");
        FMClientVerifyHelper.verifyEmptyAndNoZero((CoreUIObject)ui, (String)resourcePath, (Object)row.getCell("exchange").getValue(), (String)"NoneExchangeRate");
        FMClientVerifyHelper.verifyEmptyAndNoZero((CoreUIObject)ui, (String)resourcePath, (Object)row.getCell("amount").getValue(), (String)"NoneAmount");
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)ui, (String)resourcePath, (Object)row.getCell("creator").getValue(), (String)"NoneCreator");
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)ui, (String)resourcePath, (Object)row.getCell("createDate").getValue(), (String)"NoneCreateTime");
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)ui, (String)resourcePath, (Object)row.getCell("currency").getValue(), (String)"NoneCurrency");
    }

    private void verifyBankAcctNoSame(CoreUIObject ui, SettlementBillInfo info) {
        if (info.getPayerBankAcct() != null && info.getPayeeBankAcct() != null && info.getPayerBankAcct().getId().equals((Object)info.getPayeeBankAcct().getId()) && MsgBox.showConfirm2((Component)ui, (String)EASResource.getString((String)resourcePath, (String)"TheSameBankAcct")) == 2) {
            SysUtil.abort();
        }
    }

    private void verifyInAcctNoSame(CoreUIObject ui, SettlementBillInfo info) {
        if (info.getPayerInnerAcct() != null && info.getPayeeInnerAcct() != null && info.getPayeeInnerAcct().getId().equals((Object)info.getPayerInnerAcct().getId()) && MsgBox.showConfirm2((Component)ui, (String)EASResource.getString((String)resourcePath, (String)"TheSameInnerAcct")) == 2) {
            SysUtil.abort();
        }
    }

    private void checkPayerByInfo(CoreUIObject ui, SettlementBillInfo info) {
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)ui, (String)resourcePath, (Object)info.getInnerPayerAcct(), (String)"NoneInnerPayerAcct", (String)"prmtinnerPayerAcct");
        if (info.getType().getValue() != 100 && info.getPayerBankAcct() != null) {
            CurrencyInfo currencyInfo = info.getCurrency();
            AccountBankInfo acctBankInfo = info.getPayerBankAcct();
            CurrencyInfo acctBankCurrinfo = acctBankInfo.getCurrency();
            if (acctBankInfo.isIsByCurrency() && !acctBankCurrinfo.getId().equals((Object)currencyInfo.getId())) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"131_SettlementBillHandler"));
                SysUtil.abort();
            }
        }
        if (info.getPayerAcct() != null && info.getPayerAcct().isIsBank() && info.getPayerBankAcct() == null) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"132_SettlementBillHandler"));
            SysUtil.abort();
            ((SettlementBillEditUI)ui).prmtSettleType.requestFocus();
        }
        CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        boolean valSettle = ContextHelperFactory.getRemoteInstance().getBooleanParam("TM011", (IObjectPK)new ObjectUuidPK(currentCompany.getId()));
        if (valSettle && info.getSettleType() == null) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"133_SettlementBillHandler"));
            ((SettlementBillEditUI)ui).prmtSettleType.requestFocus();
            SysUtil.abort();
        }
    }

    private void checkPayeeByInfo(CoreUIObject ui, SettlementBillInfo info) {
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)ui, (String)resourcePath, (Object)info.getInnerPayeeAcct(), (String)"NoneInnerPayeeAcct", (String)"prmtinnerPayeeAcct");
        if (info.getPayeeBankAcct() != null) {
            CurrencyInfo currencyInfo = info.getCurrency();
            AccountBankInfo acctBankInfo = info.getPayeeBankAcct();
            CurrencyInfo acctBankCurrinfo = acctBankInfo.getCurrency();
            if (acctBankInfo.isIsByCurrency() && !acctBankCurrinfo.getId().equals((Object)currencyInfo.getId())) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"134_SettlementBillHandler"));
                SysUtil.abort();
            }
        }
        if (info.getPayeeAcct() != null && info.getPayeeAcct().isIsBank() && info.getPayeeBankAcct() == null) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"132_SettlementBillHandler"));
            SysUtil.abort();
        }
    }

    private void checkPayeeByRow4Accept(CoreUIObject ui, IRow row) {
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)ui, (String)resourcePath, (Object)row.getCell("innerPayeeAcct.number").getValue(), (String)"NoneInnerPayeeAcct", (String)"prmtinnerPayeeAcct");
    }

    private void checkPayeeBankAcctByRow4Accept(CoreUIObject ui, IRow row) {
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)ui, (String)resourcePath, (Object)row.getCell("payeeBankAcct").getValue(), (String)"NonePayeeBankAcct", (String)"f7PayerBankAcct");
    }

    private void checkPayerBankAcctByRow4Accept(CoreUIObject ui, IRow row) {
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)ui, (String)resourcePath, (Object)row.getCell("payerBankAcct").getValue(), (String)"NonePayerBankAcct", (String)"f7PayerBankAcct");
    }

    private void checkPayerByRow4Accept(CoreUIObject ui, IRow row) {
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)ui, (String)resourcePath, (Object)row.getCell("innerPayerAcct.number").getValue(), (String)"NoneInnerPayerAcct", (String)"prmtinnerPayerAcct");
    }

    private void checkPayerByRow4Approve(CoreUIObject ui, IRow row) {
        if (row.getCell("auditor").getValue() != null) {
            MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)resourcePath, (String)"alreadyApprove"));
            SysUtil.abort();
        }
    }

    private void checkPayerByRow4UntiApprove(CoreUIObject ui, IRow row) {
        if (row.getCell("auditor").getValue() == null) {
            MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)resourcePath, (String)"notApprove"));
            SysUtil.abort();
        }
    }

    public void verifyInfoData(CoreUIObject ui, SettlementBillInfo info) {
        if (info == null) {
            return;
        }
        this.verifyInfoNormalData(ui, info);
        this.verifyInAcctNoSame(ui, info);
        this.verifyBankAcctNoSame(ui, info);
        this.verifySettleNumber(ui, info);
        int key = info.getType().getValue();
        switch (key) {
            case 1: {
                this.checkPayeeByInfo(ui, info);
                break;
            }
            case 2: 
            case 100: {
                this.checkPayerByInfo(ui, info);
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            case 51: 
            case 52: {
                this.verifyForMutil(ui, info);
                break;
            }
        }
    }

    public void verifyForMutil(CoreUIObject ui, SettlementBillInfo info) {
        switch (info.getMutilType().getValue()) {
            case 1: {
                if (info.getInnerPayeeAcct() == null) {
                    MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)resourcePath, (String)"mustInnerPayeeView"));
                    SysUtil.abort();
                    break;
                }
                if (info.getPayeeBankAcct() == null && info.getInnerPayerAcct() == null) {
                    MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)resourcePath, (String)"mustPayeeBankAcctOrPayerView"));
                    SysUtil.abort();
                }
                if (info.getPayeeBankAcct() == null || info.getPayerInnerAcct() == null || !info.getPayeeBankAcct().isIsReckoning() || !info.getPayerInnerAcct().isIsReckoning()) break;
                MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)resourcePath, (String)"payeeBankAcctAndPayerAcctReck"));
                SysUtil.abort();
                break;
            }
            case 2: {
                if (info.getInnerPayerAcct() == null) {
                    MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)resourcePath, (String)"mustInnerPayerView"));
                    SysUtil.abort();
                    break;
                }
                if (info.getPayerBankAcct() == null && info.getInnerPayeeAcct() == null) {
                    MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)resourcePath, (String)"mustPayerBankAcctOrPayeeView"));
                    SysUtil.abort();
                }
                if (info.getPayerBankAcct() == null || info.getPayeeInnerAcct() == null || !info.getPayerBankAcct().isIsReckoning() || !info.getPayeeInnerAcct().isIsReckoning()) break;
                MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)resourcePath, (String)"payerBankAcctAndPayeeAcctReck"));
                SysUtil.abort();
                break;
            }
            case 3: {
                if (info.getInnerPayeeAcct() != null && info.getInnerPayerAcct() != null) break;
                MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)resourcePath, (String)"mustHaveInnerSideAcctView"));
                SysUtil.abort();
                break;
            }
        }
    }

    private void verifySettleNumber(CoreUIObject ui, SettlementBillInfo info) {
        block5: {
            Calendar cal = Calendar.getInstance();
            cal.setTime(info.getBizDate());
            Calendar beginDate = Calendar.getInstance();
            beginDate.set(cal.get(1), cal.get(2), cal.get(5));
            Calendar endDate = beginDate;
            try {
                if (FMHelper.isEmpty((String)info.getInnerSettleNumber())) break block5;
                String sql = "where innerSettleNumber = '" + info.getInnerSettleNumber() + "' And bizDate >={" + TypeConversionUtils.objToDate((Object)beginDate.getTime()) + "} And bizDate <={" + TypeConversionUtils.objToDate((Object)endDate.getTime()) + "}";
                IObjectPK[] pks = SettlementBillFactory.getRemoteInstance().getPKList(sql);
                for (int i = 0; i < pks.length; ++i) {
                    if (pks[i].equals((Object)new ObjectUuidPK(info.getId()))) continue;
                    if (MsgBox.showConfirm2((Component)ui, (String)EASResource.getString((String)resourcePath, (String)"InnerSettleNumError")) == 2) {
                        SysUtil.abort();
                        continue;
                    }
                    break;
                }
            }
            catch (EASBizException e) {
                SysUtil.abort();
            }
            catch (BOSException e) {
                SysUtil.abort();
            }
        }
    }

    public void verifyRowData4Accept(CoreUIObject ui, IRow row) {
        this.verifyRowNormalData(ui, row);
        BizEnumValueInfo type = (BizEnumValueInfo)row.getCell("type").getValue();
        int key = type.getInt();
        switch (key) {
            case 3: {
                this.checkPayeeByRow4Accept(ui, row);
                this.checkPayerByRow4Accept(ui, row);
                break;
            }
            case 4: {
                this.checkPayeeByRow4Accept(ui, row);
                this.checkPayerByRow4Accept(ui, row);
                break;
            }
            case 1: {
                this.checkPayeeByRow4Accept(ui, row);
                break;
            }
            case 2: 
            case 100: {
                this.checkPayerByRow4Accept(ui, row);
                break;
            }
            case 51: {
                this.verifyForMutil(ui, row);
                break;
            }
            case 52: {
                this.verifyForMutil(ui, row);
                break;
            }
        }
    }

    public void verifyRowData4Approve(CoreUIObject ui, IRow row) {
        BizEnumValueInfo type = (BizEnumValueInfo)row.getCell("type").getValue();
        int key = type.getInt();
        switch (key) {
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 100: {
                this.checkPayerByRow4Approve(ui, row);
                break;
            }
        }
    }

    public void verifyRowData4UntiApprove(CoreUIObject ui, IRow row) {
        BizEnumValueInfo type = (BizEnumValueInfo)row.getCell("type").getValue();
        int key = type.getInt();
        switch (key) {
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 100: {
                this.checkPayerByRow4UntiApprove(ui, row);
                break;
            }
        }
    }

    public void setCompanyF7(KDBizPromptBox f7Company) {
        f7Company.setQueryInfo("com.kingdee.eas.basedata.org.app.CompanyOrgUnitQuery");
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isOnlyUnion", (Object)new Integer(0)));
        view.setFilter(filter);
        f7Company.setEditable(true);
        f7Company.setEditFormat("$simpleName$");
        f7Company.setCommitFormat("$simpleName$");
        f7Company.setDisplayFormat("$name$");
        f7Company.setEntityViewInfo(view);
    }

    public void verifyOverdraft(CoreUIObject ui, String state, SettlementBillInfo editData, RecPayInstanceAmountBean bean, SettlementBillRpcCacheInfo rpcCacheInfo) throws BOSException, EASBizException {
        BOSUuid sbid;
        if (editData.getPayeeInnerAcct() != null && editData.getPayerInnerAcct() != null && editData.getPayeeInnerAcct().getId().equals((Object)editData.getPayerInnerAcct().getId())) {
            return;
        }
        boolean is_SAVE_ACCEPT = false;
        if (rpcCacheInfo != null) {
            if (rpcCacheInfo.isChCompany()) {
                is_SAVE_ACCEPT = rpcCacheInfo.isTM004();
            }
        } else {
            CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
            if (FSClientHelper.isClearingHouseCompany(currentCompany)) {
                is_SAVE_ACCEPT = ContextHelperFactory.getRemoteInstance().getBooleanParam("TM004", (IObjectPK)new ObjectUuidPK(currentCompany.getId()));
            }
        }
        this.vervifyOverDraftInnerAcct(ui, state, editData, bean, rpcCacheInfo, is_SAVE_ACCEPT);
        boolean vervifyOverDraftBankAcct = true;
        if (SettBizTypeEnum.RECOUTSIDE.equals((Object)editData.getType()) && !EmptyUtil.isEmpty((String)editData.getSourceBillId()) && (sbid = BOSUuid.read((String)editData.getSourceBillId())).getType().equals((Object)new PaymentBillInfo().getBOSType())) {
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("payBillType.*");
            PaymentBillInfo paymentBill = PaymentBillFactory.getRemoteInstance().getPaymentBillInfo((IObjectPK)new ObjectUuidPK(editData.getSourceBillId()), selector);
            if (paymentBill.getPayBillType().isIsFinanceTranUp()) {
                vervifyOverDraftBankAcct = false;
            }
        }
        if (vervifyOverDraftBankAcct) {
            this.vervifyOverDraftBankAcct(ui, state, editData, bean, rpcCacheInfo, is_SAVE_ACCEPT);
        }
    }

    public String verifyOverdraftForTip(CoreUIObject ui, String state, SettlementBillInfo editData, RecPayInstanceAmountBean bean, SettlementBillRpcCacheInfo rpcCacheInfo) throws BOSException, EASBizException {
        BOSUuid sbid;
        String msg1;
        if (editData.getPayeeInnerAcct() != null && editData.getPayerInnerAcct() != null && editData.getPayeeInnerAcct().getId().equals((Object)editData.getPayerInnerAcct().getId())) {
            return "";
        }
        boolean is_SAVE_ACCEPT = false;
        if (rpcCacheInfo != null) {
            if (rpcCacheInfo.isChCompany()) {
                is_SAVE_ACCEPT = rpcCacheInfo.isTM004();
            }
        } else {
            CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
            if (FSClientHelper.isClearingHouseCompany(currentCompany)) {
                is_SAVE_ACCEPT = ContextHelperFactory.getRemoteInstance().getBooleanParam("TM004", (IObjectPK)new ObjectUuidPK(currentCompany.getId()));
            }
        }
        if (!EmptyUtil.isEmpty((String)(msg1 = this.vervifyOverDraftInnerAcctForTip(ui, state, editData, bean, rpcCacheInfo, is_SAVE_ACCEPT)))) {
            return msg1;
        }
        boolean vervifyOverDraftBankAcct = true;
        if (SettBizTypeEnum.RECOUTSIDE.equals((Object)editData.getType()) && !EmptyUtil.isEmpty((String)editData.getSourceBillId()) && (sbid = BOSUuid.read((String)editData.getSourceBillId())).getType().equals((Object)new PaymentBillInfo().getBOSType())) {
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("payBillType.*");
            PaymentBillInfo paymentBill = PaymentBillFactory.getRemoteInstance().getPaymentBillInfo((IObjectPK)new ObjectUuidPK(editData.getSourceBillId()), selector);
            if (paymentBill.getPayBillType().isIsFinanceTranUp()) {
                vervifyOverDraftBankAcct = false;
            }
        }
        String msg2 = "";
        if (vervifyOverDraftBankAcct) {
            msg2 = this.vervifyOverDraftBankAcctForTip(ui, state, editData, bean, rpcCacheInfo, is_SAVE_ACCEPT);
        }
        return msg2;
    }

    private void vervifyOverDraftInnerAcct(CoreUIObject ui, String state, SettlementBillInfo editData, RecPayInstanceAmountBean bean, SettlementBillRpcCacheInfo rpcCacheInfo, boolean is_SAVE_ACCEPT) throws BOSException, EASBizException, AccountBankException {
        BigDecimal amount = editData.getAmount();
        if (amount.compareTo(Constants.ZERO) != 0) {
            InnerAccountInfo inAcct = null;
            CurrencyInfo currency = null;
            BigDecimal billAmount = null;
            boolean isRedBill = false;
            if (amount.compareTo(Constants.ZERO) > 0) {
                inAcct = editData.getPayerInnerAcct();
                if (!editData.isIsDlByPay()) {
                    return;
                }
                currency = editData.getCurrency();
                billAmount = editData.getAmount();
                isRedBill = false;
            } else if (amount.compareTo(Constants.ZERO) < 0) {
                inAcct = editData.getPayeeInnerAcct();
                if (!editData.isIsDlByRec()) {
                    return;
                }
                currency = editData.getCurrency();
                billAmount = amount.abs();
                isRedBill = true;
            }
            if (inAcct != null) {
                inAcct = InnerAccountFactory.getRemoteInstance().getInnerAccountInfo("select * , ctrlParam.* where id ='" + inAcct.getId() + "'");
                ObjectUuidPK chCompanyPk = new ObjectUuidPK(inAcct.getCompany().getId());
                CompanyOrgUnitInfo chCompany = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)chCompanyPk);
                String companyNumber = chCompany.getNumber();
                AccountMgrStrategyInfo ctrlStrategy = inAcct.getCtrlParam();
                boolean isSingleOk = false;
                isSingleOk = this.isNeedCtrl(state, isRedBill, is_SAVE_ACCEPT, ctrlStrategy);
                if (isSingleOk) {
                    String msg;
                    if (ctrlStrategy.getOverdraftCtrl().equals((Object)OverdraftCtrlEnum.NOTCONTROL) && ctrlStrategy.isRemind()) {
                        BigDecimal totalFrozenAmt;
                        BankInfo clearhouse = null;
                        clearhouse = rpcCacheInfo != null ? rpcCacheInfo.getClearingHouse() : FSClientHelper.getClearingHouse();
                        Date unSettleDate = clearhouse.getSettleDate();
                        BigDecimal currentBalance = InAcctFactory.getRemoteInstance().inAcct(companyNumber, inAcct.getNumber(), currency.getNumber(), unSettleDate, unSettleDate, InAcctDataTypeEnum.K);
                        BigDecimal kValue = currentBalance.subtract(totalFrozenAmt = this.handler.getFrozenBalanceValue(currency.getId().toString(), inAcct.getId().toString()));
                        if (kValue.compareTo(billAmount) < 0 && MsgBox.showConfirm2((Component)ui, (String)(msg = MessageFormat.format(EASResource.getString((String)resourcePath, (String)"overDraftFrozen"), inAcct.getName(), kValue, billAmount.subtract(kValue)))) == 2) {
                            SysUtil.abort();
                        }
                    }
                    if (ctrlStrategy.getOverdraftCtrl() == OverdraftCtrlEnum.INLIMITCANOVERDRAFT && ctrlStrategy.isRemind()) {
                        BigDecimal totalFrozenAmt;
                        Date unSettleDate = FSClientHelper.getClearingHouse().getSettleDate();
                        BigDecimal currentBalance = InAcctFactory.getRemoteInstance().inAcct(companyNumber, inAcct.getNumber(), currency.getNumber(), unSettleDate, unSettleDate, InAcctDataTypeEnum.K);
                        BigDecimal kValue = currentBalance.subtract(totalFrozenAmt = this.handler.getFrozenBalanceValue(currency.getId().toString(), inAcct.getId().toString()));
                        BigDecimal preAmount = kValue.subtract(billAmount);
                        if (preAmount.signum() == -1 && preAmount.compareTo(ctrlStrategy.getOverDraftAmount().negate()) >= 0 && MsgBox.showConfirm2((Component)ui, (String)(msg = MessageFormat.format(EASResource.getString((String)resourcePath, (String)"inSafeDraftFrozen"), inAcct.getName(), kValue, ctrlStrategy.getOverDraftAmount(), billAmount.subtract(kValue)))) == 2) {
                            SysUtil.abort();
                        }
                    }
                }
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                view.setFilter(filter);
                filter.getFilterItems().add(new FilterItemInfo("innerAcct.id", (Object)inAcct.getId().toString()));
                InnerAcctGroupEntryCollection coll = InnerAcctGroupEntryFactory.getRemoteInstance().getInnerAcctGroupEntryCollection(view);
                if (coll != null && coll.size() > 0) {
                    AccountMgrStrategyInfo ctrlStrategyNew;
                    InnerAcctGroupEntryInfo innerAcctGroupEntryInfo = coll.get(0);
                    SelectorItemCollection selector = new SelectorItemCollection();
                    selector.add("*");
                    selector.add("ctrlParam.*");
                    selector.add("entrys.*");
                    selector.add("entrys.innerAcct.*");
                    InnerAcctGroupInfo innerAcctGroupInfo = InnerAcctGroupFactory.getRemoteInstance().getInnerAcctGroupInfo((IObjectPK)new ObjectUuidPK(innerAcctGroupEntryInfo.getParent().getId()), selector);
                    AccountMgrStrategyInfo ctrlParamGroup = innerAcctGroupInfo.getCtrlParam();
                    boolean isGroupOk = false;
                    if (ctrlParamGroup != null && !(isGroupOk = this.isNeedCtrl(state, isRedBill, is_SAVE_ACCEPT, ctrlStrategyNew = AccountMgrStrategyFactory.getRemoteInstance().getAccountMgrStrategyInfo((IObjectPK)new ObjectUuidPK(ctrlParamGroup.getId())))) && ctrlStrategy.getOverdraftCtrl().equals((Object)OverdraftCtrlEnum.NOTCONTROL) && ctrlStrategy.isRemind()) {
                        String msg;
                        Date unSettleDate = FSClientHelper.getClearingHouse().getSettleDate();
                        StringBuffer allInnerAcctNumber = new StringBuffer();
                        String allInnerAcctNumberString = null;
                        for (int i = 0; i < innerAcctGroupInfo.getEntrys().size(); ++i) {
                            InnerAcctGroupEntryInfo entryInfo = innerAcctGroupInfo.getEntrys().get(i);
                            allInnerAcctNumber.append(entryInfo.getInnerAcct().getNumber());
                            allInnerAcctNumber.append(",");
                        }
                        allInnerAcctNumberString = allInnerAcctNumber.substring(0, allInnerAcctNumber.length() - 1);
                        BigDecimal curBalance = InAcctFactory.getRemoteInstance().inAcct(companyNumber, allInnerAcctNumberString, currency.getNumber(), unSettleDate, unSettleDate, InAcctDataTypeEnum.K);
                        StringBuffer allInnerAcctId = new StringBuffer();
                        String allInnerAcctIdString = null;
                        for (int i = 0; i < innerAcctGroupInfo.getEntrys().size(); ++i) {
                            InnerAcctGroupEntryInfo entryInfo = innerAcctGroupInfo.getEntrys().get(i);
                            allInnerAcctId.append(entryInfo.getInnerAcct().getId());
                            allInnerAcctId.append(",");
                        }
                        allInnerAcctIdString = allInnerAcctId.substring(0, allInnerAcctId.length() - 1);
                        BigDecimal totalFrozenAmt = InnerFrozenDepositFactory.getRemoteInstance().getTotalFrozenAmt(allInnerAcctIdString, currency.getId().toString());
                        BigDecimal kValue = curBalance.subtract(totalFrozenAmt);
                        if (kValue.compareTo(billAmount) < 0 && MsgBox.showConfirm2((Component)ui, (String)(msg = MessageFormat.format(EASResource.getString((String)resourcePath, (String)"overDraftFrozen"), innerAcctGroupInfo.getName(), kValue, billAmount.subtract(kValue)))) == 2) {
                            SysUtil.abort();
                        }
                    }
                }
            }
        }
    }

    private void vervifyOverDraftBankAcct(CoreUIObject ui, String state, SettlementBillInfo editData, RecPayInstanceAmountBean bean, SettlementBillRpcCacheInfo rpcCacheInfo, boolean is_SAVE_ACCEPT) throws BOSException, EASBizException, AccountBankException {
        BigDecimal amount = editData.getAmount();
        if (amount.compareTo(Constants.ZERO) != 0) {
            CurrencyInfo currency = null;
            BigDecimal billAmount = BigDecimal.ZERO;
            boolean isRedBill = false;
            if (amount.compareTo(Constants.ZERO) > 0) {
                currency = editData.getCurrency();
                billAmount = editData.getAmount();
                isRedBill = false;
            } else if (amount.compareTo(Constants.ZERO) < 0) {
                currency = editData.getCurrency();
                billAmount = amount.abs();
                isRedBill = true;
            }
            boolean isAcctBankNotChanged = bean.getAcctBank() != null && editData.getPayerBankAcct() != null && bean.getAcctBank().getId().equals((Object)editData.getPayerBankAcct().getId());
            boolean isAcctViewNotChanged = bean.getAcctBank() == null && editData.getPayerBankAcct() == null && bean.getAcctView() != null && editData.getPayerAcct() != null && bean.getAcctView().getId().equals((Object)editData.getPayerAcct().getId());
            boolean isSaved = SettlementBillFactory.getRemoteInstance().exists((IObjectPK)new ObjectUuidPK(editData.getId()));
            BigDecimal amountAcct = FMConstants.ZERO;
            AccountBankInfo bankAcct = editData.getPayerBankAcct();
            AccountMgrStrategyInfo ctrlStrategyBankAcct = null;
            if (bankAcct != null) {
                ctrlStrategyBankAcct = bankAcct.getCtrlStrategy();
            }
            if (ctrlStrategyBankAcct != null) {
                ctrlStrategyBankAcct = AccountMgrStrategyFactory.getRemoteInstance().getAccountMgrStrategyInfo((IObjectPK)new ObjectUuidPK(ctrlStrategyBankAcct.getId()));
                boolean isSingleBankAcctOk = false;
                isSingleBankAcctOk = this.isNeedCtrl(state, isRedBill, is_SAVE_ACCEPT, ctrlStrategyBankAcct);
                if (isSingleBankAcctOk) {
                    String CS132 = ContextHelperFactory.getRemoteInstance().getStringParam("CS132", (IObjectPK)new ObjectUuidPK(editData.getCompany().getId()));
                    if (bankAcct != null && bankAcct.isIsSetBankInterface() && !"1".equals(CS132)) {
                        String acctBankID = bankAcct.getId().toString();
                        if (currency != null) {
                            String currencyID = currency.getId().toString();
                            BigDecimal balance = PaymentBillFactory.getRemoteInstance().getBalanceValue(acctBankID, currencyID);
                            amountAcct = balance.subtract(amount);
                        }
                    } else {
                        BigDecimal balance = RecPayAcctBankStratageCtrl.getSettleBillBalance(null, (CompanyOrgUnitInfo)bankAcct.getCompany(), (AccountBankInfo)bankAcct, (AccountViewInfo)editData.getPayerAcct(), (CurrencyInfo)currency, (Date)new Date(), (boolean)false);
                        if (editData != null && editData.isHasEffected() && (isAcctBankNotChanged || isAcctViewNotChanged)) {
                            balance = balance.add(bean.getOrignalAmt().subtract(amount));
                        }
                        amountAcct = !isSaved || !editData.isHasEffected() || bean.getAcctBank() == null || !isAcctBankNotChanged ? balance.subtract(amount) : balance;
                    }
                    RecPayAcctBankStratageCtrl.ctrlAcctBank((AccountMgrStrategyInfo)ctrlStrategyBankAcct, (boolean)true, (AccountBankInfo)bankAcct, (boolean)ctrlStrategyBankAcct.isRemind(), (BigDecimal)amountAcct);
                }
            }
            AccountBankGroupInfo acctBankGroup = null;
            if (bankAcct != null) {
                acctBankGroup = AccountBankFactory.getRemoteInstance().getAcctBankGroup(bankAcct.getId().toString());
            }
            AccountMgrStrategyInfo ctrlParamGroup = null;
            if (acctBankGroup != null) {
                ctrlParamGroup = acctBankGroup.getStrategy();
            }
            if (ctrlParamGroup != null) {
                boolean isSingleBankAcctGroupOk = false;
                isSingleBankAcctGroupOk = this.isNeedCtrl(state, isRedBill, is_SAVE_ACCEPT, ctrlParamGroup);
                if (isSingleBankAcctGroupOk) {
                    String msg;
                    ctrlParamGroup = AccountMgrStrategyFactory.getRemoteInstance().getAccountMgrStrategyInfo((IObjectPK)new ObjectUuidPK(ctrlParamGroup.getId()));
                    BigDecimal balance = RecPayAcctBankStratageCtrl.getTotalSettleBillBalance(null, (CompanyOrgUnitInfo)bankAcct.getCompany(), (AccountBankGroupInfo)acctBankGroup, (CurrencyInfo)currency, (Date)new Date(), (boolean)false);
                    if (editData != null && editData.isHasEffected() && (isAcctBankNotChanged || isAcctViewNotChanged)) {
                        balance = balance.add(bean.getOrignalAmt().subtract(editData.getAmount()));
                    }
                    if (ctrlParamGroup.getOverdraftCtrl().equals((Object)OverdraftCtrlEnum.NOTCONTROL) && ctrlParamGroup.isRemind() && balance.compareTo(billAmount) < 0 && MsgBox.showConfirm2((Component)ui, (String)(msg = MessageFormat.format(EASResource.getString((String)resourcePath, (String)"overDraftFrozenAcctGroup"), acctBankGroup.getName(), balance, billAmount.subtract(balance)))) == 2) {
                        SysUtil.abort();
                    }
                    amountAcct = !isSaved || !editData.isHasEffected() ? balance.subtract(editData.getAmount()) : balance;
                    RecPayAcctBankStratageCtrl.acctBankGroupCtrl((AccountBankGroupInfo)acctBankGroup, (AccountMgrStrategyInfo)ctrlParamGroup, (BigDecimal)amountAcct);
                }
            }
        }
    }

    private boolean isNeedCtrl(String state, boolean isRedBill, boolean is_SAVE_ACCEPT, AccountMgrStrategyInfo ctrlStrategy) {
        boolean isSingleOk = true;
        if (ctrlStrategy == null) {
            isSingleOk = false;
        }
        if (isRedBill && !ctrlStrategy.isCtrlRedBill()) {
            isSingleOk = false;
        }
        if (state.equals("submit") && !ctrlStrategy.isCtrlSettleSubm() && !is_SAVE_ACCEPT) {
            isSingleOk = false;
        }
        if (state.equals("save") && !ctrlStrategy.isCtrlSettleSave()) {
            isSingleOk = false;
        }
        if (state.equals("accept") && !ctrlStrategy.isCtrlSettlePast()) {
            isSingleOk = false;
        }
        return isSingleOk;
    }

    public static void beforeRecPay(String billId, int action) throws EASBizException, BOSException {
        ObjectUuidPK pk = new ObjectUuidPK(billId);
        SettlementBillInfo info = SettlementBillFactory.getRemoteInstance().getSettlementBillInfo((IObjectPK)pk, SettlementBillHandler.getSelectors());
        if (!(info.getType().equals((Object)SettBizTypeEnum.RECOUTSIDE) || info.getType().equals((Object)SettBizTypeEnum.PAYOUTSIDE) || info.getType().equals((Object)SettBizTypeEnum.RECINSIDEDIF) || info.getType().equals((Object)SettBizTypeEnum.PAYINSIDEDIF) || info.getType().equals((Object)SettBizTypeEnum.PAYOUTDIFFCUR) || info.getType().equals((Object)SettBizTypeEnum.LINKPAY))) {
            switch (Integer.valueOf(action)) {
                case 1: {
                    throw new FSException(FSException.WRONGTYPE, new String[]{info.getNumber()});
                }
                case 2: {
                    throw new FSException(FSException.WORNGTYPEFORSETTLE, new String[]{info.getNumber()});
                }
            }
        }
    }

    public static void beforeRecPayForWritCh(String billId) throws EASBizException, BOSException {
        ObjectUuidPK pk = new ObjectUuidPK(billId);
        SettlementBillInfo info = SettlementBillFactory.getRemoteInstance().getSettlementBillInfo((IObjectPK)pk, SettlementBillHandler.getSelectors());
        if (info.getType().equals((Object)SettBizTypeEnum.RECOUTSIDE) && info.getPayeeBankAcct() != null && info.getPayeeBankAcct().isIsReckoning()) {
            throw new FSException(FSException.NOTWRITEBANKACCT, new String[]{info.getNumber()});
        }
        if (info.getType().equals((Object)SettBizTypeEnum.PAYOUTSIDE) && info.getPayerBankAcct() != null && info.getPayerBankAcct().isIsReckoning()) {
            throw new FSException(FSException.NOTWRITEBANKACCT, new String[]{info.getNumber()});
        }
        CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        if (info.getSourceBillId() != null) {
            AccountBankCollection coll;
            AccountBankInfo acct;
            BOSUuid sbid = BOSUuid.read((String)info.getSourceBillId());
            if (sbid.getType().equals((Object)new ReceivingBillInfo().getBOSType()) && SettBizTypeEnum.RECOUTSIDE.equals((Object)info.getType()) && info.getPayeeBankAcct() != null) {
                acct = info.getPayeeBankAcct();
                coll = null;
                try {
                    coll = RecPayHelper.getAccountBankInfo(null, (CompanyOrgUnitInfo)currentCompany, (AccountBankInfo)acct);
                }
                catch (BOSException e) {
                    ExceptionHandler.handle((Throwable)e);
                }
                if (coll != null && coll.size() > 0) {
                    throw new FSException(FSException.NOTWRITECHFORDAILI, new String[]{info.getNumber()});
                }
            }
            if (sbid.getType().equals((Object)new PaymentBillInfo().getBOSType()) && SettBizTypeEnum.PAYOUTSIDE.equals((Object)info.getType()) && info.getPayerBankAcct() != null) {
                acct = info.getPayerBankAcct();
                coll = null;
                try {
                    coll = RecPayHelper.getAccountBankInfo(null, (CompanyOrgUnitInfo)currentCompany, (AccountBankInfo)acct);
                }
                catch (BOSException e) {
                    ExceptionHandler.handle((Throwable)e);
                }
                if (coll != null && coll.size() > 0) {
                    throw new FSException(FSException.NOTWRITECHFORDAILI, new String[]{info.getNumber()});
                }
            }
        } else {
            InnerAccountInfo innerAcct;
            AccountBankInfo acct;
            if (SettBizTypeEnum.PAYOUTSIDE.equals((Object)info.getType()) && info.getPayerBankAcct() != null) {
                acct = info.getPayerBankAcct();
                innerAcct = info.getPayerInnerAcct();
                if (acct.getInnerAcct() != null && acct.getInnerAcct().getId().equals((Object)innerAcct.getId()) && !acct.getBank().isInGroup()) {
                    throw new FSException(FSException.NOTWRITCHFOROUTER, new String[]{info.getNumber()});
                }
            }
            if (SettBizTypeEnum.RECOUTSIDE.equals((Object)info.getType()) && info.getPayeeBankAcct() != null) {
                acct = info.getPayeeBankAcct();
                innerAcct = info.getPayeeInnerAcct();
                if (acct.getInnerAcct() != null && acct.getInnerAcct().getId().equals((Object)innerAcct.getId()) && !acct.getBank().isInGroup()) {
                    throw new FSException(FSException.NOTWRITCHFOROUTER, new String[]{info.getNumber()});
                }
            }
        }
    }

    public static void beforeRecPay(SettlementBillInfo info) throws EASBizException, BOSException {
        if ((info.getType().equals((Object)SettBizTypeEnum.RECOUTSIDE) || info.getType().equals((Object)SettBizTypeEnum.PAYOUTSIDE)) && info.getSettleConfirmCH() != null) {
            throw new FSException(FSException.RECPAYERROR, new String[]{info.getNumber()});
        }
    }

    public static void beforeCancelRecPay(String billId) throws EASBizException, BOSException {
        ObjectUuidPK pk = new ObjectUuidPK(billId);
        SettlementBillInfo info = SettlementBillFactory.getRemoteInstance().getSettlementBillInfo((IObjectPK)pk);
        if (info.getSource().equals((Object)SettlementBillSourceEnum.TRANSFERBILL)) {
            throw new FSException(FSException.ANTIRECPAYERROR, new String[]{info.getNumber()});
        }
        if ((info.getType().equals((Object)SettBizTypeEnum.RECOUTSIDE) || info.getType().equals((Object)SettBizTypeEnum.PAYOUTSIDE)) && info.getSettleConfirmCH() != null) {
            throw new FSException(FSException.ANTIRECPAYERROR2, new String[]{info.getNumber()});
        }
    }

    public void setBankAcctF7ForFinal(KDBizPromptBox f7BankAcct, SettBizTypeEnum type, String companyId) throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)new Integer(0)));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        f7BankAcct.setEntityViewInfo(view);
    }

    public void setInnerAcctF7ForFinal(KDBizPromptBox f7InnerAccount, boolean isCUControl, String companyId, SettlementBillRpcCacheInfo rpcCacheInfo) throws EASBizException, BOSException {
        EntityViewInfo info = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("closed", (Object)Boolean.FALSE));
        filter.getFilterItems().add(new FilterItemInfo("isUsed", (Object)Boolean.TRUE));
        int tm102 = rpcCacheInfo.getTM102();
        switch (tm102) {
            case 0: {
                break;
            }
            case 1: {
                filter.getFilterItems().add(new FilterItemInfo("type.property", (Object)new Integer(1).toString()));
                break;
            }
            case 2: {
                filter.getFilterItems().add(new FilterItemInfo("type.property", (Object)new Integer(2).toString()));
                break;
            }
            case 3: {
                filter.getFilterItems().add(new FilterItemInfo("type.property", (Object)new Integer(3).toString()));
                break;
            }
        }
        info.setFilter(filter);
        f7InnerAccount.setEntityViewInfo(info);
    }

    public static SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("payeeBankAcct.isReckoning"));
        sic.add(new SelectorItemInfo("payeeBankAcct.InnerAcct.id"));
        sic.add(new SelectorItemInfo("payeeBankAcct.bank.inGroup"));
        sic.add(new SelectorItemInfo("payerBankAcct.isReckoning"));
        sic.add(new SelectorItemInfo("payerBankAcct.InnerAcct.id"));
        sic.add(new SelectorItemInfo("payerBankAcct.bank.inGroup"));
        return sic;
    }

    public void verifyForMutil(CoreUIObject ui, IRow row) {
        BizEnumValueInfo mutilType = (BizEnumValueInfo)row.getCell("mutilType").getValue();
        Object innerPayeeAcct = row.getCell("innerPayeeAcct.number").getValue();
        Object payeeBankAcct = row.getCell("payeeBankAcct").getValue();
        Object innerPayerAcct = row.getCell("innerPayerAcct.number").getValue();
        Object payerBankAcct = row.getCell("payerBankAcct").getValue();
        switch (mutilType.getInt()) {
            case 1: {
                if (innerPayeeAcct == null) {
                    MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)resourcePath, (String)"mustInnerPayeeView"));
                    SysUtil.abort();
                    break;
                }
                if (payeeBankAcct != null || innerPayeeAcct != null) break;
                MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)resourcePath, (String)"mustPayeeBankAcctOrPayerView"));
                SysUtil.abort();
                break;
            }
            case 2: {
                if (innerPayerAcct == null) {
                    MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)resourcePath, (String)"mustInnerPayerView"));
                    SysUtil.abort();
                    break;
                }
                if (payerBankAcct != null || innerPayerAcct != null) break;
                MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)resourcePath, (String)"mustPayerBankAcctOrPayeeView"));
                SysUtil.abort();
                break;
            }
            case 3: {
                if (innerPayeeAcct != null && innerPayerAcct != null) break;
                MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)resourcePath, (String)"mustHaveInnerSideAcctView"));
                SysUtil.abort();
                break;
            }
        }
    }

    public void writeCheckInfo(CoreUIObject ui, SettlementBillInfo info) {
        if (info.getType().getValue() == 2 || info.getType().getValue() == 4) {
            boolean val = false;
            if (info.getPayerInnerAcct() != null && info.getPayerInnerAcct().getApplyUnit() != null) {
                val = ContextHelperFactory.getRemoteInstance().getBooleanParam("TM009", (IObjectPK)new ObjectUuidPK(info.getPayerInnerAcct().getApplyUnit().getId()));
            }
            if (val && info.getInnerSettleNumber() != null) {
                int result;
                String msg = "";
                try {
                    msg = SettleFacadeFactory.getRemoteInstance().checkFindCheck((IObjectPK)new ObjectUuidPK(info.getId()));
                }
                catch (EASBizException e) {
                    ExceptionHandler.handle((Throwable)e);
                }
                catch (BOSException e) {
                    ExceptionHandler.handle((Throwable)e);
                }
                if (!FMHelper.isEmpty((String)msg) && (result = MsgBox.showConfirm2((Component)ui, (String)msg)) == 2) {
                    SysUtil.abort();
                }
            }
        }
    }

    public RecPayInstanceAmountBean getInstanceBean() {
        return this.instanceBean;
    }

    public void setInstanceBean(RecPayInstanceAmountBean instanceBean) {
        this.instanceBean = instanceBean;
    }

    private String vervifyOverDraftInnerAcctForTip(CoreUIObject ui, String state, SettlementBillInfo editData, RecPayInstanceAmountBean bean, SettlementBillRpcCacheInfo rpcCacheInfo, boolean is_SAVE_ACCEPT) throws BOSException, EASBizException, AccountBankException {
        BigDecimal amount = editData.getAmount();
        if (amount.compareTo(Constants.ZERO) != 0) {
            InnerAccountInfo inAcct = null;
            CurrencyInfo currency = null;
            BigDecimal billAmount = null;
            boolean isRedBill = false;
            if (amount.compareTo(Constants.ZERO) > 0) {
                inAcct = editData.getPayerInnerAcct();
                if (!editData.isIsDlByPay()) {
                    return "";
                }
                currency = editData.getCurrency();
                billAmount = editData.getAmount();
                isRedBill = false;
            } else if (amount.compareTo(Constants.ZERO) < 0) {
                inAcct = editData.getPayeeInnerAcct();
                if (!editData.isIsDlByRec()) {
                    return "";
                }
                currency = editData.getCurrency();
                billAmount = amount.abs();
                isRedBill = true;
            }
            if (inAcct != null) {
                inAcct = InnerAccountFactory.getRemoteInstance().getInnerAccountInfo("select * , ctrlParam.* where id ='" + inAcct.getId() + "'");
                ObjectUuidPK chCompanyPk = new ObjectUuidPK(inAcct.getCompany().getId());
                CompanyOrgUnitInfo chCompany = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)chCompanyPk);
                String companyNumber = chCompany.getNumber();
                AccountMgrStrategyInfo ctrlStrategy = inAcct.getCtrlParam();
                boolean isSingleOk = false;
                isSingleOk = this.isNeedCtrl(state, isRedBill, is_SAVE_ACCEPT, ctrlStrategy);
                if (isSingleOk) {
                    if (ctrlStrategy.getOverdraftCtrl().equals((Object)OverdraftCtrlEnum.NOTCONTROL) && ctrlStrategy.isRemind()) {
                        BigDecimal totalFrozenAmt;
                        BankInfo clearhouse = null;
                        clearhouse = rpcCacheInfo != null ? rpcCacheInfo.getClearingHouse() : FSClientHelper.getClearingHouse();
                        Date unSettleDate = clearhouse.getSettleDate();
                        BigDecimal currentBalance = InAcctFactory.getRemoteInstance().inAcct(companyNumber, inAcct.getNumber(), currency.getNumber(), unSettleDate, unSettleDate, InAcctDataTypeEnum.K);
                        BigDecimal kValue = currentBalance.subtract(totalFrozenAmt = this.handler.getFrozenBalanceValue(currency.getId().toString(), inAcct.getId().toString()));
                        if (kValue.compareTo(billAmount) < 0) {
                            String msg = MessageFormat.format(EASResource.getString((String)resourcePath, (String)"overDraftFrozen"), inAcct.getName(), kValue, billAmount.subtract(kValue));
                            return msg;
                        }
                    }
                    if (ctrlStrategy.getOverdraftCtrl() == OverdraftCtrlEnum.INLIMITCANOVERDRAFT && ctrlStrategy.isRemind()) {
                        BigDecimal totalFrozenAmt;
                        Date unSettleDate = FSClientHelper.getClearingHouse().getSettleDate();
                        BigDecimal currentBalance = InAcctFactory.getRemoteInstance().inAcct(companyNumber, inAcct.getNumber(), currency.getNumber(), unSettleDate, unSettleDate, InAcctDataTypeEnum.K);
                        BigDecimal kValue = currentBalance.subtract(totalFrozenAmt = this.handler.getFrozenBalanceValue(currency.getId().toString(), inAcct.getId().toString()));
                        BigDecimal preAmount = kValue.subtract(billAmount);
                        if (preAmount.signum() == -1 && preAmount.compareTo(ctrlStrategy.getOverDraftAmount().negate()) >= 0) {
                            String msg = MessageFormat.format(EASResource.getString((String)resourcePath, (String)"inSafeDraftFrozen"), inAcct.getName(), kValue, ctrlStrategy.getOverDraftAmount(), billAmount.subtract(kValue));
                            return msg;
                        }
                    }
                }
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                view.setFilter(filter);
                filter.getFilterItems().add(new FilterItemInfo("innerAcct.id", (Object)inAcct.getId().toString()));
                InnerAcctGroupEntryCollection coll = InnerAcctGroupEntryFactory.getRemoteInstance().getInnerAcctGroupEntryCollection(view);
                if (coll != null && coll.size() > 0) {
                    AccountMgrStrategyInfo ctrlStrategyNew;
                    InnerAcctGroupEntryInfo innerAcctGroupEntryInfo = coll.get(0);
                    SelectorItemCollection selector = new SelectorItemCollection();
                    selector.add("*");
                    selector.add("ctrlParam.*");
                    selector.add("entrys.*");
                    selector.add("entrys.innerAcct.*");
                    InnerAcctGroupInfo innerAcctGroupInfo = InnerAcctGroupFactory.getRemoteInstance().getInnerAcctGroupInfo((IObjectPK)new ObjectUuidPK(innerAcctGroupEntryInfo.getParent().getId()), selector);
                    AccountMgrStrategyInfo ctrlParamGroup = innerAcctGroupInfo.getCtrlParam();
                    boolean isGroupOk = false;
                    if (ctrlParamGroup != null && !(isGroupOk = this.isNeedCtrl(state, isRedBill, is_SAVE_ACCEPT, ctrlStrategyNew = AccountMgrStrategyFactory.getRemoteInstance().getAccountMgrStrategyInfo((IObjectPK)new ObjectUuidPK(ctrlParamGroup.getId())))) && ctrlStrategy.getOverdraftCtrl().equals((Object)OverdraftCtrlEnum.NOTCONTROL) && ctrlStrategy.isRemind()) {
                        Date unSettleDate = FSClientHelper.getClearingHouse().getSettleDate();
                        StringBuffer allInnerAcctNumber = new StringBuffer();
                        String allInnerAcctNumberString = null;
                        for (int i = 0; i < innerAcctGroupInfo.getEntrys().size(); ++i) {
                            InnerAcctGroupEntryInfo entryInfo = innerAcctGroupInfo.getEntrys().get(i);
                            allInnerAcctNumber.append(entryInfo.getInnerAcct().getNumber());
                            allInnerAcctNumber.append(",");
                        }
                        allInnerAcctNumberString = allInnerAcctNumber.substring(0, allInnerAcctNumber.length() - 1);
                        BigDecimal curBalance = InAcctFactory.getRemoteInstance().inAcct(companyNumber, allInnerAcctNumberString, currency.getNumber(), unSettleDate, unSettleDate, InAcctDataTypeEnum.K);
                        StringBuffer allInnerAcctId = new StringBuffer();
                        String allInnerAcctIdString = null;
                        for (int i = 0; i < innerAcctGroupInfo.getEntrys().size(); ++i) {
                            InnerAcctGroupEntryInfo entryInfo = innerAcctGroupInfo.getEntrys().get(i);
                            allInnerAcctId.append(entryInfo.getInnerAcct().getId());
                            allInnerAcctId.append(",");
                        }
                        allInnerAcctIdString = allInnerAcctId.substring(0, allInnerAcctId.length() - 1);
                        BigDecimal totalFrozenAmt = InnerFrozenDepositFactory.getRemoteInstance().getTotalFrozenAmt(allInnerAcctIdString, currency.getId().toString());
                        BigDecimal kValue = curBalance.subtract(totalFrozenAmt);
                        if (kValue.compareTo(billAmount) < 0) {
                            String msg = MessageFormat.format(EASResource.getString((String)resourcePath, (String)"overDraftFrozen"), innerAcctGroupInfo.getName(), kValue, billAmount.subtract(kValue));
                            return msg;
                        }
                    }
                }
            }
        }
        return "";
    }

    private String vervifyOverDraftBankAcctForTip(CoreUIObject ui, String state, SettlementBillInfo editData, RecPayInstanceAmountBean bean, SettlementBillRpcCacheInfo rpcCacheInfo, boolean is_SAVE_ACCEPT) throws BOSException, EASBizException, AccountBankException {
        BigDecimal amount = editData.getAmount();
        if (amount.compareTo(Constants.ZERO) != 0) {
            CurrencyInfo currency = null;
            BigDecimal billAmount = BigDecimal.ZERO;
            boolean isRedBill = false;
            if (amount.compareTo(Constants.ZERO) > 0) {
                currency = editData.getCurrency();
                billAmount = editData.getAmount();
                isRedBill = false;
            } else if (amount.compareTo(Constants.ZERO) < 0) {
                currency = editData.getCurrency();
                billAmount = amount.abs();
                isRedBill = true;
            }
            boolean isAcctBankNotChanged = bean.getAcctBank() != null && editData.getPayerBankAcct() != null && bean.getAcctBank().getId().equals((Object)editData.getPayerBankAcct().getId());
            boolean isAcctViewNotChanged = bean.getAcctBank() == null && editData.getPayerBankAcct() == null && bean.getAcctView() != null && editData.getPayerAcct() != null && bean.getAcctView().getId().equals((Object)editData.getPayerAcct().getId());
            boolean isSaved = SettlementBillFactory.getRemoteInstance().exists((IObjectPK)new ObjectUuidPK(editData.getId()));
            BigDecimal amountAcct = FMConstants.ZERO;
            AccountBankInfo bankAcct = editData.getPayerBankAcct();
            AccountMgrStrategyInfo ctrlStrategyBankAcct = null;
            if (bankAcct != null) {
                ctrlStrategyBankAcct = bankAcct.getCtrlStrategy();
            }
            if (ctrlStrategyBankAcct != null) {
                ctrlStrategyBankAcct = AccountMgrStrategyFactory.getRemoteInstance().getAccountMgrStrategyInfo((IObjectPK)new ObjectUuidPK(ctrlStrategyBankAcct.getId()));
                boolean isSingleBankAcctOk = false;
                isSingleBankAcctOk = this.isNeedCtrl(state, isRedBill, is_SAVE_ACCEPT, ctrlStrategyBankAcct);
                if (isSingleBankAcctOk) {
                    String CS132 = ContextHelperFactory.getRemoteInstance().getStringParam("CS132", (IObjectPK)new ObjectUuidPK(editData.getCompany().getId()));
                    if (bankAcct != null && bankAcct.isIsSetBankInterface() && !"1".equals(CS132)) {
                        String acctBankID = bankAcct.getId().toString();
                        if (currency != null) {
                            String currencyID = currency.getId().toString();
                            BigDecimal balance = PaymentBillFactory.getRemoteInstance().getBalanceValue(acctBankID, currencyID);
                            amountAcct = balance.subtract(amount);
                        }
                    } else {
                        BigDecimal balance = RecPayAcctBankStratageCtrl.getSettleBillBalance(null, (CompanyOrgUnitInfo)bankAcct.getCompany(), (AccountBankInfo)bankAcct, (AccountViewInfo)editData.getPayerAcct(), (CurrencyInfo)currency, (Date)new Date(), (boolean)false);
                        if (editData != null && editData.isHasEffected() && (isAcctBankNotChanged || isAcctViewNotChanged)) {
                            balance = balance.add(bean.getOrignalAmt().subtract(amount));
                        }
                        amountAcct = !isSaved || !editData.isHasEffected() ? balance.subtract(amount) : balance;
                    }
                    String msg = RecPayAcctBankStratageCtrl.ctrlAcctBankForTip((AccountMgrStrategyInfo)ctrlStrategyBankAcct, (boolean)true, (AccountBankInfo)bankAcct, (boolean)ctrlStrategyBankAcct.isRemind(), (BigDecimal)amountAcct);
                    if (!EmptyUtil.isEmpty((String)msg)) {
                        return msg;
                    }
                }
            }
            AccountBankGroupInfo acctBankGroup = null;
            if (bankAcct != null) {
                acctBankGroup = AccountBankFactory.getRemoteInstance().getAcctBankGroup(bankAcct.getId().toString());
            }
            AccountMgrStrategyInfo ctrlParamGroup = null;
            if (acctBankGroup != null) {
                ctrlParamGroup = acctBankGroup.getStrategy();
            }
            if (ctrlParamGroup != null) {
                boolean isSingleBankAcctGroupOk = false;
                isSingleBankAcctGroupOk = this.isNeedCtrl(state, isRedBill, is_SAVE_ACCEPT, ctrlParamGroup);
                if (isSingleBankAcctGroupOk) {
                    ctrlParamGroup = AccountMgrStrategyFactory.getRemoteInstance().getAccountMgrStrategyInfo((IObjectPK)new ObjectUuidPK(ctrlParamGroup.getId()));
                    BigDecimal balance = RecPayAcctBankStratageCtrl.getTotalSettleBillBalance(null, (CompanyOrgUnitInfo)bankAcct.getCompany(), (AccountBankGroupInfo)acctBankGroup, (CurrencyInfo)currency, (Date)new Date(), (boolean)false);
                    if (editData != null && editData.isHasEffected() && (isAcctBankNotChanged || isAcctViewNotChanged)) {
                        balance = balance.add(bean.getOrignalAmt().subtract(editData.getAmount()));
                    }
                    if (ctrlParamGroup.getOverdraftCtrl().equals((Object)OverdraftCtrlEnum.NOTCONTROL) && ctrlParamGroup.isRemind() && balance.compareTo(billAmount) < 0) {
                        String msg = MessageFormat.format(EASResource.getString((String)resourcePath, (String)"overDraftFrozenAcctGroup"), acctBankGroup.getName(), balance, billAmount.subtract(balance));
                        return msg;
                    }
                    amountAcct = !isSaved || !editData.isHasEffected() ? balance.subtract(editData.getAmount()) : balance;
                    RecPayAcctBankStratageCtrl.acctBankGroupCtrl((AccountBankGroupInfo)acctBankGroup, (AccountMgrStrategyInfo)ctrlParamGroup, (BigDecimal)amountAcct);
                }
            }
        }
        return "";
    }

    public class RecPayInstanceAmountBean {
        private BigDecimal orignalAmt = Constants.ZERO;
        private AccountBankInfo acctBank = null;
        private AccountViewInfo acctView = null;

        public RecPayInstanceAmountBean(BigDecimal orignalAmt, AccountBankInfo acctBank, AccountViewInfo acctView) {
            this.orignalAmt = orignalAmt;
            this.acctBank = acctBank;
            this.acctView = acctView;
        }

        public AccountBankInfo getAcctBank() {
            return this.acctBank;
        }

        public void setAcctBank(AccountBankInfo acctBank) {
            this.acctBank = acctBank;
        }

        public AccountViewInfo getAcctView() {
            return this.acctView;
        }

        public void setAcctView(AccountViewInfo acctView) {
            this.acctView = acctView;
        }

        public BigDecimal getOrignalAmt() {
            return this.orignalAmt;
        }

        public void setOrignalAmt(BigDecimal orignalAmt) {
            this.orignalAmt = orignalAmt;
        }
    }
}

