/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.ExtendParser;
import com.kingdee.bos.ctrl.extendcontrols.IParser;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.VoucherAbstractInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.fs.FSHelper;
import com.kingdee.eas.fm.fs.InnerAccountInfo;
import com.kingdee.eas.fm.fs.SettBizTypeEnum;
import com.kingdee.eas.fm.fs.SettBizTypeInfo;
import com.kingdee.eas.fm.fs.SettleMutilTypeEnum;
import com.kingdee.eas.fm.fs.SettlementBillFactory;
import com.kingdee.eas.fm.fs.SettlementBillInfo;
import com.kingdee.eas.fm.fs.client.AbstractSettlementBillSimpleInnerEditUI;
import com.kingdee.eas.fm.fs.client.CurrencyUtil;
import com.kingdee.eas.fm.fs.client.FSClientHelper;
import com.kingdee.eas.fm.fs.client.SettlementBillHandler;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.Date;
import org.apache.log4j.Logger;

public class SettlementBillSimpleInnerEditUI
extends AbstractSettlementBillSimpleInnerEditUI {
    private static final Logger logger = CoreUIObject.getLogger(SettlementBillSimpleInnerEditUI.class);
    private CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
    private static final String resourcePath = "com.kingdee.eas.fm.fs.SettlementBillUI";
    private SettlementBillInfo preEditData = null;
    private CompanyOrgUnitInfo companyInfo = null;
    private Date settleDate = null;
    private SettlementBillHandler handler = SettlementBillHandler.create();

    public void onShow() throws Exception {
        super.onShow();
        this.pkBizDate.requestFocus();
    }

    public void onLoad() throws Exception {
        CurrencyUtil.fillCombCurrency(this.comboCurrency);
        if (this.companyInfo == null) {
            this.companyInfo = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        }
        if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)this.currentCompany)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"OnlyUnionNoIn"));
            SysUtil.abort();
        }
        if (this.settleDate == null) {
            this.settleDate = FSClientHelper.getClearingHouse().getSettleDate();
        }
        super.onLoad();
        this.initUIProps();
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionSubmit.putValue("SmallIcon", (Object)EASResource.getIcon((String)"imgTbtn_submit"));
    }

    protected void initDataStatus() {
        super.initDataStatus();
        boolean visible = false;
        this.actionEdit.setVisible(visible);
        this.actionRemove.setVisible(visible);
        this.actionCopy.setVisible(visible);
        this.actionSave.setVisible(visible);
        this.actionPrint.setVisible(visible);
        this.actionPrintPreview.setVisible(visible);
        this.actionCancel.setVisible(visible);
        this.actionCancelCancel.setVisible(visible);
    }

    private void initUIProps() throws Exception {
        this.txtAmount.setHorizontalAlignment(4);
        this.txtAmount.setRemoveingZeroInDispaly(false);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("type", (Object)new Integer(3)));
        filter.getFilterItems().add(new FilterItemInfo("type", (Object)new Integer(4)));
        filter.setMaskString("#0 OR #1");
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        this.prmtBizType.setEntityViewInfo(evi);
        String companyId = this.companyInfo.getId().toString();
        this.handler.setInnerAcctF7(this.prmtInnerAcct, true, companyId, 0, null, true, null);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("applyUnit.*"));
        sic.add(new SelectorItemInfo("company.*"));
        this.prmtInnerAcct.setSelectorCollection(sic);
        ExtendParser parser = new ExtendParser(this.prmtDesc);
        this.prmtDesc.setCommitParser((IParser)parser);
        this.prmtDesc.setEditable(true);
        this.prmtDesc.setDisplayFormat("$name$");
        this.prmtDesc.setEditFormat("$name$");
        this.prmtDesc.setCommitFormat("$number$");
        this.prmtDesc.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7VoucherAbstract");
    }

    @Override
    public void loadFields() {
        super.loadFields();
        SettBizTypeInfo bizTypeInfo = this.editData.getBizType();
        if (bizTypeInfo != null) {
            int bizType = bizTypeInfo.getType().getValue();
            InnerAccountInfo innerAcctInfo = null;
            if (bizType == 3) {
                innerAcctInfo = this.editData.getPayeeInnerAcct();
            } else if (bizType == 4) {
                innerAcctInfo = this.editData.getPayerInnerAcct();
            }
            this.prmtInnerAcct.setValue((Object)innerAcctInfo);
        }
        this.prmtDesc.setValue((Object)this.editData.getDescription());
        FMClientHelper.setSelectObject((KDComboBox)this.comboCurrency, (Object)this.editData.getCurrency());
    }

    @Override
    public void storeFields() {
        SettBizTypeInfo bizTypeInfo;
        super.storeFields();
        InnerAccountInfo innerAcctInfo = (InnerAccountInfo)this.prmtInnerAcct.getValue();
        if (innerAcctInfo != null) {
            this.editData.setApplyUnit(innerAcctInfo.getApplyUnit());
        }
        if ((bizTypeInfo = this.editData.getBizType()) != null) {
            if (innerAcctInfo != null) {
                int bizType = bizTypeInfo.getType().getValue();
                if (bizType == 3) {
                    this.editData.setPayeeInnerAcct(innerAcctInfo);
                    this.editData.setPayerInnerAcct(null);
                    this.editData.setPayerBankAcct(null);
                    this.editData.setPayeeFullName(innerAcctInfo.getApplyUnit().getName());
                } else if (bizType == 4) {
                    this.editData.setPayerInnerAcct(innerAcctInfo);
                    this.editData.setPayeeInnerAcct(null);
                    this.editData.setPayeeBankAcct(null);
                    this.editData.setPayerFullName(innerAcctInfo.getApplyUnit().getName());
                }
            }
            this.editData.setType(bizTypeInfo.getType());
        }
        String companyId = this.companyInfo.getId().toString();
        String srcCurrId = this.editData.getCurrency().getId().toString();
        BigDecimal exRate = Constants.ONE;
        try {
            exRate = FMClientHelper.getExRate((String)companyId, (String)srcCurrId, null, (Date)this.editData.getBizDate());
        }
        catch (EASBizException e) {
            this.handUIExceptionAndAbort((Exception)((Object)e));
        }
        catch (BOSException e) {
            this.handUIExceptionAndAbort((Exception)((Object)e));
        }
        this.editData.setExchange(exRate);
        if (this.editData.getAmount() != null) {
            BigDecimal localAmt = exRate.multiply(this.editData.getAmount());
            this.editData.setLocalAmt(localAmt);
        }
        if (this.prmtDesc.getValue() instanceof VoucherAbstractInfo) {
            this.editData.setDescription(((VoucherAbstractInfo)this.prmtDesc.getValue()).getName());
        } else if (this.prmtDesc.getValue() instanceof String) {
            this.editData.setDescription(this.prmtDesc.getValue().toString());
        }
        this.preEditData = this.editData;
        try {
            FSHelper.setDlByRecPay(null, this.editData);
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("bizDate");
        sic.add("bizType.id");
        sic.add("bizType.number");
        sic.add("bizType.name");
        sic.add("bizType.type");
        sic.add("amount");
        sic.add("innerSettleNumber");
        sic.add("currency.id");
        sic.add("currency.name");
        sic.add("currency.precision");
        sic.add("payeeInnerAcct.id");
        sic.add("payeeInnerAcct.number");
        sic.add("payeeInnerAcct.name");
        sic.add("payeeInnerAcct.acctNumber");
        sic.add("payeeInnerAcct.company.id");
        sic.add("payeeInnerAcct.company.number");
        sic.add("payeeInnerAcct.company.name");
        sic.add("payeeInnerAcct.applyUnit.id");
        sic.add("payeeInnerAcct.applyUnit.number");
        sic.add("payeeInnerAcct.applyUnit.name");
        sic.add("payerInnerAcct.id");
        sic.add("payerInnerAcct.number");
        sic.add("payerInnerAcct.name");
        sic.add("payerInnerAcct.acctNumber");
        sic.add("payerInnerAcct.company.id");
        sic.add("payerInnerAcct.company.number");
        sic.add("payerInnerAcct.company.name");
        sic.add("payerInnerAcct.applyUnit.id");
        sic.add("payerInnerAcct.applyUnit.number");
        sic.add("payerInnerAcct.applyUnit.name");
        sic.add("description");
        sic.add("company.id");
        sic.add("company.number");
        sic.add("company.name");
        sic.add(new SelectorItemInfo("payeeInnerAcct.isUsed"));
        sic.add(new SelectorItemInfo("payeeInnerAcct.closed"));
        sic.add(new SelectorItemInfo("payerInnerAcct.isUsed"));
        sic.add(new SelectorItemInfo("payerInnerAcct.closed"));
        return sic;
    }

    protected IObjectValue createNewData() {
        SettlementBillInfo info = new SettlementBillInfo();
        if (this.preEditData != null) {
            info.setCompany(this.companyInfo);
            info.setBizDate(this.preEditData.getBizDate());
            info.setBizType(this.preEditData.getBizType());
            info.setCurrency(this.preEditData.getCurrency());
        } else {
            info.setBizDate(this.settleDate);
            info.setCompany(this.companyInfo);
            info.setCurrency(this.companyInfo.getBaseCurrency());
        }
        info.setFiVouchered(false);
        return info;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return SettlementBillFactory.getRemoteInstance();
    }

    @Override
    protected void prmtBizType_dataChanged(DataChangeEvent e) throws Exception {
    }

    @Override
    protected void comboCurrency_itemStateChanged(ItemEvent e) throws Exception {
        if (e.getStateChange() == 2) {
            return;
        }
        CurrencyInfo currencyInfo = (CurrencyInfo)this.comboCurrency.getSelectedItem();
        if (currencyInfo == null) {
            return;
        }
        this.txtAmount.setPrecision(currencyInfo.getPrecision());
        this.setBalanceValue();
    }

    @Override
    protected void prmtInnerAcct_dataChanged(DataChangeEvent e) throws Exception {
        InnerAccountInfo info = (InnerAccountInfo)e.getNewValue();
        if (info == null) {
            this.lblInnerAcct.setText("");
            this.lblBalance.setText("");
        } else {
            this.lblInnerAcct.setText(info.getAcctNumber());
            this.setBalanceValue();
        }
    }

    @Override
    protected void prmtInnerAcct_willShow(SelectorEvent e) throws Exception {
        this.setPayeeInnerAcctF7(this.prmtInnerAcct, true, this.companyInfo.getId().toString());
    }

    private void setPayeeInnerAcctF7(KDBizPromptBox f7InnerAccount, boolean isCUControl, String companyId) throws EASBizException, BOSException {
        EntityViewInfo info = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("closed", (Object)Boolean.FALSE));
        filter.getFilterItems().add(new FilterItemInfo("isUsed", (Object)Boolean.TRUE));
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId));
        StringBuffer sql = new StringBuffer();
        sql.append(" select a.FInnerAcctId from t_bd_accountbanks a  ").append(" join t_bd_bank b on a.FBank=b.fid ").append(" where b.FIsInGroup =0 and a.FInnerAcctId is not null ");
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)sql.toString(), CompareType.NOTINNER));
        InnerAccountInfo inneeAcct = (InnerAccountInfo)this.prmtInnerAcct.getData();
        if (!(inneeAcct == null || this.editData.getType() != SettBizTypeEnum.RECINSIDEDIF && this.editData.getType() != SettBizTypeEnum.PAYINSIDEDIF || this.editData.getMutilType() != SettleMutilTypeEnum.TRANS && this.editData.getMutilType() != SettleMutilTypeEnum.REC || inneeAcct.getCompany().getId().equals((Object)this.editData.getCompany().getId()))) {
            filter.getFilterItems().add(new FilterItemInfo("isReckoning", (Object)Constants.TRUE));
        }
        int tm102 = ContextHelperFactory.getRemoteInstance().getIntParam("TM102", (IObjectPK)new ObjectUuidPK(BOSUuid.read((String)companyId)));
        switch (tm102) {
            case 0: {
                break;
            }
            case 1: {
                filter.getFilterItems().add(new FilterItemInfo("type.property", (Object)new Integer(1).toString()));
                break;
            }
            case 2: {
                filter.getFilterItems().add(new FilterItemInfo("type.property", (Object)new Integer(2).toString()));
                break;
            }
            case 3: {
                filter.getFilterItems().add(new FilterItemInfo("type.property", (Object)new Integer(3).toString()));
                break;
            }
        }
        info.setFilter(filter);
        f7InnerAccount.setEntityViewInfo(info);
        this.prmtInnerAcct.getQueryAgent().resetRuntimeEntityView();
        this.prmtInnerAcct.setEntityViewInfo(info);
    }

    private void setBalanceValue() throws EASBizException, BOSException {
        InnerAccountInfo innerAcctInfo = (InnerAccountInfo)this.prmtInnerAcct.getValue();
        CurrencyInfo currencyInfo = (CurrencyInfo)this.comboCurrency.getSelectedItem();
        BigDecimal balance = this.handler.getBalanceValue(currencyInfo, innerAcctInfo);
        String str = EASResource.getString((String)resourcePath, (String)"instantBalance");
        String pattern = FMClientHelper.getNumberFtm((BOSUuid)currencyInfo.getId());
        DecimalFormat fm = new DecimalFormat(pattern);
        this.lblBalance.setText(str + fm.format(balance));
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemove_actionPerformed(e);
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        FMClientVerifyHelper.verifyUIControlEmpty((CoreUI)this);
        FMClientVerifyHelper.verifyEmptyAndNoZero((CoreUIObject)this, (KDFormattedTextField)this.txtAmount);
        FMClientVerifyHelper.verifyComboCurrency((CoreUIObject)this, (KDComboBox)this.comboCurrency);
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        this.storeFields();
        this.verify(e);
        this.editData.setHasEffected(false);
        this.handler.verifyOverdraft((CoreUIObject)this, "save", this.editData, this.handler.getInstanceBean(), null);
        super.actionSave_actionPerformed(e);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.storeFields();
        this.verify(e);
        this.editData.setHasEffected(true);
        boolean is_SAVE_ACCEPT = ContextHelperFactory.getRemoteInstance().getBooleanParam("TM004", (IObjectPK)new ObjectUuidPK(this.currentCompany.getId()));
        if (is_SAVE_ACCEPT) {
            this.handler.writeCheckInfo((CoreUIObject)this, this.editData);
        }
        this.handler.verifyOverdraft((CoreUIObject)this, "submit", this.editData, this.handler.getInstanceBean(), null);
        super.actionSubmit_actionPerformed(e);
        this.prmtInnerAcct.requestFocus();
    }
}

