/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.client;

import com.kingdee.bos.ctrl.kdf.table.IBlock;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.IBOTRelation;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.MessageUtil;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMVerifyHelper;
import com.kingdee.eas.fm.common.FmRpcCacheInfo;
import com.kingdee.eas.fm.common.client.DefaultOriginalCurrencyPrecProvider;
import com.kingdee.eas.fm.common.client.DefaultTablePrecisionFormat;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.common.client.ITablePrecisionProvider;
import com.kingdee.eas.fm.fs.ISettleFacade;
import com.kingdee.eas.fm.fs.SettBizTypeEnum;
import com.kingdee.eas.fm.fs.SettBizTypeInfo;
import com.kingdee.eas.fm.fs.SettleFacadeFactory;
import com.kingdee.eas.fm.fs.SettlementBillCollection;
import com.kingdee.eas.fm.fs.SettlementBillFactory;
import com.kingdee.eas.fm.fs.SettlementBillFilterParam;
import com.kingdee.eas.fm.fs.SettlementBillInfo;
import com.kingdee.eas.fm.fs.SettlementBillRpcCacheInfo;
import com.kingdee.eas.fm.fs.client.AbstractSettlementBillSimpleInnerListUI;
import com.kingdee.eas.fm.fs.client.AcceptBatchUI;
import com.kingdee.eas.fm.fs.client.FSClientHelper;
import com.kingdee.eas.fm.fs.client.SettlementBillFilterUI;
import com.kingdee.eas.fm.fs.client.SettlementBillHandler;
import com.kingdee.eas.fm.fs.client.SettlementBillSimpleInnerEditUI;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class SettlementBillSimpleInnerListUI
extends AbstractSettlementBillSimpleInnerListUI {
    private static final Logger logger = CoreUIObject.getLogger(SettlementBillSimpleInnerListUI.class);
    private SettlementBillHandler handler = SettlementBillHandler.create();
    public static final String resourcePath = "com.kingdee.eas.fm.fs.SettlementBillUI";
    private CompanyOrgUnitInfo companyInfo = null;
    public SettlementBillRpcCacheInfo rpcCacheInfo = null;
    FMFilterBaseUI filterUI = null;
    ISettleFacade iSettleFacade = SettleFacadeFactory.getRemoteInstance();

    public SettlementBillSimpleInnerListUI() throws Exception {
        DefaultTablePrecisionFormat precFmt = new DefaultTablePrecisionFormat();
        DefaultOriginalCurrencyPrecProvider precProvider = new DefaultOriginalCurrencyPrecProvider("currency.id");
        precFmt.setPrecProvider((ITablePrecisionProvider)precProvider);
        precFmt.initFormat(this.tblMain, new String[]{"amount", "localAmt"});
    }

    public void onLoad() throws Exception {
        this.rpcCacheInfo = (SettlementBillRpcCacheInfo)((AbstractSettlementBillSimpleInnerListUI)this).rpcCacheInfo;
        if (this.companyInfo == null) {
            this.companyInfo = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        }
        super.onLoad();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionAccept.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_accept"));
        this.actionCancelAccept.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_cancelcase"));
        this.actionCheck.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_handworkcollate"));
        this.actionAntiCheck.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_fallotpopedomforbid"));
        this.btnNextPerson.setIsControlByParent(false);
        this.btnNextPerson.setTextIconDisStyle((short)3);
        this.btnMultiapprove.setIsControlByParent(false);
        this.btnMultiapprove.setTextIconDisStyle((short)3);
        this.actionCreateTo.setVisible(false);
        this.actionCopyTo.setVisible(false);
    }

    protected ICoreBase getBizInterface() throws Exception {
        return SettlementBillFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return SettlementBillSimpleInnerEditUI.class.getName();
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new SettlementBillFilterUI(true, false, this.rpcCacheInfo);
        }
        return this.filterUI;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        String companyId = this.companyInfo.getId().toString();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId));
        filter.getFilterItems().add(new FilterItemInfo("bizType.type", (Object)new Integer(3)));
        filter.getFilterItems().add(new FilterItemInfo("bizType.type", (Object)new Integer(4)));
        filter.setMaskString("#0 AND (#1 OR #2)");
        return filter;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        return sic;
    }

    public SelectorItemCollection getBOTPSelectors() {
        SelectorItemCollection sic = this.getSelectors();
        sic.add("company.*");
        sic.add("payeeInnerAcct.*");
        sic.add("payerInnerAcct.*");
        return sic;
    }

    protected String[] getLocateNames() {
        String[] locateNames = new String[]{"number", "innerAcct", "amount", "bankAcct", "description"};
        return locateNames;
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        super.actionView_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        IRow row = (IRow)this.getSelectedRows().get(0);
        this.verifyCanEditOrRemove(row);
        super.actionEdit_actionPerformed(e);
    }

    private void verifyCanEditOrRemove(IRow row) {
        if (row.getCell("acceptor").getValue() != null) {
            this.showWarning("AcceptedNotDeleteOrEdit");
        }
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)company)) {
            this.showWarning("CanNotDelByOnlyUnion");
        }
        if (MsgBox.isCancel((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Delete")))) {
            return;
        }
        try {
            IBlock selectBlock = null;
            ICell cell = null;
            for (int i = 0; i < this.tblMain.getSelectManager().size(); ++i) {
                selectBlock = KDTSelectBlock.change((KDTable)this.tblMain, (IBlock)this.tblMain.getSelectManager().get(i));
                for (int j = selectBlock.getTop(); j <= selectBlock.getBottom(); ++j) {
                    Object keyValue;
                    BOSUuid id;
                    Set src;
                    IRow row = this.tblMain.getRow(j);
                    this.verifyCanEditOrRemove(row);
                    cell = row.getCell(this.getKeyFieldName());
                    if (cell == null) {
                        MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_KeyField_Fail"));
                        SysUtil.abort();
                    }
                    if ((src = FMHelper.getSrcBillIdSet(null, (String)(id = BOSUuid.read((String)((String)(keyValue = cell.getValue())))).toString())) != null && src.size() > 0) {
                        MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"137_SettlementBillListUI"));
                        SysUtil.abort();
                    }
                    this.getBizInterface().delete((IObjectPK)new ObjectUuidPK(id));
                }
            }
        }
        catch (ObjectNotFoundException onfe) {
            logger.error((Object)onfe.getMessage(), (Throwable)onfe);
            this.refreshList();
            throw new EASBizException(EASBizException.CHECKEXIST);
        }
        MessageUtil.showSuccessInfo((CoreUI)this, (ItemAction)this.actionRemove);
        this.refresh(e);
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
    }

    protected void execQuery() {
        this.mainQuery.getSorter().clear();
        this.mainQuery.getSorter().add(new SorterItemInfo("bizType.name"));
        this.mainQuery.getSorter().add(new SorterItemInfo("bizDate"));
        this.mainQuery.getSorter().add(new SorterItemInfo("number"));
        super.execQuery();
    }

    private void showWarning(String resName) {
        MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)resName));
        SysUtil.abort();
    }

    private void showSuccessMsg(ActionEvent e) {
        Component component = (Component)e.getSource();
        FMClientHelper.showSuccessMessage((CoreUI)this, (Component)component);
    }

    private List getSelectedRows() {
        ArrayList<IRow> rows = new ArrayList<IRow>();
        IBlock selectBlock = null;
        int size = this.tblMain.getSelectManager().size();
        if (size == 0 || this.tblMain.getSelectManager() == null) {
            this.showWarning("CheckSettlementBill");
        }
        for (int i = 0; i < size; ++i) {
            selectBlock = KDTSelectBlock.change((KDTable)this.tblMain, (IBlock)this.tblMain.getSelectManager().get(i));
            for (int j = selectBlock.getTop(); j <= selectBlock.getBottom(); ++j) {
                IRow row = this.tblMain.getRow(j);
                rows.add(row);
            }
        }
        return rows;
    }

    @Override
    public void actionAccept_actionPerformed(ActionEvent e) throws Exception {
        boolean isAcceptBatch;
        this.checkSelected();
        ArrayList ids = this.getSelectedIdValues();
        EntityViewInfo evi = this.getEntity(new HashSet(ids));
        evi.getSelector().add(new SelectorItemInfo("*"));
        evi.getSelector().add(new SelectorItemInfo("bizType.*"));
        evi.getSelector().add(new SelectorItemInfo("payerInnerAcct.applyUnit.id"));
        evi.getSelector().add(new SelectorItemInfo("payerInnerAcct.applyUnit.name"));
        evi.getSelector().add(new SelectorItemInfo("payerInnerAcct.applyUnit.number"));
        SettlementBillCollection sbc = SettlementBillFactory.getRemoteInstance().getSettlementBillCollection(evi);
        int size = sbc.size();
        SettBizTypeInfo bizType = new SettBizTypeInfo();
        CurrencyInfo currency = null;
        for (int i = 0; i < size; ++i) {
            SettlementBillInfo settlementBillInfo = sbc.get(i);
            FMVerifyHelper.checkBlank(null, (IObjectValue)settlementBillInfo, (String)"bizType");
            FMVerifyHelper.checkBlank(null, (IObjectValue)settlementBillInfo, (String)"currency");
            if (bizType != null && bizType.getId() != null && settlementBillInfo.getBizType() != null && !bizType.getId().equals((Object)settlementBillInfo.getBizType().getId())) {
                MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"71_AcceptBatchUI"));
                SysUtil.abort();
            }
            if (currency != null && !currency.getId().equals((Object)settlementBillInfo.getCurrency().getId())) {
                MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"72_AcceptBatchUI"));
                SysUtil.abort();
            }
            this.handler.verifyOverdraft((CoreUIObject)this, "accept", settlementBillInfo, this.handler.getInstanceBean(), this.rpcCacheInfo);
            bizType = settlementBillInfo.getBizType();
            currency = settlementBillInfo.getCurrency();
            if (settlementBillInfo.getAcceptor() != null) {
                this.showWarning("HasAccepted");
            }
            ids.add(settlementBillInfo.getId().toString());
        }
        int sizeList = ids.size();
        if (sizeList == 0) {
            return;
        }
        boolean bl = isAcceptBatch = bizType.getType() == SettBizTypeEnum.RECINSIDE || bizType.getType() == SettBizTypeEnum.PAYINSIDE;
        if (isAcceptBatch) {
            AcceptBatchUI.showDialogWindows((IUIObject)this, FMHelper.asSet((String[])ids.toArray(new String[ids.size()])));
        } else {
            this.iSettleFacade.settle(ids, true);
            this.showSuccessMsg(e);
        }
        this.refreshList();
    }

    @Override
    public void actionCancelAccept_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList ids = this.getSelectedIdValues();
        int size = ids.size();
        for (int i = 0; i < size; ++i) {
            IBOTRelation iBotRelation = BOTRelationFactory.getRemoteInstance();
            ArrayList idss = iBotRelation.getDestObjIdByDestType(ids.get(i).toString(), null);
            if (idss == null || idss.size() <= 0) continue;
            int rst = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"161_SettlementBillSimpleInnerListUI"));
            if (rst == 0) break;
            this.abort();
        }
        this.iSettleFacade.cancelAccept(ids);
        this.showSuccessMsg(e);
        this.refreshList();
    }

    private EntityViewInfo getEntity(HashSet idset) {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idset, CompareType.INCLUDE));
        evi.setFilter(filter);
        return evi;
    }

    public IRow getSelectedRow(KDTable tblMain) {
        this.checkSelected();
        KDTSelectBlock selectBlock = tblMain.getSelectManager().get();
        if (selectBlock == null || selectBlock.getTop() == -1) {
            SysUtil.abort();
        }
        IRow row = tblMain.getRow(selectBlock.getTop());
        return row;
    }

    public void actionVoucher_actionPerformed(ActionEvent e) throws Exception {
        IRow row = this.getSelectedRow(this.tblMain);
        if (row.getCell("acceptor").getValue() == null) {
            this.showWarning("NotAcceptedForVoucher");
        }
        super.actionVoucher_actionPerformed(e);
    }

    public void actionDelVoucher_actionPerformed(ActionEvent e) throws Exception {
        FSClientHelper.checkClearingHouseCompany();
        super.actionDelVoucher_actionPerformed(e);
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        super.tblMain_tableSelectChanged(e);
        this.changeButtonStatus();
    }

    private void changeButtonStatus() {
        IRow row = this.getSelectedRow(this.tblMain);
        boolean canCheck = row.getCell("acceptor").getValue() != null && row.getCell("checker").getValue() == null;
        this.actionCheck.setEnabled(canCheck);
        this.actionCheck.setVisible(canCheck);
        boolean canAntiCheck = row.getCell("checker").getValue() != null;
        this.actionAntiCheck.setEnabled(canAntiCheck);
        this.actionAntiCheck.setVisible(canAntiCheck);
    }

    @Override
    public void actionAntiCheck_actionPerformed(ActionEvent e) throws Exception {
        super.actionAntiCheck_actionPerformed(e);
        this.checkSelected();
        for (int i = 0; i < this.tblMain.getSelectManager().size(); ++i) {
            IBlock selectBlock = KDTSelectBlock.change((KDTable)this.tblMain, (IBlock)this.tblMain.getSelectManager().get(i));
            for (int j = selectBlock.getTop(); j <= selectBlock.getBottom(); ++j) {
                IRow row = this.tblMain.getRow(j);
                String id = row.getCell("id").getValue().toString();
                if (row.getCell("checker").getValue() != null) continue;
                this.showWarning("label86");
            }
        }
        ArrayList ids = this.getSelectedIdValues();
        this.iSettleFacade.antiCheck(ids);
        this.showSuccessMsg(e);
        this.refreshList();
    }

    @Override
    public void actionCheck_actionPerformed(ActionEvent e) throws Exception {
        super.actionCheck_actionPerformed(e);
        this.checkSelected();
        for (int i = 0; i < this.tblMain.getSelectManager().size(); ++i) {
            IBlock selectBlock = KDTSelectBlock.change((KDTable)this.tblMain, (IBlock)this.tblMain.getSelectManager().get(i));
            for (int j = selectBlock.getTop(); j <= selectBlock.getBottom(); ++j) {
                IRow row = this.tblMain.getRow(j);
                String id = row.getCell("id").getValue().toString();
                if (row.getCell("acceptor").getValue() == null) {
                    this.showWarning("label84");
                }
                if (row.getCell("checker").getValue() == null) continue;
                this.showWarning("label85");
            }
        }
        ArrayList ids = this.getSelectedIdValues();
        this.iSettleFacade.check(ids);
        this.showSuccessMsg(e);
        this.refreshList();
    }

    protected boolean isFootVisible() {
        return true;
    }

    protected IRow appendFootRow() {
        IRow row = super.appendFootRow();
        String currencyId = null;
        if (row != null && row.getCell("amount") != null && row.getCell("localAmt") != null) {
            try {
                currencyId = ((SettlementBillFilterParam)this.getFilterParam()).getCurrencyId();
                if (currencyId == null) {
                    currencyId = this.companyInfo.getBaseCurrency().getId().toString();
                }
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            String numberFormat = FMClientHelper.getNumberFtm((int)2);
            String baseNumberFormat = FMClientHelper.getNumberFtm((BOSUuid)BOSUuid.read((String)this.companyInfo.getBaseCurrency().getId().toString()));
            if (currencyId != null) {
                numberFormat = FMClientHelper.getNumberFtm((BOSUuid)BOSUuid.read((String)currencyId));
            }
            row.getCell("amount").getStyleAttributes().setNumberFormat(numberFormat);
            row.getCell("localAmt").getStyleAttributes().setNumberFormat(baseNumberFormat);
        }
        return row;
    }

    protected boolean isRpcCacheProcess() {
        return true;
    }

    protected FmRpcCacheInfo getRpcCacheParam() {
        SettlementBillRpcCacheInfo paramInfo = new SettlementBillRpcCacheInfo();
        paramInfo.setBatchImplClassName(this.getRpcBatchImplClassName());
        paramInfo.setBillInfo((CoreBaseInfo)new SettlementBillInfo());
        return paramInfo;
    }

    protected String getRpcBatchImplClassName() {
        return "com.kingdee.eas.fm.fs.app.SettlementBillBatchFetcher";
    }
}

